/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	lv_q.h,v $
 * Revision 4.2  91/09/19  22:31:59  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: lv_q.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:31:59 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
#ifndef _LV_Q_H_
#define _LV_Q_H_

#include <sys/buf.h>

/*
 *  queues, and macros for manipulating them.
 */

struct lv_queue {
	struct buf *lv_head;
	struct buf **lv_tail;
	int	lv_count;
};

#include <lvm/lv_qmacros.h>		/* helpful macro definitions */
	/* Q is always a "pointer to a struct lv_queue", E is a "pointer
	 * to an element of the queue" */
#define LV_QUEUE_APPEND(Q,E)	Q_APPEND_PROTO(Q,E,\
					lv_head,lv_tail,av_forw,lv_count)
#define LV_QUEUE_PREPEND(Q,E)	Q_PREPEND_PROTO(Q,E,\
					lv_head,lv_tail,av_forw,lv_count)
#define LV_QUEUE_FETCH(Q,E)	Q_FETCH_PROTO(Q,E,\
					lv_head,lv_tail,av_forw,lv_count)
#define LV_QUEUE_INIT(Q)	Q_INIT_PROTO(Q,lv_head,lv_tail,lv_count)

#endif  /* _LV_Q_H_ */
