/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	kern_msg.h,v $
 * Revision 4.2  91/09/19  22:25:26  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: kern_msg.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:25:26 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * File:	kern_msg.h
 * Purpose:
 *	Kernel internal message structure.
 *
 *	Revision History:
 *
 * 8-Apr-91	Ron Widyono
 *	Delay inclusion of sys/preempt.h (for RT_PREEMPT) to avoid circular
 *	include file problem.
 *
 */

#ifndef	_KERN_KERN_MSG_H_
#define _KERN_KERN_MSG_H_

#include <rt_preempt.h>

#if	RT_PREEMPT
#ifndef	_SKIP_PREEMPT_H_
#define _SKIP_PREEMPT_H_
#define	_KERN_KERN_MSG_H_PREEMPT_
#endif
#endif

#include <mach/message.h>
#include <kern/task.h>
#include <kern/queue.h>
#include <kern/zalloc.h>
#include <kern/ipc_netport.h>

typedef struct kern_msg {
		queue_chain_t		queue_head;	/* must be first */
		struct port_hash *	sender_entry;
		zone_t			home_zone;
		boolean_t		kernel_message;
						/* Kernel is receiver? */

		msg_header_t		kmsg_header;
} *kern_msg_t;

#define		KERN_MSG_NULL	((kern_msg_t) 0)

#if	RT_PREEMPT
#ifdef	_KERN_KERN_MSG_H_PREEMPT_
#include <sys/preempt.h>
#endif
#endif

#endif	/* _KERN_KERN_MSG_H_ */
