/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ipc_netport.h,v $
 * Revision 4.2  91/09/19  22:24:34  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ipc_netport.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:24:34 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * File:	ipc_netport.h
 * Purpose:
 *	Header file for mach_ipc_netport option.
 */

#ifndef	_KERN_IPC_NETPORT_H_
#define _KERN_IPC_NETPORT_H_

#include <mach/boolean.h>
#include <mach/message.h>
#include <mach/netport.h>

/*
 * Debugging flags.
 */
extern int		np_flags;
#define NP_DEBUG	0x1
#define NP_SODEBUG	0x2
#define NP_TRACE	0x3


/*
 * Values for src_format
 */
#define DISP_FMT_NETWORK	0
#define DISP_FMT_VL_1		1	/* Vax order, long align */
#define DISP_FMT_NL_1		2	/* Non-vax order, long align */
#define DISP_FMT_MAX		(2 + 1)

/*
 * Format of the messages generated by servers on different machine types.
 */
#if	BYTE_MSF
#	define VaxOrder		0
#	define CONF_OWN_FORMAT		DISP_FMT_NL_1
#else	/* BYTE_MSF */
#	define VaxOrder		1
#	define CONF_OWN_FORMAT		DISP_FMT_VL_1
#endif	/* BYTE_MSF */

#if	defined(vax) || defined(ibmrt) || defined(sun3) || defined(sun4) || defined(mips)
#define LongAlign		1
#else
#define LongAlign		0
#endif	/* defined(vax) || defined(ibmrt) || defined(sun3) || defined(sun4) || defined(mips) */


typedef struct {
    unsigned short	disp_type;		/* type of message (network format) */
    unsigned short	src_format;		/* format for all following data */
} disp_hdr_t, *disp_hdr_ptr_t;

/*
 * Values for disp_type
 */
#define DISP_IPC_MSG		1
#define DISP_IPC_UNBLOCK	2
#define DISP_PORTCHECK		3
#define DISP_NETNAME		4
#define DISP_PO_RO_HINT		5
#define DISP_PO_RO_XFER		6
#define DISP_PO_TOKEN		7
#define DISP_PO_DEATH		8
#define DISP_PORTSEARCH		9
#define DISP_PS_AUTH		10
#define DISP_STARTUP		11
#define DISP_IPC_ABORT		12
#define DISP_TYPE_MAX		(12 + 1)


/*
 * Return codes for request-response interactions.
 */
#define DISP_WILL_REPLY		0
#define DISP_FAILURE		-1
#define DISP_SUCCESS		-2
#define DISP_IGNORE		-3
#define TR_SUCCESS		-10
#define TR_FAILURE		-11
#define TR_REMOTE_ACCEPT	-12
#define TR_REMOTE_REJECT	-13
#define TR_CRYPT_FAILURE	-14
#define TR_SEND_FAILURE		-15
#define TR_OVERLOAD		-16
#define IPC_SUCCESS		1
#define IPC_FAILURE		2
#define IPC_PORT_BLOCKED	3
#define IPC_PORT_NOT_HERE	4
#define IPC_BAD_SEQ_NO		5
#define IPC_REQUEST		6
#define IPC_ABORT_REPLY		7
#define IPC_ABORT_REQUEST	8
#define IPC_PORT_BUSY		9
#define IPC_ABORT_REQUEST_FLUSH	10
#define IPC_ABORT_CLIENT	11


typedef network_port_t *network_port_ptr_t;

typedef union {
    struct {
	unsigned char ia_net_owner;
	unsigned char ia_net_node_type;
	unsigned char ia_host_high;
	unsigned char ia_host_low;
    } ia_bytes;
    netaddr_t ia_netaddr;
} ip_addr_t;

/*
 * Header for network IPC messages 
 */
typedef struct {
	disp_hdr_t      disp_hdr;	/* dispatcher header */
	network_port_t  local_port;
	network_port_t  remote_port;
	unsigned long   info;		/* info bits */
	unsigned long   npd_size;	/* size of Network Port Dictionary */
	unsigned long   inline_size;	/* size of inline part of message */
	unsigned long   ool_size;	/* size of ool part of message */
	unsigned long   ool_num;	/* number of ool sections (for assembly) */
	unsigned long	ipc_seq_no;	/* the IPC sequence number of this message */
}               ipc_network_hdr_t;

/*
 * Header and IPC message:
 */
typedef struct {
	disp_hdr_t      disp_hdr;	/* dispatcher header */
	network_port_t  local_port;
	network_port_t  remote_port;
	unsigned long   info;		/* info bits */
	unsigned long   npd_size;	/* size of Network Port Dictionary */
	unsigned long   inline_size;	/* size of inline part of message */
	unsigned long   ool_size;	/* size of ool part of message */
	unsigned long   ool_num;	/* number of ool sections (for assembly) */
	unsigned long	ipc_seq_no;	/* the IPC sequence number of this message */
	msg_header_t	kmsg_header;
}               ipc_netmsg_hdr_t;

/*
 * Bits for info field 
 */
#define IPC_INFO_SIMPLE		0x1
#define IPC_INFO_RPC		0x2

/*
 * Macro to test for network port equality.
 */
#define NPORT_EQUAL(nport1,nport2) (					\
	((nport1).np_puid.np_uid_high == (nport2).np_puid.np_uid_high)	\
	&& ((nport1).np_puid.np_uid_low == (nport2).np_puid.np_uid_low)	\
	&& ((nport1).np_sid.np_uid_low == (nport2).np_sid.np_uid_low)	\
	&& ((nport1).np_sid.np_uid_low == (nport2).np_sid.np_uid_low))


/*
 * TCP control messages.
 */
#define TCP_CTL_REQUEST		1
#define TCP_CTL_REPLY		2
#define TCP_CTL_CLOSEREQ	3
#define TCP_CTL_CLOSEREP	4

typedef struct tcp_ctl {
	int		ctl;
	unsigned long	trid;
	int		code;
	unsigned long	size;
	int		crypt_level;
} tcp_ctl_t, *tcp_ctl_ptr_t;

#define NETPORT_MSG_SIZE_MAX	(8 * 1024)

/*
 * Transport modules entry points.
 */
#define TR_TCP_ENTRY	0
#define TR_VMTP_ENTRY	1
#define TR_MAX_ENTRY	2
typedef struct {
    int		(*sendrequest)();
    int		(*sendreply)();
} transport_sw_entry_t;
extern transport_sw_entry_t transport_switch[TR_MAX_ENTRY];


/*
 * Transport ID's for both TCP and VMTP.
 */
typedef struct {
	unsigned long	v1;
	unsigned long	v2;
} trid_t;

#endif	/* _KERN_IPC_NETPORT_H_ */
