/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	sim_target.h,v $
 * Revision 1.1.3.2  92/02/27  16:07:10  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.2.4  92/01/31  11:21:17  Janet_Schank
 * 	Made 64bit modifications
 * 	[92/01/31  10:02:06  Janet_Schank]
 * 
 * Revision 1.1.2.3  92/01/28  18:29:38  Janet_Schank
 * 	Merged in changes from LA.
 * 	[92/01/28  18:09:58  Janet_Schank]
 * 
 * Revision 1.1.2.2  92/01/17  13:24:07  Janet_Schank
 * 	CAM support added
 * 	[92/01/17  11:19:33  Janet_Schank]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: sim_target.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/02/27 16:07:10 $
 */
#ifndef _SIM_TARGET_
#define _SIM_TARGET_

/* ---------------------------------------------------------------------- */

/* sim_target.h		Version 1.01			Nov 13, 1991 */

/*  This file contains the definitions needed for target mode operation
    of the SIM.

Modification History

	1.01	11/13/91	janet
	Added struct VERS defines.

	1.00	06/12/90	janet
	Created this file.
*/

/* ---------------------------------------------------------------------- */


#define INQ_PROC_TYPE	0x03	/* Processor type for inquiry command */
#define SIM_TARG_MODE_CMD_LN 16

#define TARG_CAM_RESOURCE	0x0
#define TARG_UNDEFINED_RESOURCE	-1

#define TARG_BUSFREE	 0x80000000
#define TARG_ATNSET	 0x40000000
#define TARG_CMDCPLT	 0x20000000

#define TARG_GOT_CMD	 0x10000000

#define TARG_DATAIN	 0x08000000
#define TARG_DATAOUT	 0x04000000
#define TARG_DATADNE	 0x02000000

/*
 * The following structure is used during target mode operation.
 */
typedef struct sim_targ_ws {
#define SIM_TARG_WS_VERS 1
    U32 flags;
    u_char it_conn;		/* Bit code of initiator and bit code	*
				 * of the target will be set.  Read off	*
				 * the SCSI bus during the selection.	*/
    U32 disconnect;		/* Set to zero if disconnects are disabled */
    u_char command[SIM_TARG_MODE_CMD_LN];
    				/* the command recieved from the	*
				 * initiator.				*/
    u_char command_len;
    I32 resource_type;
    I32 (*resource)();

} SIM_TARG_WS;

/*
 * Information for the inquiry command.
 */
#define TARG_VENDOR_ID		"DEC     "
#define TARG_PRODUCT_ID		"CAM TARGET MODE "
#define TARG_REVISION		"1.00"
#define TARG_INQ_LN		36

#endif /* _SIM_TARGET_ */
