/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	dme_turbo_94_ram.h,v $
 * Revision 1.1.3.2  92/02/27  16:02:40  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.2.4  92/01/31  11:18:14  Janet_Schank
 * 	Made 64bit modifications
 * 	[92/01/31  09:48:11  Janet_Schank]
 * 
 * Revision 1.1.2.3  92/01/28  18:27:06  Janet_Schank
 * 	Merged in changes from LA.
 * 	[92/01/28  18:07:22  Janet_Schank]
 * 
 * Revision 1.1.2.2  92/01/17  13:21:40  Janet_Schank
 * 	CAM support added
 * 	[92/01/17  11:17:20  Janet_Schank]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: dme_turbo_94_ram.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/02/27 16:02:40 $
 */
#ifndef __DME_TURBO_94_RAM_H__

#define __DME_TURBO_94_RAM_H__

/* ---------------------------------------------------------------------- */

/* dme_turbo_94_ram.h	Version 1.00			July 1, 1991 */

/*  This file contains the definitions and data structures needed by
    the 3MIN DME related files.

Modification History

	Version	  Date		Who	Reason

	1.00    12/31/90        rln     Created this file.
*/

typedef struct dme_3max_struct 
  {
    /*
     * These pointers contain the free DMA segments available to the
     * the SIM DME.
     *
     * Allocate pointers to each of the Active Segment structure.
     * The dme_XXkb_flink points at the first free segment and
     * dme_XXkb_blink points at the last free segment. The list
     * is empty if the blink points at the flink.
     */
    SEGMENT_ELEMENT *head_1kb;
    SEGMENT_ELEMENT *tail_1kb;
    SEGMENT_ELEMENT *head_4kb;
    SEGMENT_ELEMENT *tail_4kb;
    SEGMENT_ELEMENT *head_8kb;
    SEGMENT_ELEMENT *tail_8kb;
    SEGMENT_ELEMENT *head_16kb;
    SEGMENT_ELEMENT *tail_16kb;

    void*	SVAPTE;		/* System Virtual address of first PTE */
    				/* used to double map P0 Virt Addresses*/
    void*	SVA;		/* S0 address used to dbl mapped buffer*/

  } DME_3MAX_STRUCT;


#endif





