/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	devdriver.h,v $
 * Revision 1.1.3.9  92/05/21  11:29:55  William_Burns
 * 	Ansify endifs.
 * 	[92/05/15  11:52:13  William_Burns]
 * 
 * Revision 1.1.3.8  92/03/24  09:07:08  Jeff_Anuszczyk
 * 	Add MP macros to lock the hardware topology tree.
 * 	[92/03/19  17:42:59  Jeff_Anuszczyk]
 * 
 * Revision 1.1.3.7  92/03/13  17:28:40  halproject_Donald_Dutile
 * 	Merge to AG from HALPROJECT
 * 	[92/03/13  16:49:00  halproject_Donald_Dutile]
 * 
 * 	Added extern statements for BADADDR() & DELAY().
 * 	[92/03/09  22:08:54  Donald_Dutile]
 * 
 * Revision 1.1.3.6  92/03/12  13:36:37  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  10:57:14  Timothy_Burke]
 * 
 * 	Re-integrated MSI & CI bus types.
 * 	[92/03/10  10:38:13  Timothy_Burke]
 * 
 * 	Added fields for loadable driver support.
 * 	[92/03/09  19:46:50  Timothy_Burke]
 * 
 * Revision 1.1.3.5  92/03/10  10:13:48  Joseph_Amato
 * 	fix typo missing ";"
 * 	[92/03/10  10:10:35  Joseph_Amato]
 * 
 * Revision 1.1.3.4  92/03/09  10:39:26  Joseph_Amato
 * 	add mailbox ptr to keep data structure in synch with alpha
 * 	[92/03/09  08:45:44  Joseph_Amato]
 * 
 * Revision 1.1.3.3  92/02/24  11:46:36  Peter_Keilty
 * 	bmerge against ag.latest
 * 	[92/02/23  13:35:02  Peter_Keilty]
 * 
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:37:21  Peter_Keilty]
 * 
 * Revision 1.1.3.2  91/11/20  13:57:28  Hal_Project
 * 	Moved & derived from dec/machine/common; pool reorg
 * 	[91/11/18  08:39:33  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:17:37  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: devdriver.h,v $ $Revision: 1.1.3.9 $ (DEC) $Date: 92/05/21 11:29:55 $
 */ 
/*
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * New in OSF/1
 */

/*
 * Abstract:
 *	This module contains the definitions for the various data structures
 *	used by device drivers and configuration code.
 *
 * Revision History
 *
 *	25-Jan-1991	Mark Parenti (map)
 *		Original Version
 */

#ifndef DEVDRIVER_HDR
#define DEVDRIVER_HDR

struct bus_ctlr_common {
	u_long *mbox;
	struct bus *bus_hd;
};

typedef struct bus_ctlr_common * bus_ctlr_common_t;

#ifdef KERNEL
#include <io/common/handler.h>	
#endif /* KERNEL */

#ifdef KERNEL
extern struct bus       *system_bus;    /* Pointer to nexus bus structure */
#endif /* KERNEL */
/*
 * Define the MP lock macros for the hardware topology tree created
 * with the structures defined in the header file.  This lock is
 * intended to protect the entire topology tree since access to the
 * tree will most likely be very seldom.  Also, static initialization
 * of the tree need not get the lock since we are known to be single
 * threaded (not multi-user).
 */
#ifdef KERNEL
extern lock_data_t topology_tree_lock;
#define LOCK_TOPOLOGY_TREE	lock_write(&topology_tree_lock)
#define UNLOCK_TOPOLOGY_TREE	lock_done(&topology_tree_lock)
#endif /* KERNEL */

/* bus structure - 
 *
 *	The bus structure is used to describe a bus entity. A bus is an entity
 *	(real or imagined) to which other buses or controllers are logically
 *	attached. All systems have at least one bus, the system bus.
 */

struct	bus {
	u_long		*bus_mbox;
	struct bus	*nxt_bus;	/* next bus			*/
	struct controller *ctlr_list;	/* controllers connected to this bus */
	struct bus	*bus_hd;	/* pointer to bus this bus connected to */
	struct bus	*bus_list;	/* buses connected to this bus */
	int		bus_type;	/* bus type			*/
	char		*bus_name;	/* bus name 			*/
	int		bus_num;	/* bus number			*/
	int		slot;		/* node or slot number		*/
	char		*connect_bus;	/* bus connected to		*/
	int		connect_num;	/* bus num connected to		*/
	int		(*confl1)();	/* Level 1 configuration routine */
	int		(*confl2)();	/* Level 2 configuration routine */
	char		*pname;		/* port name, if needed		*/
	struct port	*port;		/* pointer to port structure	*/
	int		(**intr)();	/* interrupt routine(s) for this bus */
	int		alive;		/* See bit definitions below	*/
	struct bus_framework *framework; /* Bus rtns for loadable drivers*/
	char            *driver_name;   /* Name of controlling driver */
	caddr_t		private[5];	/* Reserved for this bus use	*/
	caddr_t		conn_priv[5];	/* Reserved for connected bus use */
	caddr_t		rsvd[5];	/* Reserved for future expansion */
};

/* controller structure - 
 *
 *	The controller structure is used to describe a controller entity. A
 *	controller is an entity which connects logically to a bus. A controller
 *	may control devices which are directly connected, such as disks or
 *	tapes, or may perform some other controlling operation such as 
 *	network interface.
 */

struct	controller {
	u_long		*ctlr_mbox;
	struct controller *nxt_ctlr;	/* pointer to next ctlr on this bus */
	struct device	*dev_list;	/* devices connected to this ctlr */
	struct bus	*bus_hd;	/* pointer to bus for this ctlr   */
	struct driver	*driver;	/* pointer to driver structure for */
					/* this controller 		   */
	int		ctlr_type;	/* controller type		*/
	char		*ctlr_name;	/* controller name		*/
	int		ctlr_num;	/* controller number		*/
	char		*bus_name;	/* bus name			*/
	int		bus_num;	/* bus number connected to 	*/
	int		rctlr;		/* remote controller number	*/
					/* e.g. ci node or scsi id	*/
	int		slot;		/* node or slot number		*/
	int		alive;		/* See bit definitions below	*/
	char		*pname;		/* port name			*/
	struct port	*port;		/* port structure		*/
	int		(**intr)();	/* interrupt routine(s) for this ctlr */
	caddr_t		addr;		/* virtual address of controller */
	caddr_t		addr2;		/* virtual address of second ctlr */
					/* register space		  */
	int		flags;		/* flags from config line	*/
	int		bus_priority;	/* bus priority from from config */
	int		ivnum;		/* interrupt vector number	*/
	int		priority;	/* system ipl level		*/
	int		cmd;		/* cmd for go routine		*/
	caddr_t		physaddr;	/* physical address of addr	*/
	caddr_t		physaddr2;	/* physical address of addr2	*/
	caddr_t		private[5];	/* Reserved for ctlr use	*/
	caddr_t		conn_priv[5];	/* Reserved for connected bus use */
	caddr_t		rsvd[5];	/* reserved for future expansion */
};

/* device structure -
 *
 *	The device structure is used to describe a device entity. A device
 *	is an entity that connects to, and is controlled by, a controller.
 */

struct	device {
	struct device	*nxt_dev;/* pointer to next dev on this ctlr */
	struct controller *ctlr_hd;	/* pointer to ctlr for this device */
	char		*dev_type;	/* device type			*/
	char		*dev_name;	/* device name			*/
	int		logunit;	/* logical unit	number		*/
	int		unit;		/* physical unit number		*/
	char		*ctlr_name;	/* controller name connected to */
	int		ctlr_num;	/* controller number for this device */
	int		alive;		/* See bit definitions below	*/
	caddr_t		private[5];	/* reserved for device use	*/
	caddr_t		conn_priv[5];	/* Reserved for connected controller use */
	caddr_t		rsvd[5];	/* reserved for future expansion */
};

/* Defines for device private structures */
#define perf private[1]

/* port structure - 
 *
 *	The port structure is used to contain information about a port.  A port
 *	is ??
 */

struct	port {
	int	(*conf)();		/* config routine for this port */
};

/* driver structure - 
 *
 *	The driver structure contains information about driver entry points
 *	and other driver-specific information.
 */

struct	driver {
	int	(*probe)();		/* see if a driver is really there */
	int	(*slave)();		/* see if a slave is there */
	int	(*cattach)();		/* controller attach routine */
	int	(*dattach)();		/* device attach routine */
	int	(*go)();		/* fill csr/ba to start transfer */
	caddr_t	*addr_list;		/* device csr addresses */
	char	*dev_name;		/* name of device which connects to */
					/* this controller		    */
	struct	device **dev_list;	/* backpointers to driver structs */
					/* indexed with device logunit    */
	char	*ctlr_name;		/* name of controller */
	struct	controller **ctlr_list;	/* backptrs to controller structs */
					/* indexed with controller number */
	short	xclu;			/* want exclusive use of bdp's */
	int	addr1_size;		/* size of first csr area */
        int	addr1_atype;	 	/* address space of first csr area */
	int	addr2_size;		/* size of second csr area */
        int	addr2_atype;	 	/* address space of second csr area */
	int	(*ctlr_unattach)();	/* controller unattach routine */
	int	(*dev_unattach)();	/* device unattach routine */
};

#ifdef KERNEL
/*
 * These routines provide dynamic extensions to bus functionality.  They
 * are used to configure in loadable drivers and to register interrupt
 * handlers.
 */
struct bus_framework {
	int		(*ctlr_configure)();	/* Ctlr configure routine     */
	int		(*ctlr_unconfigure)();	/* Ctlr unconfigure routine   */
	int		(*adp_unattach)();	/* Bus remove adapter routine */
	int		(*config_resolver)();	/* Autoconfig bus resolver    */
        ihandler_id_t   (*adp_handler_add)();	/* Register interrupt	      */
        int             (*adp_handler_del)();   /* De-register interrupt      */
        int             (*adp_handler_enable)(); /* Enable interrupt handler  */
        int             (*adp_handler_disable)(); /* Disable interrupt handler*/
	caddr_t		rsvd[5];		/* Rsvd for future expansion  */
	caddr_t		private[5];		/* Reserved for driver use    */
};
#endif /* KERNEL */

/*
 * Loadable driver configuration data structure:
 *
 * After the stanza entry has been parsed to produce a bus, controller and
 * device lists, the elements of these lists are packaged up and passed down
 * to the kernel via setsysinfo.  In order to have a single form of setsysinfo
 * command the following structure is used to represent all of the different
 * types.  It consists of the structures themselves with an identifying type
 * and name fields.  The name field is needed so that you could have kernel
 * bus, ctlr, dev lists with these entries for different drivers.
 *
 * The bus, controller and device structures conatin pointers to names.  Such
 * as connecting bus name, connecting controller name, or port name.  In order
 * to make it easy to pass this structure to the kernel via setsysinfo, the
 * name fields will be copied into this structure and then the name pointers
 * within the bus/controller/device structures will be setup in the kernel
 * to point to these strings.
 */
#define MAX_NAME        100     	/* Maximum name length          */
struct config_entry {
	struct  config_entry *e_next;	/* Next entry in linked list    */
	char 	e_name[MAX_NAME];	/* Driver name 			*/
	int	e_type;			/* type = bus, ctlr, dev        */
	union {
		struct bus		e_bus;
		struct controller	e_controller;
		struct device		e_device;
	} e_str;
	char 	e_nm_1[MAX_NAME];	/* Name string			*/
	char 	e_nm_2[MAX_NAME];	/* Name string			*/
	char 	e_nm_3[MAX_NAME];	/* Name string			*/
	char 	e_nm_4[MAX_NAME];	/* Name string			*/
};

/* Bus type definitions	*/

#define	BUS_IBUS	1
#define	BUS_TC		2
#define	BUS_XMI		3
#define	BUS_BI		4
#define	BUS_UNIBUS	5
#define	BUS_QBUS	6
#define	BUS_VME		7
#define BUS_MSI		8
#define BUS_CI		9
#define BUS_LSB		10
#define BUS_IOP		11
#define BUS_LAMB	12
#define BUS_FLAG	13
#define BUS_LBUS	14
#define BUS_FBUS	15



/* Alive field bit definitions */

#define	ALV_FREE	0x00000000	/* Device not yet processed  */
#define ALV_ALIVE	0x00000001	/* Device present and configured */
#define	ALV_PRES	0x00000002	/* Device present but no configed */
#define	ALV_NOCNFG	0x00000004	/* Device not to be configured	*/
#define	ALV_WONLY	0x00000008	/* Device is write-only		*/
#define	ALV_RONLY	0x00000010	/* Device is read-only		*/
#define ALV_LOADABLE	0x00000020	/* Device resolved by loadable */
#define ALV_NOSIZER	0x00000040	/* Sizer should ignore this item */

/* Define various constants used in configuring of loadable drivers */

#define	NEXUS_NUMBER		(-1)
#define LDBL_WILDNAME	"*"			/* Char field wildcard */
#define LDBL_WILDNUM		(-99)		/* Int field wildcard */
/*
 * Module types.
 */
#define BOGUS_TYPE	0x0		/* Invalid type			  */
#define BUS_TYPE	0x1		/* Bus type			  */
#define CONTROLLER_TYPE	0x2		/* Controller type		  */
#define DEVICE_TYPE	0x4		/* Device type			  */

/* External routine definitions */

#ifdef KERNEL
extern struct bus 		*get_sys_bus();
extern struct bus 		*get_bus();
extern struct bus 		*bus_search();
extern struct controller	*get_ctlr();
extern struct controller	*ctlr_search();
extern struct device		*get_device();
extern void			conn_ctlr();
extern void			conn_device();
extern void	 		conn_bus();
extern int			BADADDR();
extern int			DELAY();
#endif /* KERNEL */

#endif /* DEVDRIVER_HDR */
