/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cons_sw_data.c,v $
 * Revision 1.1.3.5  92/03/26  21:02:19  Barbara_Corriero
 * 	mmap() support
 * 	[92/03/19  19:08:17  Barbara_Corriero]
 * 
 * 	Added console driver mmap() support
 * 	[92/03/10  16:06:10  Barbara_Corriero]
 * 
 * Revision 1.1.3.4  92/02/24  19:07:06  Shirley_Smith
 * 	Modified for SSC support: removed invalid ssc_param() routine, added
 * 	ssc_cninit() routine.
 * 	[92/02/24  16:53:07  Shirley_Smith]
 * 
 * 	Modified for SSC support: removed invalid ssc_param() routine, added
 * 	ssc_cninit() routine.
 * 	[92/02/24  16:48:42  Shirley_Smith]
 * 
 * Revision 1.1.3.3  91/12/16  10:47:00  Gary_Dupuis
 * 
 * 	91/12/06	Gary Dupuis
 * 	Added support for Maxine (PERSONAL_DECstation)
 * 	1)  DSPERSONAL_DECSTATION was added to the list of machines
 * 	    using the scc routines.
 * 	2)  An entry was added to the cons_sw[] array for the MAXine.
 * 	[91/12/11  15:05:25  Gary_Dupuis]
 * 
 * Revision 1.1.2.2  91/11/19  18:15:46  Donald_Dutile
 * 	Moved from dec/data; pool reorg
 * 	[91/11/18  00:44:29  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:24:18  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: cons_sw_data.c,v $ $Revision: 1.1.3.5 $ (DEC) $Date: 92/03/26 21:02:19 $
 */ 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from cons_sw_data.c	4.4      (ULTRIX)  9/6/90";
 */

/*
 * Modification History
 *
 * 10-May-91    Paul Grist
 *	Added Entries for 3MAX+/BIGMAX (DS5000_300).
 *
 * 05-May-91	Joel Gringorten
 *	Changes for new WS graphics driver.
 *
 * 20-Dec-90 - Kuo-Hsiung Hsieh
 *	Changed DS5100 entry.  Mipsmate driver is now merged into DS3100.
 *	OSF started.
 *	-----------------------------------------------------------------
 *
 * 06-Sep-90 - Randall Brown
 *	Removed entries for 'cfb' and 'pm', they are now folded into fb driver
 *
 * 03-Apr-90 - Tim Burke
 * 	Added console support for Mipsmate (DS5100).
 *
 * 27-Feb-90 - Philip Gapuzte
 *	Added entries for DS5000_100 (3MIN) console ssc.
 *
 * 04-Dec-89 - Sam Hsu
 *	Added entries for DS5000 graphics accelerators to vcons_init.
 *
 * 29-Oct-89 - Randall Brown
 *
 *	Added the c_init entry to each switch entry.  Also added the 
 *	vcons_init table.
 *
 * 20-May-89 - Randall Brown
 *
 *	created file.
 *
 */
#include <hal/cons_sw.h>
#include <hal/cpuconf.h>


extern int nocons();
extern int noconsmmap();

#if defined(DS3100) || defined(DS5000) || defined(DS5100) 
int dcopen(), dcclose(), dcread();
int dcwrite(), dcioctl(), dcstart();
int dcstop(), dcselect(), dcputc(), dcgetc();
int dcprobe(), dcintr(), dc_cons_init();
int dcparam(), dcmmap();
extern struct tty dc_tty[];
#endif /* DS3100 */

#if defined(DS5000_100) || defined(DS5000_300) || defined(DSPERSONAL_DECSTATION)
int sccopen(), sccclose(), sccread();
int sccwrite(), sccioctl(), sccstart();
int sccstop(), sccselect(), sccputc(), sccgetc();
int sccprobe(), sccintr(), scc_cons_init();
int sccparam(), sccmmap();
extern struct tty scc_tty[];
#endif

#if defined(DS5400) || defined(DS5800) || defined(DS5500)
int ssc_cnopen(), ssc_cnclose(), ssc_cnread();
int ssc_cnwrite(), ssc_cnioctl(), ssc_cnrint();
int ssc_cnxint(), ssc_cnstart(), ssc_cnputc();
int ssc_cngetc(),ttselect();
int ssc_cninit();
extern struct tty cons[];
#endif

struct cons_sw cons_sw[] =
{	/* no system */
#ifdef DS3100 
	{	/* PMAX - DECstation 3100 */
	  DS_3100,		dcopen,			dcclose,
	  dcread,	  	dcwrite,		dcioctl,
	  dcintr,		dcintr,			dcstart,
	  dcstop,		dcselect,	        dcputc,
	  dcprobe,		dcgetc,			dc_cons_init,
	  dcparam,              dcmmap,			dc_tty,
	},
#endif /* DS3100 */

#ifdef DS5100
	{	/* MIPSMATE - DECsystem 5100 */
	  DS_5100,		dcopen,			dcclose,
	  dcread,	  	dcwrite,		dcioctl,
	  dcintr,		dcintr,			dcstart,
	  dcstop,		dcselect,	        dcputc,
	  dcprobe,		dcgetc,			dc_cons_init,
	  dcparam,              dcmmap,			dc_tty,
	},
#endif /* DS5100 */

#ifdef DS5400
	{	/* MIPSFAIR */
	  DS_5400,		ssc_cnopen,		ssc_cnclose,
	  ssc_cnread,		ssc_cnwrite,		ssc_cnioctl,
	  ssc_cnrint,		ssc_cnxint,		ssc_cnstart,
	  nocons,		ttselect,		ssc_cnputc,
	  nocons,		ssc_cngetc,		ssc_cninit,
	  nocons,		noconsmmap,		cons,
	},
#endif /* DS5400 */

#ifdef DS5800
	{	/* ISIS */
	  DS_5800,		ssc_cnopen,		ssc_cnclose,
	  ssc_cnread,		ssc_cnwrite,		ssc_cnioctl,
	  ssc_cnrint,		ssc_cnxint,		ssc_cnstart,
	  nocons,		ttselect,		ssc_cnputc,
	  nocons,		ssc_cngetc,		ssc_cninit,
	  nocons,		noconsmmap,		cons,
	},
#endif /* DS5800 */

#ifdef DS5000
	{	/* 3MAX - DECstation 5000 */
	  DS_5000,		dcopen,			dcclose,
	  dcread,	  	dcwrite,		dcioctl,
	  dcintr,		dcintr,			dcstart,
	  dcstop,		dcselect,	        dcputc,
	  dcprobe,		dcgetc,			dc_cons_init,
	  dcparam,		dcmmap,			dc_tty,
	},
#endif /* DS5000 */

#ifdef DS5500
	{	/* MIPSFAIR - 2 */
	  DS_5500,		ssc_cnopen,		ssc_cnclose,
	  ssc_cnread,		ssc_cnwrite,		ssc_cnioctl,
	  ssc_cnrint,		ssc_cnxint,		ssc_cnstart,
	  nocons,		ttselect,		ssc_cnputc,
	  nocons,		ssc_cngetc,		ssc_cninit,
	  nocons,		noconsmmap,		cons,
	},
#endif /* DS5500 */

#ifdef DS5000_100 
	{	/* 3MIN */
	  DS_5000_100,		sccopen,		sccclose,
	  sccread,	  	sccwrite,		sccioctl,
	  sccintr,		sccintr,		sccstart,
	  sccstop,		sccselect,	        sccputc,
	  sccprobe,		sccgetc,		scc_cons_init,
	  sccparam,		sccmmap,		scc_tty,
	},
#endif /* DS5000_100 */

#ifdef DSPERSONAL_DECSTATION 
	{	/* MAXine */
	  DS_MAXINE,		sccopen,		sccclose,
	  sccread,	  	sccwrite,		sccioctl,
	  sccintr,		sccintr,		sccstart,
	  sccstop,		sccselect,	        sccputc,
	  sccprobe,		sccgetc,		scc_cons_init,
	  sccparam,		sccmmap,		scc_tty,
	},
#endif /* DSPERSONAL_DECSTATION */

#ifdef DS5000_300 
	{	/* 3MAX+ and BIGMAX */
	  DS_5000_300,		sccopen,		sccclose,
	  sccread,	  	sccwrite,		sccioctl,
	  sccintr,		sccintr,		sccstart,
	  sccstop,		sccselect,	        sccputc,
	  sccprobe,		sccgetc,		scc_cons_init,
	  sccparam,		sccmmap,		scc_tty,
	},
#endif /* DS5000_300 */


	{	/* always need 0 to be last entry */
	  0,			0,			0,
	  0,			0,			0,
	  0,			0,			0,
	  0,			0,			0,
	  0,			0,			0,
	  0,
        }
};	


/*
#include "gq.h"
#if NGQ > 0
int gq_cons_init();
#endif

#include "ga.h"
#if NGA > 0
int ga_cons_init();
#endif
*/

#include "fb.h"
#if NFB > 0
int fb_cons_init();
#endif


(*vcons_init[])() = {

#if NGQ > 0
    gq_cons_init,
#endif

#if NGA > 0
    ga_cons_init,
#endif

#if NFB > 0
    fb_cons_init,
#endif

    0			/* we must have a 0 entry to end the loop */
    };

