/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	binlog_data.c,v $
 * Revision 1.1.2.3  92/06/01  10:39:53  Scott_Cranston
 * 	 Changed #include path for binlog.h
 * 	[92/05/19  10:29:56  Scott_Cranston]
 * 
 * Revision 1.1.2.2  92/02/28  13:24:53  Scott_Cranston
 * 	Initial file creation.
 * 	[92/01/14  16:23:32  Scott_Cranston]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: binlog_data.c,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/06/01 10:39:53 $";
#endif


#include <kern/queue.h>
#include <sys/types.h>
#include <sys/time.h>
#include <dec/binlog/binlog.h>


/*
 * kernel binary event log buffer size
 *
 * The buffer size, in bytes, is enforced to be within minimum/maximum limits:
 *
 *            BINLOG_BUFMIN    (8 * 1024)
 *            BINLOG_BUFMAX   (48 * 1024)
*/
int binlog_bufsize = (24 * 1024);



/*
 * Initialized binary event logging status.
 *
 * Options are ('or' multiple options together):
 *
 *   BINLOG_ON       -  Enables binary event logging. [normally enabled]
 *
 *   BINLOG_ASCIION  -  Enables having ascii messages that get sent to the
 *                      syslog facility are also put into the binary event
 *                      log.  [normally disabled]  By default panic and
 *                      system startup messages are always logged.
*/
int binlog_status = BINLOG_ON;

