#
# @DEC_COPYRIGHT@
#
#
# HISTORY
# $Log:	template.mk,v $
# Revision 4.3.5.4  92/05/15  15:35:04  Marc_Evans
# 	support for GPROF pc sampling
# 	[92/05/15  15:09:09  Marc_Evans]
# 
# Revision 4.3.5.3  92/03/12  14:46:51  Brian_Stevens
# 	Removed message stating 'No dynamic linking' now that loadable
# 	modules are in.
# 	[92/03/12  14:42:14  Brian_Stevens]
# 
# Revision 4.3.5.2  92/02/28  21:23:00  Sec_Proj_Michael_Fairbrother
# 	Merge Phil Cameron's work with Security changes
# 	[92/02/05  09:12:51  Michael_Fairbrother]
# 
# Revision 4.3.1.3  92/01/23  08:37:34  Philip_Cameron
# 	fix G 0 option for dynamic cc of dynamic files.
# 
# Revision 4.3.1.2  92/01/20  14:07:26  Philip_Cameron
# 	Add support for dynamic load modules
# 
# Revision 4.3  91/11/26  11:05:23  devbld_zk3
# 	Baselevel AG_BL0
# 
# Revision 4.2.2.2  91/10/23  15:01:35  William_Burns
# 	Merge from ODE/TIN: revision 3.6.9.2
# 	date: 91/10/17 21:12:51;  author: devrcs;  state: Exp;  lines added/del: 2/2
# 	sccs rev: 3.7;  orig date: 91/10/02 08:36:52;  orig author: fred
# 	Fred Canter - kernel warnings.
# 	[91/10/23  10:00:07  William_Burns]
# 
# Revision 4.2  91/09/19  22:06:52  devbld
# 	Adding ODE Headers
# 
# $EndLog$
#
#
#	@(#)$RCSfile: template.mk,v $ $Revision: 4.3.5.4 $ (DEC) $Date: 92/05/15 15:35:04 $
# (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
#
# Mach Operating System
# Copyright (c) 1989 Carnegie-Mellon University
# All rights reserved.  The CMU software License Agreement
# specifies the terms and conditions for use and redistribution.
#
# OSF/1 Release 1.0
######################################################################
#BEGIN	Machine dependent Makefile fragment for the MIPS
######################################################################
# ------------------------------------------------------------------
# | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights |
# | Reserved.  This software contains proprietary and confidential |
# | information of MIPS and its suppliers.  Use, disclosure or     |
# | reproduction is prohibited without the prior express written   |
# | consent of MIPS.                                               |
# ------------------------------------------------------------------
#
# Makefile for 4.3 bsd on MIPS Computer Systems Charleston architecture
#

#
# To build a Mach-O kernel define MACHO in the config file
#
KCC=${COFF_GCC_EXEC_PREFIX}cc

RM=		rm -f
GPSIZE=		${MACHO?0:18}

# don't pass -EL to gcc
#
ENDIAN=${NO_GCC?-EL:}

# mig generated c files require -Imach for gcc so that mach includes 
# can be found.  
# Makefile.template checks for $@_IMACH and adds a -Imach to the flags.
#
mach_user_internal.o_MIG =
exc_user.o_MIG = 
memory_object_default_user.o_MIG =
memory_object_user.o_MIG =

#
# COPTS is recognized by config and massaged for profiling kernels
#
# cc options for most kernel sources
# CCNFLAGS - normal files
# CCDFLAGS - device drivers
# CCSFLAGS - swap*.c files
# CCASFLAGS - *.s files
# CCPFLAGS - profiling *.c files
# CCPASFLAGS - profiling *.s files
#
# CCOPTS may be set from the config file
# CDEBUGOPTS may be set from the config file
# ASOPTS may be set from the config file
# ENDIAN may be set from the config file
#
CCPROFOPT=-p
CCOPTS=-D__mips__=1 -D__MIPSEL__=1 -Dmips=1 -DMIPSEL=1

CCNFLAGS= -c -O2 ${ENDIAN} ${CCOPTS} ${COPTS} ${DEFINES}
CCDFLAGS= -c -O0 ${ENDIAN} ${CCOPTS} ${COPTS} ${DEFINES}
CCSFLAGS= -c -O2 ${ENDIAN} ${CCOPTS} ${COPTS} ${DEFINES}
# HACK: should this be ASOPTS in config file? Fred Canter -- 5/1/91
CCASFLAGS= -c -O0 ${ENDIAN} ${ASOPTS} ${COPTS} ${DEFINES} -DASSEMBLER -DMIPSEL=1 -Dmips=1
CCPFLAGS= -c ${ENDIAN} ${CCOPTS} ${PCOPTS} ${PROFOPTS} ${DEFINES}
CCPASFLAGS= -c ${ENDIAN} ${ASOPTS} ${PCOPTS} ${PROFOPTS} ${DEFINES} -DASSEMBLER

# flags for dynamic kernel module linking
#DCC_NFLAGS= -pic-names ${VMUNIX_PICNAMES} -c ${ENDIAN} ${CCOPTS} -MD -G 0 \
#	${CDEBUGOPTS} ${ALLOPTS} ${GCC_OPTS} ${INCLUDES} ${IDENT} \
#	${ALLDEFINES} ${DEFINES}
#DCC_DFLAGS= -pic-names ${VMUNIX_PICNAMES} -c ${ENDIAN} ${CCOPTS} -MD -G 0 \
#	${CDEBUGOPTS} ${ALLOPTS} ${GCC_OPTS} ${INCLUDES} ${IDENT} \
#	${ALLDEFINES} ${DEFINES}
DCC_PFLAGS= -pic-names ${VMUNIX_PICNAMES} -c ${ENDIAN} ${CCOPTS} \
	${PCOPTS} ${PROFOPTS} ${DEFINES}
DCOPTS_P=${CDEBUGOPTS} -G 0 ${ALLOPTS} ${GCC_OPTS}
DCOPTS=  ${DCOPTS_P} ${${@}_MIG?-Imach:}
DCC_NFLAGS= -c -O2 ${ENDIAN} ${CCOPTS} ${DCOPTS} ${DEFINES}
DCC_DFLAGS= -c -O0 ${ENDIAN} ${CCOPTS} ${DCOPTS} ${DEFINES}

#
LDOBJS_PREFIX=entry.o
LDFLAGS= ${MACHO?:${ENDIAN} -G ${GPSIZE} -N} -T ${TEXTBASE} -e start ${LDOPTS} -non_shared

# define volatile to be __volatile__ for gcc with -traditional
#
GCC_EXTRAS=-std0 -EL -signed
GCC_OPTS=${NO_GCC?:${GCC_EXTRAS}}

${SOBJS}: assym.s

#DEPENDS=${NO_GCC?-G ${GPSIZE}:-MD -G ${GPSIZE}}
DEPENDS=-G ${GPSIZE}

SYSDEPS_PREFIX=libvmunix


libvmunix: vmunix.sys


######################################################################
#END	Machine dependent Makefile fragment for the MIPS
######################################################################
