/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	uswitch.h,v $
 * Revision 1.1.2.3  92/05/05  16:33:01  Peter_Lega
 * 	System V Null ptr. behavior
 * 
 * Revision 1.1.2.2  92/03/28  17:53:33  Alaa_Zeineldine
 * 	Merge
 * 	[92/03/28  17:33:34  Alaa_Zeineldine]
 * 
 * 	Initial revision
 * 	[92/03/26  14:18:25  Alaa_Zeineldine]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: uswitch.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/05/05 16:33:01 $
 */
#ifndef _SYS_USWITCH_H_
#define _SYS_USWITCH_H_

#ifndef _HABITAT_H_
#include <sys/habitat.h>
#endif

/*
 * Values for "cmd" used by the habitat system call 
*/
#define USC_GET		1
#define USC_SET		2

/*
 * Feature macros:
 * u_uswitch is laid out:
 * bits 0-7:  habitat value
 * bit  8:    set   if *(NULL) == 0 for calling process. (System V behavior)
 *            clear if *(NULL) causes SIGSEGV. (default)
 * bits 9-31: reserved for future use.
*/

#define USW_NULLP	(1<<8)

/* mask out all but habitat */
#define USW_GETHAB(x)	((x)&(0xff))

/* unused bits mask */
#define USW_UNUSED(x)	((x)&(0xfffffe00))


/*
 * Value macros
 * USW_MIN and USW_MAX are used for range checking. Currently they are
 * defined by the min and max habitat values, but that can change when
 * non-habitat related switches are used.
*/
#define USW_MIN		hbval(DEFAULT_HAB_NO)
#define USW_MAX		hbval(MAX_HAB_NO)

/*
 * WFS values for switching worlds (aka file name space mapping)
*/
#define USW_SVID2	hbval(SVID2_HAB_NO)
#define USW_SVID3	hbval(SVID3_HAB_NO)
#define USW_SVR4	hbval(SVR4_HAB_NO)
#define USW_SOE2	hbval(SOE2_HAB_NO)

/* 
 * Toggle values
*/
#define USW_OFF		0
#define USW_ON		1

#endif /* _SYS_USWITCH_H_ */
