/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	types.h,v $
 * Revision 4.2.4.7  92/06/19  12:43:31  Maria_Vella
 * 	Modified SCSI/CAM macros to allow for more SCSI controllers.
 * 	[92/06/18  15:44:40  Maria_Vella]
 * 
 * Revision 4.2.4.6  92/05/07  13:26:45  Thomas_Tierney
 * 	Merge with AG.
 * 	[92/05/07  12:46:19  Thomas_Tierney]
 * 
 * 	Check in for next ag.latest merge.
 * 	[92/04/30  10:14:33  Thomas_Tierney]
 * 
 * 	Check-in for remerge
 * 	[92/04/30  09:39:52  Thomas_Tierney]
 * 
 * 	Merge
 * 	[92/04/23  10:37:13  Thomas_Tierney]
 * 
 * 	Added new dev_t annotation macros and typedefs.
 * 	[92/04/21  16:26:22  Thomas_Tierney]
 * 
 * Revision 4.2.4.5  92/04/08  12:16:22  David_Metsky
 * 	Added ssize_t definition for POSIX standards work
 * 	[92/03/31  18:20:00  David_Metsky]
 * 
 * Revision 4.2.4.4  92/03/28  17:39:58  Diane_Lebel
 * 	AG merge
 * 	[92/03/28  17:38:21  Diane_Lebel]
 * 
 * 	Put MAX_NOFILE back in
 * 	[92/03/28  17:33:12  Diane_Lebel]
 * 
 * Revision 4.2.4.3  92/03/27  18:06:38  Diane_Lebel
 * 	AG merge
 * 	[92/03/27  18:00:34  Diane_Lebel]
 * 
 * 	Added support for per-process configurable file descriptor
 * 	limits through setrlimit syscall.
 * 	[92/03/26  19:54:51  Diane_Lebel]
 * 
 * Revision 4.2.4.2  92/02/24  12:02:36  Peter_Keilty
 * 	bmerge against ag.latest
 * 	[92/02/23  13:47:17  Peter_Keilty]
 * 
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:46:16  Peter_Keilty]
 * 
 * Revision 4.2  91/09/19  23:02:14  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: types.h,v $ $Revision: 4.2.4.7 $ (DEC) $Date: 92/06/19 12:43:31 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * types.h
 *
 * Modification History:
 *
 * 27-Mar-92    David Metsky
 *      Added ssize_t definition for ISO/IEC 9945 (POSIX 1990)
 * 3-Jun-91     lebel
 *	Added support for > 64 open files per process.
 * 4-Apr-91     Paula Long
 *      Added P1003.4 required extensions.  
 *
 */

/*
 * COMPONENT_NAME: type declaration header file
 *
 * ORIGIN: IBM, ATT, BSD
 *
 * Copyright International Business Machines Corp. 1985, 1988
 * All Rights Reserved
 * Licensed Material - Property of IBM
 *
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the Rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *      (#)types.h     7.1 (Berkeley) 6/4/86
 */

#ifndef _SYS_TYPES_H_
#define _SYS_TYPES_H_
#include <standards.h>

#if     !defined(ASSEMBLER) && !defined(LOCORE)

#ifdef   _ANSI_C_SOURCE
/*
 * ANSI C required typedefs
 */

#ifndef _VA_LIST
#define _VA_LIST
typedef char *          va_list;
#endif

#ifndef _PTRDIFF_T
#define _PTRDIFF_T
typedef int             ptrdiff_t;
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned short  wchar_t;
#endif

#ifndef _FPOS_T
#define _FPOS_T
typedef long            fpos_t;
#endif

#ifndef _TIME_T
#define _TIME_T
typedef long            time_t;
#endif

#ifndef _CLOCK_T
#define _CLOCK_T
typedef int             clock_t;
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned long   size_t;
#endif

#endif   /* _ANSI_C_SOURCE */


#ifdef   _POSIX_SOURCE

typedef long                    ssize_t; /* Required for ISO/IEC 9945-1:1990 */

/*
 * shorthand type definitions for unsigned storage classes
 */
typedef	unsigned char	uchar_t;
typedef	unsigned short	ushort_t;
typedef	unsigned int	uint_t;
typedef unsigned long	ulong_t;
typedef	volatile unsigned char	vuchar_t;
typedef	volatile unsigned short	vushort_t;
typedef	volatile unsigned int	vuint_t;
typedef volatile unsigned long	vulong_t;


#if	defined(__vax__) || defined(__ns32000__) || defined(__i386__)
typedef	struct	{ int r[1]; } *physadr_t;
typedef	struct	label_t	{
	int	val[14];
} label_t;
#endif	/* defined(__vax__) || defined(__ns32000__) || defined(__i386__) */

#ifdef	__ibmrt__
typedef	struct	{ int r[1]; } *physadr_t;
typedef	struct	label_t	{
	int	val[16];
} label_t;
#endif	/* __ibmrt__ */

#if	defined(__mc68000__) || defined(__mc68000)
typedef struct  { short r[1]; } *physadr_t;
typedef struct  label_t {
        int     val[13];
} label_t;
#endif	/* __mc68000__ */

#ifdef __sparc__
typedef struct  { int r[1]; } *physadr_t;
typedef struct label_t {
        int     val[2];
} label_t;
#endif	/* __sparc__ */

#ifdef	__mips__
typedef	struct	{ int r[1]; } *physadr_t;
/*
 * WARNING:
 * this must match the definition of kernel jmpbuf's in machine/pcb.h
 */
typedef	struct	label_t	{
	int	val[12];
} label_t;
#endif	/* __mips__ */

typedef long		level_t;
typedef	long		daddr_t;	/* disk address */
typedef	char *		caddr_t;	/* "core" (i.e. memory) address */
typedef long *  qaddr_t;        /* should be typedef quad * qaddr_t; */
typedef	ulong_t		ino_t;		/* inode number (filesystem) */
typedef short		cnt_t;
typedef uint_t		dev_t;		/* device number (major+minor) */
typedef	long		chan_t;		/* channel number (minor's minor) */

#ifdef  _KERNEL
typedef ulong_t  off_t;			/* file offset */
#else   /* _KERNEL */
typedef long    off_t;			/* file offset */
#endif  /* _KERNEL */

typedef	long		paddr_t;
typedef	ushort_t	nlink_t;
typedef long    	key_t;		/* ipc key type */
typedef	ulong_t		mode_t;		/* file mode */
typedef ulong_t		uid_t;		/* user ID */
typedef ulong_t		gid_t;		/* group ID */
typedef	void *		mid_t;		/* module ID	*/
typedef	long		pid_t;		/* process ID */
typedef char		slab_t[12];	/* security label */


/* typedef for signal mask */
typedef unsigned int 	sigset_t;
#ifndef _KERNEL
/*
 * name conflict.
 *              /kernel/kern typedefs timer_t to something else.
 *              The file isn't exported.
 */
typedef long            timer_t;        /* timer id for _POSIX_4SOURCE */
#endif /* !defined(_KERNEL) */
#endif /* _POSIX_SOURCE */

#ifdef _OSF_SOURCE

#ifndef NULL
#define	NULL	0
#endif

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

typedef void (*sig_t)();

/*
 * Types used by dev_t annotation macros (see below)
 */
typedef uint_t	major_t;      /* major device number   */
typedef uint_t	minor_t;      /* minor device number   */
typedef uint_t	devs_t;       /* device-specific info  */
typedef uint_t	unit_t;       /* unit number of device */


/*
 * Basic system types and major/minor device constructing/busting macros.
 */
#define major(x)	((major_t)  (((dev_t)(x)>>20)&07777))
#define minor(x)	((minor_t)  ((dev_t)(x)&03777777))
#define makedev(x,y)	((dev_t)    (((major_t)(x)<<20) | (minor_t)(y)))

/*
 * Disk/Tape (SCSI/CAM - DSA) specific dev_t annotations macros.
 */
#define MAKEMINOR(u,d)  ((minor_t)  (((unit_t)(u)<<6) |(devs_t)(d)))
#define GETUNIT(dev)	((unit_t)   (minor(dev)>>6)&037777)
#define GETDEVS(dev)	((devs_t)   (minor(dev))&077)
#define MAKECAMMINOR(u,d) ((minor_t) MAKEMINOR((((u&0770)<<5)|((u&07)<<4)),d))
#define GETCAMUNIT(x)   ((unit_t) (((GETUNIT(x))>>5)&0770)|((GETUNIT(x)>>4)&07))
#define GETCAMTARG(x)   ((unit_t) ((x >> 3)&07))

#include <mach/machine/vm_types.h>

/*
 * shorthand type definitions for unsigned storage classes
 */
typedef	uchar_t		uchar;
typedef	ushort_t	ushort;
typedef	uint_t		uint;
typedef ulong_t		ulong;

typedef	physadr_t	physadr;


/* typedefs for BSD unsigned things */
typedef	uchar_t		u_char;
typedef	ushort_t 	u_short;
typedef	uint_t		u_int;
typedef	ulong_t		u_long;
typedef	vuchar_t	vu_char;
typedef	vushort_t 	vu_short;
typedef	vuint_t		vu_int;
typedef	vulong_t	vu_long;

#ifdef  _KERNEL
typedef struct  _quad { u_long val[2]; } quad;
#else   /* _KERNEL */
typedef struct  _quad { long val[2]; } quad;
#endif  /* _KERNEL */

typedef	long	swblk_t;
typedef u_long	fixpt_t;

/* We don't really want to include all of limits.h to get the 
   real value of this, so we leave this ugly constant here */
#define	NBBY	8		/* number of bits in a byte */

/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here is equal
 * to OPEN_MAX_SYSTEM in param.h since that defines the absolute maximum 
 * number of file descriptors that a process can open.
 */
#define MAX_NOFILE      4096
#ifndef	FD_SETSIZE
#define	FD_SETSIZE	MAX_NOFILE
#endif

typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */

#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))


#endif   /* _OSF_SOURCE */

#endif  /* ASSEMBLER */


#endif /* _SYS_TYPES_H_ */
