/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	mman.h,v $
 * Revision 4.2.2.4  92/06/15  16:31:07  Jeffrey_Denham
 * 	"Submit to AG"
 * 
 * Revision 4.2.3.2  92/06/15  15:11:38  Jeffrey_Denham
 * 	Update for POSIX.4/D11 by adding process memory locking data.
 * 
 * Revision 4.2.2.3  92/05/06  16:20:59  Marian_Macartney
 * 	Replace #else removed by last submittor
 * 	[92/05/06  16:20:30  Marian_Macartney]
 * 
 * Revision 4.2.2.2  92/03/27  16:19:37  Lai-Wah_Hui
 * 	"Add RT support"
 * 
 * Revision 4.2.1.3  92/03/27  15:23:07  Lai-Wah_Hui
 * 	Add RT support
 * 
 * Revision 4.2.1.2  92/03/27  10:48:25  Lai-Wah_Hui
 * 	Add P1003.4 Shared Memory function prototypes
 * 
 * Revision 4.2  91/09/19  22:58:47  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: mman.h,v $ $Revision: 4.2.2.4 $ (DEC) $Date: 92/06/15 16:31:07 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *

 */

#ifndef	_SYS_MMAN_H_
#define _SYS_MMAN_H_

/* protections are chosen from these bits, or-ed together */
#define PROT_NONE	0		/* no access to these pages */
#define PROT_READ	0x1		/* pages can be read */
#define PROT_WRITE	0x2		/* pages can be written */
#define PROT_EXEC	0x4		/* pages can be executed */

/* flags contain sharing type, mapping type, and options */

/* mapping visibility: choose either SHARED or PRIVATE */
#define MAP_SHARED	0x1		/* share changes */
#define MAP_PRIVATE	0x2		/* changes are private */

/* mapping region: choose either FILE or ANONYMOUS */
#define	MAP_FILE	0x00		/* map from a file */
#define	MAP_ANONYMOUS	0x10		/* man an unnamed region */
#define	MAP_ANON	0x10		/* man an unnamed region */
#define	MAP_TYPE	0xf0		/* the type of the region */

/* mapping placement: choose either FIXED or VARIABLE */
#define	MAP_FIXED	0x100		/* map addr must be exactly as specified */
#define	MAP_VARIABLE	0x00		/* system can place new region */

/* other flags */

#define	MAP_HASSEMAPHORE 0x0200		/* region may contain semaphores */
#define	MAP_INHERIT	0x0400		/* region is retained after exec */
#define MAP_UNALIGNED	0x0800		/* allow non-page-aligned file offset */

/* advice to madvise */
#define MADV_NORMAL	0		/* no further special treatment */
#define MADV_RANDOM	1		/* expect random page references */
#define MADV_SEQUENTIAL	2		/* expect sequential page references */
#define MADV_WILLNEED	3		/* will need these pages */
#define MADV_DONTNEED	4		/* dont need these pages */
#define	MADV_SPACEAVAIL	5		/* ensure that resources are available */

/* msem conditions and structure */
typedef struct {
	int msem_state;		/* The semaphore is locked is non-zero. */
	int msem_wanted;	/* Threads are waiting on the semaphore. */
}msemaphore;

#define MSEM_UNLOCKED 	0	/* Initialize the semahore to unlocked */
#define MSEM_LOCKED 	1	/* Initialize the semahore to locked */
#define MSEM_IF_NOWAIT	2	/* Do not wait if semaphore is locked */
#define MSEM_IF_WAITERS	3	/* Unlock only if there are waiters */

/* msync flags */
#define MS_ASYNC 1		/* Asynchronous cache flush */
#define MS_SYNC  3		/* Synchronous cashe flush */
#define MS_INVALIDATE 4		/* Invalidate cached pages */

#if !defined(_NO_PROTO) && !defined(KERNEL)

extern int	madvise(caddr_t addr, size_t len, int behav);
extern caddr_t	mmap(caddr_t addr, size_t len, int prot, int flags, int filedes, off_t off);
extern int	mprotect(caddr_t addr, size_t len, int prot);
extern msemaphore 	*msem_init(msemaphore *sem, int initial_value);
extern int	msem_lock(msemaphore *sem, int condition);
extern int	msem_remove(msemaphore *sem);
extern int	msem_unlock(msemaphore *sem, int condition);
extern int	msync(caddr_t addr, size_t len, int flags);
extern int	munmap(caddr_t addr, size_t len);
extern int      shm_open(const char *path, int oflag, mode_t mode);
extern int      shm_unlink(const char *path);

#else /* _NO_PROTO || KERNEL */

extern int	madvise();
extern caddr_t	mmap();
extern int	mprotect();
extern msemaphore 	*msem_init();
extern int	msem_lock();
extern int	msem_remove();
extern int	msem_unlock();
extern int	msync();
extern int	munmap();
extern int      shm_open();
extern int      shm_unlink();
#endif /* _NO_PROTO || KERNEL */

#ifdef _POSIX_4SOURCE

#include <sys/memlk.h>

#define MCL_CURRENT  C_PROLOCK	/* Lock all currently mapped paged */
#define MCL_FUTURE   F_PROLOCK  /* Lock all additions to address space */

#ifndef _NO_PROTO
extern int	mlockall (int);
extern int	munlockall ();
extern int	mlock   (void *, size_t);
extern int	munlock (void *, size_t);
#else
extern int	mlockall ();
extern int	munlockall ();
extern int	mlock   ();
extern int	munlock ();
#endif

/*
 * POSIX and SVID differ on how mlockall() handles a flags field if
 * neither MCL_CURRENT nor MCL_FUTURE are set.  The following macro follows
 * the SVID behavior by setting the TYPE field in the memlk() to NULL (EINVAL).
 * If POSIX is accepted, TYPE should be set to NOP.
*/
#define mlockall(flags) memlk((flags)&(MCL_CURRENT|MCL_FUTURE), NULL, NULL)
#define munlockall() 	memunlk(PROLOCK, NULL, NULL)
#define mlock(addr, size) 	memlk(REGLOCK, (addr), (size))
#define munlock(addr, size) 	memunlk(REGLOCK, (addr), (size))

#endif /* _POSIX_4SOURCE */

#endif	/* _SYS_MMAN_H_ */
