/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	flock.h,v $
 * Revision 4.2.2.3  92/04/24  15:20:52  Diane_Lebel
 * 	AG merge
 * 	[92/04/24  15:16:13  Diane_Lebel]
 * 
 * 	lockmgr fixes
 * 	[92/04/22  18:17:51  Diane_Lebel]
 * 
 * Revision 4.2.2.2  92/03/26  16:04:49  Diane_Lebel
 * 	added support for NFS locking
 * 	[92/03/25  17:44:11  Diane_Lebel]
 * 
 * Revision 4.2  91/09/19  22:57:36  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: flock.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 92/04/24 15:20:52 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_SYS_FLOCK_H
#define	_SYS_FLOCK_H

#ifdef	_KERNEL
#include <unix_locks.h>
#if	UNIX_LOCKS
#include <kern/lock.h>
#endif
#endif

/* file locking structure (connected to file table entry) */
#ifdef	_KERNEL
/*
 * Locking constraints on the filock structure.
 * 	Field			Comment
 *	-----			-------
 *	set			FICHAIN_LOCK (from flip field)
 *	stat			FICHAIN_LOCK
 *	prev			FICHAIN_LOCK
 *	next			FICHAIN_LOCK
 *	flip			read-only
 */
#endif
struct	filock	{
	struct	eflock set;	/* contains type, start, and length */
	union	{
		int wakeflg;	/* for locks sleeping on this one */
		int blkpid;	/* pid of blocking lock
				 * (for sleeping locks only)
				 */
	}	stat;
	struct	filock *prev;
	struct	filock *next;
	struct	flino  *flip;	/* back pointer to chain we are on */
	int 	class;		/* Class of lock (FILE_LOCK or LOCKMGR) */
	int	lock_id;	/* unique ID for this filock */
	int	blocked_by;	/* lock_id of blocking lock */
	pid_t   blkrpid;	/* rpid of blocking lock */
	long	blkrsys;	/* rsys of blocking lock */
};

/* table to associate files with chain of locks */
#ifdef	_KERNEL
/*
 * Locking constraints for the flino structure.
 *	Field			Comment
 *	-----			-------
 *	vp			read-only
 *	fl_refcnt		flino_lock
 *	fl_flck			fi_chain_lock
 *	prev			FIDS_LOCK (global lock)
 *	next			FIDS_LOCK (global lock)
 *
 * The FIDS_LOCK cannot be taken while holding the flino_lock
 */
#endif
struct	flino {
	struct vnode *vp;	 /* vnode address for the file */
	int	fl_refcnt;	 /* # procs currently referencing this flino */
	struct	filock *fl_flck; /* pointer to chain of locks for this file */
	struct	flino  *prev;
	struct	flino  *next;
#ifdef i386
	unsigned short status;	/* for Xenix compatibility */
#endif
	udecl_simple_lock_data(, flino_lock)
#if	defined(_KERNEL) && UNIX_LOCKS
	lock_data_t	fichain_lock;	/* lock to protect fl_flck chain */
#endif
};

/* file and record locking configuration structure */
/* record and file use totals may overflow */
#ifdef	_KERNEL
/*
 * Locking constraints for the flockinfo structure.
 *	Field		Comment
 *	-----		-------
 *	recs		read-only
 *	fils		read-only
 *	reccnt		flckinfo_lock
 *	filcnt		flckinfo_lock
 *	rectot		flckinfo_lock
 *	filtot		flckinfo_lock
 */
#endif
struct flckinfo {
	long recs;	/* number of records configured on system */
	long fils;	/* number of file headers configured on system */
	long reccnt;	/* number of records currently in use */
	long filcnt;	/* number of file headers currently in use */
	long rectot;	/* number of records used since system boot */
	long filtot;	/* number of file headers used since system boot */
#ifdef	_KERNEL
	udecl_simple_lock_data(, flckinfo_lock)
#endif
};

extern struct flckinfo	flckinfo;

#ifdef	_KERNEL

/*  Lock classes, determines how they are treated when they are unlocked. */
#define FILE_LOCK       0       /* Generic class no special treatment */
#define IO_LOCK         1       /* Indicates I/O waiting to complete */
#define LOCKMGR         2       /* Indicates lock manager lock */

#define	FLCKINFO_LOCK(f)	usimple_lock(&(f)->flckinfo_lock)
#define	FLCKINFO_UNLOCK(f)	usimple_unlock(&(f)->flckinfo_lock)
#define	FLCKINFO_LOCKINIT(f)	usimple_lock_init(&(f)->flckinfo_lock)

#define	FLINO_LOCK(f)		usimple_lock(&(f)->flino_lock)
#define	FLINO_UNLOCK(f)		usimple_unlock(&(f)->flino_lock)
#define	FLINO_LOCKINIT(f)	usimple_lock_init(&(f)->flino_lock)

#define	FICHAIN_LOCKINIT(l)	ulock_init(&(l)->fichain_lock,TRUE,LTYPE_FICHAIN)
#define	FICHAIN_LOCK(l)		ulock_write(&(l)->fichain_lock)
#define	FICHAIN_UNLOCK(l)	ulock_done(&(l)->fichain_lock)
#define	FICHAIN_LOCK_HOLDER(p)	ULOCK_HOLDER(&(p)->fichain_lock)

#endif	/* _KERNEL */
#endif	/* _SYS_FLOCK_H */
