/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	str_debug.h,v $
 * Revision 4.2  91/09/19  22:54:12  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: str_debug.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:54:12 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_STR_DEBUG_H
#define	_STR_DEBUG_H

#undef	DB_CHECK_WAIT		/* disable obsolete (?) debug code */
#undef	DB_CHECK_LOCK		/* has not been updated for QUEUE synchr. */

/*
 *	Debug areas
 */

#define DB_SCHED	 1
#define DB_SYS		 2
#define DB_LINK    	 3
#define DB_PUTMSG	 4
#define DB_GETMSG	 5
#define DB_PUSHPOP	 6
#define DB_ALLOC   	 7
#define DB_CANPUT	 8
#define DB_ECHO		 9
#define DB_DBG_TLI	10
#define DB_SIG		11
#define DB_MP		12
#define DB_SYNC		13
#define	DB_CTTY		14
#define DB_FUNC		15

#define DB_LAST		16	/* must be last in sequence! */

/*
 *	System call indentifications
 */

#define	SYSCALL_OPEN	1
#define SYSCALL_CLOSE	2
#define SYSCALL_READ	3
#define SYSCALL_WRITE	4
#define SYSCALL_IOCTL	5

/*
 *	The following
 *		- provides the external declarations (  DEBUG + _NO_PROTO )
 *	OR	- provides the right prototypes ( DEBUG + ANSI C )
 *	OR	- makes all debug calls disappear from the code ( NO DEBUG )
 *
 *	Some debug facilities are only appropriate for certain versions,
 *	and thus may have further configuration controls.
 */

/*
 *	printf facility - works in every version
 */

#ifdef	STREAMS_DEBUG

#define STR_DEBUG(stmt)	stmt

#ifdef	_NO_PROTO
extern	void	DB_init();
extern	void	DB0();
extern	void	DB1();
extern	void	DB2();
extern	void	DB3();
extern	void	DB4();
extern	void	DB5();
extern	void	DB_show_stream();

#else	/* _NO_PROTO */

extern	void	DB_init();
extern	void	DB0(int, int, char *);
extern	void	DB1(int, int, char *, caddr_t);
extern	void	DB2(int, int, char *, caddr_t, caddr_t);
extern	void	DB3(int, int, char *, caddr_t, caddr_t, caddr_t);
extern	void	DB4(int, int, char *, caddr_t, caddr_t, caddr_t, caddr_t);
extern	void	DB5(int, int, char *, caddr_t, caddr_t, caddr_t, caddr_t, caddr_t);
extern	void	DB_show_stream(STHP);

#endif	/* _NO_PROTO */

#else	/* !STREAMS_DEBUG */

#define STR_DEBUG(stmt)	/* null */

#define	DB_init()
#define DB0(area, level, fmt)
#define DB1(area, level, fmt, a)
#define DB2(area, level, fmt, a, b)
#define DB3(area, level, fmt, a, b, c)
#define DB4(area, level, fmt, a, b, c, d)
#define DB5(area, level, fmt, a, b, c, d, e)
#define	DB_show_stream(sth)

#endif	/* !STREAMS_DEBUG */

/*
 * Function call monitoring
 */

#ifdef	STREAMS_DEBUG

#ifdef	_NO_PROTO

extern	void	ENTER_FUNC();
extern	void	LEAVE_FUNC();

#else

extern	void	ENTER_FUNC(pfi_t, int, int, int, int);
extern	void	LEAVE_FUNC(pfi_t, int);
extern	void	REPORT_FUNC();

#endif

#else

#define	ENTER_FUNC(func, a, b, c, d)
#define	LEAVE_FUNC(func, retval)
#define	REPORT_FUNC()

#endif


/*
 * DB_WAIT_CHECK package (obsolete?)
 */

#ifndef	STREAMS_DEBUG
#undef	DB_CHECK_WAIT
#endif

#ifdef	DB_CHECK_WAIT

#ifdef	_NO_PROTO
extern	void	DB_assert_wait();
extern	void	DB_clear_wait();
extern	void	DB_thread_block();
extern	void	DB_wait_check();

#else

extern	void	DB_assert_wait(int, int);
extern	void	DB_clear_wait(thread_t, int, int);
extern	void	DB_thread_block();
extern	void	DB_wait_check(char *, OSRP, int, int);

#endif

#else	/* DB_CHECK_WAIT */
#define	DB_assert_wait		assert_wait
#define	DB_clear_wait		clear_wait
#define	DB_thread_block		thread_block
#define DB_wait_check(caller, osr, valid_sth, id)
#endif	/* DB_CHECK_WAIT */

/*
 * STREAMS_CHECK package - works only for MULTI_DEBUG
 */

#if	defined(STREAMS_DEBUG) && defined(MULTI_DEBUG) && defined(DB_CHECK_LOCK)
#define	STREAMS_CHECK
#endif

#ifdef	STREAMS_CHECK
#ifdef	_NO_PROTO

extern	void	DB_isopen();
extern	void	DB_isclosed();
extern	void	DB_check_streams();

#else

extern	void	DB_isopen(STHP);
extern	void	DB_isclosed(STHP);
extern	void	DB_check_streams(char *);

#endif
#else	/* !STREAMS_CHECK */

#define	DB_isopen(sth)
#define	DB_isclosed(sth)
#define DB_check_streams(caller)

#endif
#endif
