/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	zone_info.h,v $
 * Revision 4.2  91/09/19  22:36:16  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: zone_info.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:36:16 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_MACH_DEBUG_ZONE_INFO_H_
#define _MACH_DEBUG_ZONE_INFO_H_

#include <mach/boolean.h>
#include <mach/machine/vm_types.h>

/*
 *	Remember to update the mig type definition
 *	in mach_debug_types.defs when adding/removing fields.
 */

#define ZONE_NAME_MAX_LEN		80

typedef struct zone_name {
	char		name[ZONE_NAME_MAX_LEN];
} zone_name_t;

typedef zone_name_t *zone_name_array_t;


typedef struct zone_info {
	int		count;		/* Number of elements used now */
	vm_size_t	cur_size;	/* current memory utilization */
	vm_size_t	max_size;	/* how large can this zone grow */
	vm_size_t	elem_size;	/* size of an element */
	vm_size_t	alloc_size;	/* size used for more memory */
	boolean_t	pageable;	/* zone pageable? */
	boolean_t	sleepable;	/* sleep if empty? */
	boolean_t	exhaustible;	/* merely return if empty? */
} zone_info_t;

typedef zone_info_t *zone_info_array_t;

#endif	/* _MACH_DEBUG_ZONE_INFO_H_ */
