/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	pmagbba.h,v $
 * Revision 1.1.3.2  92/02/13  17:59:23  Barbara_Corriero
 * 	Ported from Ultrix 4.L
 * 	[92/02/12  19:21:36  Barbara_Corriero]
 * 
 * $EndLog$
 */
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
#ifndef PMAGBBA_H
#define PMAGBBA_H

#define PMAGBBA_FB_OFFSET		0x201000
#define PMAGBBA_BT459_OFFSET		0x1C0000
#define PMAGBBA_SFB_ASIC_OFFSET		0x100000
#define PMAGBBA_SFB_ASIC_GP0		0x140000
#define PMAGBBA_SFB_ASIC_GP1		0x180000
#define PMAGBBA_MAX_PROM_RGN            0x100000

#define Pixel8      unsigned char
#define Pixel32     unsigned int

#define Bits32      unsigned int
#define Bits8       unsigned char

#define Bool8       unsigned char
#define Bool        int

void sfb_bot();
int sfb_attach();
void sfb_interrupt();
void sfb_enable_interrupt();
sfb_clear_screen();
sfb_scroll_screen();
sfb_blitc();
sfb_map_unmap_screen();
int sfb_close();
int sfb_ioctl();

/*
 *  ws_prom_map is used for mapping and unmapping the address space
 *  of a flash eeprom. In the case of mapping the size and offset
 *  arguments are used to specify the desired prom address space.
 *  A user process virtual address is returned in pm_vaddr and the
 *  corresponding kernel virtual address in pm_svaddr for verification
 *  of mapped space. In unmapping, pm_vaddr specifies the virtual
 *  address to deallocate.  Upon completion of unmapping pm_vaddr
 *  and pm_svaddr are set NULL. 
 */ 
   
typedef struct {
    short screen;		/* standard interface		  */
    short cmd; 			/* ioctl differentiator		  */
    caddr_t pm_vaddr;		/* user proc. virtual addr	  */
    caddr_t pm_svaddr;		/* system virtual addr		  */
    size_t pm_offset;		/* position relative to base addr */
    size_t pm_size;		/* size of mapped area 		  */
} ws_prom_map;

#define SFB_SUCCESS		0
#define SFB_ERROR	       -1	

#define PROM_MAP_OPS  		_IOWR('w', (0|IOC_S), ws_prom_map)
#define CXT_MAP_PROM		1
#define CXT_UNMAP_PROM  	2
#endif
