/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vm_ubc.h,v $
 * Revision 1.1.2.4  92/04/24  09:29:38  Robert_Picco
 * 	Changed vfs_ubc.c ref bit handling
 * 	[92/04/16  08:23:31  Robert_Picco]
 * 
 * Revision 1.1.2.3  92/03/26  11:44:08  Robert_Picco
 * 	fixed reference bit code
 * 	[92/03/24  09:59:04  Robert_Picco]
 * 
 * Revision 1.1.2.2  92/02/26  15:31:39  Charles_Briggs
 * 	From ONC Reference port.
 * 	[92/02/21  15:05:45  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vm_ubc.h,v $ $Revision: 1.1.2.4 $ (DEC) $Date: 92/04/24 09:29:38 $
 */
#ifndef	__VM_UBC__
#define	__VM_UBC__ 1
#include <machine/cpu.h>
#include <ref_bits.h>
#include <vm/vm_debug.h>

#define ubc_kmem_alloc(PP) (PP)->pg_addr = PHYS_TO_K0(page_to_phys(PP))
#define ubc_kmem_free(PP)
#define ubc_kmem_cache(PP) FALSE
#define	ubc_load(PP, OFFSET, SIZE) (PP)->pg_addr
#define	ubc_unload(PP, OFFSET, SIZE)
#define	ubc_page_zero(PP, O, S)						\
	bzero(PHYS_TO_K0(page_to_phys((PP))) + (O) , (S))

#define	ubc_page_referenced(PP)						\
	pmap_is_referenced(page_to_phys(PP))
#define	ubc_page_clear_reference(PP) 					\
	pmap_clear_reference(page_to_phys(PP))


#if	UBC_PAGE_CHECK

#undef	ubc_load
#undef	ubc_page_zero
#define ubc_load(PP, OFFSET, SIZE) 					\
	ubc_load_page_check(PP, OFFSET, SIZE)
#define	ubc_page_zero(PP, O, S) 					\
	ubc_page_zero_page_check(PP, O, S)

#endif	/* UBC_PAGE_CHECK */

#endif	/* !__VM_UBC__ */
