#ifdef REV_INFO
#ifndef lint
static char SCCSID[] = "OSF/Motif: @(#)Xm.h	3.67.1.3 91/05/29";
#endif /* lint */
#endif /* REV_INFO */
/******************************************************************************
*******************************************************************************
*
*  (c) Copyright 1989, 1990, 1991 OPEN SOFTWARE FOUNDATION, INC.
*  (c) Copyright 1987, 1988, 1989, 1990, HEWLETT-PACKARD COMPANY
*  ALL RIGHTS RESERVED
*  
*  	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED
*  AND COPIED ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND
*  WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR
*  ANY OTHER COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE
*  AVAILABLE TO ANY OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF THE
*  SOFTWARE IS HEREBY TRANSFERRED.
*  
*  	THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
*  NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY OPEN SOFTWARE
*  FOUNDATION, INC. OR ITS THIRD PARTY SUPPLIERS  
*  
*  	OPEN SOFTWARE FOUNDATION, INC. AND ITS THIRD PARTY SUPPLIERS,
*  ASSUME NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE ANY OF ITS
*  SOFTWARE .   OSF SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
*  KIND, AND OSF EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING
*  BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*  FITNESS FOR A PARTICULAR PURPOSE.
*  
*  Notice:  Notwithstanding any other lease or license that may pertain to,
*  or accompany the delivery of, this computer software, the rights of the
*  Government regarding its use, reproduction and disclosure are as set
*  forth in Section 52.227-19 of the FARS Computer Software-Restricted
*  Rights clause.
*  
*  (c) Copyright 1989, 1990, 1991 Open Software Foundation, Inc.  Unpublished - all
*  rights reserved under the Copyright laws of the United States.
*  
*  RESTRICTED RIGHTS NOTICE:  Use, duplication, or disclosure by the
*  Government is subject to the restrictions as set forth in subparagraph
*  (c)(1)(ii) of the Rights in Technical Data and Computer Software clause
*  at DFARS 52.227-7013.
*  
*  Open Software Foundation, Inc.
*  11 Cambridge Center
*  Cambridge, MA   02142
*  (617)621-8700
*  
*  RESTRICTED RIGHTS LEGEND:  This computer software is submitted with
*  "restricted rights."  Use, duplication or disclosure is subject to the
*  restrictions as set forth in NASA FAR SUP 18-52.227-79 (April 1985)
*  "Commercial Computer Software- Restricted Rights (April 1985)."  Open
*  Software Foundation, Inc., 11 Cambridge Center, Cambridge, MA  02142.  If
*  the contract contains the Clause at 18-52.227-74 "Rights in Data General"
*  then the "Alternate III" clause applies.
*  
*  (c) Copyright 1989, 1990, 1991 Open Software Foundation, Inc.
*  ALL RIGHTS RESERVED 
*  
*  
* Open Software Foundation is a trademark of The Open Software Foundation, Inc.
* OSF is a trademark of Open Software Foundation, Inc.
* OSF/Motif is a trademark of Open Software Foundation, Inc.
* Motif is a trademark of Open Software Foundation, Inc.
* DEC is a registered trademark of Digital Equipment Corporation
* DIGITAL is a registered trademark of Digital Equipment Corporation
* X Window System is a trademark of the Massachusetts Institute of Technology
*
*******************************************************************************
******************************************************************************/

#ifndef _Xm_h
#define _Xm_h


#ifdef VMS
#include <DECW$INCLUDE:Intrinsic.h>
#include <DECW$INCLUDE:Vendor.h>
#else
#include <X11/Intrinsic.h>
#include <X11/Vendor.h>
#endif

/*
** NOTE: _NO_PROTO is NOT defined in the OSF version of Xm.h.
** However, we have chosen to set it on by default for use with C compilers
** which are NOT ANSI-standard compliant.  Users may choose to use prototypes
** with those compilers which support them by adding a
**	#define __STDC__ 1 
** around the #include files which have the prototype definitions.
** Note that this stricture also applies to applications using compiler
** switches that define __STDC__ to be a value other that 1 (such as the 
** OSF/1 compiler's -std switch).
*/
#if defined(__STDC__) && __STDC__
/* leave definition of _NO_PROTO in user's hands */
#else
#ifndef _NO_PROTO
#define _NO_PROTO	1
#endif
#endif

/* force prototypes for C++ */

#if defined(__cplusplus) || defined(c_plusplus)
#undef _NO_PROTO
#endif

#ifdef VMS
#include <DECW$INCLUDE:VirtKeys.h>
#else
#include <Xm/VirtKeys.h>
#endif

#define XmVERSION	1
#define XmREVISION	1
#define XmVersion (XmVERSION * 1000 + XmREVISION)

#ifndef DEC_MOTIF_BUG_FIX
#define DEC_MOTIF_BUG_FIX
#endif
#ifndef DEC_MOTIF_EXTENSION
#define DEC_MOTIF_EXTENSION
#endif
#ifndef DEC_MOTIF_RTOL
#define DEC_MOTIF_RTOL
#endif
#if !defined(DEC_KEYSYM_FALLBACK) && !defined(VMS)
#define DEC_KEYSYM_FALLBACK
#endif

#ifdef DEC_MOTIF_BUG_FIX
externalref int xmUseVersion;
#else
extern int xmUseVersion;
#endif

/* define used to denote an unspecified pixmap  */

#define XmUNSPECIFIED_PIXMAP	2

/* define charset constants */
#define XmSTRING_ISO8859_1  "ISO8859-1"
#define XmSTRING_OS_CHARSET "ISO8859-1"
#ifndef XmFALLBACK_CHARSET
#define XmFALLBACK_CHARSET "ISO8859-1"
#endif

 

/****************
 *
 * XmString structure defines. These must be here (at the start of the file) 
 * becaused they are used later on.
 *
 ****************/

#define XmSTRING_DIRECTION_L_TO_R	0
#define XmSTRING_DIRECTION_R_TO_L	1
#define XmSTRING_DIRECTION_DEFAULT      255

typedef unsigned char *	XmString;		/* opaque to outside */
typedef XmString *	XmStringTable;		/* opaque to outside */
typedef char *		XmStringCharSet;	/* Null term string */
typedef unsigned char	XmStringComponentType;	/* component tags */
typedef unsigned char 	XmStringDirection;

typedef struct _XmFontListRec       *XmFontList;       /* opaque to outside */
typedef struct __XmStringContextRec *_XmStringContext; /* opaque to outside */
typedef struct __XmStringRec        *_XmString;        /* opaque to outside */
typedef struct _XmtStringContextRec *XmStringContext;  /* opaque to outside */
typedef struct _XmFontListContextRec *XmFontContext;   /* opaque to outside */

#define XmSTRING_COMPONENT_UNKNOWN	0
#define XmSTRING_COMPONENT_CHARSET	1
#define XmSTRING_COMPONENT_TEXT		2
#define XmSTRING_COMPONENT_DIRECTION	3
#define XmSTRING_COMPONENT_SEPARATOR	4	/* 5-125 reserved */

#define XmSTRING_COMPONENT_END		126	/* no more comp in string */

#define XmSTRING_COMPONENT_USER_BEGIN	128	/* 128-255 are user tags */
#define XmSTRING_COMPONENT_USER_END	255
#define XmSTRING_DEFAULT_CHARSET	""

/************************************************************************
 *  Resource names
 *	Taken from StringDefs, with Xt replaced by Xm.
 ************************************************************************/

#ifndef X_GBLS
#if defined(VMS) && !defined(NO_X_GBLS)
globalref char X$GBLSTRINGS [];
#include <DECW$INCLUDE:DECW$GblStrings.H>
#if defined(__STDC__) && __STDC__
#define X_GBLS(string) &X$GBLSTRINGS[XGBLN##string]
#else
#define X_GBLS(string) &X$GBLSTRINGS[XGBLN/**/string]
#endif /*__STDC__*/
#else
#if defined(__STDC__)
#define X_GBLS(string) #string
#else
#define X_GBLS(string) "string"
#endif /*__STDC__*/
#endif /* VMS */
#endif

#define XmNaccelerator          X_GBLS(accelerator)
#define XmNaccelerators         X_GBLS(accelerators)
#define XmNacceleratorText      X_GBLS(acceleratorText)
#define XmNadjustLast		X_GBLS(adjustLast)
#define XmNadjustMargin		X_GBLS(adjustMargin)
#define XmNalignment		X_GBLS(alignment)
#define XmNancestorSensitive	X_GBLS(ancestorSensitive)
#define XmNarmCallback	 	X_GBLS(armCallback)
#define XmNbackground		X_GBLS(background)
#define XmNbackgroundPixmap     X_GBLS(backgroundPixmap)
#define XmNbitmap		X_GBLS(bitmap)
#define XmNborderColor		X_GBLS(borderColor)
#define XmNborder		X_GBLS(borderColor)
#define XmNborderPixmap		X_GBLS(borderPixmap)
#define XmNborderWidth		X_GBLS(borderWidth)
#define XmNbuttonAccelerators	X_GBLS(buttonAccelerators)
#define XmNbuttonAcceleratorText	X_GBLS(buttonAcceleratorText)
#define XmNbuttonCount		X_GBLS(buttonCount)
#define XmNbuttonMnemonicCharSets	X_GBLS(buttonMnemonicCharSets)
#define XmNbuttonMnemonics	X_GBLS(buttonMnemonics)
#define XmNbuttons		X_GBLS(buttons)
#define XmNbuttonSet		X_GBLS(buttonSet)
#define XmNbuttonType		X_GBLS(buttonType)
#define XmNcascadePixmap	X_GBLS(cascadePixmap)
#define XmNcascadingCallback	X_GBLS(cascadingCallback)
#define XmNchildren             X_GBLS(children)
#define XmNcolormap		X_GBLS(colormap)
#define XmNcommandWindowLocation X_GBLS(commandWindowLocation)
#define XmNdefaultFontList	X_GBLS(defaultFontList)
#define XmNdepth		X_GBLS(depth)
#define XmNdestroyCallback      X_GBLS(destroyCallback)
#define XmNdisarmCallback       X_GBLS(disarmCallback)
#define XmNeditType		X_GBLS(editType)
#define XmNentryAlignment	X_GBLS(entryAlignment)
#define XmNentryBorder		X_GBLS(entryBorder)
#define XmNentryClass		X_GBLS(entryClass)
#define XmNentryCallback	X_GBLS(entryCallback)
#define XmNexposeCallback       X_GBLS(exposeCallback)
#define XmNfile			X_GBLS(file)
#define XmNfillOnSelect		X_GBLS(fillOnSelect)
#define XmNfilterLabelString	X_GBLS(filterLabelString)
#define XmNfont			X_GBLS(font)
#define XmNfontList		X_GBLS(fontList)
#define XmNforceBars		X_GBLS(forceBars)
#define XmNforeground		X_GBLS(foreground)
#define XmNfunction		X_GBLS(function)
#define XmNheight		X_GBLS(height)
#define XmNhighlight		X_GBLS(highlight)
#define XmNindex		X_GBLS(index)
#define XmNindicatorOn		X_GBLS(indicatorOn)
#define XmNindicatorSize	X_GBLS(indicatorSize)
#define XmNindicatorType	X_GBLS(indicatorType)
#define XmNinitialResourcesPersistent   X_GBLS(initialResourcesPersistent)
#define XmNinnerHeight		X_GBLS(innerHeight)
#define XmNinnerWidth		X_GBLS(innerWidth)
#define XmNinnerWindow		X_GBLS(innerWindow)
#define XmNinsertPosition       X_GBLS(insertPosition)
#define XmNinternalHeight	X_GBLS(internalHeight)
#define XmNinternalWidth	X_GBLS(internalWidth)
#define XmNisAligned		X_GBLS(isAligned)
#define XmNisHomogeneous	X_GBLS(isHomogeneous)
#define XmNjumpProc		X_GBLS(jumpProc)
#define XmNjustify		X_GBLS(justify)
#define XmNlabelInsensitivePixmap X_GBLS(labelInsensitivePixmap)
#define XmNlabelPixmap		X_GBLS(labelPixmap)
#define XmNlabelString		X_GBLS(labelString)
#define XmNlabelType		X_GBLS(labelType)
#define XmNlength		X_GBLS(length)
#define XmNlistUpdated      X_GBLS(listUpdated)
#define XmNlowerRight		X_GBLS(lowerRight)
#define XmNmapCallback		X_GBLS(mapCallback)
#define XmNmappedWhenManaged	X_GBLS(mappedWhenManaged)
#define XmNmappingDelay	        X_GBLS(mappingDelay)
#define XmNmarginHeight		X_GBLS(marginHeight)
#define XmNmarginTop		X_GBLS(marginTop)
#define XmNmarginBottom		X_GBLS(marginBottom)
#define XmNmarginWidth		X_GBLS(marginWidth)
#define XmNmarginRight		X_GBLS(marginRight)
#define XmNmarginLeft		X_GBLS(marginLeft)
#define XmNmenuAccelerator	X_GBLS(menuAccelerator)
#define XmNmenuCursor		X_GBLS(menuCursor)
#define XmNmenuEntry		X_GBLS(menuEntry)
#define XmNmenuHelpWidget	X_GBLS(menuHelpWidget)
#define XmNmenuHistory		X_GBLS(menuHistory)
#define XmNmenuPost		X_GBLS(menuPost)
#define XmNmnemonic		X_GBLS(mnemonic)
#define XmNmnemonicCharSet  	X_GBLS(mnemonicCharSet)
#define XmNname         	X_GBLS(name)
#define XmNnavigationType	X_GBLS(navigationType)
#define XmNnotify		X_GBLS(notify)
#define XmNnumChildren		X_GBLS(numChildren)
#define XmNnumColumns		X_GBLS(numColumns)
#define XmNoptionLabel		X_GBLS(optionLabel)
#define XmNoptionMnemonic	X_GBLS(optionMnemonic)
#define XmNorientation		X_GBLS(orientation)
#define XmNpacking		X_GBLS(packing)
#define XmNparameter		X_GBLS(parameter)
#define XmNpopdownCallback	X_GBLS(popdownCallback)
#define XmNpopupCallback	X_GBLS(popupCallback)
#define XmNpopupEnabled		X_GBLS(popupEnabled)
#define XmNpostFromButton	X_GBLS(postFromButton)
#define XmNpostFromCount	X_GBLS(postFromCount)
#define XmNpostFromList		X_GBLS(postFromList)
#define XmNradioAlwaysOne	X_GBLS(radioAlwaysOne)
#define XmNradioBehavior	X_GBLS(radioBehavior)
#define XmNrecomputeSize	X_GBLS(recomputeSize)
#define XmNresize		X_GBLS(resize)
#define XmNresizeCallback       X_GBLS(resizeCallback)
#define XmNreverseVideo		X_GBLS(reverseVideo)
#define XmNrowColumnType	X_GBLS(rowColumnType)
#define XmNscaleMultiple     X_GBLS(scaleMultiple)
#define XmNscreen               X_GBLS(screen)
#define XmNscrollProc		X_GBLS(scrollProc)
#define XmNscrollDCursor	X_GBLS(scrollDCursor)
#define XmNscrollHCursor	X_GBLS(scrollHCursor)
#define XmNscrollLCursor	X_GBLS(scrollLCursor)
#define XmNscrollRCursor	X_GBLS(scrollRCursor)
#define XmNscrollUCursor	X_GBLS(scrollUCursor)
#define XmNscrollVCursor	X_GBLS(scrollVCursor)
#define XmNselectColor		X_GBLS(selectColor)
#define XmNselection		X_GBLS(selection)
#define XmNselectionArray	X_GBLS(selectionArray)
#define XmNselectInsensitivePixmap X_GBLS(selectInsensitivePixmap)
#define XmNselectPixmap	 	X_GBLS(selectPixmap)
#define XmNsensitive		X_GBLS(sensitive)
#define XmNset			X_GBLS(set)
#define XmNshadow		X_GBLS(shadow)
#define XmNshown		X_GBLS(shown)
#define XmNsimpleCallback	X_GBLS(simpleCallback)
#define XmNspace		X_GBLS(space)
#define XmNspacing		X_GBLS(spacing)
#define XmNstring		X_GBLS(string)
#define XmNstringDirection	X_GBLS(stringDirection)
#define XmNsubMenuId		X_GBLS(subMenuId)
#define XmNtextOptions		X_GBLS(textOptions)
#define XmNtextSink		X_GBLS(textSink)
#define XmNtextSource		X_GBLS(textSource)
#define XmNthickness		X_GBLS(thickness)
#define XmNthumb		X_GBLS(thumb)
#define XmNthumbProc		X_GBLS(thumbProc)
#define XmNtop			X_GBLS(top)
#define XmNtranslations		X_GBLS(translations)
#define XmNtraversalType    X_GBLS(traversalType)
#define XmNtroughColor		X_GBLS(troughColor)
#define XmNunmapCallback	X_GBLS(unmapCallback)
#define XmNunselectPixmap 	X_GBLS(unselectPixmap)
#define XmNupdate		X_GBLS(update)
#define XmNuseBottom		X_GBLS(useBottom)
#define XmNuseRight		X_GBLS(useRight)
#define XmNvalue		X_GBLS(value)
#define XmNvisibleWhenOff	X_GBLS(visibleWhenOff)
#define XmNwhichButton	X_GBLS(whichButton)
#define XmNwidth		X_GBLS(width)
#define XmNwindow		X_GBLS(window)
#define XmNx			X_GBLS(x)
#define XmNy			X_GBLS(y)


/* Class types */ 

#define XmCAccelerator          X_GBLS(Accelerator)
#define XmCAccelerators         X_GBLS(Accelerators)
#define XmCAcceleratorText      X_GBLS(AcceleratorText)
#define XmCAdjustLast		X_GBLS(AdjustLast)
#define XmCAdjustMargin		X_GBLS(AdjustMargin)
#define XmCAlignment		X_GBLS(Alignment)
#define XmCArmCallback		X_GBLS(ArmCallback)
#define XmCBackground		X_GBLS(Background)
#define XmCBitmap		X_GBLS(Bitmap)
#define XmCBoolean		X_GBLS(Boolean)
#define XmCBorderColor		X_GBLS(BorderColor)
#define XmCBorderWidth		X_GBLS(BorderWidth)
#define XmCButtonAccelerators	X_GBLS(ButtonAccelerators)
#define XmCButtonAcceleratorText	X_GBLS(ButtonAcceleratorText)
#define XmCButtonCount		X_GBLS(ButtonCount)
#define XmCButtonMnemonicCharSets	X_GBLS(ButtonMnemonicCharSets)
#define XmCButtonMnemonics	X_GBLS(ButtonMnemonics)
#define XmCButtons		X_GBLS(Buttons)
#define XmCButtonSet		X_GBLS(ButtonSet)
#define XmCButtonType		X_GBLS(ButtonType)
#define XmCCallback             X_GBLS(Callback)
#define XmCChildren             X_GBLS(Children)
#define XmCColormap		X_GBLS(Colormap)
#define XmCColor		X_GBLS(Color)
#define XmCCommandWindowLocation X_GBLS(CommandWindowLocation)
#define XmCCursor		X_GBLS(Cursor)
#define XmCDefaultFontList	X_GBLS(DefaultFontList)
#define XmCDepth		X_GBLS(Depth)
#define XmCDimension		X_GBLS(Dimension)
#define XmCDisarmCallback	X_GBLS(DisarmCallback)
#define XmCEditType		X_GBLS(EditType)
#define XmCEntryBorder		X_GBLS(EntryBorder)
#define XmCEntryClass		X_GBLS(EntryClass)
#define XmCEventBindings	X_GBLS(EventBindings)
#define XmCExposeCallback       X_GBLS(ExposeCallback)
#define XmCFile			X_GBLS(File)
#define XmCFillOnSelect		X_GBLS(FillOnSelect)
#define XmCFilterLabelString	X_GBLS(FilterLabelString)
#define XmCFont			X_GBLS(Font)
#define XmCFontList		X_GBLS(FontList)
#define XmCForeground		X_GBLS(Foreground)
#define XmCFraction		X_GBLS(Fraction)
#define XmCFunction		X_GBLS(Function)
#define XmCHeight		X_GBLS(Height)
#define XmCHSpace		X_GBLS(HSpace)
#define XmCIndex		X_GBLS(Index)
#define XmCIndicatorOn		X_GBLS(IndicatorOn)
#define XmCIndicatorSize	X_GBLS(IndicatorSize)
#define XmCIndicatorType	X_GBLS(IndicatorType)
#define XmCInitialResourcesPersistent   X_GBLS(InitialResourcesPersistent)
#define XmCInsertPosition       X_GBLS(InsertPosition)
#define XmCInterval		X_GBLS(Interval)
#define XmCIsAligned		X_GBLS(IsAligned)
#define XmCIsHomogeneous	X_GBLS(IsHomogeneous)
#define XmCJustify		X_GBLS(Justify)
#define XmCLabel		X_GBLS(Label)
#define XmCLabelInsensitivePixmap X_GBLS(LabelInsensitivePixmap)
#define XmCLabelPixmap		X_GBLS(LabelPixmap)
#define XmCLabelString		X_GBLS(LabelString)
#define XmCLabelType		X_GBLS(LabelType)
#define XmCLength		X_GBLS(Length)
#define XmCListUpdated       X_GBLS(ListUpdated)
#define XmCMappedWhenManaged	X_GBLS(MappedWhenManaged)
#define XmCMappingDelay         X_GBLS(MappingDelay)
#define XmCMargin		X_GBLS(Margin)
#define XmCMarginHeight		X_GBLS(MarginHeight)
#define XmCMarginWidth		X_GBLS(MarginWidth)
#define XmCMarginLeft		X_GBLS(MarginLeft)
#define XmCMarginRight		X_GBLS(MarginRight)
#define XmCMarginTop		X_GBLS(MarginTop)
#define XmCMarginBottom		X_GBLS(MarginBottom)
#define XmCMenuEntry		X_GBLS(MenuEntry)
#define XmCMenuPost		X_GBLS(MenuPost)
#define XmCMenuWidget           X_GBLS(MenuWidget)
#define XmCMnemonic		X_GBLS(Mnemonic)
#define XmCMnemonicCharSet      X_GBLS(MnemonicCharSet)
#define XmCNavigationType	X_GBLS(NavigationType)
#define XmCNotify		X_GBLS(Notify)
#define XmCNumChildren		X_GBLS(NumChildren)
#define	XmCNumColumns		X_GBLS(NumColumns)
#define XmCOptionLabel		X_GBLS(OptionLabel)
#define XmCOptionMnemonic	X_GBLS(OptionMnemonic)
#define XmCOrientation		X_GBLS(Orientation)
#define XmCPacking		X_GBLS(Packing)
#define XmCParameter		X_GBLS(Parameter)
#define XmCPixmap		X_GBLS(Pixmap)
#define XmCPopupEnabled		X_GBLS(PopupEnabled)
#define XmCPosition		X_GBLS(Position)
#define XmCPostFromButton	X_GBLS(PostFromButton)
#define XmCPostFromCount	X_GBLS(PostFromCount)
#define XmCPostFromList		X_GBLS(PostFromList)
#define XmCRadioAlwaysOne	X_GBLS(RadioAlwaysOne)
#define XmCRadioBehavior	X_GBLS(RadioBehavior)
#define XmCRecomputeSize	X_GBLS(RecomputeSize)
#define XmCResize		X_GBLS(Resize)
#define XmCResizeCallback       X_GBLS(ResizeCallback)
#define XmCReverseVideo		X_GBLS(ReverseVideo)
#define XmCRowColumnType	X_GBLS(RowColumnType)
#define XmCScaleMultiple        X_GBLS(ScaleMultiple)
#define XmCScreen               X_GBLS(Screen)
#define XmCScrollProc		X_GBLS(ScrollProc)
#define XmCScrollDCursor	X_GBLS(ScrollDCursor)
#define XmCScrollHCursor	X_GBLS(ScrollHCursor)
#define XmCScrollLCursor	X_GBLS(ScrollLCursor)
#define XmCScrollRCursor	X_GBLS(ScrollRCursor)
#define XmCScrollUCursor	X_GBLS(ScrollUCursor)
#define XmCScrollVCursor	X_GBLS(ScrollVCursor)
#define XmCSelectColor		X_GBLS(SelectColor)
#define XmCSelection		X_GBLS(Selection)
#define XmCSensitive		X_GBLS(Sensitive)
#define XmCSelectionArray	X_GBLS(SelectionArray)
#define XmCSelectInsensitivePixmap X_GBLS(SelectInsensitivePixmap)
#define XmCSelectPixmap	 	X_GBLS(SelectPixmap)
#define XmCSet			X_GBLS(Set)
#define XmCSimpleCheckBox	X_GBLS(SimpleCheckBox)
#define XmCSimpleMenuBar	X_GBLS(SimpleMenuBar)
#define XmCSimplePopupMenu	X_GBLS(SimplePopupMenu)
#define XmCSimplePulldownMenu	X_GBLS(SimplePulldownMenu)
#define XmCSimpleOptionMenu	X_GBLS(SimpleOptionMenu)
#define XmCSimpleRadioBox	X_GBLS(SimpleRadioBox)
#define XmCSpace		X_GBLS(Space)
#define XmCSpacing		X_GBLS(Spacing)
#define XmCString		X_GBLS(String)
#define XmCStringDirection	X_GBLS(StringDirection)
#define XmCTextOptions		X_GBLS(TextOptions)
#define XmCTextPosition		X_GBLS(TextPosition)
#define XmCTextSink		X_GBLS(TextSink)
#define XmCTextSource		X_GBLS(TextSource)
#define XmCThickness		X_GBLS(Thickness)
#define XmCThumb		X_GBLS(Thumb)
#define XmCTroughColor		X_GBLS(TroughColor)
#define XmCTranslations		X_GBLS(Translations)
#define XmCTraversalType        X_GBLS(TraversalType)
#define XmCUnselectPixmap 	X_GBLS(UnselectPixmap)
#define XmCValue		X_GBLS(Value)
#define XmCValueChangedCallback	X_GBLS(ValueChangedCallback)
#define XmCVisibleWhenOff	X_GBLS(VisibleWhenOff)
#define XmCVSpace		X_GBLS(VSpace)
#define XmCWhichButton	        X_GBLS(WhichButton)
#define XmCWidth		X_GBLS(Width)
#define XmCWindow		X_GBLS(Window)
#define XmCXmString             X_GBLS(XmString)
#define XmCX			X_GBLS(X)
#define XmCY			X_GBLS(Y)


/* Representation types */

#define XmRAcceleratorTable     X_GBLS(AcceleratorTable)
#ifdef VMS
#define XmRAlignment		X_GBLS(XmAlignment)   /* Compatibility with XUI */
#else
#define XmRAlignment		X_GBLS(Alignment)
#endif
#define XmRXmBackgroundPixmap	X_GBLS(XmBackgroundPixmap)
#define XmRBool			X_GBLS(Bool)
#define XmRBoolean		X_GBLS(Boolean)
#define XmRButtonType		X_GBLS(ButtonType)
#define XmRCallback             X_GBLS(Callback)
#define XmRCallbackProc         "CallbackProc"
#define XmRCallProc             X_GBLS(CallProc)
#define XmRChar			X_GBLS(Char)
#define XmRCharSetTable			X_GBLS(CharSetTable)
#define XmRColor		X_GBLS(Color)
#define XmRCommandWindowLocation X_GBLS(CommandWindowLocation)
#define XmRCompoundText		X_GBLS(CompoundText)
#define XmRCursor		X_GBLS(Cursor)
#define XmRDimension		X_GBLS(Dimension)
#define XmRDisplay		X_GBLS(Display)
#define XmREditMode		X_GBLS(EditMode)
#define XmRFile			X_GBLS(File)
#define XmRFont			X_GBLS(Font)
#ifdef VMS
#define XmRFontList		X_GBLS(XmFontList)    /* Compatibility with XUI */
#else
#define XmRFontList		X_GBLS(FontList)
#endif
#define XmRFontStruct		X_GBLS(FontStruct)     
#define XmRFunction		X_GBLS(Function)
#define XmRGeometry		X_GBLS(Geometry)
#define XmRHorizontalDimension	X_GBLS(HorizontalDimension)
#define XmRHorizontalPosition	X_GBLS(HorizontalPosition)
#define XmRImmediate		X_GBLS(Immediate)
#define XmRIndicatorType	X_GBLS(IndicatorType)
#define XmRInt			X_GBLS(Int)
#define XmRJustify		X_GBLS(Justify)
#define XmRKeySym               X_GBLS(KeySym)
#define XmRKeySymTable               X_GBLS(KeySymTable)
#ifdef VMS
#define XmRLabelType		X_GBLS(XmLabelType)   /* Compatibility with XUI */
#else
#define XmRLabelType		X_GBLS(LabelType)
#endif
#define XmRLongBoolean		XmRBool		/* Compatibility */
#define XmRMenuWidget           X_GBLS(MenuWidget)
#define XmRMnemonic		X_GBLS(Mnemonic)
#define XmRNavigationType	X_GBLS(NavigationType)
#ifdef VMS
#define XmROrientation		X_GBLS(XmOrientation) /* Compatibility with XUI */
#else
#define XmROrientation		X_GBLS(Orientation)
#endif
#define XmRPacking		X_GBLS(Packing)
#define XmRPixel		X_GBLS(Pixel)
#define XmRPixmap		X_GBLS(Pixmap)
#define XmRGadgetPixmap		X_GBLS(GadgetPixmap)
#define XmRPointer		X_GBLS(Pointer)
#define XmRPosition		X_GBLS(Position)
#define XmRProc			X_GBLS(Proc)
#define XmRRowColumnType	X_GBLS(RowColumnType)
#define XmRShort                X_GBLS(Short)
#define XmRString		X_GBLS(String)
#define XmRStringDirection	X_GBLS(StringDirection)
#define XmRStringTable		X_GBLS(StringTable)
#define XmRTextPosition         X_GBLS(TextPosition)
#define XmRUnsignedChar         X_GBLS(UnsignedChar)
#define XmRVerticalDimension	X_GBLS(VerticalDimension)
#define XmRVerticalPosition	X_GBLS(VerticalPosition)
#define XmRTranslationTable     X_GBLS(TranslationTable)
#define XmRTraversalType     	X_GBLS(TraversalType)
#define XmRWhichButton		X_GBLS(WhichButton)
#define XmRWidget		X_GBLS(Widget)
#define XmRWidgetList		X_GBLS(WidgetList)
#define XmRWidgetClass		X_GBLS(WidgetClass)
#define XmRWindow		X_GBLS(Window)
#define XmRXmString		X_GBLS(XmString)
#define XmRXmStringTable	X_GBLS(XmStringTable)
#define XmRStringCharSet    	X_GBLS(XmStringCharSet)

/************************************************************************
 *  Resource names
 *	Taken from Shell.h, Xt replaced by Xm
 ************************************************************************/
#define XmNiconName	X_GBLS(iconName)
#define XmCIconName	X_GBLS(IconName)
#define XmNiconPixmap	X_GBLS(iconPixmap)
#define XmCIconPixmap	X_GBLS(IconPixmap)
#define XmNiconWindow	X_GBLS(iconWindow)
#define XmCIconWindow	X_GBLS(IconWindow)
#define XmNiconMask	X_GBLS(iconMask)
#define XmCIconMask	X_GBLS(IconMask)
#define XmNwindowGroup	X_GBLS(windowGroup)
#define XmCWindowGroup	X_GBLS(WindowGroup)
 
#define XmNsaveUnder		X_GBLS(saveUnder)
#define XmCSaveUnder		X_GBLS(SaveUnder)
#define XmNtransient		X_GBLS(transient)
#define XmCTransient		X_GBLS(Transient)
#define XmNoverrideRedirect	X_GBLS(overrideRedirect)
#define XmCOverrideRedirect	X_GBLS(OverrideRedirect)

#define XmNallowShellResize	X_GBLS(allowShellResize)
#define XmCAllowShellResize	X_GBLS(AllowShellResize)
#define XmNcreatePopupChildProc	X_GBLS(createPopupChildProc)
#define XmCCreatePopupChildProc	X_GBLS(CreatePopupChildProc)

#define XmNtitle	X_GBLS(title)
#define XmCTitle	X_GBLS(Title)

/* 
 * The following are only used at creation and can not be changed via 
 * SetValues.
 */

#define XmNargc		X_GBLS(argc)
#define XmCArgc		X_GBLS(Argc)
#define XmNargv		X_GBLS(argv)
#define XmCArgv		X_GBLS(Argv)
#define XmNiconX	X_GBLS(iconX)
#define XmCIconX	X_GBLS(IconX)
#define XmNiconY	X_GBLS(iconY)
#define XmCIconY	X_GBLS(IconY)
#define XmNinput	X_GBLS(input)
#define XmCInput	X_GBLS(Input)
#define XmNiconic	X_GBLS(iconic)
#define XmCIconic	X_GBLS(Iconic)
#define XmNinitialState	X_GBLS(initialState)
#define XmCInitialState	X_GBLS(InitialState)
#define XmNgeometry	X_GBLS(geometry)
#define XmCGeometry	X_GBLS(Geometry)
#define XmNminWidth	X_GBLS(minWidth)
#define XmCMinWidth	X_GBLS(MinWidth)
#define XmNminHeight	X_GBLS(minHeight)
#define XmCMinHeight	X_GBLS(MinHeight)
#define XmNmaxWidth	X_GBLS(maxWidth)
#define XmCMaxWidth	X_GBLS(MaxWidth)
#define XmNmaxHeight	X_GBLS(maxHeight)
#define XmCMaxHeight	X_GBLS(MaxHeight)
#define XmNwidthInc	X_GBLS(widthInc)
#define XmCWidthInc	X_GBLS(WidthInc)
#define XmNheightInc	X_GBLS(heightInc)
#define XmCHeightInc	X_GBLS(HeightInc)
#define XmNminAspectY	X_GBLS(minAspectY)
#define XmCMinAspectY	X_GBLS(MinAspectY)
#define XmNmaxAspectY	X_GBLS(maxAspectY)
#define XmCMaxAspectY	X_GBLS(MaxAspectY)
#define XmNminAspectX		X_GBLS(minAspectX)
#define XmCMinAspectX		X_GBLS(MinAspectX)
#define XmNmaxAspectX		X_GBLS(maxAspectX)
#define XmCMaxAspectX		X_GBLS(MaxAspectX)
#define XmNwmTimeout		X_GBLS(wmTimeout)
#define XmCWmTimeout		X_GBLS(WmTimeout)
#define XmNwaitForWm		X_GBLS(waitforwm)
#define XmCWaitForWm		X_GBLS(Waitforwm)

/****************
 *
 * New R4 psudo defines
 *
 ****************/
#define XmCReadOnly     XtCReadOnly
#define XmNvisual       XtNvisual
#define XmCVisual       XtCVisual
#define XmNiconNameEncoding     XtNiconNameEncoding
#define XmCIconNameEncoding     XtCIconNameEncoding
#define XmNtransientFor     XtNtransientFor
#define XmCTransientFor     XtCTransientFor
#define XmNbaseHeight       XtNbaseHeight
#define XmCBaseHeight       XtCBaseHeight
#define XmNbaseWidth        XtNbaseWidth
#define XmCBaseWidth        XtCBaseWidth
#define XmNtitleEncoding        XtNtitleEncoding
#define XmCTitleEndcoding       XtCTitleEndcoding
#define XmNwinGravity       XtNwinGravity
#define XmCWinGravity       XtCWinGravity

/************************************************************************
 *  Include VendorE.h in order to get it's resources, so a caller
 *  doesn't have to include it explicitly
 ************************************************************************/
#ifndef _VendorE_h
#ifdef VMS
#include <DECW$INCLUDE:VendorE.h>
#else
#include <Xm/VendorE.h>
#endif
#endif /* _VendorE_h */

#ifndef XmEXPLICIT
#define XmEXPLICIT 0
#define XmPOINTER 1
#endif


/************************************************************************
 *
 *  Base widget class and record definitions.
 *	Included are the definitions for XmPrimitive, XmManager,
 *      and XmGadget.
 *
 ************************************************************************/

/*  Primitive widget class and record definitions  */

externalref WidgetClass xmPrimitiveWidgetClass;

typedef struct _XmPrimitiveClassRec * XmPrimitiveWidgetClass;
typedef struct _XmPrimitiveRec      * XmPrimitiveWidget;


/*  Gadget widget class and record definitions  */

externalref WidgetClass xmGadgetClass;

typedef struct _XmGadgetClassRec * XmGadgetClass;
typedef struct _XmGadgetRec      * XmGadget;


/*  Manager widger class and record definitions  */


externalref WidgetClass xmManagerWidgetClass;

typedef struct _XmManagerClassRec * XmManagerWidgetClass;
typedef struct _XmManagerRec      * XmManagerWidget;


/************************************************************************
 *  Fast subclassing -- just do XtIsSubclass now.  To be replaced.
 ************************************************************************/

#ifndef XmIsPrimitive
#define XmIsPrimitive(w)	XtIsSubclass(w, xmPrimitiveWidgetClass)
#endif  /* XmIsPrimitive */

#ifndef XmIsGadget
#define XmIsGadget(w)	XtIsSubclass(w, xmGadgetClass)
#endif  /* XmIsGadget */

#ifndef XmIsManager
#define XmIsManager(w)	XtIsSubclass(w, xmManagerWidgetClass)
#endif  /* XmIsManager */


/************************************************************************
 *  Primitive Resources and define values
 ************************************************************************/

#define XmNforeground		X_GBLS(foreground)
#define XmCForeground		X_GBLS(Foreground)

#define XmRPrimForegroundPixmap	X_GBLS(PrimForegroundPixmap)
#define XmRManForegroundPixmap	X_GBLS(ManForegroundPixmap)

#define XmCBackgroundPixmap	X_GBLS(BackgroundPixmap)
#define XmRBackgroundPixmap	X_GBLS(BackgroundPixmap)

#define XmNtraversalOn		X_GBLS(traversalOn)
#define XmCTraversalOn		X_GBLS(TraversalOn)

#define XmNhighlightOnEnter	X_GBLS(highlightOnEnter)
#define XmCHighlightOnEnter	X_GBLS(HighlightOnEnter)

#define XmNsizePolicy		X_GBLS(sizePolicy)
#define XmCSizePolicy		X_GBLS(SizePolicy)
#define XmRSizePolicy		X_GBLS(SizePolicy)

#define XmNhighlightThickness	X_GBLS(highlightThickness)
#define XmCHighlightThickness	X_GBLS(HighlightThickness)

#define XmNhighlightColor	X_GBLS(highlightColor)
#define XmCHighlightColor	X_GBLS(HighlightColor)

#define XmNhighlightPixmap	X_GBLS(highlightPixmap)
#define XmCHighlightPixmap	X_GBLS(HighlightPixmap)
#define XmRPrimHighlightPixmap	X_GBLS(HighlightPixmap)

#define XmNshadowThickness	X_GBLS(shadowThickness)
#define XmCShadowThickness	X_GBLS(ShadowThickness)

#define XmNtopShadowColor	X_GBLS(topShadowColor)
#define XmCTopShadowColor	X_GBLS(TopShadowColor)

#define XmNtopShadowPixmap	X_GBLS(topShadowPixmap)
#define XmCTopShadowPixmap	X_GBLS(TopShadowPixmap)
#define XmRPrimTopShadowPixmap	X_GBLS(TopShadowPixmap)

#define XmNbottomShadowColor	X_GBLS(bottomShadowColor)
#define XmCBottomShadowColor	X_GBLS(BottomShadowColor)

#define XmNbottomShadowPixmap		X_GBLS(bottomShadowPixmap)
#define XmCBottomShadowPixmap		X_GBLS(BottomShadowPixmap)
#define XmRPrimBottomShadowPixmap	X_GBLS(BottomShadowPixmap)

#define XmNunitType		X_GBLS(unitType)
#define XmCUnitType		X_GBLS(UnitType)
#define XmRUnitType		X_GBLS(UnitType)

#define XmNhelpCallback		X_GBLS(helpCallback)
#define XmNuserData		X_GBLS(userData)
#define XmCUserData		X_GBLS(UserData)


#ifdef DEC_MOTIF_EXTENSION

/* layout direction resource, added to gadget, primitive and manager class */

#define DXmNlayoutDirection     X_GBLS(DXmlayoutDirection)
#define DXmCLayoutDirection     X_GBLS(DXmLayoutDirection)
#define DXmRLayoutDirection     X_GBLS(DXmLayoutDirection)

#define DXmLAYOUT_LEFT_DOWN   1
#define DXmLAYOUT_LEFT_UP     2
#define DXmLAYOUT_RIGHT_DOWN  3
#define DXmLAYOUT_RIGHT_UP    4

/* Auto-unrealize resource added to Bulletin Board */

#define DXmNautoUnrealize	X_GBLS(DXmautoUnrealize)
#define DXmCAutoUnrealize	X_GBLS(DXmAutoUnrealize)

#endif /* DEC_MOTIF_EXTENSION */



/* size policy values  */

#define XmCHANGE_ALL	0
#define XmCHANGE_NONE	1
#define XmCHANGE_WIDTH	2
#define XmCHANGE_HEIGHT	3


/*  unit type values  */

#define XmPIXELS		0
#define Xm100TH_MILLIMETERS	1
#define Xm1000TH_INCHES		2
#define Xm100TH_POINTS		3
#define Xm100TH_FONT_UNITS	4


/************************************************************************
 *  Navigation defines 
 ************************************************************************/
#ifndef XmNONE
#define XmNONE	 		0
#endif /* XmNONE */
#define XmTAB_GROUP		1
#define XmSTICKY_TAB_GROUP	2
#define XmEXCLUSIVE_TAB_GROUP	3
#define XmDYNAMIC_DEFAULT_TAB_GROUP	255

/************************************************************************
 *  Manager Resources and define values
 ************************************************************************/

#define XmRManTopShadowPixmap		X_GBLS(ManTopShadowPixmap)
#define XmRManBottomShadowPixmap	X_GBLS(ManBottomShadowPixmap)
#define XmRManHighlightPixmap		X_GBLS(ManHighlightPixmap)

#define XmNchildPosition	X_GBLS(childPosition)



/************************************************************************
 *  Menu defines
 ************************************************************************/

#define XmNO_ORIENTATION       0
#define XmVERTICAL	       1
#define XmHORIZONTAL           2

#define XmWORK_AREA	       0
#define XmMENU_BAR	       1
#define XmMENU_PULLDOWN        2
#define XmMENU_POPUP           3
#define XmMENU_OPTION          4

#define XmNO_PACKING           0
#define XmPACK_TIGHT	       1
#define XmPACK_COLUMN	       2
#define XmPACK_NONE	       3


/************************************************************************
 *  Label defines
 ************************************************************************/

#define XmALIGNMENT_BEGINNING		0
#define XmALIGNMENT_CENTER		1
#define XmALIGNMENT_END			2


/************************************************************************
 *  ToggleButton  defines
 ************************************************************************/

#define XmN_OF_MANY			1
#define XmONE_OF_MANY			2


/************************************************************************
 *  Form resources and defines
 ************************************************************************/

/*  Form resources  */

#define XmNhorizontalSpacing	X_GBLS(horizontalSpacing)
#define XmNverticalSpacing	X_GBLS(verticalSpacing)

#define XmNfractionBase		X_GBLS(fractionBase)
#define XmCMaxValue		X_GBLS(MaxValue)

#define XmNrubberPositioning	X_GBLS(rubberPositioning)
#define XmCRubberPositioning	X_GBLS(RubberPositioning)

#define XmNresizePolicy		X_GBLS(resizePolicy)
#define XmCResizePolicy		X_GBLS(ResizePolicy)
#define XmRResizePolicy		X_GBLS(ResizePolicy)


/*  Form constraint resources  */

#define XmNtopAttachment	X_GBLS(topAttachment)
#define XmNbottomAttachment	X_GBLS(bottomAttachment)
#define XmNleftAttachment	X_GBLS(leftAttachment)
#define XmNrightAttachment	X_GBLS(rightAttachment)
#define XmCAttachment		X_GBLS(Attachment)
#define XmRAttachment		X_GBLS(Attachment)

#define XmNtopWidget		X_GBLS(topWidget)
#define XmNbottomWidget		X_GBLS(bottomWidget)
#define XmNleftWidget		X_GBLS(leftWidget)
#define XmNrightWidget		X_GBLS(rightWidget)
#define XmCWidget		X_GBLS(Widget)

#define XmNtopPosition		X_GBLS(topPosition)
#define XmNbottomPosition	X_GBLS(bottomPosition)
#define XmNleftPosition		X_GBLS(leftPosition)
#define XmNrightPosition	X_GBLS(rightPosition)
#define XmNtopOffset		X_GBLS(topOffset)
#define XmNbottomOffset		X_GBLS(bottomOffset)
#define XmNleftOffset		X_GBLS(leftOffset)
#define XmNrightOffset		X_GBLS(rightOffset)
#define XmCOffset		X_GBLS(Offset)

#define XmNresizable		X_GBLS(resizable)

#ifdef DEC_MOTIF_EXTENSION
#ifdef NOT_TURNED_ON_YET
/* Added RtoL aliases for left and right attachments */

#define DXmNnearAttachment      XmNleftAttachment
#define DXmNfarAttachment       XmNrightAttachment
#define DXmNnearWidget		XmNleftWidget
#define DXmNfarWidget 		XmNrightWidget
#define DXmNnearPosition  	XmNleftPosition
#define DXmNfarPosition		XmNrightPosition
#define DXmNnearOffset		XmNleftOffset
#define DXmNfarOffset		XmNrightOffset
#endif
#endif

/*  Form defines  */

#define XmATTACH_NONE			0
#define XmATTACH_FORM			1
#define XmATTACH_OPPOSITE_FORM		2
#define XmATTACH_WIDGET			3
#define XmATTACH_OPPOSITE_WIDGET	4
#define XmATTACH_POSITION		5
#define XmATTACH_SELF			6

#define XmRESIZE_NONE	0
#define XmRESIZE_GROW	1
#define XmRESIZE_ANY	2	/*  for BulletinBoard, DrawingArea  */ 



/****************************************************************************
 *  Callback reasons 
 ****************************************************************************/

#define XmCR_NONE            		0
#define XmCR_HELP            		1
#define XmCR_VALUE_CHANGED		2
#define XmCR_INCREMENT			3
#define XmCR_DECREMENT			4
#define XmCR_PAGE_INCREMENT		5
#define XmCR_PAGE_DECREMENT		6
#define XmCR_TO_TOP			7
#define XmCR_TO_BOTTOM			8
#define XmCR_DRAG			9
#define XmCR_ACTIVATE			10
#define XmCR_ARM			11
#define XmCR_DISARM			12
#define XmCR_MAP       			16
#define XmCR_UNMAP  			17
#define XmCR_FOCUS			18
#define XmCR_LOSING_FOCUS		19
#define XmCR_MODIFYING_TEXT_VALUE	20
#define XmCR_MOVING_INSERT_CURSOR	21
#define XmCR_EXECUTE			22
#define	XmCR_SINGLE_SELECT		23
#define	XmCR_MULTIPLE_SELECT		24
#define	XmCR_EXTENDED_SELECT		25
#define	XmCR_BROWSE_SELECT		26
#define	XmCR_DEFAULT_ACTION		27
#define XmCR_CLIPBOARD_DATA_REQUEST	28
#define XmCR_CLIPBOARD_DATA_DELETE	29
#define XmCR_CASCADING			30
#define XmCR_OK                         31
#define XmCR_CANCEL                     32
#define XmCR_APPLY                      34
#define XmCR_NO_MATCH                   35
#define XmCR_COMMAND_ENTERED            36
#define XmCR_COMMAND_CHANGED            37
#define XmCR_EXPOSE			38
#define XmCR_RESIZE			39
#define XmCR_INPUT			40
#define XmCR_GAIN_PRIMARY		41
#define XmCR_LOSE_PRIMARY		42
/* BEGIN OSF Fix pir 2813 */
#define XmCR_CREATE			43
/* END OSF Fix pir 2813 */
#define XmCR_PROTOCOLS			6666


/************************************************************************
 *  Callback structures 
 ************************************************************************/

typedef struct
{
    int     reason;
    XEvent  *event;
} XmAnyCallbackStruct;

typedef struct
{
    int     reason;
    XEvent  *event;
    int	    click_count;
} XmArrowButtonCallbackStruct;

typedef struct
{
    int     reason;
    XEvent  *event;
    Window  window;
} XmDrawingAreaCallbackStruct;

typedef struct
{
    int     reason;
    XEvent  *event;
    Window  window;
    int	    click_count;
} XmDrawnButtonCallbackStruct;

typedef struct
{
    int     reason;
    XEvent  *event;
    int	    click_count;
} XmPushButtonCallbackStruct;

typedef struct
{
    int     reason;
    XEvent  *event;
    Widget  widget;
    char    *data;
    char    *callbackstruct;
} XmRowColumnCallbackStruct;

typedef struct
{
   int reason;
   XEvent * event;
   int value;
   int pixel;
} XmScrollBarCallbackStruct;

typedef struct
{
   int reason;
   XEvent * event;
   int set;
} XmToggleButtonCallbackStruct;

typedef struct
{
   int 	     reason;
   XEvent    *event;
   XmString  item;
   int       item_length;
   int       item_position;
   XmString  *selected_items;
   int       selected_item_count;
   int       *selected_item_positions;
   char      selection_type;
} XmListCallbackStruct;

typedef struct
{
    int reason;
    XEvent	*event;
    XmString	value;
    int		length;
} XmSelectionBoxCallbackStruct;

typedef struct
{
    int reason;
    XEvent	*event;
    XmString	value;
    int		length;
} XmCommandCallbackStruct;

typedef struct
{
    int reason;
    XEvent	*event;
    XmString	value;
    int		length;
    XmString	mask;
    int		mask_length;
    XmString	dir ;
    int		dir_length ;
    XmString    pattern ;
    int		pattern_length ;
} XmFileSelectionBoxCallbackStruct;


typedef struct 
{
   int reason;
   XEvent * event;
   int value;
} XmScaleCallbackStruct;



/************************************************************************
 *  PushButton defines
 ************************************************************************/

#define XmNfillOnArm		X_GBLS(fillOnArm)
#define XmCFillOnArm		X_GBLS(FillOnArm)

#define XmNarmColor		X_GBLS(armColor)
#define XmCArmColor		X_GBLS(ArmColor)

#define XmNarmPixmap		X_GBLS(armPixmap)
#define XmCArmPixmap		X_GBLS(ArmPixmap)

#define XmNshowAsDefault		X_GBLS(showAsDefault)
#define XmCShowAsDefault		X_GBLS(ShowAsDefault)
#define XmRBooleanDimension		X_GBLS(BooleanDimension)

#define XmNdefaultButtonShadowThickness    X_GBLS(defaultButtonShadowThickness)
#define XmCDefaultButtonShadowThickness    X_GBLS(DefaultButtonShadowThickness)

#define XmNmultiClick	X_GBLS(multiClick)
#define XmCMultiClick	X_GBLS(MultiClick)
#define XmRMultiClick   X_GBLS(MultiClick)

#define XmMULTICLICK_DISCARD 0
#define XmMULTICLICK_KEEP 1

/************************************************************************
 *  DrawnButton defines
 ************************************************************************/

#define XmNpushButtonEnabled	X_GBLS(pushButtonEnabled)
#define XmCPushButtonEnabled	X_GBLS(PushButtonEnabled)

#define XmNshadowType	X_GBLS(shadowType)
#define XmCShadowType	X_GBLS(ShadowType)
#define XmRShadowType   X_GBLS(ShadowType)

#define XmSHADOW_IN		7
#define XmSHADOW_OUT		8

/************************************************************************
 *  Arrow defines
 ************************************************************************/

#define XmNarrowDirection	X_GBLS(arrowDirection)
#define XmCArrowDirection	X_GBLS(ArrowDirection)
#define XmRArrowDirection	X_GBLS(ArrowDirection)

#define XmNactivateCallback	X_GBLS(activateCallback)
#define XmNhelpCallback		X_GBLS(helpCallback)

#define XmARROW_UP	0
#define XmARROW_DOWN	1
#define XmARROW_LEFT	2
#define XmARROW_RIGHT	3



/************************************************************************
 *  Separator defines
 ************************************************************************/

#define XmNmargin 	X_GBLS(margin)
#define XmRMargin	X_GBLS(Margin)

#define XmNseparatorType  X_GBLS(separatorType)
#define XmCSeparatorType  X_GBLS(SeparatorType)
#define XmRSeparatorType  X_GBLS(SeparatorType)

#define XmNO_LINE               0
#define XmSINGLE_LINE           1
#define XmDOUBLE_LINE           2
#define XmSINGLE_DASHED_LINE    3
#define XmDOUBLE_DASHED_LINE    4
#define XmSHADOW_ETCHED_IN	5
#define XmSHADOW_ETCHED_OUT	6

#define XmPIXMAP	1
#define XmSTRING	2



/************************************************************************
 *  ScrollBar resource names and #defines
 ************************************************************************/

/*  Resources for scrollbar  */

#define XmNminimum	X_GBLS(minimum)
#define XmCMinimum	X_GBLS(Minimum)

#define XmNmaximum	X_GBLS(maximum)
#define XmCMaximum	X_GBLS(Maximum)

#define XmNsliderSize	X_GBLS(sliderSize)
#define XmCSliderSize	X_GBLS(SliderSize)

#define XmNshowArrows	X_GBLS(showArrows)
#define XmCShowArrows	X_GBLS(ShowArrows)

#define XmNprocessingDirection	X_GBLS(processingDirection)
#define XmCProcessingDirection	X_GBLS(ProcessingDirection)
#define XmRProcessingDirection	X_GBLS(ProcessingDirection)

#define XmNincrement		X_GBLS(increment)
#define XmCIncrement		X_GBLS(Increment)
#define XmNpageIncrement	X_GBLS(pageIncrement)
#define XmCPageIncrement	X_GBLS(PageIncrement)

#define XmNinitialDelay		X_GBLS(initialDelay)
#define XmCInitialDelay		X_GBLS(InitialDelay)
#define XmNrepeatDelay		X_GBLS(repeatDelay)
#define XmCRepeatDelay		X_GBLS(RepeatDelay)

#define XmNvalueChangedCallback		X_GBLS(valueChangedCallback)
#define XmNincrementCallback		X_GBLS(incrementCallback)
#define XmNdecrementCallback		X_GBLS(decrementCallback)
#define XmNpageIncrementCallback	X_GBLS(pageIncrementCallback)
#define XmNpageDecrementCallback	X_GBLS(pageDecrementCallback)
#define XmNtoTopCallback		X_GBLS(toTopCallback)
#define XmNtoBottomCallback		X_GBLS(toBottomCallback)
#define XmNdragCallback			X_GBLS(dragCallback)

/*  Defined values for scrollbar  */

#define XmMAX_ON_TOP	0
#define XmMAX_ON_BOTTOM	1
#define XmMAX_ON_LEFT	2
#define XmMAX_ON_RIGHT	3


/************************************************************************
 *									*
 * List Widget defines							*
 *									*
 ************************************************************************/


#define XmNlistSpacing 	X_GBLS(listSpacing)
#define XmCListSpacing	X_GBLS(ListSpacing)
#define XmRListSpacing	X_GBLS(ListSpacing)

#define XmNlistMarginWidth 	X_GBLS(listMarginWidth)
#define XmCListMarginWidth	X_GBLS(ListMarginWidth)
#define XmRListMarginWidth	X_GBLS(ListMarginWidth)

#define XmNlistMarginHeight 	X_GBLS(listMarginHeight)
#define XmCListMarginHeight	X_GBLS(ListMarginHeight)
#define XmRListMarginHeight	X_GBLS(ListMarginHeight)

#define XmNitems 	X_GBLS(items)
#define XmCItems	X_GBLS(Items)
#define XmRItems	X_GBLS(Items)

#define XmNitemCount 	X_GBLS(itemCount)
#define XmCItemCount	X_GBLS(ItemCount)
#define XmRItemCount	X_GBLS(ItemCount)

#define XmNselectedItems 	X_GBLS(selectedItems)
#define XmCSelectedItems	X_GBLS(SelectedItems)
#define XmRSelectedItems	X_GBLS(SelectedItems)

#define XmNselectedItemCount 	X_GBLS(selectedItemCount)
#define XmCSelectedItemCount	X_GBLS(SelectedItemCount)
#define XmRSelectedItemCount	X_GBLS(SelectedItemCount)

#define XmNvisibleItemCount 	X_GBLS(visibleItemCount)
#define XmCVisibleItemCount	X_GBLS(VisibleItemCount)
#define XmRVisibleItemCount	X_GBLS(VisibleItemCount)

#define XmNselectionPolicy 	X_GBLS(selectionPolicy)
#define XmCSelectionPolicy	X_GBLS(SelectionPolicy)
#define XmRSelectionPolicy	X_GBLS(SelectionPolicy)

#define XmNlistSizePolicy 	X_GBLS(listSizePolicy)
#define XmCListSizePolicy	X_GBLS(ListSizePolicy)
#define XmRListSizePolicy	X_GBLS(ListSizePolicy)

#define XmNdoubleClickInterval 	X_GBLS(doubleClickInterval)
#define XmCDoubleClickInterval	X_GBLS(DoubleClickInterval)
#define XmRDoubleClickInterval	X_GBLS(DoubleClickInterval)

#define XmNsingleSelectionCallback 	X_GBLS(singleSelectionCallback)
#define XmNmultipleSelectionCallback 	X_GBLS(multipleSelectionCallback)
#define XmNextendedSelectionCallback 	X_GBLS(extendedSelectionCallback)
#define XmNbrowseSelectionCallback 	X_GBLS(browseSelectionCallback)
#define XmNdefaultActionCallback 	X_GBLS(defaultActionCallback)

#define XmNautomaticSelection	X_GBLS(automaticSelection)
#define XmCAutomaticSelection	X_GBLS(AutomaticSelection)

#define XmNtopItemPosition      X_GBLS(topItemPosition)
#define XmCTopItemPosition      X_GBLS(TopItemPosition)

/****************
 *
 * Selection types
 *
 ****************/
#define	XmSINGLE_SELECT		0
#define	XmMULTIPLE_SELECT	1
#define	XmEXTENDED_SELECT	2
#define	XmBROWSE_SELECT		3

#define	XmSTATIC	0
#define	XmDYNAMIC	1

/************************************************************************
 *									*
 * Scrolled Window defines.						*
 *									*
 ************************************************************************/
#define XmNhorizontalScrollBar	X_GBLS(horizontalScrollBar)
#define XmCHorizontalScrollBar	X_GBLS(HorizontalScrollBar)

#define XmNverticalScrollBar	X_GBLS(verticalScrollBar)
#define XmCVerticalScrollBar	X_GBLS(VerticalScrollBar)

#define XmNworkWindow	X_GBLS(workWindow)
#define XmCWorkWindow	X_GBLS(WorkWindow)

#define XmNclipWindow	X_GBLS(clipWindow)
#define XmCClipWindow	X_GBLS(ClipWindow)

#define XmNscrollingPolicy	X_GBLS(scrollingPolicy)
#define XmCScrollingPolicy	X_GBLS(ScrollingPolicy)
#define XmRScrollingPolicy	X_GBLS(ScrollingPolicy)

#define  XmNvisualPolicy	X_GBLS(visualPolicy)
#define  XmCVisualPolicy	X_GBLS(VisualPolicy)
#define  XmRVisualPolicy	X_GBLS(VisualPolicy)

#define XmNscrollBarDisplayPolicy	X_GBLS(scrollBarDisplayPolicy)
#define XmCScrollBarDisplayPolicy	X_GBLS(ScrollBarDisplayPolicy)
#define XmRScrollBarDisplayPolicy	X_GBLS(ScrollBarDisplayPolicy)

#define XmNscrollBarPlacement	X_GBLS(scrollBarPlacement)
#define XmCScrollBarPlacement	X_GBLS(ScrollBarPlacement)
#define XmRScrollBarPlacement	X_GBLS(ScrollBarPlacement)

#define XmNupdateSliderSize	X_GBLS(updateSliderSize)
#define XmCUpdateSliderSize	X_GBLS(UpdateSliderSize)

#define XmNscrolledWindowMarginHeight	X_GBLS(scrolledWindowMarginHeight)
#define XmCScrolledWindowMarginHeight	X_GBLS(ScrolledWindowMarginHeight)

#define XmNscrolledWindowMarginWidth	X_GBLS(scrolledWindowMarginWidth)
#define XmCScrolledWindowMarginWidth	X_GBLS(ScrolledWindowMarginWidth)


#define XmVARIABLE	        0
#define XmCONSTANT	        1
#define XmRESIZE_IF_POSSIBLE	2

#define XmAUTOMATIC		0
#define XmAPPLICATION_DEFINED	1

/* #define	XmSTATIC	0     ** This is already defined by List ***/
#define	XmAS_NEEDED	1

#define SW_TOP		1
#define SW_BOTTOM	0
#define SW_LEFT		2
#define SW_RIGHT	0

#define XmTOP_LEFT	(SW_TOP | SW_LEFT)
#define XmBOTTOM_LEFT	(SW_BOTTOM  | SW_LEFT)
#define XmTOP_RIGHT	(SW_TOP | SW_RIGHT)
#define XmBOTTOM_RIGHT	(SW_BOTTOM  | SW_RIGHT)

/************************************************************************
 *									*
 * MainWindow Resources                                                 *
 *									*
 ************************************************************************/


#define XmNcommandWindow		X_GBLS(commandWindow)
#define XmCCommandWindow		X_GBLS(CommandWindow)
#define XmNmenuBar			X_GBLS(menuBar)
#define XmCMenuBar			X_GBLS(MenuBar)
#define XmNmessageWindow		X_GBLS(messageWindow)
#define XmCMessageWindow		X_GBLS(MessageWindow)
#define XmNmainWindowMarginHeight	X_GBLS(mainWindowMarginHeight)
#define XmCMainWindowMarginHeight	X_GBLS(MainWindowMarginHeight)
#define XmNmainWindowMarginWidth	X_GBLS(mainWindowMarginWidth)
#define XmCMainWindowMarginWidth	X_GBLS(MainWindowMarginWidth)
#define XmNshowSeparator    X_GBLS(showSeparator)
#define XmCShowSeparator    X_GBLS(ShowSeparator)

#define XmCOMMAND_ABOVE_WORKSPACE 0
#define XmCOMMAND_BELOW_WORKSPACE 1

/************************************************************************
 *									*
 * Text Widget defines							*
 *									*
 ************************************************************************/

#define XmNsource		X_GBLS(source)
#define XmCSource		X_GBLS(Source)

#define XmNoutputCreate		X_GBLS(outputCreate)
#define XmCOutputCreate		X_GBLS(OutputCreate)

#define XmNinputCreate		X_GBLS(inputCreate)
#define XmCInputCreate		X_GBLS(InputCreate)

#define XmNautoShowCursorPosition	X_GBLS(autoShowCursorPosition)
#define XmCAutoShowCursorPosition	X_GBLS(AutoShowCursorPosition)

#define XmNcursorPosition	X_GBLS(cursorPosition)
#define XmCCursorPosition	X_GBLS(CursorPosition)

#define XmNeditable		X_GBLS(editable)
#define XmCEditable		X_GBLS(Editable)

#define XmNmaxLength		X_GBLS(maxLength)
#define XmCMaxLength		X_GBLS(MaxLength)

#define XmNfocusCallback	 X_GBLS(focusCallback)
#define XmNlosingFocusCallback	 X_GBLS(losingFocusCallback)
#define XmNmodifyVerifyCallback  X_GBLS(modifyVerifyCallback)
#define XmNmotionVerifyCallback  X_GBLS(motionVerifyCallback)
#define XmNgainPrimaryCallback  X_GBLS(gainPrimaryCallback)
#define XmNlosePrimaryCallback  X_GBLS(losePrimaryCallback)

#define XmNverifyBell                   X_GBLS(verifyBell)
#define XmCVerifyBell                   X_GBLS(VerifyBell)

#define XmNwordWrap		X_GBLS(wordWrap)
#define XmCWordWrap		X_GBLS(WordWrap)

#define XmNblinkRate		X_GBLS(blinkRate)
#define XmCBlinkRate		X_GBLS(BlinkRate)

#define XmNresizeWidth		X_GBLS(resizeWidth)
#define XmCResizeWidth		X_GBLS(ResizeWidth)

#define XmNresizeHeight	X_GBLS(resizeHeight)
#define XmCResizeHeight	X_GBLS(ResizeHeight)

#define XmNscrollHorizontal	X_GBLS(scrollHorizontal)
#define XmNscrollVertical	X_GBLS(scrollVertical)
#define XmCScroll		X_GBLS(Scroll)

#define XmNscrollLeftSide	X_GBLS(scrollLeftSide)
#define XmNscrollTopSide	X_GBLS(scrollTopSide)
#define XmCScrollSide		X_GBLS(ScrollSide)

#define XmNcursorPositionVisible	X_GBLS(cursorPositionVisible)
#define XmCCursorPositionVisible	X_GBLS(CursorPositionVisible)

#define XmNtoPositionCallback	X_GBLS(toPositionCallback)

#define XmNcolumns	X_GBLS(columns)
#define XmCColumns	X_GBLS(Columns)

#define XmNrows		X_GBLS(rows)
#define XmCRows		X_GBLS(Rows)

#define XmNselectThreshold		X_GBLS(selectThreshold)
#define XmCSelectThreshold		X_GBLS(SelectThreshold)

#define XmNselectionArrayCount		X_GBLS(selectionArrayCount)
#define XmCSelectionArrayCount		X_GBLS(SelectionArrayCount)

#define XmNpendingDelete		X_GBLS(pendingDelete)
#define XmCPendingDelete		X_GBLS(PendingDelete)

#define XmNeditMode			X_GBLS(editMode)
#define XmCEditMode			X_GBLS(EditMode)

#define XmMULTI_LINE_EDIT	0
#define XmSINGLE_LINE_EDIT	1

typedef long XmTextPosition;
typedef Atom XmTextFormat;

#define FMT8BIT         ((XmTextFormat) XA_STRING)      /* 8-bit text. */
#define FMT16BIT        ((XmTextFormat)2)               /* 16-bit text. */

typedef enum { XmSELECT_POSITION, XmSELECT_WHITESPACE, XmSELECT_WORD,
               XmSELECT_LINE, XmSELECT_ALL, XmSELECT_PARAGRAPH } XmTextScanType;

typedef enum {XmHIGHLIGHT_NORMAL, XmHIGHLIGHT_SELECTED,
	      XmHIGHLIGHT_SECONDARY_SELECTED} XmHighlightMode;

/* XmTextBlock's are used to pass text around. */

typedef struct {
    char *ptr;                  /* Pointer to data. */
    int length;                 /* Number of bytes of data. */
    XmTextFormat format;       /* Representations format */
} XmTextBlockRec, *XmTextBlock;

typedef struct
{
    int reason;
    XEvent  *event;
    Boolean doit;
    long currInsert, newInsert;
    long startPos, endPos;
    XmTextBlock text;
} XmTextVerifyCallbackStruct, *XmTextVerifyPtr;

#define XmNtopCharacter                 X_GBLS(topCharacter)
#define XmCtopCharacter                 X_GBLS(TopCharacter)

/* functions renamed after 1.0 release due to resource name overlap */
#define XmGetTopPosition                XmGetTopCharacter
#define XmSetTopPosition                XmSetTopCharacter

/************************************************************************
 *									*
 * VPaned Widget defines						*
 *									*
 ************************************************************************/

/*  Resources for Vertical Paned Window  */

#define XmNrefigureMode		X_GBLS(refigureMode)

#define XmNseparatorOn		X_GBLS(separatorOn)
#define XmCSeparatorOn		X_GBLS(SeparatorOn)

#define XmNsashIndent		X_GBLS(sashIndent)
#define XmCSashIndent		X_GBLS(SashIndent)

#define XmNsashWidth		X_GBLS(sashWidth)
#define XmCSashWidth		X_GBLS(SashWidth)

#define XmNsashHeight		X_GBLS(sashHeight)
#define XmCSashHeight		X_GBLS(SashHeight)

#define XmNsashShadowThickness	X_GBLS(sashShadowThickness)


/* Constraint Resources for Vertical Paned Window */

#define XmNallowResize		X_GBLS(allowResize)
#define XmNskipAdjust		X_GBLS(skipAdjust)
#define XmNpaneMinimum          X_GBLS(paneMinimum)
#define XmNpaneMaximum          X_GBLS(paneMaximum)

#define XmCPaneMinimum          X_GBLS(PaneMinimum)
#define XmCPaneMaximum          X_GBLS(PaneMaximum)



/************************************************************************
 *									*
 * 	DrawingArea defines
 *									*
 ************************************************************************/

#define XmNinputCallback	X_GBLS(inputCallback)


/************************************************************************
 *									*
 *  DIALOG defines..  BulletinBoard and things common to its subclasses *
 *          CommandBox    MessageBox    Selection    FileSelection      *
 *									*
 ************************************************************************/

/* child type defines for Xm...GetChild() */
#define XmDIALOG_NONE	          0       /* a valid default button type */
#define XmDIALOG_APPLY_BUTTON	  1
#define XmDIALOG_CANCEL_BUTTON    2
#define XmDIALOG_DEFAULT_BUTTON   3
#define XmDIALOG_OK_BUTTON        4
#define XmDIALOG_FILTER_LABEL     5
#define XmDIALOG_FILTER_TEXT      6
#define XmDIALOG_HELP_BUTTON      7
#define XmDIALOG_LIST		  8
#define XmDIALOG_HISTORY_LIST     XmDIALOG_LIST
#define XmDIALOG_LIST_LABEL	  9
#define XmDIALOG_MESSAGE_LABEL    10
#define XmDIALOG_SELECTION_LABEL  11
#define XmDIALOG_PROMPT_LABEL     XmDIALOG_SELECTION_LABEL
#define XmDIALOG_SYMBOL_LABEL     12
#define XmDIALOG_TEXT	    	  13
#define XmDIALOG_VALUE_TEXT       XmDIALOG_TEXT
#define XmDIALOG_COMMAND_TEXT     XmDIALOG_TEXT
#define XmDIALOG_SEPARATOR    	  14
#define XmDIALOG_DIR_LIST         15
#define XmDIALOG_DIR_LIST_LABEL   16
#define XmDIALOG_FILE_LIST        XmDIALOG_LIST
#define XmDIALOG_FILE_LIST_LABEL  XmDIALOG_LIST_LABEL

/* defines for callbacks */
#define XmNokCallback             X_GBLS(okCallback)
#define XmNcancelCallback         X_GBLS(cancelCallback)
#define XmNapplyCallback	  X_GBLS(applyCallback)
#define XmNnoMatchCallback	  X_GBLS(noMatchCallback)
#define XmNcommandEnteredCallback X_GBLS(commandEnteredCallback)
#define XmNcommandChangedCallback X_GBLS(commandChangedCallback)


/* XmN defines for subwidgets */
#define XmNokLabelString         X_GBLS(okLabelString)
#define XmNcancelLabelString     X_GBLS(cancelLabelString)
#define XmNhelpLabelString       X_GBLS(helpLabelString)
#define XmNapplyLabelString	 X_GBLS(applyLabelString)
#define XmNselectionLabelString	 X_GBLS(selectionLabelString)
#define XmNlistLabelString	 X_GBLS(listLabelString)
#define XmNpromptString          X_GBLS(promptString)


/* XmC defines for subwidgets */
#define XmCOkLabelString	 X_GBLS(OkLabelString)
#define XmCCancelLabelString	 X_GBLS(CancelLabelString)
#define XmCHelpLabelString	 X_GBLS(HelpLabelString)
#define XmCApplyLabelString	 X_GBLS(ApplyLabelString)
#define XmCSelectionLabelString	 X_GBLS(SelectionLabelString)
#define XmCListLabelString	 X_GBLS(ListLabelString)
#define XmCPromptString          X_GBLS(PromptString)
#define XmCMessageString         X_GBLS(MessageString)


#define XmNdefaultButton	X_GBLS(defaultButton)
#define XmNcancelButton		X_GBLS(cancelButton)

#define XmNbuttonFontList	X_GBLS(buttonFontList)
#define XmCButtonFontList	X_GBLS(ButtonFontList)
#define XmNlabelFontList	X_GBLS(labelFontList)
#define XmCLabelFontList	X_GBLS(LabelFontList)
#define XmNtextFontList		X_GBLS(textFontList)
#define XmCTextFontList		X_GBLS(TextFontList)

#define XmNtextTranslations	X_GBLS(textTranslations)

#define XmNallowOverlap		X_GBLS(allowOverlap)
#define XmCAllowOverlap		X_GBLS(AllowOverlap)

#define XmNdefaultPosition	X_GBLS(defaultPosition)
#define XmCDefaultPosition	X_GBLS(DefaultPosition)

#define XmNautoUnmanage		X_GBLS(autoUnmanage)
#define XmCAutoUnmanage		X_GBLS(AutoUnmanage)

#define XmNallowShellResize	X_GBLS(allowShellResize)

#define XmNdialogTitle		X_GBLS(dialogTitle)
#define XmCDialogTitle		X_GBLS(DialogTitle)

#define XmNnoResize		X_GBLS(noResize)
#define XmCNoResize		X_GBLS(NoResize)

#define XmNdialogStyle		X_GBLS(dialogStyle)
#define XmCDialogStyle		X_GBLS(DialogStyle)
#define XmRDialogStyle		X_GBLS(DialogStyle)

/*  dialog style defines  */
#define XmDIALOG_MODELESS		0
#define XmDIALOG_PRIMARY_APPLICATION_MODAL 1
#define XmDIALOG_FULL_APPLICATION_MODAL	2
#define XmDIALOG_SYSTEM_MODAL		3

/* The following is for compatibility only. Its use is deprecated.
 */
#define XmDIALOG_APPLICATION_MODAL	XmDIALOG_PRIMARY_APPLICATION_MODAL

#ifdef DEC_MOTIF_EXTENSION
/* Automatic I14Y Code */
#define DXmNfitToScreenPolicy	"DXmfitToScreenPolicy"
#define DXmCFitToScreenPolicy   "DXmFitToScreenPolicy"
#define DXmRFitToScreenPolicy	"DXmFitToScreenPolicy"

#define DXmNONE			0
#define DXmAS_NEEDED		1
#endif

/************************************************************************
 * XmSelectionBox, XmFileSelectionBox and XmCommand - misc. stuff       *
 ***********************************************************************/

#define XmNmustMatch		   X_GBLS(mustMatch)
#define XmCMustMatch		   X_GBLS(MustMatch)
#define XmNnoMatchString	   X_GBLS(noMatchString)
#define XmCNoMatchString	   X_GBLS(NoMatchString)
#define XmNdirectory		   X_GBLS(directory)
#define XmCDirectory		   X_GBLS(Directory)
#define XmNpattern		   X_GBLS(pattern)
#define XmCPattern		   X_GBLS(Pattern)
#define XmNdirSpec                 X_GBLS(dirSpec)
#define XmCDirSpec                 X_GBLS(DirSpec)
#define XmNdirMask                 X_GBLS(dirMask)
#define XmCDirMask                 X_GBLS(DirMask)
#define XmNfileTypeMask            X_GBLS(fileTypeMask)
#define XmCFileTypeMask            X_GBLS(FileTypeMask)
#define XmRFileTypeMask            X_GBLS(FileTypeMask)
#define XmNdirectoryValid          X_GBLS(directoryValid)
#define XmCDirectoryValid          X_GBLS(DirectoryValid)
#define XmNdirListItems		   X_GBLS(dirListItems)
#define XmCDirListItems		   X_GBLS(DirListItems)
#define XmNdirListItemCount	   X_GBLS(dirListItemCount)
#define XmCDirListItemCount	   X_GBLS(DirListItemCount)
#define XmNdirListLabelString      X_GBLS(dirListLabelString)
#define XmCDirListLabelString      X_GBLS(DirListLabelString)
#define XmNfileListItems	   "fileListItems"
#define XmCFileListItems	   "FileListItems"
#define XmNfileListItemCount	   "fileListItemCount"
#define XmCFileListItemCount	   "FileListItemCount"
#define XmNfileListLabelString     X_GBLS(fileListLabelString)
#define XmCFileListLabelString     X_GBLS(FileListLabelString)
#define XmNqualifySearchDataProc   X_GBLS(qualifySearchDataProc)
#define XmCQualifySearchDataProc   X_GBLS(QualifySearchDataProc)
#define XmNdirSearchProc           X_GBLS(dirSearchProc)
#define XmCDirSearchProc           X_GBLS(DirSearchProc)
#define XmNfileSearchProc          X_GBLS(fileSearchProc)
#define XmCFileSearchProc          X_GBLS(FileSearchProc)
#define XmNlistItems		   X_GBLS(listItems)
#define XmNlistItemCount	   X_GBLS(listItemCount)
#define XmNlistVisibleItemCount	   X_GBLS(listVisibleItemCount)
#define XmNhistoryItems		   X_GBLS(historyItems)
#define XmNhistoryItemCount	   X_GBLS(historyItemCount)
#define XmNhistoryVisibleItemCount X_GBLS(historyVisibleItemCount)
#define XmNhistoryMaxItems         X_GBLS(historyMaxItems)
#define XmCMaxItems                X_GBLS(MaxItems)

#define XmNtextAccelerators	X_GBLS(textAccelerators)
#define XmCTextValue		X_GBLS(TextValue)          /* used in text widget */
#define XmNtextValue		X_GBLS(textValue)          /* used in text widget */
#define XmCTextString	        X_GBLS(TextString)
#define XmNtextString	        X_GBLS(textString)
#define XmNtextColumns		X_GBLS(textColumns)
#define XmNcommand		X_GBLS(command)

/* Defines for file type mask:
*/
#define XmFILE_DIRECTORY (1 << 0)
#define XmFILE_REGULAR   (1 << 1)
#define XmFILE_ANY_TYPE  (XmFILE_DIRECTORY | XmFILE_REGULAR)

/* Defines for selection dialog type:
*/
#define XmDIALOG_WORK_AREA      0
#define XmDIALOG_PROMPT         1
#define XmDIALOG_SELECTION      2
#define XmDIALOG_COMMAND        3
#define XmDIALOG_FILE_SELECTION 4


/************************************************************************
 *  XmMessageBox           stuff not common to other dialogs            *
 ***********************************************************************/

#define XmNdefaultButtonType     X_GBLS(defaultButtonType)
#define XmCDefaultButtonType     X_GBLS(DefaultButtonType)
#define XmRDefaultButtonType     X_GBLS(DefaultButtonType)

#define XmNminimizeButtons       X_GBLS(minimizeButtons)
#define XmCMinimizeButtons       X_GBLS(MinimizeButtons)

#define XmNmessageString         X_GBLS(messageString)
#define XmNmessageAlignment      X_GBLS(messageAlignment)

#define XmNsymbolPixmap          X_GBLS(symbolPixmap)

#define XmNdialogType            X_GBLS(dialogType)
#define XmCDialogType            X_GBLS(DialogType)
#define XmRDialogType            X_GBLS(DialogType)

/* defines for dialog type */
#define XmDIALOG_ERROR        1
#define XmDIALOG_INFORMATION  2
#define XmDIALOG_MESSAGE      3
#define XmDIALOG_QUESTION     4
#define XmDIALOG_WARNING      5
#define XmDIALOG_WORKING      6


/************************************************************************
 *	Resource names used by XmScale
 ************************************************************************/

#define XmNscaleWidth		X_GBLS(scaleWidth)
#define XmCScaleWidth		X_GBLS(ScaleWidth)

#define XmNscaleHeight		X_GBLS(scaleHeight)
#define XmCScaleHeight		X_GBLS(ScaleHeight)

#define XmNdecimalPoints	X_GBLS(decimalPoints)
#define XmCDecimalPoints	X_GBLS(DecimalPoints)

#define XmNshowValue		X_GBLS(showValue)
#define XmCShowValue		X_GBLS(ShowValue)

#define XmNtitleString		X_GBLS(titleString)
#define XmCTitleString		X_GBLS(TitleString)

/*  Traversal direction defines  */

#define XmTRAVERSE_CURRENT            0
#define XmTRAVERSE_NEXT               1
#define XmTRAVERSE_PREV               2
#define XmTRAVERSE_HOME               3
#define XmTRAVERSE_NEXT_TAB_GROUP     4
#define XmTRAVERSE_PREV_TAB_GROUP     5
#define XmTRAVERSE_UP                 6
#define XmTRAVERSE_DOWN               7
#define XmTRAVERSE_LEFT               8
#define XmTRAVERSE_RIGHT              9


/**********************************************************************
 *
 *  Color generation function.
 *
 **********************************************************************/

#ifdef _NO_PROTO
typedef void (*XmColorProc) ();
void XmGetColors();
XmColorProc  XmSetColorCalculation();
XmColorProc  XmGetColorCalculation();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

typedef void (*XmColorProc) (
 	XColor *bg_color,
 	XColor *fg_color,
 	XColor *sel_color,
 	XColor *ts_color,
 	XColor *bs_color
     );
XmColorProc XmSetColorCalculation(XmColorProc proc);
XmColorProc XmGetColorCalculation(void);
void XmGetColors (Screen * screen, Colormap color_map, Pixel background,
	Pixel *foreground_ret, Pixel *top_shadow_ret,
	Pixel *bottom_shadow_ret, Pixel *select_ret);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

/**********************************************************************
 *
 *  extern for the string to unit type converter.
 *
 **********************************************************************/

#ifdef _NO_PROTO
extern void XmCvtStringToUnitType();
extern void XmSetFontUnit();
extern void XmSetFontUnits();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
extern void XmCvtStringToUnitType(XrmValuePtr args, Cardinal * num_args,
				  XrmValue * from_val, XrmValue * to_val);

extern void XmSetFontUnit (Display *display, int value);
extern void XmSetFontUnits(Display *display, int hvalue, int vvalue);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

/****************
 *
 *  Public functions with prototypes defined in XmString.c
 *
 ****************/

#ifndef _ARGUMENTS
#ifdef _NO_PROTO
#define _ARGUMENTS(arglist) ()
#else
#define _ARGUMENTS(arglist) arglist
#endif
#endif

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#if NeedWidePrototypes

extern XmString XmStringDirectionCreate  _ARGUMENTS((int direction));
extern XmString XmStringSegmentCreate  _ARGUMENTS(( char *text , XmStringCharSet charset , int direction , int separator ));
extern void XmStringDraw  _ARGUMENTS(( Display *d , Window w , XmFontList fontlist , XmString string , GC gc , int x , int y , int width , unsigned int align , unsigned int lay_dir ,XRectangle *clip ));
extern void XmStringDrawImage  _ARGUMENTS(( Display *d , Window w , XmFontList fontlist , XmString string , GC gc ,int x , int y , int width , unsigned int align , unsigned int lay_dir , XRectangle *clip ));
extern void XmStringDrawUnderline  _ARGUMENTS(( Display *d , Window w , XmFontList fntlst , XmString str , GC gc , int x , int y , int width , unsigned int align , unsigned int lay_dir , XRectangle *clip, XmString under ));
#else
extern XmString XmStringDirectionCreate  _ARGUMENTS((XmStringDirection direction ));
extern XmString XmStringSegmentCreate  _ARGUMENTS(( char *text , XmStringCharSet charset ,XmStringDirection direction , Boolean separator ));
extern void XmStringDraw  _ARGUMENTS(( Display *d , Window w , XmFontList fontlist , XmString string , GC gc ,Position x , Position y , Dimension width , unsigned char align , unsigned char lay_dir , XRectangle *clip ));
extern void XmStringDrawImage  _ARGUMENTS(( Display *d , Window w , XmFontList fontlist , XmString string , GC gc ,Position x , Position y , Dimension width , unsigned char align , unsigned char lay_dir , XRectangle *clip ));
extern void XmStringDrawUnderline  _ARGUMENTS(( Display *d , Window w , XmFontList fntlst , XmString str , GC gc , Position x , Position y , Dimension width , unsigned char align , unsigned char lay_dir , XRectangle *clip , XmString under ));

#endif /* NeedWidePrototypes */

extern XmString XmStringCreate  _ARGUMENTS(( char *text , XmStringCharSet charset ));
extern XmString XmStringCreateSimple  _ARGUMENTS(( char *text ));
extern XmString XmStringSeparatorCreate  _ARGUMENTS(( void ));
extern XmString XmStringLtoRCreate  _ARGUMENTS(( char *text , XmStringCharSet charset ));
extern XmString XmStringCreateLtoR  _ARGUMENTS(( char *text , XmStringCharSet charset ));
extern Boolean XmStringInitContext  _ARGUMENTS(( XmStringContext *context , XmString string ));
extern void XmStringFreeContext  _ARGUMENTS(( XmStringContext context ));
#ifdef DEC_MOTIF_EXTENSION
/* Note - the original version of the XmStringGetNextComponent prototype
** is too long for VMS C compiler using /SHOW=EXPAND
** But the prototype itself can't be #ifdef'd to keep both versions in
*/
#endif
extern XmStringComponentType XmStringGetNextComponent  _ARGUMENTS((
		XmStringContext context ,
		char **text ,
		XmStringCharSet *charset ,
		XmStringDirection *direction ,
		XmStringComponentType *unknown_tag ,
		unsigned short *unknown_length ,
		unsigned char **unknown_value ));
extern XmStringComponentType XmStringPeekNextComponent  _ARGUMENTS(( XmStringContext context ));
extern Boolean XmStringGetNextSegment  _ARGUMENTS(( XmStringContext context , char **text , XmStringCharSet *charset , XmStringDirection *direction , Boolean *separator ));
extern Boolean XmStringGetLtoR  _ARGUMENTS(( XmString string , XmStringCharSet charset , char **text ));
extern XmFontList XmFontListCreate  _ARGUMENTS(( XFontStruct *font , XmStringCharSet charset ));
extern XmFontList XmStringCreateFontList  _ARGUMENTS(( XFontStruct *font , XmStringCharSet charset ));
extern void XmFontListFree  _ARGUMENTS(( XmFontList fontlist ));
extern XmFontList XmFontListAdd  _ARGUMENTS(( XmFontList old , XFontStruct *font , XmStringCharSet charset ));
extern XmFontList XmFontListCopy  _ARGUMENTS(( XmFontList fontlist ));
extern Boolean XmFontListInitFontContext  _ARGUMENTS(( XmFontContext *context , XmFontList fontlist ));
extern Boolean XmFontListGetNextFont  _ARGUMENTS(( XmFontContext context , XmStringCharSet *charset , XFontStruct **font ));
extern void XmFontListFreeFontContext  _ARGUMENTS(( XmFontContext context ));
extern XmString XmStringConcat  _ARGUMENTS(( XmString a , XmString b ));
extern XmString XmStringNConcat  _ARGUMENTS(( XmString first , XmString second , int n ));
extern XmString XmStringCopy  _ARGUMENTS(( XmString string ));
extern XmString XmStringNCopy  _ARGUMENTS(( XmString str , int n ));
extern Boolean XmStringByteCompare  _ARGUMENTS(( XmString a1 , XmString b1 ));
extern Boolean XmStringCompare  _ARGUMENTS(( XmString a , XmString b ));
extern int XmStringLength  _ARGUMENTS(( XmString string ));
extern Boolean XmStringEmpty  _ARGUMENTS(( XmString string ));
extern Boolean XmStringHasSubstring  _ARGUMENTS(( XmString string , XmString substring ));
extern void XmStringFree  _ARGUMENTS(( XmString string ));
extern Dimension XmStringBaseline  _ARGUMENTS(( XmFontList fontlist , XmString string ));
extern Dimension XmStringWidth  _ARGUMENTS(( XmFontList fontlist , XmString string ));
extern Dimension XmStringHeight  _ARGUMENTS(( XmFontList fontlist , XmString string ));
extern void XmStringExtent  _ARGUMENTS(( XmFontList fontlist , XmString string , Dimension *width , Dimension *height ));
extern int XmStringLineCount  _ARGUMENTS(( XmString string ));

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

/***********************************************************************
 *
 * SimpleMenu declarations and definitions.
 *
 ***********************************************************************/
typedef unsigned char XmButtonType;
typedef XmButtonType * XmButtonTypeTable;
typedef KeySym * XmKeySymTable;
typedef XmStringCharSet * XmStringCharSetTable;

#define XmPUSHBUTTON 1
#define XmTOGGLEBUTTON 2
#define XmCHECKBUTTON 2
#define XmRADIOBUTTON 3
#define XmCASCADEBUTTON 4
#define XmSEPARATOR 5
#define XmDOUBLE_SEPARATOR 6
#define XmTITLE 7

#define XmVaPUSHBUTTON		"pushButton"
#define XmVaTOGGLEBUTTON        "checkButton"
#define XmVaCHECKBUTTON         "checkButton"
#define XmVaRADIOBUTTON         "radioButton"
#define XmVaCASCADEBUTTON	"cascadeButton"
#define XmVaSEPARATOR		"separator"
#define XmVaSINGLE_SEPARATOR	"singleSeparator"
#define XmVaDOUBLE_SEPARATOR	"doubleSeparator"
#define XmVaTITLE		"title"

#ifdef _NO_PROTO
Widget XmCreateSimpleMenuBar();
Widget XmCreateSimplePopupMenu();
Widget XmCreateSimplePulldownMenu();
Widget XmCreateSimpleOptionMenu();
Widget XmCreateSimpleRadioBox();
Widget XmCreateSimpleCheckBox();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

Widget XmCreateSimpleMenuBar (Widget parent, String name, ArgList args, Cardinal arg_count);
Widget XmCreateSimplePopupMenu (Widget parent, String name, ArgList args, Cardinal arg_count);
Widget XmCreateSimplePulldownMenu (Widget parent, String name, ArgList args, Cardinal arg_count);
Widget XmCreateSimpleOptionMenu (Widget parent, String name, ArgList args, Cardinal arg_count);
Widget XmCreateSimpleRadioBox (Widget parent, String name, ArgList args, Cardinal arg_count);
Widget XmCreateSimpleCheckBox (Widget parent, String name, ArgList args, Cardinal arg_count);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#ifdef _NO_PROTO
extern Widget XmVaCreateSimpleMenuBar();
extern Widget XmVaCreateSimplePopupMenu();
extern Widget XmVaCreateSimplePulldownMenu();
extern Widget XmVaCreateSimpleOptionMenu();
extern Widget XmVaCreateSimpleRadioBox();
extern Widget XmVaCreateSimpleCheckBox();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern Widget XmVaCreateSimpleMenuBar (Widget parent, String name, ...);
extern Widget XmVaCreateSimplePopupMenu (Widget parent, String name,
                                  XtCallbackProc callback, ...);
extern Widget XmVaCreateSimplePulldownMenu (Widget parent, String name,
                                     int post_from_button,
                                     XtCallbackProc callback, ...);
extern Widget XmVaCreateSimpleOptionMenu (Widget parent, String name,
                                   XmString option_label,
                                   KeySym option_mnemonic,
                                   int button_set,
                                   XtCallbackProc callback, ...);
extern Widget XmVaCreateSimpleRadioBox (Widget parent, String name,
                                 int button_set, XtCallbackProc callback, ...);
extern Widget XmVaCreateSimpleCheckBox (Widget parent, String name,
                                 XtCallbackProc callback, ...);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

/***********************************************************************
 *
 * 	Misc Declarations
 * 
 ***********************************************************************/

#ifdef _NO_PROTO
typedef XtPointer	(*XmResourceBaseProc)();
#else /* _NO_PROTO */
#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
typedef XtPointer	(*XmResourceBaseProc)(
 	Widget  widget,
 	XtPointer client_data
     );
#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
#endif /* else _NO_PROTO */

typedef struct _XmSecondaryResourceDataRec{
    XmResourceBaseProc	base_proc;
    XtPointer		client_data;
    String		name;
    String		res_class;
    XtResourceList	resources;
    Cardinal		num_resources;
}XmSecondaryResourceDataRec, *XmSecondaryResourceData;

#ifdef _NO_PROTO
extern Cardinal XmGetSecondaryResourceData ();
extern Widget XmTrackingLocate ();
extern int XmConvertUnits ();
extern int XmCvtFromHorizontalPixels ();
extern int XmCvtFromVerticalPixels ();
extern int XmCvtToHorizontalPixels ();
extern int XmCvtToVerticalPixels ();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern Cardinal XmGetSecondaryResourceData (WidgetClass wclass,
                                    XmSecondaryResourceData **secondaryDataRtn);
extern Widget XmTrackingLocate (Widget widget, Cursor cursor, 
#if NeedWidePrototypes
    int confineTo
#else
    Boolean confineTo
#endif 
);
extern int XmConvertUnits (Widget widget, int dimension, int from_type, 
                            int from_val, int to_type);
extern int XmCvtFromHorizontalPixels (Screen * screen, int from_val, int to_type);
extern int XmCvtFromVerticalPixels (Screen * screen, int from_val, int to_type);
extern int XmCvtToHorizontalPixels (Screen * screen, int from_val, int from_type);
extern int XmCvtToVerticalPixels (Screen * screen, int from_val, int from_type);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif


#ifdef _NO_PROTO
extern XmString XmCvtCTToXmString();
extern char * XmCvtXmStringToCT();
extern Boolean XmCvtTextToXmString();
extern Boolean XmCvtXmStringToText();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern XmString XmCvtCTToXmString( char *text );
extern char * XmCvtXmStringToCT( XmString string );
extern Boolean XmCvtTextToXmString  ( Display *display , XrmValuePtr args , Cardinal *num_args , XrmValue *from_val , XrmValue *to_val , XtPointer *converter_data );
extern Boolean XmCvtXmStringToText  ( Display *display , XrmValuePtr args , Cardinal *num_args , XrmValue *from_val , XrmValue *to_val , XtPointer *converter_data );

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* _NO_PROTO */

typedef unsigned char   XmNavigationType;

#ifdef _NO_PROTO
extern void XmAddTabGroup ();
extern void XmRemoveTabGroup ();
extern Boolean XmProcessTraversal ();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern void XmAddTabGroup (Widget tabGroup);
extern void XmRemoveTabGroup (Widget w);
extern Boolean XmProcessTraversal (Widget w, int dir);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#ifdef _NO_PROTO
extern Boolean XmDestroyPixmap ();
extern Boolean XmUninstallImage ();
extern Boolean XmInstallImage ();
extern Pixmap XmGetPixmap ();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern Boolean XmUninstallImage (XImage *image);
extern Boolean XmDestroyPixmap (Screen *screen, Pixmap pixmap);
extern Boolean XmInstallImage (XImage *image, char *image_name);
extern Pixmap XmGetPixmap (Screen *screen, char *image_name, Pixel foreground, Pixel background);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#ifdef _NO_PROTO
extern Cursor XmGetMenuCursor ();
extern void XmSetMenuCursor ();     
extern Widget XmGetDestination ();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern Cursor XmGetMenuCursor (Display *display);
extern void XmSetMenuCursor (Display *display, Cursor cursorId);     
extern Widget XmGetDestination (Display *display);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

typedef long XmOffset;
typedef XmOffset *XmOffsetPtr;

#ifdef _NO_PROTO
extern void XmUpdateDisplay ();
extern void XmResolvePartOffsets ();
extern void XmResolveAllPartOffsets ();
#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern void XmUpdateDisplay (Widget w);
extern void XmResolvePartOffsets (WidgetClass wclass, XmOffsetPtr *offset);
extern void XmResolveAllPartOffsets (WidgetClass wclass, XmOffsetPtr *offset,
					XmOffsetPtr *constraint_offset);
#endif /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

/***********************************************************************

  The following workarounds have been suggested by licensees and have
  not been thoroughly tested. 

***********************************************************************/

#ifdef USE_NO_GETCWD
char *getcwd(buf,size)
char *buf;
int size;
{
extern char *malloc();
if (buf==(char*) NULL)
        buf=(char *) malloc (size);
return (char *)getwd(buf);
}
#endif

#ifdef NO_VFORK
#define vfork fork
#endif



#endif /* _Xm_h */
 /* DON'T ADD STUFF AFTER THIS #endif */
