/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  ext_ctos_types.h                                                         */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  03/28/91  121H.01  P. Johansson  /  Added code for get FHB old style.    */
/*  03/06/91  121G.00  W. Chiu       /  Merged in Peter Johansson's changes  */
/*                                   /  and added header.                    */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/

#define PARAGRAPH_SIZE 16u
#define LOG2_PARAGRAPH_SIZE 4u
#define PAGE_SIZE 512ul
#define LOG2_PAGE_SIZE 9u
#define SEGMENT_SIZE 65536ul
#define LOG2_SEGMENT_SIZE 16u
#define BITS_PER_SEGMENT 524288ul
#define LOG2_BITS_PER_SEGMENT 19u
#define PAGES_PER_SEGMENT ((unsigned) (SEGMENT_SIZE / PAGE_SIZE))

#define MAGIC 0x7C39			/* Old style volume */
#define MAGIC_PC 0x5043			/* Old style encrypted volume */
#define MAGIC_VM 0x8000			/* New VM bit masks for magic word */
#define MAGIC_LBA 0x4000		/* Logical Block Addressable device */
#define MAGIC_ENCRYPT 0x0002		/* Encrypted volume */

#define PASSWORD_ENCRYPTED 0x80		/* High-order bit of first character */

#if defined(dcb_type) || defined(All)
#undef dcb_type
typedef struct {
   flag fMountable;
   flag fNonSharable;
   union {
      flag fDoubleDensity;
      flag fRemovable;
   } shared_flag;
   flag fOnline;
   flag fAttention;
   byte bCacheCtrl;
   byte devName[13];
   byte devPassword[13];
   byte controllerNum;
   byte unitNum;
   byte state;
   enum {ready_status, inoperable_status, locked_status} unitStatus;
   enum {wd2010_class = 0, wd2797_class = 1, srp_smd_class = 2,
         ncr53C90_class = 4, nec765C_class = 5, ct_scsi_class = 6,
         memory_class = 8, cache_memory_class = 10} deviceClass;
   byte userCount;
   offset oVhb;
   offset oQueuedIob;
   offset oActiveIob;
   dword lfaMax;
   word chain;
   word verifyKey;
   byte romClass;
   byte romOrdinal;
   word pageSizeMask;
   word retryLimit;
   word softErrorCnt;
   word hardErrorCnt;
   byte deviceSpecific[34];
} dcb_type;

typedef struct {
   flag fMountable;
   flag fNonSharable;
   flag fDoubleDensity;
   flag fNoMultiTrack;
   flag fAttention;
   flag fTimeout;
   byte devName[13];
   byte devPassword[13];
   byte controllerNum;
   byte unitNum;
   byte state;
   byte unitStatus;
   byte deviceClass;
   byte userCount;
   offset oVhb;
   offset oIobFirst;
   offset oIobActive;
   dword lfaMax;
   word lfaMask;
   word verifyKey;
   byte reserved[4];
   word setRetryCnt;
   word softErrorCnt;
   word hardErrorCnt;
   word currentCylinder;
   byte sectorSizeCode;
   union {
      struct {
         word gapLength;
         byte dataLength;
      } workstation;
      struct {
         byte gapLength;
         byte writePrecompCyl;
         byte stepRate;
      } srp;
   } processor_specific_a;
   word bytesPerSector;
   word sectorsPerTrack;
   word tracksPerCylinder;
   word cylindersPerDisk;
   union {
      struct {
         flag fInhibitEcc;
         byte reserved[3];
      } workstation;
      struct {
         flag fEccFormat;
         byte spiralFactor;
         flag fOnline;
         flag fInhibitEcc;
      } srp;
   } processor_specific_b;
} old_dcb_type;
#endif

#if defined(disk_geometry_type) || defined(All)
#undef disk_geometry_type
typedef struct {
   word cylindersPerDisk;
   byte tracksPerCylinder;
   byte sectorsPerTrack;
   word bytesPerSector;
   flag fRemovable;
   flag fMountable;
   flag fUtilizeECC;
   flag fEccCapable;
   flag fWritePrecompensation;
   byte reserved;
   byte sbResourceMgr[13];
   byte rgResourceId[5];
   word writePrecompCyl;
   byte gapLength;
   byte stepRate;
   byte spiralFactor;
   byte interleave;
   dword blocksPerDisk;
} disk_geometry_type;
#endif

#if defined(iob_dma_type) || defined(All)
#undef iob_dma_type
typedef struct {
   unsigned chain;
   char ctrl_flags;
   char slot_id;
   void *requester;
   unsigned long bus_address_requester;
   void *target;
   unsigned long bus_address_target;
   unsigned xfer_length;
   unsigned data_segment;
   unsigned completion_exch;
   void *completion_msg;
} iob_dma_type;

#define REQUESTER_MAPPED 0x04		/* Bit assignments in 'ctrl_flags' */
#define TARGET_MAPPED 0x02
#define TARGET_WRITE 0x01
#endif

#define NO_DMA_FENCE 0
#define BYTE_DMA_FENCE 1
#define WORD_DMA_FENCE 2
#define MOVER_DMA_FENCE 3

#define MODE_EXCLUSIVE 0x6D78
#define MODE_PEEK 0x6D71
#define MODE_SHARE 0x6D73

#define NODE_PARSE_ERROR 0x0001
#define VOLUME_PARSE_ERROR 0x0002
#define DIRECTORY_PARSE_ERROR 0x0004
#define FILENAME_PARSE_ERROR 0x0008
#define PASSWORD_PARSE_ERROR 0x0010

#define ENLS_INSERT_LITERAL 0
#define ENLS_NEXT_PAGE 1
#define ENLS_PREV_PAGE 2
#define ENLS_SCROLL_UP 3
#define ENLS_SCROLL_DOWN 4
#define ENLS_CANCEL 0x07
#define ENLS_HELP 6
#define ENLS_FINISH 0x04
#define ENLS_MOVE 8
#define ENLS_DELETE 9
#define ENLS_OVERTYPE 10
#define ENLS_COPY 11
#define ENLS_F1 12
#define ENLS_F2 13
#define ENLS_F3 14
#define ENLS_F4 15
#define ENLS_F5 16
#define ENLS_F6 17
#define ENLS_F7 18
#define ENLS_F8 19
#define ENLS_F9 20
#define ENLS_F10 21
#define ENLS_TAB 22
#define ENLS_BACKSPACE 23
#define ENLS_RETURN 24
#define ENLS_MARK 25
#define ENLS_BOUND 26
#define ENLS_UP_ARROW 27
#define ENLS_DOWN_ARROW 28
#define ENLS_LEFT_ARROW 29
#define ENLS_RIGHT_ARROW 30
#define ENLS_GO 0x1B
#define ENLS_CODE_LEFT_ARROW 32
#define ENLS_CODE_RIGHT_ARROW 33
#define ENLS_CODE_GO 34
#define ENLS_SHIFT_DELETE 35
#define ENLS_SHIFT_GO 36
#define ENLS_SHIFT_LEFT_ARROW 37
#define ENLS_SHIFT_RIGHT_ARROW 38
#define ENLS_CODE_DELETE 39
#define ENLS_CODE_BACKSPACE 40
#define ENLS_CODE_UP_ARROW 41
#define ENLS_CODE_DOWN_ARROW 42
#define ENLS_CODE_F1 43
#define ENLS_CODE_F2 44
#define ENLS_CODE_F3 45
#define ENLS_CODE_F4 46
#define ENLS_CODE_F5 47
#define ENLS_CODE_F6 48
#define ENLS_CODE_F7 49
#define ENLS_CODE_F8 50
#define ENLS_CODE_F9 51
#define ENLS_CODE_F10 52
#define ENLS_CODE_MARK 53
#define ENLS_CODE_BOUND 54
#define ENLS_CODE_A 55
#define ENLS_CODE_Z 56
#define ENLS_NIL 0XFF
#define ENLS_KBD_DIRECT_MODE_0 0x00
#define ENLS_KBD_DIRECT_MODE_1 0x01
#define ENLS_KBD_DIRECT_MODE_2 0x02
#define ENLS_KBD_DIRECT_MODE_3 0x03
#define ENLS_KBD 0x80
#define ENLS_BSWA 0x81
#define ENLS_BUFFER 0x82

#define FILE_STATUS_LENGTH 0
#define FILE_STATUS_TYPE 1
#define FILE_STATUS_PROTECTION 2
#define FILE_STATUS_PASSWORD 3
#define FILE_STATUS_CREATION_DATE 4
#define FILE_STATUS_MODIFICATION_DATE 5
#define FILE_STATUS_EOF 6
#define FILE_STATUS_FHB_RESERVED 7
#define FILE_STATUS_VHB 8
#define FILE_STATUS_DCB 9
#define FILE_STATUS_APPLICATION_INFO 10
#define FILE_STATUS_NODE 11
#define FILE_STATUS_FHB 12

#if defined(scsi_info_type) || defined(All)
#undef scsi_info_type
typedef struct {
   char scsi_id;
   char lun;
   char device_type;
} scsi_info_type;
#endif

#define B27 8
#define FP 10
#define TP 11
#define CP 12
#define SP 13
#define DP 14
#define GP 20
#define GP_SI 21
#define GP_CI 22

#if defined(tpib_type) || defined(All)
#undef tpib_type
typedef struct {
   void *next;
   void *prev;
   void (*(interrupt_process))(void);
   unsigned data_segment;
   unsigned intervals;
   void *rq;
   unsigned footprint;
   unsigned delta;
   char reserved[8];
} tpib_type;
#endif

#if defined(vhb_type) || defined(All)
#undef vhb_type
typedef struct {
   word checksum;
   dword lfaSysImageBase;
   word cPagesSysImage;
   dword lfaBadBlkBase;
   word cPagesBadBlk;
   dword lfaCrashDumpBase;
   word cPagesCrashDump;
   byte volName[13];
   byte volPassword[13];
   dword lfaVhb;
   dword lfaInitialVhb;
   dword creationDT;
   dword modificationDT;
   dword lfaMfdBase;
   word cPagesMfd;
   dword lfaLogBase;
   word cPagesLog;
   word currentLogPage;
   word currentLogByte;
   dword lfaFileHeadersBase;
   word cPagesFileHeaders;
   word altFileHeaderPageOffset;
   word iFreeFileHeader;
   word cFreeFileHeaders;
   byte clusterFactor;
   byte bECC;
   word defaultExtend;
   word allocSkipCnt;
   dword lfaAllocBase;
   word allocPageCnt;
   word lastAllocPg;
   word lastAllocWd;
   word lastAllocBit;
   dword cFreePages;
   word iDev;
   offset oMfdFcb;
   byte seekStepRate;
   byte gapSize;
   byte writePrecompCylinder;
   byte devType;
   byte spiralFactor;
   byte startingSector;
   byte interleaveFactor;
   byte verifyCode;
   byte reserved2[95];
   word magicWd;
   byte bootBaseSector;
   byte bootBaseHead;
   word bootBaseCyl;
   word bootMaxPageCount;
   byte badBlkBaseSector;
   byte badBlkBaseHead;
   word badBlkBaseCyl;
   word badBlkMaxPageCount;
   byte crashDumpBaseSector;
   byte crashDumpBaseHead;
   word crashDumpBaseCyl;
   word crashDumpMaxPageCount;
   word bytesPerSector;
   word sectorsPerTrack;
   word tracksPerCylinder;
   word cylindersPerDisk;
   dword volumeCapacity;
   byte reserved3[5];
} vhb_type;
#endif

typedef struct {
   byte sbDirectory[13];
   byte sbPassword[13];
   dword lfaBase;
   word cPages;
   byte defaultAccessCode;
   word lruCnt;
} mfd_entry_type;

typedef struct {
   unsigned seconds;
   unsigned day_times_2;
} system_time_type;

typedef struct {
   unsigned year;
   char month;
   char day_of_month;
   char day_of_week;
   char hour;
   char minute;
   char second;
} exp_date_time_type;

#if defined(portStructureType) || defined(All)
#undef portStructureType
typedef struct {
   unsigned beeperPort;
   unsigned ioCommCtlA;
   unsigned ioCommDataA;
   unsigned ioCommCtlB;
   unsigned ioCommDataB;
   unsigned modeWord8253;
   unsigned baudRateCtrA;
   unsigned baudRateCtrB;
   unsigned OCW1_8259;
   unsigned OCW2_8269;
   unsigned cascadeOCW1_8259;
   unsigned cascadeOCW2_8269;
   unsigned extCtlReg;
   unsigned earPort;
   unsigned parityEnablePort;
   unsigned parityErrPort0;
   unsigned parityErrPort1;
   unsigned vidControl;
   unsigned vid6845Addr;
   unsigned vid6845Data;
   unsigned commDmaAddr;
   unsigned commDmaWrdCnt;
   unsigned commDmaEar;
   unsigned dmaMask;
   unsigned dmaMode;
   unsigned dmaCommand;
   unsigned dmaBytePtrClr;
   unsigned rdsrL;
   unsigned rdsrH;
   unsigned tdsrL;
   unsigned tdsrH;
   unsigned pcsarL;
   unsigned pcsarH;
   unsigned pcrL;
   unsigned pcrH;
   unsigned cPort;
   unsigned stat;
   unsigned timerCtl;
   unsigned timerComm;
   unsigned clearRtcIntPort;
   unsigned xIntR3Vector;
   unsigned processorType;
   unsigned dmaEarEnable;
   unsigned timeClockBaseAddr;
   unsigned nonvolatileRamBaseAddr;
   unsigned protectedModeEnable;
   unsigned fingerPort;
   unsigned shCpuSpeed;
   unsigned videoType;
   unsigned rs232DmaAddr0;
   unsigned rs232DmaWrdCnt0;
   unsigned rs232DmaAddr1;
   unsigned rs232DmaWrdCnt1;
   unsigned rs232DmaAddr2;
   unsigned rs232DmaWrdCnt2;
   unsigned rs232DmaAddr3;
   unsigned rs232DmaWrdCnt3;
   unsigned rs232DmaCommand;
   unsigned rs232DmaRequest;
   unsigned rs232DmaMask;
   unsigned rs232DmaMode;
   unsigned rs232DmaBytePtrClr;
   unsigned rs232DmaMstrClr;
   unsigned rs232DmaMaskAll;
   unsigned rs232DmaEar0;
   unsigned rs232DmaEar1;
   unsigned rs232DmaEar2;
   unsigned rs232DmaEar3;
   unsigned rs232DmaEarEnable;
   unsigned ledDisplayPort;
} portStructureType;
#endif
