;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpMsgMZ.asm                                                         *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Editor message text.                                                      *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/05/90 120F/02 T. Ball      / Changed undelete to retrive               *;
;* 12/13/89 120F/01 T. Ball      / Added cmrFileTooLarge                     *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpMsgAL.asm

$include(WpMsg.mdf)

DGroup group Const
assume ds: DGroup


;-----------------------------------------------
; ************** CMR DEFINITIONS **************
; NOTE: These are now alphabetized by cmr name.
;       Please keep them that way.  Thank you.
;-----------------------------------------------


%DefineCmr(AccessDenied, 1, true, true, false,
~File | is protected: Access denied~, ~<> <1>~)%'

%DefineCmr(BadDirSpec, 1, true, true, false,
~ is not a valid directory name~, ~<1>~)%'

%DefineCmr(BadFileSpec, 1, true, true, false,
~ is not a valid file name~, ~<1>~)%'

%DefineCmr(BadHexNumber, 1, true, true, false,
~Invalid hexadecimal digit in code~, ~~)%'

%DefineCmr(BadNumber, 1, true, true, false,
~Value must be a number less than 65535~, ~~)%'

%DefineCmr(BadPswd, 1, true, true, false,
~Bad password~, ~~)%'

%DefineCmr(BadWcMatch, 1, true, true, false,
~ has a mismatched wildcard~, ~<1>~)%'

%DefineCmr(BadWildCard, 1, true, true, false,
~Wildcard expression too complicated~, ~~)%'

%DefineCmr(BlkCmtErr, 1, true, true, false,
~Ending comment delimiter missing~, ~~)%'

%DefineCmr(BlkEndCmtErr, 1, true, true, false,
~Beginning comment delimiter missing~, ~~)%'

%DefineCmr(BlkEndErr, 1, true, true, false,
~Block start delimiter missing~, ~~)%'

%DefineCmr(BlkOk, 1, true, false, false,
~No block errors detected~, ~~)%'

%DefineCmr(BlkStartErr, 1, true, true, false,
~Block end delimiter missing~, ~~)%'

%DefineCmr(Canceled, 1, true, true, false,
~Command canceled~, ~~)%'

%DefineCmr(CantCopyBkg, 1, true, true, false, 
~Cannot move or copy to background file~, ~~)%'

%DefineCmr(CantCreate, 1, true, true, false,
~Unable to create file ~, ~~)%'

%DefineCmr(CantCreateEnd, 1, true, true, false,
~ ~, ~~)%'

%DefineCmr(CantDivide, 1, true, true, false,
~Cannot divide when in full-screen mode~, ~~)%'

%DefineCmr(CantEditThere, 1, true, true, false,
~Cannot edit there~, ~~)%'

%DefineCmr(CantOpen, 1, true, true, false,
~Unable to open file ~, ~~)%'

%DefineCmr(CantOpenEnd, 1, true, true, false,
~ ~, ~~)%'

%DefineCmr(CantSearch, 1, true, true, false,
~Cannot search there~, ~~)%'

%DefineCmr(CantSelect, 1, true, true, false,
~Cannot select there~, ~~)%'

%DefineCmr(Checking, 1, true, false, false,
~Checking ...~, ~~)%'

%DefineCmr(ChooseAWindow, 1, true, true, false,
~Cursor must be in a window~, ~~)%'

%DefineCmr(ColorNotSupported, 1, true, true, false,
~Color is not supported on this workstation~, ~~)%'

%DefineCmr(ConfirmContinue,2, true, true, false,
~Cannot open |, status code = |.
Press GO to continue search, CANCEL to cancel command~, ~<> <1> <2>~)%'

%DefineCmr(ConfirmDiscard, 1, true, true, false,
~Press GO to confirm DISCARD, CANCEL to cancel command~, ~~)%'

%DefineCmr(ConfirmFinish, 1, true, true, false,
~Press GO to confirm FINISH, CANCEL to cancel command~, ~~)%'

%DefineCmr(ConfirmNewDoc, 1, true, true, false,
~Press GO to create file |, CANCEL to cancel command~, ~<> <1>~)%'

%DefineCmr(ConfirmNoReplay, 3, true, false, true,
~Starting a new session will destroy your unrecovered work.
Are you sure this is what you want to do?
Press GO to proceed with new session, CANCEL to exit Editor.~, ~~)%'

%DefineCmr(ConfirmOverwrite, 2, true, true, false,
~File | already exists.  Overwrite?
Press GO to confirm, CANCEL to cancel command~, ~<> <1>~)%'

%DefineCmr(ConfirmReadOnly, 2, true, true, false,
~File | cannot be changed.
Press GO to proceed, CANCEL to cancel command.~, ~<> <1>~)%'

%DefineCmr(ConfirmRemove, 1, true, true, false,
~Press GO to confirm REMOVE FORMAT, CANCEL to cancel command~, ~~)%'

%DefineCmr(ConfirmReplay, 2, true, false, true,
~Your last session did not FINISH successfully.
Press GO to recover, CANCEL to start a new session.~, ~~)%'

%DefineCmr(ConfirmSubst, 1, true, true, false,
~Press GO to replace, NEXT to skip item, CANCEL to cancel command~, ~~)%'

%DefineCmr(ConfirmTsBad, 2, true, false, true,
~Cannot recover; typescript not valid or different version.
Press GO to exit, CANCEL to proceed with new session.~, ~~)%'

%DefineCmr(ConfirmUnDelete, 2, true, true, false,
~File | has been deleted.
Press GO to retrieve the file, CANCEL to cancel command.~, ~<> <1>~)%'

%DefineCmr(ConfirmWritable, 2, true, true, false,
~File | is read only.
Press GO to make the file WRITABLE, CANCEL to cancel command.~, ~<> <1>~)%'

%DefineCmr(CopyFromInvalid, 1, true, true, false,
~Please specify "Allow changes: Yes"~, ~~)%'

%DefineCmr(Copying, 1, true, false, false,
~Copying ...~, ~~)%'

%DefineCmr(Deleting, 1, true, false, false,
~Deleting ...~, ~~)%'

%DefineCmr(DirAccessDenied, 1, true, true, false,
~Directory | is protected: Access denied~, ~<> <1>~)%'

%DefineCmr(DirFull, 1, true, true, false,
~Directory | is full~, ~<> <1>~)%'

%DefineCmr(DiskFull, 1, true, true, false,
~Disk | is full~, ~<> <1>~)%'

%DefineCmr(DisplayChCount, 1, true, false, false,
~Number of characters:  | ~, ~<> <1>~)%'

%DefineCmr(DisplayCurLine, 1, true, false, false,
~Current line number: |, column: | ~, ~<> <1> <2>~)%'

%DefineCmr(DocAlreadyOpen, 1, true, true, false,
~File | is already open~, ~<> <1>~)%'

%DefineCmr(DocNotEdited, 1, true, true, false,
~That file has not been changed~, ~~)%'

%DefineCmr(Expanding, 1, true, false, false,
~Expanding file list ...~, ~~)%'

%DefineCmr(FatalDirFull, 3, true, false, true,
~Your directory is full.
Please delete or rename unneeded files before Recovering.
Press any key to exit Editor.~, ~~)%'

%DefineCmr(FatalDiskFull, 3, true, false, true,
~Your disk is full.
Please delete unneeded files before Recovering.
Press any key to exit Editor.~, ~~)%'

%DefineCmr(FatalError, 3, true, false, true,
~A software error has occurred; status code = |.
Please report the error to your system administrator before Recovering.
Press any key to exit Editor.~, ~<> <1>~)%'

%DefineCmr(FileAlreadyExists, 1, true, true, false,
~There is already a file named | ~, ~<> <1>~)%'

%DefineCmr(FileError, 1, true, true, false,
~Unable to complete command; status code = | ~, ~<> <1>~)%'

%DefineCmr(FileInUse, 1, true, true, false,
~File | is in use~, ~<> <1>~)%'

%DefineCmr(FileTooLarge, 1, true, true, false,
~File | is too large~, ~<> <1>~)%'

%DefineCmr(GoNotLegal, 1, true, true, false,
~GO not valid~, ~~)%'

%DefineCmr(HeapFailure, 1, true, true, true,
~Memory low; please Save~, ~~)%'

%DefineCmr(InvalidTabLength, 1, true, true, false,
~Tab length must be between 3 and 80~, ~~)%'

%DefineCmr(LiteralPrompt, 1, true, true, false,
~Next key typed will be inserted literally~, ~~)%'


end
