/*
	Copyright 1987-1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in an
	XVT user's application.
*/

#include "xvt.h"					/* standard XVT header */
#include "xvtmenu.h"				/* standard XVT menu tags */

#ifdef PROTO
STATICFCN void showdir(void);
STATICFCN void chg_dir_s(char *);
STATICFCN void do_menu(MENU_TAG, BOOLEAN, BOOLEAN);
#else
STATICFCN void showdir();
STATICFCN void chg_dir_s();
STATICFCN void do_menu();
#endif

/* Required application setup structure. */
APPL_SETUP appl_setup = {
	0,								/* menu bar resource ID (use default) */
	0,								/* about box resource ID (use default) */
	"dir",						/* application's name */
	W_NONE,							/* type of initial window */
	FALSE,							/* size box on initial window? */
	FALSE,							/* vert. scroll bar on initial window? */
	FALSE,							/* horz. scroll bar on initial window? */
	FALSE,							/* close box on initial window? */
	FALSE,							/* want std. font menu? (includes sizes) */
	FALSE							/* want std. style menu? */
};

/* Function to show the current directory. */
#ifdef FPROTO
static void showdir(void)
#else
static void showdir()
#endif
{
	DIRECTORY d;
	char path[100];

	if (!get_dir(&d))
		error("Can't get current directory.");
	else if (!dir_to_str(&d, path, sizeof(path)))
		error("Can't show current directory.");
	else
		note("Current directory is %s", path);
}

/* Function to change the current directory using a string path. */
#ifdef FPROTO
static void chg_dir_s(char *path)
#else
static void chg_dir_s(path)
char *path;
#endif
{
	DIRECTORY d;

	if (!str_to_dir(path, &d) || !chg_dir(&d))
		error("Can't change directory using string \"%s\".", path);
}

/* Function to handle all menu commands. */
#ifdef FPROTO
static void do_menu(MENU_TAG cmd, BOOLEAN shift, BOOLEAN control)
#else
static void do_menu(cmd, shift, control)
MENU_TAG cmd;						/* menu tag */
BOOLEAN shift;						/* was shift key down? */
BOOLEAN control;					/* was control key down? */
#endif
{
	FILE_SPEC fs;
	static char s[256];

	NOREF(shift);
	NOREF(control);
	switch (cmd) {
	case M_FILE_OPEN:
		showdir();
		save_dir();
		if (get_str_response("What directory should be changed to?", s,
		  sizeof(s)) == NULL)
			break;
		chg_dir_s(s);
		showdir();
		if (!str_to_dir(s, &fs.dir))
			error("Can't convert \"%s\" to DIRECTORY.", s);
		fs.type[0] = '\0';
		strcpy(fs.name,"*");
		if (open_file_dlg(&fs, "Type a name...") != FL_OK)
			break;
		showdir();
		if (!dir_to_str(&fs.dir, s, sizeof(s))) /* save for next time */
			error("Can't convert DIRECTORY to string.");
		restore_dir();
		showdir();
		break;
	case M_FILE_SAVE:
		save_dir();
		showdir();
		strcpy(fs.type, "JNK");
		strcpy(fs.name, "Proposed Name");
		if (get_str_response("At what directory should save dialog start?", s,
		  sizeof(s)) == NULL)
			break;
		if (!str_to_dir(s, &fs.dir))
			error("Can't convert \"%s\" to DIRECTORY.", s);
		if (save_file_dlg(&fs, "Type a name...") != FL_OK)
			break;
		showdir();
		if (!dir_to_str(&fs.dir, s, sizeof(s))) /* save for next time */
			error("Can't convert DIRECTORY to string.");
		restore_dir();
		showdir();
		break;
	case M_FILE_QUIT:
		terminate();
		break;
	}
}

/*
	Application initialization.  Set font menu and record the existence of
	XVT's initial window, created from the appl_setup structure (std_win).
*/
BOOLEAN XVTENTRY appl_init()
{
	menu_enable(M_FILE_OPEN, TRUE);
	menu_enable(M_FILE_SAVE, TRUE);
	return(TRUE);
}

/* Main application entry point. */
void XVTENTRY main_event(win, ep)
WINDOW win;							/* window */
EVENT *ep;							/* event */
{
	extern BOOLEAN set_loc_OK;

	NOREF(win);
	switch (ep->type) {
	case E_COMMAND:
		do_menu(ep->v.cmd.tag, ep->v.cmd.shift, ep->v.cmd.control);
		break;
	case E_CLOSE:
		terminate();
		break;
	case E_QUIT:
		if (ep->v.query)
			quit_OK();
		else
			terminate();
	}
}

/* Application cleanup.  Nothing to do. */
void XVTENTRY appl_cleanup()
{
}
