#include "xvt.h"					/* standard XVT header */
#if (XVTCC == MWCCC) && (XVTOS == CTOOS)
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);
#endif

#include "xvtmenu.h"				/* standard XVT menu tags */
#include "demo.h"

#define TMP_STR_LEN 132

APPL_SETUP appl_setup = {
	0,								/* menu bar resource ID (use default) */
	0,								/* about box resource ID (use default) */
	"Demo",							/* application's name */
	W_DOC,
	TRUE,							/* size box on initial window? */
	FALSE,							/* vert. scroll bar on initial window? */
	FALSE,							/* horz. scroll bar on initial window? */
	FALSE,							/* close box on initial window? */
	FALSE,							/* want std. font menu? (includes sizes) */
	FALSE							/* want std. style menu? */
};

/* instructions stuff */
static int page_number = 1;
static WINDOW page1_window = NULL_WIN;
static WINDOW page2_window = NULL_WIN;
static WINDOW page3_window = NULL_WIN;
static WINDOW page4_window = NULL_WIN;
static WINDOW page5_window = NULL_WIN;
#define PAGE1_CONTROL 11
#define PAGE2_CONTROL 12
#define PAGE3_CONTROL 13
#define PAGE4_CONTROL 14
#define PAGE5_CONTROL 15

/* windows stuff */
#define MAX_WINDOWS 12
static WINDOW windows[MAX_WINDOWS];
typedef struct {
	int h_scroll;
	int v_scroll;
} WINDOW_INFO;
static RCT std_win_rect;

/* data entry dialog box stuff */
static WINDOW data_entry_window = NULL_WIN;

/* options dialog box stuff */
static WINDOW options_window = NULL_WIN;
static int which_state = OPT_COLORADO;
static BOOLEAN opt_skiing = FALSE;
static BOOLEAN opt_hiking = FALSE;
static BOOLEAN opt_biking = FALSE;
static char opt_favorite[TMP_STR_LEN] = "";

/* list box dialog box stuff */
static WINDOW list_box_window = NULL_WIN;

static char *page1[] = {
	"ABOUT XVT SOFTWARE, INC.",
	"",
	"XVT allows programmers to write programs in C with graphical user",
	"interfaces portably.",
	"",
	"Published by:",
	"XVT Software, Inc.",
	"P.O. 17665",
	"1800 30th Street, Suite 204",
	"Boulder, CO 80308 USA",
	"(303)443-4223",
	"(303)443-0969 (Fax)",
	NULL
};

static char *page2[] = {
	"XVT PLATFORMS",
	"",
	"XVT is available for:",
	"- The Macintosh (XVT/Mac)",
	"- Microsoft Windows (XVT/Win)",
	"- Presentation Manager on OS/2 (XVT/PM)",
	"- X Windows and Motif on Unix (XVT/XM)",
	"- Character based displays on DOS, OS/2, and Unix (XVT/CH)",
	"",
	"All implementations of XVT are written in C, and C is the principle",
	"language used for development of XVT applications.",
	NULL
};

static char *page3[] = {
	"MORE INFORMATION",
	"",
	"Please contact us if you would like further information. The",
	"following are available:",
	"- XVT: A Virtual Tookit for Portability Between Window Systems",
	"- A Unified Programming Interface for Character-Based and",
	"  Graphical Window Systems",
	"- XVT++ Information: a C++ interface to XVT",
	"- Functional Comparison between XVT and Commonview",
	"- A reprint of a review of XVT that was published in the March,",
	"  1989 Issue of Byte Magazine",
	"",
	"In addition, you can buy the XVT Programmer's Manual for $35.00.",
	NULL
};

static char *page4[] = {
	"HOW TO USE THE PULLDOWN MENUS",
	"",
	"If you are running the XVT/Win, XVT/Mac, or XVT/PM version of this",
	"program, you probably know how to operate the pulldown menus.",
	"",
	"If you are running the XVT/CH version of this program:",
	"  You can operate the menus with the mouse. They operate in a fashion",
	"  similar to the Macintosh, or Microsoft Windows.",
	"",
	"  To access the menus with the keyboard, press the menu key (F10) and",
	"  use the arrow keys to move the highlight to the desired command.",
	"  Then press the return key.",
	NULL
};

static char *page5[] = {
	"HOW TO USE THE HELP SYSTEM",
	"",
	"- Select 'About' from the File menu.",
	"- Press the Return key (which presses the Help button).",
	"- Double click on the topic.",
	"- Operate the help text scroll bar with the mouse.",
	"       - or -",
	"- Select 'About' from the File menu.",
	"- Press the Return key (which presses the Help button).",
	"- Tab to the list box and move to the desired topic.",
	"- Press the Return key.",
	"- Tab to the help text and press the Page Down key.",
	NULL
};

#ifdef PROTO
STATICFCN void config_menu(void);
STATICFCN BOOLEAN no_windows(void);
STATICFCN void close_all_windows(void);
STATICFCN void show_buttons(BOOLEAN);
STATICFCN void print_page(int);
STATICFCN void do_update(WINDOW win);
STATICFCN void main_event_ST_INSTRUCTIONS(WINDOW win, EVENT *ep);
STATICFCN BOOLEAN build_window(void);
STATICFCN void windows_init(void);
STATICFCN void data_entry_init(void);
STATICFCN BOOLEAN XVTENTRY cb_data_entry BTCENTRY(int cid, CONTROL_INFO *cip);
STATICFCN BOOLEAN XVTENTRY cb_options BTCENTRY(int cid, CONTROL_INFO *cip);
STATICFCN void options_init(void);
STATICFCN BOOLEAN XVTENTRY cb_lbexer BTCENTRY(int, CONTROL_INFO *);
STATICFCN void lbexer_dialog(void);
STATICFCN int cvt_index(void);
#else
static void config_menu();
static BOOLEAN no_windows();
static void close_all_windows();
static void show_buttons();
static void print_page();
static void do_update();
static void main_event_ST_INSTRUCTIONS();
static BOOLEAN build_window(void);
static void windows_init();
static void data_entry_init();
static BOOLEAN XVTENTRY cb_data_entry BTCENTRY();
static BOOLEAN XVTENTRY cb_options BTCENTRY();
static void options_init();
static BOOLEAN XVTENTRY cb_lbexer BTCENTRY();
static void lbexer_dialog();
static int cvt_index();
#endif

#ifdef FPROTO
static void config_menu(void)
#else
static void config_menu()
#endif
{
	int i;

	menu_enable(M_DEMO_WINDOWS, TRUE);
	menu_enable(M_DEMO_DATA_ENTRY, data_entry_window == NULL_WIN);
	menu_enable(M_DEMO_BUTTONS, options_window == NULL_WIN);
	menu_enable(M_DEMO_LIST_BOXES, list_box_window == NULL_WIN);
	menu_enable(M_DEMO_CLOSE_ALL, ! no_windows());
	menu_enable(M_FILE_NEW, TRUE);
	menu_enable(M_FILE_CLOSE, FALSE);
	for (i = 0; i < MAX_WINDOWS; ++i)
		if (windows[i] != NULL_WIN) {
			menu_enable(M_FILE_CLOSE, TRUE);
			break;
		}
}

#ifdef FPROTO
static void show_buttons(BOOLEAN show)
#else
static void show_buttons(show)
BOOLEAN show;
#endif
{
	if (show)
		move_window(std_win, &std_win_rect);
	show_window(page1_window, show);
	show_window(page2_window, show);
	show_window(page3_window, show);
	show_window(page4_window, show);
	show_window(page5_window, show);
}

#ifdef FPROTO
static BOOLEAN no_windows(void)
#else
static BOOLEAN no_windows()
#endif
{
	int i;

	if (data_entry_window != NULL_WIN)
		return (FALSE);
	if (options_window != NULL_WIN)
		return (FALSE);
	if (list_box_window != NULL_WIN)
		return (FALSE);
	for (i = 0; i < MAX_WINDOWS; ++i)
		if (windows[i] != NULL_WIN)
			return (FALSE);
	return (TRUE);
}

#ifdef FPROTO
static void close_all_windows(void)
#else
static void close_all_windows()
#endif
{
	int i;
	void *p;

	if (data_entry_window != NULL_WIN) {
		close_window(data_entry_window);
		data_entry_window = NULL_WIN;
	}
	if (options_window != NULL_WIN) {
		close_window(options_window);
		options_window = NULL_WIN;
	}
	if (list_box_window != NULL_WIN) {
		close_window(list_box_window);
		list_box_window = NULL_WIN;
	}
	for (i = 0; i < MAX_WINDOWS; ++i)
		if (windows[i] != NULL_WIN) {
			p = (void *)get_app_data(windows[i]);
			xvt_free(p);
			close_window(windows[i]);
			windows[i] = NULL_WIN;
		}
}

#ifdef FPROTO
static void print_page(int pn)
#else
static void print_page(pn)
int pn;
#endif
{
	RCT rct;
	int l, a, d, line, top;
	char *s, **info;
	
	get_client_rect(std_win, &rct);
	set_cbrush(&white_cbrush);
	set_cpen(&hollow_cpen);
	draw_rect(&rct);
	get_font_metrics(&l, &a, &d);
	switch (pn) {
	case 1:
		info = page1;
		break;
	case 2:
		info = page2;
		break;
	case 3:
		info = page3;
		break;
	case 4:
		info = page4;
		break;
	case 5:
		info = page5;
		break;
	default:
		fatal("print_page: invalid page number");
	}
	line = 0;
	while (TRUE) {
		if (*info == NULL)
			break;
		draw_text(8, (line + 2) * (l + a + d), *info, -1);
		++line;
		++info;
	}
	top = 15.5 * (l + a + d);
	s = "Click a button with the mouse, or press 1-5.";
	draw_text(8, top, s, -1);
}

#ifdef FPROTO
static void do_update(WINDOW win)
#else
static void do_update(win)
WINDOW win;
#endif
{
	RCT rct;

	if (no_windows()) {
		if (win == std_win)
			print_page(page_number);
	} else {
		get_client_rect(win, &rct);
		set_cpen(&hollow_cpen);
		set_cbrush(&white_cbrush);
		draw_rect(&rct);
		if (std_win == get_front_window()) {
			draw_text(8, 16, "Standard window has been brought to the top.",
			  -1);
			draw_text(8, 24, "Resize, and bring other windows to the top.",
			  -1);
			draw_text(8, 32, "    - or -", -1);
			draw_text(8, 40, "Press the F6 key to force the standard window",
			  -1);
			draw_text(8, 48, "to the back.", -1);
			caret_off(std_win);
		}
	}
}

BOOLEAN XVTENTRY appl_init BTCENTRY()
{
	RCT r;
	int left, top, right, bottom, l, a, d, w;
	
	get_client_rect(std_win, &std_win_rect);
	get_font_metrics(&l, &a, &d);
	w = text_width("(1) XVT Software, Inc. ");
	w = max(w, text_width("(2) Platforms  "));
	w = max(w, text_width("(3) More Information   "));
	w = max(w, text_width("(4) Pulldown Menus  "));
	w = max(w, text_width("(5) Help System  "));
	left = 8;
	top = 16 * (l + a + d);
	right = left + w + 8;
	bottom = 19 * (l + a + d);
	set_rect(&r, left, top, right, bottom);
	page1_window = new_control(&r, "(1) XVT Software, Inc.", WC_PUSHBUTTON,
	  std_win, TRUE, PAGE1_CONTROL, NULL);
	left = w + 24;
	top = 16 * (l + a + d);
	right = left + w + 8;
	bottom = 19 * (l + a + d);
	set_rect(&r, left, top, right, bottom);
	page2_window = new_control(&r, "(2) Platforms", WC_PUSHBUTTON,
	  std_win, TRUE, PAGE2_CONTROL, NULL);
	left = w * 2 + 40;
	top = 16 * (l + a + d);
	right = left + w + 8;
	bottom = 19 * (l + a + d);
	set_rect(&r, left, top, right, bottom);
	page3_window = new_control(&r, "(3) More Information", WC_PUSHBUTTON,
	  std_win, TRUE, PAGE3_CONTROL, NULL);
	left = 8;
	top = 19 * (l + a + d);
	right = left + w + 8;
	bottom = 22 * (l + a + d);
	set_rect(&r, left, top, right, bottom);
	page4_window = new_control(&r, "(4) Pulldown Menus", WC_PUSHBUTTON,
	  std_win, TRUE, PAGE4_CONTROL, NULL);
	left = w + 24;
	top = 19 * (l + a + d);
	right = left + w + 8;
	bottom = 22 * (l + a + d);
	set_rect(&r, left, top, right, bottom);
	page5_window = new_control(&r, "(5) Help System", WC_PUSHBUTTON,
	  std_win, TRUE, PAGE5_CONTROL, NULL);
	config_menu();
	return(TRUE);
}

#ifdef FPROTO
static BOOLEAN build_window(void)
#else
static BOOLEAN build_window()
#endif
{
	RCT rct;
	char s[TMP_STR_LEN];
	WINDOW_INFO *wi;
	int i;

	for (i = 0; i < MAX_WINDOWS; ++i)
		if (windows[i] == NULL_WIN)
			break;
	if (i == MAX_WINDOWS) {
		error("Too many windows");
		return (FALSE);
	}
	sprintf(s, "Window #%d", i + 1);
	set_rect(&rct, i * 8 + 16, i * 8 + 40, (i + 28) * 8 + 16,
	  (i + 10) * 8 + 40);
	windows[i] = new_window(&rct, s, W_DOC, TRUE, TRUE, TRUE,
	  TRUE);
	if ((wi = (WINDOW_INFO *)xvt_malloc(sizeof(WINDOW_INFO))) == NULL)
		fatal("Out of memory");
	wi->h_scroll = 0;
	wi->v_scroll = 0;
	set_app_data(windows[i], (long)wi);
	set_scroll_range(windows[i], HSCROLL, 0, 100);
	set_scroll_range(windows[i], VSCROLL, 0, 100);
	set_scroll_pos(windows[i], HSCROLL, 0);
	set_scroll_pos(windows[i], VSCROLL, 0);
	return (TRUE);
}

#ifdef FPROTO
static void windows_init(void)
#else
static void windows_init()
#endif
{
	int i;
	
	for (i = 1; i <= 3; ++i)
		if (! build_window())
			return;
}

#ifdef FPROTO
static BOOLEAN XVTENTRY cb_data_entry BTCENTRY(int cid, CONTROL_INFO *cip)
#else
static BOOLEAN XVTENTRY cb_data_entry BTCENTRY(cid, cip)
int cid;
CONTROL_INFO *cip;
#endif
{
	char s[TMP_STR_LEN], s2[TMP_STR_LEN];
	int len, i, j;
	BOOLEAN have_decimal;
	int to_right_cnt;
	
	switch (cid) {
	case DLG_INIT:
		data_entry_window = cip->win;
		break;
	case DE_VENDOR:
	case DE_INVOICE:
	case DE_GL:
	case DE_DEPT:
		get_item_text(cid, s);
		len = strlen(s);
		for (i = 0; i < len; ++i) {
			if (s[i] >= '0' && s[i] <= '9')
				continue;
			for (j = 0; j < i; ++j)
				s2[j] = s[j];
			for (j = i + 1; j < len; ++j)
				s2[j - 1] = s[j];
			s2[j - 1] = '\0';
			set_item_text(cid, s2);
			select_item_text(cid, i, i);
		}
		break;
	case DE_AMOUNT:
		have_decimal = FALSE;
		to_right_cnt = 0;
		get_item_text(DE_AMOUNT, s);
		len = strlen(s);
		for (i = 0; i < len; ++i) {
			if (s[i] == '.') {
				if (! have_decimal) {
					have_decimal = TRUE;
					continue;
				}
			} else {
				if (s[i] >= '0' && s[i] <= '9') {
					if (have_decimal)
						++to_right_cnt;
					if (have_decimal && to_right_cnt <= 2)
						continue;
					if (! have_decimal)
						continue;
				}
			}
			for (j = 0; j < i; ++j)
				s2[j] = s[j];
			for (j = i + 1; j < len; ++j)
				s2[j - 1] = s[j];
			s2[j - 1] = '\0';
			set_item_text(DE_AMOUNT, s2);
			select_item_text(DE_AMOUNT, i, i);
		}
		break;
	case DLG_CANCEL:
		note("You canceled");
	case DLG_CLOSE:
	case DLG_OK:
		data_entry_window = NULL_WIN;
		invalidate_rect(std_win, NULL);
		show_buttons(no_windows());
		config_menu();
		return (FALSE);
	}
	return (TRUE);
}

#ifdef FPROTO
static void data_entry_init(void)
#else
static void data_entry_init()
#endif
{
	if (! new_dialog(WD_MODELESS, DE_DIALOG, cb_data_entry, 0L))
		fatal("Can't put up dialog box");
}

#ifdef FPROTO
static BOOLEAN XVTENTRY cb_options BTCENTRY(int cid, CONTROL_INFO *cip)
#else
static BOOLEAN XVTENTRY cb_options BTCENTRY(cid, cip)
int cid;
CONTROL_INFO *cip;
#endif
{
	switch (cid) {
	case DLG_INIT:
		options_window = cip->win;
		break;
	case DLG_CANCEL:
		note("You canceled");
	case DLG_CLOSE:
	case DLG_OK:
		options_window = NULL_WIN;
		invalidate_rect(std_win, NULL);
		show_buttons(no_windows());
		config_menu();
		return (FALSE);
	case OPT_COLORADO:
	case OPT_CALIFORNIA:
	case OPT_NEW_JERSEY:
		which_state = cid;
		break;
	case OPT_SKIING:
		opt_skiing = ! opt_skiing;
		break;
	case OPT_HIKING:
		opt_hiking = ! opt_hiking;
		break;
	case OPT_BIKING:
		opt_biking = ! opt_biking;
		break;
	}
	check_radio_button(which_state, OPT_COLORADO, OPT_CALIFORNIA);
	check_box(OPT_SKIING, opt_skiing);
	check_box(OPT_HIKING, opt_hiking);
	check_box(OPT_BIKING, opt_biking);
	if (! opt_skiing)
		set_item_text(OPT_FAVORITE, "");
	return (TRUE);
}

#ifdef FPROTO
static void options_init(void)
#else
static void options_init()
#endif
{
	if (! new_dialog(WD_MODELESS, OPT_DIALOG, cb_options, 0L))
		fatal("Can't put up dialog box");
}

/* Convert to convert numeric edit field (list box index) to integer. */
#ifdef FPROTO
static int cvt_index(void)
#else
static int cvt_index()
#endif
{
	char buf[100];
	register int i;

	if (get_item_text(LBEXER_INDEX_TEXT, buf)[0] == '\0')
		i = -1;
	else {
		for (i = 0; buf[i] != '\0'; i++)
			if (!isdigit(buf[i])) {
				i = -1;
				break;
			}
		if (i != -1) {
			i = atoi(buf);
			if (i < 0 || i >= lbox_count_all(LBEXER_BOX1))
				i = -1;
		}
	}
	if (i == -1)
		select_item_text(LBEXER_INDEX_TEXT, 0, SHRT_MAX);
	return(i);
}

/* Callback function for list box exerciser. */
#ifdef FPROTO
static BOOLEAN XVTENTRY cb_lbexer BTCENTRY(int control_id, CONTROL_INFO *cip)
#else
static BOOLEAN XVTENTRY cb_lbexer BTCENTRY(control_id, cip)
int control_id;						/* ID of control that got activated */
CONTROL_INFO *cip;					/* pointer to control info */
#endif
{
	SLIST x;
	SLIST_ELT e;
	char buf[100];
	int i, adjust, count;
	long index;
	struct s_state {
		int contents;
		int source;
		int index;
		char str[100];
		int count;
	} *state = (struct s_state *)get_app_data(cip->win);

	switch (control_id) {
	case DLG_INIT:
		list_box_window = cip->win;
		if ((state = (struct s_state *)
		  xvt_malloc(sizeof(struct s_state))) == NULL) {
			error("Not enough memory.");
			return(FALSE);
		}
		set_app_data(cip->win, PTR_LONG(state));
		state->contents = LBEXER_FACES;
		state->source = LBEXER_ALL;
		state->count = -1;
		state->index = 0;
		state->str[0] = '\0';
		break;
	case DLG_CLOSE:
		xvt_free((char *)state);
		invalidate_rect(std_win, NULL);
		list_box_window = NULL_WIN;
		config_menu();
		show_buttons(no_windows());
		return (FALSE);
	case LBEXER_ADD:
		get_item_text(LBEXER_ADD_TEXT, buf);
		if ((count = lbox_count_all(LBEXER_BOX1)) == 0)
			i = -1;
		else
			i = 0;
		if (i != -1 && lbox_count_sel(LBEXER_BOX1) != 1)
			note("Exactly one item must be selected.");
		else if (i != -1 && (i = lbox_get_sel_index(LBEXER_BOX1)) == -1)
			error("Error getting selection.");
		else {
			if (++i >= count) /* want AFTER selection, not BEFORE */
				i = -1;
			if (!lbox_add(LBEXER_BOX1, i, buf))
				error("Error adding to list box.");
			if (!lbox_set_sel(LBEXER_BOX1, -1, FALSE) ||
			  !lbox_set_sel(LBEXER_BOX1, i == -1 ? count : i, TRUE))
				error("Error selecting.");
		}
		select_item_text(LBEXER_ADD_TEXT, 0, SHRT_MAX);
		break;
	case LBEXER_DELETE:
		switch (state->source) {
		case LBEXER_NONE:
			break;
		case LBEXER_ALL:
			if (!lbox_clear(LBEXER_BOX1))
				error("Error clearing.");
			break;
		case LBEXER_BYINDEX:
			if ((i = cvt_index()) == -1)
				error("Invalid index.");
			else if (!lbox_delete(LBEXER_BOX1, i))
				error("Error deleting.");
			break;
		case LBEXER_FIRST:
		case LBEXER_SELECTED:
			if ((x = lbox_get_sel(LBEXER_BOX1)) == NULL)
				error("Error getting selections.");
			else {
				lbox_suspend(LBEXER_BOX1);
				adjust = 0;
				for (e = slist_first(x); e != NULL; e = slist_next(x, e)) {
					if (adjust > 0)
						wait_cursor();
					if (slist_get(x, e, &index) == NULL) {
						error("Error getting SLIST element.");
						break;
					}
					if (!lbox_delete(LBEXER_BOX1, (int)index - adjust++)) {
						error("Error deleting.");
						break;
					}
					if (state->source == LBEXER_FIRST)
						break;
				}
				slist_dispose(x);
				lbox_resume(LBEXER_BOX1);
			}
		}
		break;
	case LBEXER_GET:
		if (!lbox_clear(LBEXER_BOX2)) {
			error("Error clearing.");
			break;
		}
		switch (state->source) {
		case LBEXER_NONE:
			break;
		case LBEXER_ALL:
			wait_cursor();
			if ((x = lbox_get_all(LBEXER_BOX1)) == NULL)
				error("Error getting.");
			else {
				if (!lbox_add(LBEXER_BOX2, -1, (char *)x))
					error("Error adding.");
			}
			slist_dispose(x);
			break;
		case LBEXER_BYINDEX:
			if ((i = cvt_index()) == -1)
				note("Invalid index.");
			else if (!lbox_get_elt(LBEXER_BOX1, i, buf, sizeof(buf)) || 
			  !lbox_add(LBEXER_BOX2, -1, buf))
				error("Error getting or adding.");
			break;
		case LBEXER_FIRST:
			if (!lbox_get_first_sel(LBEXER_BOX1, buf, sizeof(buf)) ||
			  !lbox_add(LBEXER_BOX2, -1, buf))
				error("Error getting or adding.");
			break;
		case LBEXER_SELECTED:
			wait_cursor();
			if ((x = lbox_get_sel(LBEXER_BOX1)) == NULL)
				error("Error getting.");
			else {
				if (!lbox_add(LBEXER_BOX2, -1, (char *)x))
					error("Error adding.");
				slist_dispose(x);
			}
		}
		break;
	case LBEXER_SELECT:
		switch (state->source) {
		case LBEXER_NONE:
			if (!lbox_set_sel(LBEXER_BOX1, -1, FALSE))
				error("Error selecting.");
			break;
		case LBEXER_ALL:
			if (!lbox_set_sel(LBEXER_BOX1, -1, TRUE))
				error("Error selecting.");
			break;
		case LBEXER_BYINDEX:
			if ((i = cvt_index()) == -1)
				note("Invalid index.");
			else if (!lbox_set_sel(LBEXER_BOX1, -1, FALSE) ||
			  !lbox_set_sel(LBEXER_BOX1, i, TRUE))
				error("Error selecting.");
		}
		break;
	case LBEXER_COUNT:
		switch (state->source) {
		case LBEXER_NONE:
			state->count = 0;
			break;
		case LBEXER_ALL:
			state->count = lbox_count_all(LBEXER_BOX1);
			break;
		case LBEXER_BYINDEX:
			state->count = cvt_index() == -1 ? 0 : 1;
			break;
		case LBEXER_FIRST:
			state->count = lbox_count_sel(LBEXER_BOX1) > 0 ? 1 : 0;
			break;
		case LBEXER_SELECTED:
			state->count = lbox_count_sel(LBEXER_BOX1);
			break;
		}
		break;
	case LBEXER_INSERT:
		i = lbox_get_sel_index(LBEXER_BOX1);
		if (i != -1)
			i++;
		if (i >= lbox_count_all(LBEXER_BOX1))
			i = -1;
		switch (state->contents) {
		case LBEXER_FACES:
			wait_cursor();
			if ((x = list_faces()) == NULL)
				error("Can't list faces.");
			else {
				if (!lbox_add(LBEXER_BOX1, i, (char *)x))
					error("Can't add to list box.");
				slist_dispose(x);
			}
			break;
		case LBEXER_FILES:
			wait_cursor();
			if ((x = list_files("", "", TRUE)) == NULL)
				error("Can't list files.");
			else {
				if (!lbox_add(LBEXER_BOX1, i, (char *)x))
					error("Can't add to list box.");
				slist_dispose(x);
			}
			break;
		case LBEXER_STATES:
			wait_cursor();
			if ((x = list_res_str(STR_STATES1, STR_STATES2)) == NULL)
				error("Can't list states.");
			else {
				if (!lbox_add(LBEXER_BOX1, i, (char *)x))
					error("Can't add to list box.");
				slist_dispose(x);
			}
			break;
		case LBEXER_WINDOWS:
			wait_cursor();
			if ((x = list_windows()) == NULL)
				error("Can't list windows.");
			else {
				if (!lbox_add(LBEXER_BOX1, i, (char *)x))
					error("Can't add to list box.");
				slist_dispose(x);
			}
			break;
		default:
			error("Invalid state->contents.");
		}
		break;
	case LBEXER_FACES:
		state->contents = LBEXER_FACES;
		break;
	case LBEXER_FILES:
		state->contents = LBEXER_FILES;
		break;
	case LBEXER_STATES:
		state->contents = LBEXER_STATES;
		break;
	case LBEXER_WINDOWS:
		state->contents = LBEXER_WINDOWS;
		break;
	case LBEXER_NONE:
		state->source = LBEXER_NONE;
		break;
	case LBEXER_ALL:
		state->source = LBEXER_ALL;
		break;
	case LBEXER_BYINDEX:
		state->source = LBEXER_BYINDEX;
		select_item_text(LBEXER_INDEX_TEXT, 0, SHRT_MAX);
		break;
	case LBEXER_FIRST:
		state->source = LBEXER_FIRST;
		break;
	case LBEXER_SELECTED:
		state->source = LBEXER_SELECTED;
		break;
	default:
		return(TRUE);
	}
	check_radio_button(state->contents, LBEXER_FACES, LBEXER_WINDOWS);
	check_radio_button(state->source, LBEXER_NONE, LBEXER_BYINDEX);
	if (state->count == -1)
		buf[0] = '\0';
	else
		sprintf(buf, "%d", state->count);
	set_item_text(LBEXER_COUNT_RESULT, buf);
	return(TRUE);
}

/* Function to put up list box dialog box. */
#ifdef FPROTO
static void lbexer_dialog(void)
#else
static void lbexer_dialog()
#endif
{
	if (!new_dialog(DLG_MODELESS, LBEXER_DLG, cb_lbexer, 0L))
		error("Can't put up list box exerciser dialog.");
}

#ifdef FPROTO
static void main_event_ST_INSTRUCTIONS(WINDOW win, EVENT *ep)
#else
static void main_event_ST_INSTRUCTIONS(win, ep)
WINDOW win;
EVENT *ep;
#endif
{
	switch (ep->type) {
	case E_COMMAND:
		switch (ep->v.cmd.tag) {
		case M_FILE_QUIT:
			terminate();
		}
		break;
	case E_QUIT:
		if (ep->v.query)
			quit_OK();
		else
			terminate();
		break;
	case E_CHAR:
		switch (ep->v.chr.ch) {
		case '1':
			page_number = 1;
			break;
		case '2':
			page_number = 2;
			break;
		case '3':
			page_number = 3;
			break;
		case '4':
			page_number = 4;
			break;
		case '5':
			page_number = 5;
			break;
		}
		invalidate_rect(std_win, NULL);
		break;
	case E_CONTROL:
		switch (ep->v.ctl.id) {
		case PAGE1_CONTROL:
			page_number = 1;
			break;
		case PAGE2_CONTROL:
			page_number = 2;
			break;
		case PAGE3_CONTROL:
			page_number = 3;
			break;
		case PAGE4_CONTROL:
			page_number = 4;
			break;
		case PAGE5_CONTROL:
			page_number = 5;
			break;
		}
		invalidate_rect(std_win, NULL);
		break;
	case E_UPDATE:
		do_update(win);
		break;
	}
}

void XVTENTRY main_event BTCENTRY(win, ep)
WINDOW win;								/* window receiving event, if any */
EVENT *ep;								/* pointer to event structure */
{
	int pos, len, l, a, d, i;
	WINDOW w;
	WINDOW_INFO *wi;
	char s[TMP_STR_LEN];
	RCT r;

	if (ep->type == E_UPDATE && win == std_win) {
		do_update(win);
		return;
	}
	switch (ep->type) {
	case E_COMMAND:
		switch (ep->v.cmd.tag) {
		case M_DEMO_HELP:
			help();
			break;
		case M_FILE_QUIT:
			terminate();
		case M_DEMO_WINDOWS:
			windows_init();
			invalidate_rect(std_win, NULL);
			show_buttons(no_windows());
			break;
		case M_DEMO_DATA_ENTRY:
			if (data_entry_window == NULL_WIN) {
				data_entry_init();
				invalidate_rect(std_win, NULL);
				show_buttons(no_windows());
			}
			break;
		case M_DEMO_BUTTONS:
			if (options_window == NULL_WIN) {
				options_init();
				invalidate_rect(std_win, NULL);
				show_buttons(no_windows());
			}
			break;
		case M_DEMO_LIST_BOXES:
			if (list_box_window == NULL_WIN) {
				lbexer_dialog();
				invalidate_rect(std_win, NULL);
				show_buttons(no_windows());
			}
			break;
		case M_DEMO_CLOSE_ALL:
			close_all_windows();
			menu_enable(M_DEMO_CLOSE_ALL, FALSE);
			invalidate_rect(std_win, NULL);
			show_buttons(no_windows());
			break;
		case M_FILE_NEW:
			build_window();
			show_buttons(no_windows());
			break;
		case M_FILE_CLOSE:
			w = get_front_window();
			for (i = 0; i < MAX_WINDOWS; ++i)
				if (w == windows[i]) {
					wi = (WINDOW_INFO *)get_app_data(windows[i]);
					xvt_free((void *)wi);
					close_window(windows[i]);
					windows[i] = NULL_WIN;
					break;
				}
			show_buttons(no_windows());
			break;
		}
		break;
	}
	if (no_windows()) {
		main_event_ST_INSTRUCTIONS(win, ep);
		/* show_buttons(no_windows()); */
	} else {
		switch (ep->type) {
		case E_CLOSE:
			for (i = 0; i < MAX_WINDOWS; ++i)
				if (win == windows[i]) {
					wi = (WINDOW_INFO *)get_app_data(windows[i]);
					xvt_free((void *)wi);
					close_window(windows[i]);
					windows[i] = NULL_WIN;
					break;
				}
			show_buttons(no_windows());
			break;
		case E_ACTIVATE:
			if (win == std_win)
				invalidate_rect(std_win, NULL);
			break;
		case E_VSCROLL:
			wi = (WINDOW_INFO *)get_app_data(win);
			pos = wi->v_scroll;
			switch (ep->v.scroll.what) {
			case SC_LINE_DOWN:
				if (pos < 100)
					++pos;
				break;
			case SC_LINE_UP:
				if (pos > 0)
					--pos;
				break;
			case SC_PAGE_DOWN:
				if (pos <= 90)
					pos += 10;
				break;
			case SC_PAGE_UP:
				if (pos >= 10)
					pos -= 10;
				break;
			case SC_THUMB:
			case SC_THUMBTRACK:
				pos = ep->v.scroll.pos;
				break;
			}
			wi->v_scroll = pos;
			set_scroll_pos(win, VSCROLL, wi->v_scroll);
			invalidate_rect(win, NULL);
			break;
		case E_HSCROLL:
			wi = (WINDOW_INFO *)get_app_data(win);
			pos = wi->h_scroll;
			switch (ep->v.scroll.what) {
			case SC_LINE_DOWN:
				if (pos < 100)
					++pos;
				break;
			case SC_LINE_UP:
				if (pos > 0)
					--pos;
				break;
			case SC_PAGE_DOWN:
				if (pos <= 90)
					pos += 10;
				break;
			case SC_PAGE_UP:
				if (pos >= 10)
					pos -= 10;
				break;
			case SC_THUMB:
			case SC_THUMBTRACK:
				pos = ep->v.scroll.pos;
				break;
			}
			wi->h_scroll = pos;
			set_scroll_pos(win, HSCROLL, wi->h_scroll);
			invalidate_rect(win, NULL);
			break;
		case E_UPDATE:
			get_font_metrics(&l, &a, &d);
			len = max(get_text_width("Horizontal Scroll Bar:", -1),
			  get_text_width("Vertical Scroll Bar:", -1));
			get_client_rect(win, &r);
			set_cpen(&hollow_cpen);
			set_cbrush(&white_cbrush);
			draw_rect(&r);
			wi = (WINDOW_INFO *)get_app_data(win);
			sprintf(s, "%3d", wi->h_scroll);
			draw_text(8, l + a, "Horizontal Scroll Bar:", -1);
			draw_text(len + 8, l + a, s, -1);
			sprintf(s, "%3d", wi->v_scroll);
			draw_text(8, (l + a) * 2 + d, "Vertical Scroll Bar:", -1);
			draw_text(len + 8, (l + a) * 2 + d, s, -1);
			break;
		}
	}
	config_menu();
}

void XVTENTRY appl_cleanup BTCENTRY()
{
}
