/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  srp_qic.h                                                                */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  12/13/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/
/*-----------------------------------------------------------------------------
 The SRP QICI board is a memory-mapped device that implements the QIC-02
 interface.  In addition to sending the correct command byte, the byte must be
 written to the correct address in the QICI memory map.  The numbers given
 below are address bits 25 through 16, inclusive, of the location to be
 referenced.  In real mode, this high-order protion of physical address is
 written to Base Register 0 and referenced by hardware on writes to or reads
 from locations 0xC000:nnnn.  In protected mode, a separate selector is
 programmed for each unique address below and Base Register 0 is left zero for
 all references. */

#define WRITE_DATA_ADDRESS	0x00F9
#define WRITE_FILEMARK_ADDRESS	0x00F1
#define READ_DATA_ADDRESS	0x00FD
#define READ_FILEMARK_ADDRESS	0x00F1
#define READ_STATUS_ADDRESS	0x00F1
#define QIC_FLAGS_ADDRESS	0x00A9
#define WRITE_BUFFER_ADDRESS	0x00EA
#define READ_BUFFER_ADDRESS	0x00E8
#define QIC_STATUS_ADDRESS	0x00C9
#define OFFLINE_ADDRESS		0x0069
#define REQ_ADDRESS		0x01E9
#define MISC_COMMAND_ADDRESS	0x00F9
#define RESET_QIC_ADDRESS	0x02E1

/*-----------------------------------------------------------------------------
 In order to determine the presence or absence of the QICI board, the SRP NMI
 registers must be reprogrammed while an attempt is made to read data from the
 memory mapped I/O space of the interface board.  The NMI register addresses
 and bit meanings are different for the real mode processors (CP, DP, FP, SP
 and TP) and the protected mode processor (GP). */

#define NMI_REG 0x0068

#define NONEXISTENT_MEMORY 0x1000
#define BUS_TIMEOUT 0x0400
#define BUS_ERROR 0x0200
#define NMI_ENABLE 0x0001

#define CONFIG_REG_386 0x0150
#define NMI_ENABLE_386 0x0001

#define NMI_REG_386 0x0168
#define BUS_TIMEOUT_386 0x0080
#define NONEXISTENT_MEMORY_386 0x0040
#define BUS_ERROR_386 0x0008

/*-----------------------------------------------------------------------------
 The QICI board implements most of the QIC-02 interface commands, but expects
 to receive them inverted (i.e. as one's complements of the values given
 below).  The SRP QICI does not support the drive selection commands (probably
 because it supports only one drive!). */

#define REWIND 0x21
#define ERASE 0x22
#define RETENSION 0x24
#define READ_DATA 0x80
#define READ_FILEMARK 0xA0
#define WRITE_DATA 0x40
#define WRITE_FILEMARK 0x60
#define READ_STATUS 0xC0
#define RESET_QIC_FIRMWARE 0xFF		/* Not a real command */

/*-----------------------------------------------------------------------------
 QIC-02 status is six bytes of information.  The first two bits are composed
 of status bits (as defined below); the most significant bit of each byte is
 set if any of the other bits are set.  Bytes two (MSB) and three (LSB) of the
 status information are a count of recoverable errors while bytes four and
 five (in the same MSB to LSB order) are a count of underruns. */

#define EXCEPTION_STATUS 0x80
#define NO_CARTRIDGE 0x40
#define NOT_ONLINE 0x20
#define WRITE_PROTECT 0x10
#define EOM 0x08
#define UNRECOVERABLE_DATA 0x04
#define UNKNOWN_ERROR 0x02
#define FILEMARK 0x01

#define EXCEPTION_STATUS 0x80
#define ILLEGAL_COMMAND 0x40
#define NO_DATA 0x20
#define EIGHT_RETRIES 0x10
#define BOM 0x08
#define DATA_PARITY 0x04
#define EOD 0x02
#define POWER_UP_RESET 0x01

/*-----------------------------------------------------------------------------
 The QIC interface board implements an 8-bit flag register, as defined below.
 The values returned from the register are inverted, so it is necessary to
 perform a one's complement before using them with these definitions. */

#define QIC_INTERRUPT 0x20
#define QIC_EXCEPTION 0x10
#define QIC_READY 0x08
#define QIC_BUSY 0x04
#define QIC_BUFFER_B_FULL 0x02
#define QIC_BUFFER_A_FULL 0x01
#define QIC_BUFFERS_FULL 0x03
