/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  seq_service_dispatch_pertec.c                                            */
/*                                                                           */
/*  Dispatch tables for SRP/XE CTOS Sequential Access service.               */
/*  (Pertec 1/2" Reel-to-Reel SP Interface)                                  */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  02/19/91  121G.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

/* Standard C library macros and functions invoked by this module */

pragma Off(List);
#include <intel80X86.h>
pragma Pop(List);

/* There are no procedures in the Sequential Access service that can cope with
   a variable number of arguments, so this pragma makes everything much more
   efficient.  However, it has to be established AFTER any standard C library
   functions are defined because it reverses the normal C convention. */

pragma Calling_convention(_CALLEE_POPS_STACK);

/* External CTOS and CTOS Toolkit functions invoked by this module */

pragma Off(List);
#include <ctoslib.h>
pragma Pop(List);

/* Type definitions used by this module */

pragma Off(List);
#include <ctosTypes.h>
#include "seq_service.h"
pragma Pop(List);

/* Other external functions in this application invoked by this module */

extern unsigned pertec_close(dcb_type *dcb);
extern unsigned pertec_ctrl(dcb_type *dcb);
extern unsigned pertec_defaults(default_info_type *default_info);
extern void pertec_init(dcb_type *dcb, unsigned base_address);
extern unsigned pertec_io(dcb_type *dcb);
extern unsigned pertec_mode_query(dcb_type *dcb,
                                  seq_parameters_type *seq_parameters);
extern unsigned pertec_mode_set(dcb_type *dcb,
                                seq_parameters_type *seq_parameters);
extern unsigned pertec_open(dcb_type *dcb);
extern unsigned pertec_rq_done(dcb_type *dcb);
extern unsigned pertec_status(dcb_type *dcb);
extern void pertec_watchdog(watchdog_type *watchdog);

/* Global variables exported by this manuscript */

unsigned (*device_buffer[])(dcb_type *dcb) = {0, 0, 0, 0, 0};
unsigned (*device_close[])(dcb_type *dcb) = {0, 0, 0, 0, pertec_close};
unsigned (*device_ctrl[])(dcb_type *dcb) = {0, 0, 0, 0, pertec_ctrl};
unsigned (*device_defaults[])(default_info_type *default_info) =
                                                 {0, 0, 0, 0, pertec_defaults};
void (*device_init[])(dcb_type *dcb, unsigned base_address) =
                                                     {0, 0, 0, 0, pertec_init};
unsigned (*device_io[])(dcb_type *dcb) = {0, 0, 0, 0, pertec_io};
unsigned (*device_mode_query[])(dcb_type *dcb,
                                seq_parameters_type *seq_parameters)
                                             = {0, 0, 0, 0, pertec_mode_query};
unsigned (*device_mode_set[])(dcb_type *dcb,
                              seq_parameters_type *seq_parameters)
                                               = {0, 0, 0, 0, pertec_mode_set};
unsigned (*device_open[])(dcb_type *dcb) = {0, 0, 0, 0, pertec_open};
unsigned (*device_rq_done[])(dcb_type *dcb) = {0, 0, 0, 0, pertec_rq_done};
unsigned (*device_status[])(dcb_type *dcb) = {0, 0, 0, 0, pertec_status};
void (*device_watchdog[])(watchdog_type *watchdog)
                                               = {0, 0, 0, 0, pertec_watchdog};
