/* SRP SP board hardware registers */

#define INT_MASK_REG 0xFF28	/* Controls masks for INT0 through INT3 */
#define MASK_INT2 0x0040
#define INT2_CTRL_REG 0xFF3C	/* Configures interrupt for INT2 */
#define LEVEL_TRIGGERED 0x0010

/* Pertec 1/2" Tape I/O register addresses on the SRP SP board */

#define MAX_UNITS 8		/* Hardware limit 2 formatters with 4 drives */

#define TAPE_CLEAR_STATUS	0x007A
#define TAPE_GO_REG		0x007C
#define TAPE_COMMAND_REG	0x007E
#define TAPE_STATUS_REG		0x007E
#define DMA_ADDR_HIGH_REG	0x008A
#define DMA_ADDR_LOW_REG	0x008C
#define DMA_COUNT_REG		0x0090

/* Bit assignments in Tape command register */

#define REV			0x1000
#define W			0x0800
#define ED			0x0400
#define EZ			0x0200
#define WFM			0x0100
#define GO			0x0080
#define FE			0x0040
#define RW			0x0020
#define RU			0x0010
#define HS			0x0008
#define UNIT_MASK		0x0007

/* Tape commands synthesized from the above */

#define BPI_3200		(REV | ED | EZ | WFM | GO)
#define BPI_1600		(ED | EZ | WFM | GO)
#define ERASE_GAP		(W | EZ | WFM | GO)
#define ERASE_MEDIUM		(W | ED | EZ | WFM | GO)
#define NOP			(ED | EZ)
#define READ			(GO)
#define READ_EDIT		(ED | GO)
#define READ_EDIT_REVERSE	(REV | ED | GO)
#define REWIND			(RW)
#define RESET_FIRMWARE		(FE)
#define SEARCH_FILEMARK		(EZ | WFM | GO)
#define SEARCH_FILEMARK_REVERSE	(REV | EZ | WFM | GO)
#define SPACE			(EZ | GO)
#define SPACE_REVERSE		(REV | EZ | GO)
#define UNLOAD			(RU)
#define WRITE			(W | GO)
#define WRITE_EDIT		(W | ED | GO)
#define WRITE_FILEMARK		(W | WFM | GO)

/* Bit assignments in Tape status register */

#define BUSY			0x8000
#define BOT			0x4000
#define READY			0x2000
#define REWINDING		0x1000
#define WRITE_PROTECT		0x0800
#define DATA_BUSY		0x0400
#define HIGH_SPEED		0x0200
#define ONLINE			0x0100
#define EOT			0x0008
#define CORRECTED_ERROR		0x0004
#define HARD_ERROR		0x0002
#define FILEMARK		0x0001

/* Density codes for medium (these values are borrowed from SCSI-2) */

#define NRZI_800 0x01		/* 1/2" reel-to-reel 800bpi NRZI */
#define PE_1600 0x02		/* 1/2" reel-to-reel 1600bpi PE */
#define PE_3200 0x06		/* 1/2" reel-to-reel 3200bpi PE */
