;	ScUtil_all.asm
;
;	This file generates the following object modules depending on switches:
;
;	Module			Switches
;
;	ScUtil_p		ctosp, vp
;	ScUtil_v		ctosv
;	ScUtil_mf		mf
;	ScUtil_mfp		ctosp, vp, mf

%IF(NOT %*IsDef(%ctosv)) THEN (%SET(ctosv,0))FI
%if(not %*isdef(%bsac)) then (%set(bsac,0))fi

PUBLIC	Beeper
PUBLIC	ProcCurrent 
PUBLIC	ExchSync 
PUBLIC	GetModuleAddress
PUBLIC	GetModuleID
PUBLIC	GetpASCB
PUBLIC	GetUserNum 
PUBLIC	InitNetAgent
PUBLIC	InitNetServer
PUBLIC  LockDecByte
PUBLIC  LockDecWord
PUBLIC  LockIncByte
PUBLIC  LockIncWord
PUBLIC	QueryModel
PUBLIC  QueryLoadAddress
PUBLIC  SetModuleId
PUBLIC  SwapXBEar
PUBLIC  NotImplemented0Args
PUBLIC  NotImplemented2Args
PUBLIC  NotImplemented4Args
PUBLIC  NotImplemented6Args
PUBLIC  NotImplemented8Args
PUBLIC  NotImplemented10Args
PUBLIC  NotImplemented12Args
PUBLIC  NotImplemented14Args
PUBLIC  NotImplemented16Args
PUBLIC  NotImplemented18Args
PUBLIC  NotImplemented20Args
PUBLIC  NotImplemented22Args
PUBLIC  NotImplemented24Args
PUBLIC  NotImplemented26Args
PUBLIC  NotImplemented28Args
PUBLIC  NotImplemented30Args
PUBLIC  NotImplemented32Args

%if (%bsac) then (
PUBLIC	NotImplementedBSAC
PUBLIC	NotImplementedBSACCheckSum
)fi

PUBLIC ReturnOK0Args
PUBLIC ReturnOK6Args
PUBLIC ReturnOK8Args
PUBLIC ReturnOK10Args

EXTRN KWait:FAR
EXTRN Waitp:FAR
EXTRN KSend:FAR
EXTRN Crash:FAR
EXTRN ErrorExit:FAR
EXTRN ONextUserPcb:FAR
%IF(NOT %MF) THEN (
%if(not %ctosv)then(
EXTRN SwapXbEarReal:FAR
)fi
)FI


DGroup	GROUP	Const, Data
Const	SEGMENT PUBLIC 'Const'
Const	ENDS
Data	SEGMENT	PUBLIC	'Data'
extrn   cpOsSubTable:word
extrn   OsSubTable:dword

%if (%bsac) then (
EXTRN	pCheckSumPtr:DWORD
)fi

EXTRN	pRgOExUcb: DWORD
EXTRN 	oPcbRun:WORD
EXTRN 	userNumPrimary:WORD
EXTRN   wMySlotBits: WORD
EXTRN	NetServerData: WORD
EXTRN	exchNet: WORD
EXTRN	beeperPortNgen: WORD
PUBLIC  bBeepOn
PUBLIC  bBeepOff
bBeepOn	DB	0
bBeepOff	DB	0
NewGen equ 9

EXTRN	processortype: BYTE
EXTRN	vf: byte
EXTRN   shCpuSpeed: WORD
EXTRN	userNumClstrLast: WORD
EXTRN	nUcb: WORD
EXTRN	pSGBusIdTable: DWORD
EXTRN	pXbusIdTable: DWORD
EXTRN	pIbusIdTable: DWORD
EXTRN	pEisaTable: DWORD
%IF (%VP) THEN (
EXTRN	rgsgAsib:WORD
)FI
%IF (%MF) THEN (
EXTRN kbdControlReg: WORD
EXTRN kbdDataReg: WORD
EXTRN ibBufOutPut: WORD
EXTRN ibBufOutTake: WORD
EXTRN rgbBufOut: BYTE
EXTRN mBufOut: WORD
EXTRN fBufOutOverFlow: BYTE
PUBLIC fCliPortAvail
fCliPortAvail DB 0
bLastCol DB 0

)FI

PUBLIC pDwellCx, qbDwell
pDwellCx DD 0
qbDwell  DD 0
fDwellReady DB 0

CrashSeg SEGMENT WORD PUBLIC 'OemSeg'
public crashStack
crashStack dw 150 dup (0)			;stack for calling bitmap video
crashStackTop EQU CrashStack+300
CrashSeg ENDS

Data	ENDS

ercNotImplemented  	EQU	7
ercNoSuchModule		EQU	35
ercNoSuchBus		EQU	36
ercEmptySlot		EQU 57
pcbEar				EQU 16	
pcbSize				EQU	18
pcboExPcb			EQU	16
pcbPriority			EQU	3
pcbUserNum			EQU	14
pParamBlk			EQU	250h
exPcbDeltaPriority	EQU	2
exPcbSavedPriority	EQU	3
exchgSync			EQU	12
SpSave				EQU	4H
sgVirtualLowMem 	EQU 28h
sgLowMem  			EQU 60h
maskRealMode 		EQU 1

%if (%bsac) then (
iBSACcallGate		EQU 165*4			; ACS sys comm #
)fi

$INCLUDE(:f1:ioaddr1.edf)
$Include(:f1:VfEqu.idf)
$Include(:f1:descriptors.mdf)


ScUtil	SEGMENT	PUBLIC	'Code'
ASSUME	CS: ScUtil, DS: NOTHING

;*****************************************************************************
;
;	ProcCurrent: PROCEDURE WORD PUBLIC REENTRANT;
;
;*****************************************************************************
ProcCurrent PROC FAR
ASSUME ES: NOTHING, DS: NOTHING
	PUSH	BP
	MOV		BP, SP
	MOV		AX, DGroup
	MOV		ES, AX
ASSUME ES: DGroup
	MOV		DX, WORD PTR oPcbRun
	JMP		ReturnData
ASSUME ES: NOTHING
ProcCurrent	ENDP


;*****************************************************************************
;
;	ExchSync: PROCEDURE WORD PUBLIC REENTRANT;
;
;*****************************************************************************
ExchSync PROC FAR
	MOV		SI,exchgSync
	JMP		ReturnPcbData
ExchSync	ENDP


;*****************************************************************************
;
;	GetUserNum: PROCEDURE WORD PUBLIC REENTRANT;
;
;*****************************************************************************
GetUserNum	PROC	FAR

ASSUME DS: NOTHING, ES: NOTHING, SS: NOTHING
	MOV		SI,pcbUserNum

ReturnPcbData:
	PUSH	BP
	MOV		BP, SP
	MOV		AX, DGroup
	MOV		ES, AX
ASSUME	ES: DGroup
	MOV		BX, oPcbRun
	MOV		DX, ES:[BX][SI]
	CMP		SI, pcbUserNum				;GetUserNum call?
	JNE		ReturnData
	CMP		DX, userNumPrimary ;Primary user?
	JNE		ReturnData
	MOV		DX, 1				;return 1 so old servers work


ReturnData:			; this is jumped to from several places so DON'T change
ASSUME	ES: NOTHING
	XOR		AX, AX
	LES		BX, DWORD PTR [BP+6]
	MOV		ES:[BX], DX
	POP		BP
	RET		4

GetUserNum ENDP


;*****************************************************************************
;
;	GetpASCB: PROCEDURE(@pRet) WORD PUBLIC REENTRANT;
;
;*****************************************************************************
GetpASCB	PROC	FAR
ASSUME DS: NOTHING, ES: NOTHING, SS: NOTHING
	PUSH	BP
	MOV		BP, SP
%if(%ctosp)then(
	mov		ax, DGroup
	mov		es, ax
assume es:DGroup
	mov		bx, oPcbRun
	test		word ptr es:[bx+spSave], maskRealMode
assume es:nothing
	mov		ax, sgVirtualLowMem ; protected user
	jz		GetPAscbContinue    
	mov		ax, sgLowMem        ; real user
GetPAscbContinue:
)else(
	XOR		AX, AX		;zero AX
)fi
	MOV		ES, AX
	pushf
	cli
	mov		DX, ES: WORD PTR [pParamBlk]
	mov		AX, ES: WORD PTR [pParamBlk+2]
	popf
	LES		BX, DWORD PTR [BP+6]
	MOV		ES: [BX+2], AX	; pRet.sa
	JMP		ReturnData		; let ReturnData put DX into pRet.ra
GetpASCB	ENDP

;*****************************************************************************
;
;	GetModuleID: PROCEDURE(tyBus, iMod, pIdRet) ercType PUBLIC REENTRANT;
;	SetModuleID: PROCEDURE(tyBus, iMod, qId)    ercType PUBLIC REENTRANT;
;
;*****************************************************************************
GetModuleID PROC FAR
tyIBus  EQU 1
tyXBus  EQU 2
tySGBus EQU 3
tyEISA  EQU 4
cbEisaInfo  EQU 26
argBus      EQU WORD PTR [BP+0Ch]
argiModule  EQU WORD PTR [BP+0Ah]
argPIDRet   EQU DWORD PTR [BP+6]
argwID      EQU WORD PTR [BP+6]
argwIDHi    EQU WORD PTR [BP+8]

	MOV  CH, 0              ; CH is fSetModuleId
	jmp short DoModuleId

SetModuleId LABEL FAR
	MOV  CH, 1

DoModuleId:
	PUSH BP
	MOV  BP, SP
	MOV  AX, DGroup
	MOV  ES, AX
ASSUME ES:DGroup
	MOV  CL, 1              ; word or dword array depending on bus
	CMP  argBus, tyXBus
	JE   XBus
	CMP  argBus, tyIBus
	JE   IBus
	CMP  argBus, tySGBus
	JE   SGBus
	CMP  argBus, tyEISA
	JNE  NoSuchBus
	JMP  EisaBus

IBus:
	LES  BX, pIBusIDTable
	JMP  FetchID
XBus:
	LES  BX, pXBusIDTable
	JMP  FetchID
SGBus:
	TEST vf_fSGen, 1
	JZ   NoSuchBus
	LES  BX, pSGBusIdTable
	MOV  CL, 2

FetchID:
ASSUME ES:NOTHING
	MOV  SI, argiModule
	CMP  SI, 0
	JE   NoSuchModule
	CMP  SI, WORD PTR ES:[BX]   ; count is always a word
	JG   NoSuchModule
	SHL  SI, CL                 ; index into word or dword array

	OR   CH, CH                 ; if GetModuleId, goto DoFetch
	JZ   DoFetch
	MOV  AX, argWId
	MOV  ES:[BX][SI], AX
	CMP  CL, 2
	JNE  DoModuleIdErcOk
	MOV  AX, argWIdHi
	MOV  ES:[BX][SI+2], AX
	jmp  short DoModuleIdErcOk

DoFetch:
	MOV  AX, WORD PTR ES:[BX][SI]
	CMP  CL, 2
	JNE  WordOnly0
	MOV  DX, WORD PTR ES:[BX][SI+2]

WordOnly0:
	LES  BX, argPIDRet
	MOV  WORD PTR ES:[BX], AX
	CMP  CL, 2
	JNE  DoModuleIdErcOk
	MOV  WORD PTR ES:[BX+2], DX
DoModuleIdErcOk:
	XOR  AX, AX

ExitRtne:
	POP  BP
	RET  8

NoSuchModule:
	MOV  AX, ercNoSuchModule
	JMP  ExitRtne

NoSuchBus:
	MOV  AX, ercNoSuchBus
	JMP  ExitRtne

NoSuchEisaSlot:
	POP  DS
	MOV  AX, ercNoSuchModule
	JMP  ExitRtne

EmptySlot:
	POP  DS
	MOV  AX, ercEmptySlot
	JMP  ExitRtne

NotImplemented:
	MOV  AX, ercNotImplemented
	JMP  ExitRtne

EisaBus:
ASSUME ES:DGroup
	TEST vf_fEisaBus, 1
	JZ   NoSuchBus
	OR   CH, CH                    ; SetModuleID not allowed for EISA
	JNZ  NotImplemented

	PUSH DS
	LDS  SI, pEisaTable            ; Setup pointer to the EISA Info table
	LES  DI, argPIDRet             ; Setup pointer to the user buffer
	MOV  AX, cbEisaInfo            ; Each slot has a 26-byte entry
	MOV  BX, argiModule            ;
	CMP  BX, 0                     ; First slot has value of 1
	JE   NoSuchEisaSlot
	CMP  BL, BYTE PTR [SI]         ; Make sure request is for a valid slot
	JG   NoSuchEisaSlot

	MUL  BX                        ; Set index to beginning of specified slot
	MOV  BX, AX
	CMP  BYTE PTR [BX][SI], 1      ; Check if board is present
	JG   EmptySlot

	ADD  AX, 9                     ; The board IDs offset is 9-bytes
	ADD  SI, AX
	MOV  CX, 7                     ; Module ID consists of seven characters
REP MOVSB
	POP  DS
	JMP  DoModuleIdErcOk

GetModuleID	ENDP


;*****************************************************************************
;
;   GetModuleAddress: PROCEDURE(tyBus, iModule, pAddrRet) ercType
;
;   Applications used to call GetModuleId, and then calculate the IO base
;   address themselves.  This routine should be used instead because the old
;   calculation ( (nPos-1)*100h ) no longer works on all hardware.
;
;*****************************************************************************
GetModuleAddress PROC FAR
tyIBus  EQU 1
tyXBus  EQU 2
tySGBus EQU 3
tyEisa  EQU 4
cbEisaInfo  EQU 26
argBus      EQU WORD PTR [BP+0Ch]
argiModule  EQU WORD PTR [BP+0Ah]
argpAddrRet EQU DWORD PTR [BP+6]

ASSUME ES:Nothing, DS:Nothing
	PUSH BP
	MOV  BP, SP
	CMP  argBus, tyIBus
	JE   GmaIBus
	CMP  argBus, tyXBus
	JE   GmaXBus
	CMP  argBus, tySGBus
	JE   GmaSGBus
	CMP  argBus, tyEisa
	JE   GmaEisa
	JMP  GmaNoSuchBus

GmaEisa:
	JMP  GmaEisaBus

GmaIBus:
	MOV  AX, ercNotImplemented
	JMP  GmaExitRtne

GmaXBus:
	MOV  SI, argiModule
	CMP  SI, 0
	JNE  Gma0
	JMP  GmaNoSuchModule        ; First module is at position 1
Gma0:
	MOV  AX, DGroup
	MOV  ES, AX
ASSUME ES:DGroup
	LES  BX, pXBusIDTable
ASSUME ES:Nothing
	CMP  SI, WORD PTR ES:[BX]   ; First entry is count
	JBE  Gma1
	JMP  GmaNoSuchModule
Gma1:
	MOV  ES, AX
ASSUME ES:DGroup
	TEST vf_fSGen, 1
ASSUME ES:Nothing
	JZ   GmaNGen
	CMP  SI, 4
	JBE  GmaNGen                ; first 4 slots emulate NGen
	SUB  SI, 4                  ; After CPU and Video, first address is 0E400h
	SHL  SI, 10
	MOV  AX, 0E000h
	OR   AX, SI
	JMP  GmaSetAddr
GmaNGen:
	MOV  AX, SI                  ; CPU at 0, 1st module at 100h  (nPos-1)*100h
	DEC  AX
	SHL  AX, 8
	JMP  GmaSetAddr

GmaSGBus:
	MOV  AX, DGroup
	MOV  ES, AX
ASSUME ES:DGroup
	TEST vf_fSGen, 1
	JZ   GmaNoSuchBus
	MOV  SI, argiModule
	CMP  SI, 0
	JE   GmaNoSuchModule
	LES  BX, pSGBusIDTable
ASSUME ES:Nothing
	CMP  SI, WORD PTR ES:[BX]
	JG   GmaNoSuchModule
	MOV  AX, SI
	SHL  SI, 2                  ; Index into dword array
	MOV  DX, WORD PTR ES:[BX][SI]
	OR   DX, WORD PTR ES:[BX][SI+2]
	JZ   GmaNoSuchModule
	ADD  AX, 2
	SHL  AX, 12                 ; First EISA slot IO base is 3000h
	JMP  GmaSetAddr

GmaSetAddr:
	LES  BX, argpAddrRet
	MOV  WORD PTR ES:[BX], AX
	XOR  AX, AX

GmaExitRtne:
	POP  BP
	RET  8

GmaNoSuchBus:
	MOV  AX, ercNoSuchBus
	JMP  GmaExitRtne

GmaNoSuchModule:
	MOV  AX, ercNoSuchModule
	JMP  GmaExitRtne

GmaEmptySlot:
	MOV  AX, ercEmptySlot
	JMP  GmaExitRtne

GmaEisaBus:
	MOV  AX, DGroup
	MOV  ES, AX
ASSUME ES:DGroup
	TEST vf_fEisaBus, 1            ; Make sure we have an EISA Bus
	JZ   GmaNoSuchBus
	MOV  BX, argiModule
	CMP  BX, 0
	JE   GmaNoSuchModule           ; First module is at position 1
	LES  SI, pEisaTable            ; Setup pointer to the EISA Info table
	CMP  BL, BYTE PTR ES:[SI]      ; First entry is count
	JA   GmaNoSuchModule
	MOV  AX, cbEisaInfo            ; Each slot has a 26-byte entry
	MUL  BX                        ; Set index to beginning of specified slot
	MOV  BX, AX
	CMP  BYTE PTR ES:[BX][SI], 0   ; Check if board is present
	JNE  GmaEmptySlot
	ADD  BX, 7                     ; The baseIOAddress offset is 7 bytes
	MOV  AX, WORD PTR ES:[BX][SI]  ; store the baseIOAddress in AX
	JMP  GmaSetAddr

GetModuleAddress ENDP



;
;**** CAUTION: Adding new NotImplemented?Args requires that you also
;              add new code to FOverWritable in SCInstall_all.plm
;

NotImplemented0Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET
NotImplemented0Args	ENDP

NotImplemented2Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	2
NotImplemented2Args	ENDP

NotImplemented4Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	4
NotImplemented4Args	ENDP

NotImplemented6Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	6
NotImplemented6Args	ENDP

NotImplemented8Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	8
NotImplemented8Args	ENDP

NotImplemented10Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	10
NotImplemented10Args	ENDP

NotImplemented12Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	12
NotImplemented12Args	ENDP

NotImplemented14Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	14
NotImplemented14Args	ENDP

NotImplemented16Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	16
NotImplemented16Args	ENDP

NotImplemented18Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	18
NotImplemented18Args	ENDP

NotImplemented20Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	20
NotImplemented20Args	ENDP

NotImplemented22Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	22
NotImplemented22Args	ENDP

NotImplemented24Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	24
NotImplemented24Args	ENDP

NotImplemented26Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	26
NotImplemented26Args	ENDP

NotImplemented28Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	28
NotImplemented28Args	ENDP

NotImplemented30Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	30
NotImplemented30Args	ENDP

NotImplemented32Args	PROC	FAR
	MOV	AX, ercNotImplemented
	RET	32
NotImplemented32Args	ENDP

%if (%bsac) then (
;  This routine handles two cases, one where ACS (a.k.a BSAC) is not 
;  installed, and the case where ACS was installed after the caller 
;  loaded.  The first case returns erc 7, the second pushes the address
;  of the ACS dispatcher on the stack and RETs to it, never to return here.
;
FindACS		PROC	FAR
	DD	osSubTable + iBSACcallGate; -->  pBsacProc
NotImplementedBSAC LABEL FAR 
	LES	BX, CS:DWORD PTR[FindACS]; ES:BX --> pBsacProc
	MOV	AX, CS
	CMP	AX, ES:WORD PTR[BX+2]		; if CS == pBsacProc.sg
	JE	ACSreturnNotImplemented 	; then ACS isn't installed.
	PUSH	ES: WORD PTR[BX+2]		; Else put ACS's address
	PUSH	ES: WORD PTR[BX]		; on the stack,
	RET					; and execute (never returns)
ACSreturnNotImplemented:
	MOV	AX, ercNotImplemented
	RET	8
FindACS			ENDP

NotImplementedBSACCheckSum	PROC FAR 

;* What this procedure does, is completely defined in scInstall_all.plm	*;
;* This procedure has been implemented for BSAC CheckSum.				*;

ASSUME ES: DGroup
	MOV AX, DGROUP
	MOV ES, AX
	LES BX, pCheckSumPtr
	MOV AX, ES
	CMP AX, 0
	JE CheckSumNotImplemented
	PUSH ES
	PUSH BX
	RET
CheckSumNotImplemented:
	MOV	AX, ercNotImplemented
	RET	8
NotImplementedBSACCheckSum	ENDP
)fi

ReturnOK0Args	PROC	FAR
	XOR	AX, AX
	RET
ReturnOK0Args	ENDP

ReturnOK6Args	PROC	FAR
	XOR	AX, AX
	RET 6
ReturnOK6Args	ENDP

ReturnOK8Args	PROC	FAR
	XOR	AX, AX
	RET 8
ReturnOK8Args	ENDP

ReturnOK10Args	PROC	FAR
	XOR	AX, AX
	RET 10
ReturnOK10Args	ENDP

Beeper	PROC	FAR
ASSUME DS: DGroup
%IF (NOT(%MF)) THEN (
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	MOV	AX, DGroup
	MOV	DS, AX
	MOV	DX, BeeperPortNGen

	mov bx, 1
	mov cx, shCpuSpeed
	shl bx, cl

BeeperLoopCountSet:
; the 386i beeper port is a write-only register (reading returns 0FFh) so
; emulate reading a zero
	cmp processorType, NewGen
	jne ReadBeeperPort
	test vf_f386, 1
	jz ReadBeeperPort
	xor ax, ax
	jmp short EnableBeeper
		
ReadBeeperPort:
	IN	DX, AL
	JMP	$+2			;flush pipe

EnableBeeper:
	OR	AL,bBeepOn
	OUT	DX, AL

BeeperLoop:
	cmp bx, 0
	je DisableBeeper
		
	XOR	CX, CX
	LOOP	$

	dec bx
	jmp short BeeperLoop

DisableBeeper:
	IN	DX,AL
	JMP $+2		
	AND	AL, bBeepOff
	OUT	DX, AX
	
	POP	DS
	POP	DX
	POP	CX
	POP BX
	POP	AX
)FI
	RET
ASSUME DS: Nothing
Beeper	ENDP;



InitNetServer  PROC  FAR
;    InitNetServer: procedure pointer reentrant public;
;    returns pointer to NetAgentData
;    This is an OS Common subroutine, which means we are using the client's
;    DS and Stack.
	mov		ax, DGroup
	mov		es, ax
	MOV		BX, offset DGroup:NetServerData
	RET
InitNetServer  ENDP


InitNetAgent				PROC FAR
;	 InitNetAgent: procedure(pNetAgentVariables) reentrant public;
;    This is an OS Common subroutine, which means we are using the client's
;    DS and Stack.

;	NetAgentVariables:

netAgentExch				EQU	WORD PTR ES:[BX+0]
cNetUsers				EQU WORD PTR ES:[BX+2]
	PUSH		BP
	MOV		BP,SP
	PUSH		DS			;Save client's DS
	MOV		AX,DGroup			;Point to OS DS
ASSUME DS: DGroup
	MOV		DS,AX
	LES		BX,DWORD PTR [BP+6]					;ES:BX points to NetAgentVariables
	MOV		AX,netAgentExch
	MOV		exchNet,AX			;Save net exch so we know where to send net requests
	MOV		AX,userNumClstrLast
	INC		AX
	MOV		cNetUsers,AX				;Tell the NetAgent how many users we have
	POP		DS
	POP		BP
	RET		4
InitNetAgent				ENDP

;	Vp System common subroutine to find if partition contains Large model code.
QueryModel PROC FAR
argUserNum	EQU 10
argPFBig	EQU	6
	PUSH	BP
	MOV		BP,SP
	LES		BX, DWORD PTR [BP+argPFBig]
	MOV		BYTE PTR ES:[BX], 0ffh
	XOR		AX,AX
QueryModelRet:
	POP		BP
	RET		6
QueryModel	ENDP

;	Vp System common subroutine to find symbol file base for debugger.
QueryLoadAddress PROC FAR
argUserNum	EQU 10
argPSa		EQU	6
oExUcbcMassIo	EQU	2
oExUcbSaCodeSeg		EQU	6
ercBadPartitionHandle EQU 803
	PUSH	BP
	MOV		BP,SP
	PUSH	DS
	MOV		AX, DGroup
	MOV		DS, AX
ASSUME DS:DGroup
	MOV		SI, [BP+argUserNum]
    AND     SI, 03FFH
	MOV		AX, ercBadPartitionHandle
	CMP		SI, nUcb
	JAE		QueryLoadAddressRet
	SHL		SI,1
	LES		BX, DWORD PTR pRgOExUcb
	MOV		BX, WORD PTR ES:[BX][SI]
	CMP		WORD PTR ES:[BX+oExUcbcMassIo], 0FFFFh
	JE		QueryLoadAddressRet	; ercBadPartitionHandle

	MOV		AX, WORD PTR ES:[BX+oExUcbSaCodeSeg]
	LES		BX, DWORD PTR [BP+argPSa]
	MOV		WORD PTR ES:[BX], AX
	XOR		AX,AX

QueryLoadAddressRet:
	POP		DS
ASSUME DS:Nothing
	POP		BP
	RET		6
QueryLoadAddress	ENDP


;* SwapXBEar(newEar): PROCEDURE WORD
;* return old ear

SwapXBEar proc far

assume ds:dgroup, es: nothing

%IF (NOT(%MF)) THEN (
;* ax, cx and si are used to store ear values.

	push bp
	mov bp,sp

	push ds			;save user's ds
	mov ax,dgroup
	mov ds,ax		;ds = os dgroup.

	mov ax,[bp+6]	;new ear value

%if(%ctosp)then(
%if(%ctosv)then(
	xor ax, ax
)else(
	push ax
	call SwapXbEarReal
)fi
)else(

	mov cx,ax

	mov si,opcbRun
	mov si, [si+16]	;si = oExPcb
	xchg [si+4],cx	;new ear value into ExPcb.ear, old one into cx

%IF(0) THEN (
	cmp processorType, NewGen
	jne SwapXbEarWriteEar
	cmp videoType, internalGC003Hdw
	jne SwapXbEarWriteEar

;NewGen

	mov si,ax				;save new ear in si

	mov dx,ParityEnablePortNGen
	in dx,al

	cmp si, wEarNewgenGc003Fake
	jne SwapXbEarNewgenVideoOff

;* Turn newgen video on

	or al,newgenVideoBit
	out dx,al
	jmp short SwapXbEarPastWriteEar		;* Do not write to ear port.

SwapXbEarNewgenVideoOff:

	and al, NOT newgenVideoBit
	out dx,al
	mov ax,si					;* ax = new ear - write it out.
)FI

SwapXbEarWriteEar:

	or ax,ax		;if new ear value <> 0, write it into ear
	je SwapXbEarPastWriteEar


	mov dx,earPort
	out dx,ax		;new ear value into ear

SwapXbEarPastWriteEar:
	xchg ax,cx		;ax = old ear, return it.
)fi
	pop ds
	leave
) ELSE (%' MF
	XOR AX,AX		; No ear, return 0 and ignore argument on Srp.
)FI
	ret 2

SwapXBEar endp


public DbgBmPutCharCall
public DbgBmScrollCall
DbgBmScrollCall proc far
iScDbgScroll EQU 121
assume ds: dgroup
	push bp
	mov bp,sp
	xor cx,cx
	mov ax, 7
	cmp cpOsSubTable, iScDbgScroll
	jb  DbgScrollRet
	push word ptr [OsSubTable+iScDbgScroll*4+2]
	push word ptr [OsSubTable+iScDbgScroll*4]
	push ds
; switch stack
	mov ax, ss
	mov es, ax
	mov bx, sp
; es:bx = old ss:sp
	mov di, CrashSeg
	mov ss, di
	mov ds, di ; 3.x VAM faults if ss <> ds
assume ds: nothing
	mov sp, offset crashStackTop
	push es
	push bx
	call dword ptr es:[bx+2]
	pop bx
	pop es
; restore stack
	mov sp, bx
	mov bx, es
	mov ss, bx
	pop ds
	add sp, 4
DbgScrollRet:
	pop bp
	ret
DbgBmScrollCall endp


; Since VAM is a stack hog, always switch stacks before calling. Also, 3.x 
; character map VAM must run with ss = ds otherwise it faults.
DbgBmPutCharCall proc far
iScDbgPutChars EQU 120
assume ds: dgroup
	push bp
	mov bp,sp
	mov ax, 7
	cmp cpOsSubTable, iScDbgPutChars
	jb  DbgVidRet

	push word ptr [OsSubTable+iScDbgPutChars*4+2]
	push word ptr [OsSubTable+iScDbgPutChars*4]
	push ds

; switch stack
	mov ax, ss
	mov es, ax
	mov bx, sp
; es:bx = old ss:sp
	mov ax, CrashSeg
	mov ss, ax
	mov ds, ax 	; VAM faults if ds <> ss
	mov sp, offset crashStackTop
; copy args
	push es						; old ss
	push bx						; old sp
	push word ptr es:[bx+14h]	; col
	push word ptr es:[bx+12h]	; row
	push word ptr es:[bx+10h]	; sa
	push word ptr es:[bx+0eh]	; ra
	push word ptr es:[bx+0ch]	; cbBuf
	call dword ptr es:[bx+2]	; pProc
	pop cx						; old sp
	pop bx						; old ss
	mov sp, cx
	mov ss, bx
	pop ds	
	add sp, 4					; discard saved pProc
assume ds: dgroup
DbgVidRet label near
	pop bp
	ret 10
DbgBmPutCharCall endp


%IF (%MF) THEN (
;
;	QueueCliPort: PROCEDURE (b);
;
QueueCliPort PROC NEAR
b 			EQU BYTE PTR [BP+4]
lExchCli 	EQU 16
ASSUME DS:Nothing
	PUSH BP
	MOV BP, SP
	SUB SP, 4
	MOV AX, Dgroup
	MOV ES, AX
ASSUME ES:Dgroup
	TEST fCliPortAvail, 1
	JZ QueueCliPortRet
	CMP fBufOutOverFlow, 0
	JNZ WaitForBuffer
Queueit:
	MOV DI, ibBufOutPut
	MOV SI, DI
	INC SI
	AND SI, mBufOut
	CMP SI, ibBufOutTake
	JNE BufferAvailable
WaitForBuffer:
	INC fBufOutOverFlow
	PUSH lExchCli
	LEA AX, WORD PTR [BP-4]
	PUSH SS
	PUSH AX
	CALL Waitp
	MOV AX, Dgroup
	MOV ES, AX
	JMP Queueit
BufferAvailable:
	MOV AL, b
	MOV rgbBufOut[DI], AL
	MOV ibBufOutPut, SI
QueueCliPortRet:
	MOV SP, BP
	POP BP
	RET 2
QueueCliPort ENDP


Scroll PROC NEAR
ASSUME DS:NOTHING
	PUSH BP
	MOV BP, SP
	PUSH 0Ah
	CALL QueueCliPort
	PUSH 0Dh
	CALL QueueCliPort
	POP BP
	RET 
Scroll ENDP


;
;	ScrollFrame: PROCEDURE (iFrame, iLineStart, iLineMax, cLines, fUp) ercType;
;
PUBLIC ScrollFrame
ScrollFrame PROC FAR
ASSUME DS:NOTHING
	PUSH BP
	MOV BP, SP
	CALL Scroll
	XOR AX, AX
	POP BP
	RET 10
ScrollFrame ENDP


;
;	PutFrameChars: PROCEDURE (iFrame, col, row, pb, cb) ercType;
;
PUBLIC PutFrameChars
PutFrameChars PROC FAR
ASSUME DS:NOTHING
cb 	EQU WORD PTR [BP+6]
pb  EQU DWORD PTR [BP+8]
row	EQU BYTE PTR [BP+12]
col	EQU BYTE PTR [BP+14]
	PUSH BP
	MOV BP, SP
	PUSH DS
	CMP cb, 0
	JE PutFrameCharsRet
	LDS SI, pb
PutChar:
	CLD
	LODSB
	PUSH SI
	CMP AL, 0Ah
	JNE NotCR
	CALL Scroll
	JMP SHORT NextChar
NotCR:
	PUSH AX
	CALL QueueCliPort
NextChar:
	POP SI
	DEC cb
	JNZ PutChar

PutFrameCharsRet:
	XOR AX, AX
	POP DS
	POP BP
	RET 12
PutFrameChars ENDP



)FI



%IF(NOT %Vp) THEN (

;
; LockVid.Asm --
;
;	 The video semaphore is a read/modify structure which allows any number
;	 of programs read access to the video structures, but only one user to
;	 have modify access.  Read access is through the two routines:
;
;			LockVideo
;			UnLockVideo
;
;    Modify access is limited to one caller at a time and is through the
;	 routines:
;
;			LockVideoForModify;
;			UnLockVideoForModify;
;
;	 In addition, there are two termination routines available:
;
;			TerminateVidLock(userNum): ErcType;
;			{QueryVidUserCount(prgUserNumRet,srgUserNumMax): ErcType;}
;
;	 The TerminateVidLock routine is called by the termination process, and
;	 the QueryVidUserCount routine is to allow the Context Manager to find
;	 out who has read locks in case of a software problem.
;
; AUTHOR --
;	Jeff Krause
;	June 2, 1983
;
; MODIFICATIONS --
;
;	7/8/83	JK	Change names and cleanup
;	7/12/83	JK	Change to Read/Modify semaphores
;	7/26/83 JA	Use BP properly.
;

;extrn KWait: far
;extrn KSend: far
;extrn Crash: far
;extrn ErrorExit: far

ercTooManyUnLocks EQU 508
ercWrongMessage EQU 509
ercTooManyLocks EQU 510

VidSemSaRead EQU 'Jk'
VidSemRaRead EQU 'jA'
VidSemSaModifier EQU 'WH'
VidSemRaModifier EQU 'db'

Data segment public 'data'

;extrn oPcbRun: word

;PUBLIC LockVidStruct
LockVidStruct label byte
LockVidExchange DW 27
vUserReadCount DW 0
vUserWaitCount DW 0
fLocked DB 0
EXTRN	rgUserReadCount:BYTE	;in Sysgen.Mdf
EXTRN	rgUserWaitCount:BYTE


Data ends
DGroup group data

LockVid_Code Segment public 'Code'
saDGroup DW DGroup

assume cs: LockVid_Code
assume ds: nothing
assume ss: nothing
assume es: nothing


public LockVideo
;
; The normal execution path with CM installed is 14 instructions:
;
;	push ds
;	mov ds, saDGroup
;	mov bx, oPcbRun
;	mov si, [bx+14]
;	cmp si, 1
;	je y
;	cli
;	cmp fLocked, 0
;	je x
;
;x:	inc rgUserReadCount[si]
;	inc vUserReadCount
;	sti
;	pop ds
;	ret
;
; The normal execution path with no CM is 8 instructions:
;
;	push ds
;	mov ds, saDGroup
;	mov bx, oPcbRun
;	mov si, [bx+14]
;	cmp si, 1
;	je x
;
;x:	pop ds
;	ret
;

LockVideo proc far
	push ds
	mov ds, saDGroup
	assume ds:DGroup

	mov bx, oPcbRun		; get user number
	mov si, [bx+pcbUserNum]
	cmp si, userNumPrimary
	je LockVideoCmExit

	cli

	cmp fLocked, 0		; no wait if not locked
	je LockVideoNoWaitExit

	inc rgUserWaitCount[si]
	inc vUserWaitCount
	
	push bp
	mov bp,sp
	push ax
	push ax				; reserve space on stack for pMsgRet
	push LockVidExchange
	lea ax, [bp-4]		; push ppMsgRet, which points to space on stack
	push ss
	push ax
	call KWait
	pop cx
	pop dx
	pop bp

;	rgUserWaitCound[si], vUserWaitCount are decremented in
;	 UnlockVideoForModify where Send is done.
;	rgUserReadCound[si], vUserReadCount are incremented in
;	 UnlockVideoForModify where Send is done.

	cmp dx, VidSemSaRead		; see if pMsgRet is valid
	jne LockVideoError
	cmp	cx, VidSemRaRead
	je LockVideoExit

LockVideoError:
	mov ax, ercWrongMessage
	push ax
	call ErrorExit

LockVideoNoWaitExit:
	inc rgUserReadCount[si]
	inc vUserReadCount

LockVideoExit:
	sti

LockVideoCmExit:
	pop ds
	assume ds: nothing
	ret
LockVideo endp
public UnLockVideo
;
; The normal execution path with CM installed is 17 instructions:
;
;	push ds
;	mov ds, saDGroup
;	mov bx, oPcbRun
;	mov si, [bx+14]
;	cmp si, 1
;	je y
;	cli
;	sub rgUserReadCount[si], 1
;	jb UnLockVideoError
;	sub vUserReadCount, 1
;	jb UnLockVideoError
;	ja UnLockVideoExit
;	cmp fLocked, 0
;	je x
;
;x:	sti
;	pop ds
;	ret
;
; The normal execution path with no CM is 8 instructions:
;
;	push ds
;	mov ds, saDGroup
;	mov bx, oPcbRun
;	mov si, [bx+14]
;	cmp si, 1
;	je x
;
;x:	pop ds
;	ret
;
UnLockVideo proc far
	push ds
	mov ds, saDGroup
	assume ds:DGroup

	mov bx, oPcbRun			; get user number
	mov si, [bx+14]
	cmp si, 1
	je UnLockVideoCmExit

	cli

	sub rgUserReadCount[si], 1
	jb UnLockVideoError
	sub vUserReadCount, 1
	jb UnLockVideoError

	ja UnLockVideoExit		; wake up modifier if locked and use count = 0
	cmp fLocked, 0
	je UnLockVideoStiExit
	push LockVidExchange
	mov ax, VidSemSaModifier
	push ax
	mov ax, VidSemRaModifier
	push ax
	call KSend
	jmp short UnLockVideoResetPrio

UnLockVideoError:
	mov ax, ercTooManyUnLocks
	push ax
	call ErrorExit

UnLockVideoExit:
	cmp fLocked, 0
	je UnLockVideoStiExit

UnLockVideoResetPrio:
	sti		; safe to sti early
	mov bx, oPcbRun			; get my userNum
	push	[bx+pcbUserNum]
	xor	bx, bx
	push	bx	;restore
	call	SetUserPrio	;(userNum, 0)

UnLockVideoStiExit:
	sti
UnLockVideoCmExit:
	pop ds
	assume ds: nothing
	ret
UnLockVideo endp

public LockVideoForModify

LockVideoForModify proc far
	push ds
	mov ds, saDGroup
	assume ds:DGroup

	cli
	cmp fLocked, 0
	jne LockVideoFMLockError
	mov fLocked, 0FFh
	
	cmp vUserReadCount, 0
	je LockVideoFMExit
	sti

;	Raise priority of all processes owning Lock.
;	They must run next, else we risk deadlock or bad performance.

	mov	bx, nUcb
LockVideoFMNext:
	dec	bx	;userNum=nUcb-1 to 0
	js	LockVideoFMWait

	cmp rgUserReadCount[bx], 0
	je	LockVideoFMNext
	push	bx	;save loop index
    OR      BX, wMySlotBits ;needs slot for compare with pcb.userNum
	push	bx	;userNum
	mov bx, oPcbRun			; get my prio
	mov	bl, [bx+pcbPriority]
	push	bx	;prio
	call	SetUserPrio	;(userNum, prio)

	pop	bx	;restore loop index
	jmp	LockVideoFMNext

LockVideoFMWait:

	push bp
	mov bp,sp
	push ax
	push ax				; reserve space on stack for pMsgRet
	push LockVidExchange
	lea ax, [bp-4]		; push ppMsgRet, which points to space on stack
	push ss
	push ax
	call KWait
	pop cx
	pop dx
	pop bp

	cmp dx, VidSemSaModifier		; see if pMsgRet is valid
	jne LockVideoFMWaitError
	cmp	cx, VidSemRaModifier
	je LockVideoFMExit

LockVideoFMWaitError:
	mov ax, ercWrongMessage
	push ax
	call Crash

LockVideoFMLockError:
	mov ax, ercTooManyLocks
	push ax
	call Crash

LockVideoFMExit:
	sti
	pop ds
	assume ds: nothing
	ret
LockVideoForModify endp
public UnLockVideoForModify

UnLockVideoForModify proc far
	push ds
	mov ds, saDGroup
	mov es, saDGroup
	assume ds:DGroup, es:DGroup

	cli

	cmp fLocked, 0FFh
	jne UnLockVideoFMError
	mov fLocked, 0			; Unlock
	cmp	vUserWaitCount, 0
	je UnLockVideoFMExit

;	Copy wait counts to read counts
	mov	cx, nUcb
	mov	si, OFFSET DGroup:rgUserWaitCount
	mov	di, OFFSET DGroup:rgUserReadCount
	cld
rep	movsb	;ES set to DGroup by SysComSubr interface.
;
;	Zero wait counts, then send wakeup msgs.
	mov	cx, nUcb
	mov	di, OFFSET DGroup:rgUserWaitCount
	mov	al, 0
rep	stosb	;ES set to DGroup by SysComSubr interface.

	xchg cx, vUserWaitCount	; cx was left = 0
	mov vUserReadCount, cx

UnLockVideoFMKSendLoop:
	push cx
	push LockVidExchange
	mov ax, VidSemSaRead
	push ax
	mov ax, VidSemRaRead
	push ax
	call KSend
	pop cx
	loop UnLockVideoFMKSendLoop
	jmp short UnLockVideoFMExit

UnLockVideoFMError:
	mov ax, ercTooManyLocks
	push ax
	call Crash

UnLockVideoFMExit:
	sti

	pop ds
	assume ds: nothing, es: nothing
	ret
UnLockVideoForModify endp
public TerminateVidLock
assume ds:DGroup
TerminateVidLock proc far
	push bp
	mov bp, sp

	mov si, word ptr [bp+6]				; user number parameter
	cmp si, 1
	je TerminateVidLockExit

	xor ax, ax
	xchg al, rgUserWaitCount[si]		; cleanup wait counts
	sub vUserWaitCount, ax
	xor ax, ax
	xchg al, rgUserReadCount[si]		; cleanup read counts
	sub vUserReadCount, ax
	jnz TerminateVidLockExit
	cmp ax, 0
	je 	TerminateVidLockExit			; wakeup modifier if neccessary
	cmp fLocked, 0
	je TerminateVidLockExit

	push LockVidExchange
	mov ax, VidSemSaModifier
	push ax
	mov ax, VidSemRaModifier
	push ax
	call KSend

TerminateVidLockExit:
	xor ax, ax
	pop bp
	ret 2
TerminateVidLock endp



SK03   SEGMENT AT (0FFCFh)
        ORG     (51Ch)
KInt_ChangeProcPrio	label far
SK03	ENDS


SetUserPrio	PROC NEAR	;(userNum, prio or 0=restore)
argUserNum	EQU	6
argPrio		EQU	4
push	bp
mov	bp, sp

xor	bx, bx

loopPcb:
push	[bp+argUserNum]
push	bx
call	ONextUserPcb
or		ax, ax
jz		endLoopPcb
mov		bx, ax
push	bx

push	bx	;pid
mov	ah, [bx+pcbPriority]
mov	bx, [bx+pcboExPcb]
sub		ah, [bx+exPcbDeltaPriority]	;un-apply deltaPriority
xchg	ah, [bx+exPcbSavedPriority]	;save pcbPrio, read old exPcbSavedPrio
mov	al, [bp+argPrio]	;prio
or	al, al
jnz	pushal

;0=restore exPcbSavedPrio
mov	al, ah

pushal:
push	ax
call	KInt_ChangeProcPrio	;doesn't use public name so stack ops work

pop		bx
jmp		short loopPcb

endLoopPcb:
pop	bp
ret	4

SetUserPrio	ENDP

LockVid_Code ends
)FI%' NOT Vp


raP EQU  [BP+6]
saP EQU  [BP+8]

;LockDecByte: PROCEDURE(p) PUBLIC;  DECLARE  p POINTER;  END;
LockDecByte PROC FAR
	PUSH BP
	MOV  BP, SP
	MOV  DI, raP
	MOV  AX, saP
	MOV  ES, AX
	LOCK DEC ES: byte ptr [DI]
	POP  BP
	RET  4
LockDecByte ENDP

;LockDecWord: PROCEDURE(p) PUBLIC;  DECLARE  p POINTER;  END;
LockDecWord PROC FAR
	PUSH BP
	MOV  BP, SP
	MOV  DI, raP
	MOV  AX, saP
	MOV  ES, AX
	LOCK DEC ES: word ptr [DI]
	POP  BP
	RET  4
LockDecWord ENDP

;LockIncByte: PROCEDURE(p) PUBLIC;  DECLARE  p POINTER;  END;
LockIncByte PROC FAR
	PUSH BP
	MOV  BP, SP
	MOV  DI, raP
	MOV  AX, saP
	MOV  ES, AX
	LOCK INC ES: byte ptr [DI]
	POP  BP
	RET  4
LockIncByte ENDP

;LockIncWord: PROCEDURE(p) PUBLIC;  DECLARE  p POINTER;  END;
LockIncWord PROC FAR
	PUSH BP
	MOV  BP, SP
	MOV  DI, raP
	MOV  AX, saP
	MOV  ES, AX
	LOCK INC ES: word ptr [DI]
	POP  BP
	RET  4
LockIncWord ENDP

%if(%ctosv)then(
$MOD386
;WFetchTid: PROCEDURE WORD
; fast fetch of thread id used by PM
WFetchTid PROC FAR
PUBLIC WFetchTid
	STR  AX	
	SUB  AX, 8
	MOV  FS, AX
	MOV  AX, FS:[rTss386Os2Tid]
	RET  
WFetchTid ENDP
$MOD286
)fi



$MOD386

PUBLIC DwellPitHandler
DwellPitHandler PROC FAR
; DwellPitHandler is timer ISR used to calibrate Dwell. When the interrupt
; occurs, clear DwellCalibrate's CX which terminates the calibration.
ASSUME DS:Nothing
	ENTER 0, 0
	PUSH  Dgroup
	POP   DS
ASSUME DS:Dgroup
	LES	  BX, pDwellCx
	MOV   ES:WORD PTR [BX], 0
	LEAVE
	RET
DwellPitHandler ENDP


PUBLIC DwellCalibrate 
DwellCalibrate PROC FAR
; DwellCalibrate is called from immed after a 102400us PIT is started. When 
; the PIT fires, its clears our CX, terminating the calibration. The 
; calibration counter is then reduced to provide 100us intervals for Dwell.
ASSUME DS:Nothing
	ENTER 0, 0
	MOV   CL, 1			; PIT handler clear CX to terminate DwellSub 
	PUSH  Dgroup
	POP	  ES
ASSUME ES:Dgroup
	MOV   EAX, 0ffffffffh
	MOV   qbDwell, EAX
; DwellSub counts down qbDwell, expects EAX = c100us
	CALL  DwellSub
; EBX contains the complement of the loop counter
	NOT   EBX
; reduce counter of 102400us giving 100us counter
	SHR	  EBX, 10
	MOV	  qbDwell, EBX
; qbDwell = number of times DwellSub runs in 100us
	MOV   fDwellReady, 0ffh
	LEAVE 
	RET
DwellCalibrate ENDP

;
; Dwell: PROCEDURE (c100us) PUBLIC REENTRANT
;  	Dwell provides real-time 100us busy wait loops.
;
;   qbDwell has been calibrated by PIT to make DwellLoop run in 16us.
PUBLIC Dwell
Dwell PROC FAR
cUs		EQU WORD PTR [BP+6]
ASSUME DS:Nothing
	ENTER 0, 0
	MOV   CL, 1			; cx <> 0 means not a calibration test
	PUSH  Dgroup
	POP	  ES
	TEST  fDwellReady, 1
	JZ	  DwellNotInitialized
ASSUME DS:Dgroup
	MOV   AX, cUs
	CALL  DwellSub
	LEAVE
	RET   2
DwellNotInitialized:
; Dwell was called before it was calibrated.
	PUSH  7
	CALL  Crash
	
Dwell ENDP


PUBLIC DwellSub
DwellSub PROC NEAR
; assume AX = c100us
;   qbDwell has been calibrated to execute dsLoop in 100us.
ASSUME ES:Dgroup
ASSUME DS:Nothing
dsNextUSec:
	SUB	  AX, 1
	JC    dsRet
	MOV	  EBX, qbDwell
dsLoop:				; instruction-identical to DcLoop above
	SUB	  EBX, 1
	JC	  dsNextUSec
	JCXZ  dsRet		; PIT clears CX to terminate calibration
	JMP	  SHORT dsLoop
dsRet:
	RET   
DwellSub ENDP


ScUtil		ENDS
END
;
; History
; 02/10/87 JM cloned from kernel.
; 02/15/88 JA a few more PUBLICs.
; 02/29/88 JA remove SCUndefined.
; 07/20/88 JM add debugger video stub.
; 09/02/88 AT resolve slot bits in user numbers.
; ??/??/?? ??? removed SwapDebuggerVideo, etc.
; 09/14/88 MTR ExUcbs out of DGroup
; 10/20/88 KH  Merge in PS2 changes again
; 11/02/88 AT  LockDec, LockInc.
; 11/26/88 JM  QueryModel return fBig for userNumOs.
; 1/18/89  JM  GetUserNum return 1 if userNumPrimary for MP and VP case.
; 8/16/89  JA  GetModuleId for MF too (so PC Emulator works).
; 10/10/98 MTR use ONextUserPcb
; 11/01/89 GWH Removed PS2 tests in Beeper.  Now works same as Ngen.
; 11/01/89 MTR CLD!
; 11/14/89 JM  QueryModel always returns large model.
; 02/21/90 DR  ctosv, no more SwapXbEarReal
; 03/21/90 JA  remove FSrpUpProc, now in wrapped Agent.
; 03/22/90 JC  Added Bsac Support
; 09/06/90 AT  Add GetModuleAddress.
; 09/28/90 AT  GetModuleAddress must be system common for FileSystem.
; 12/05/90 AT  GetModuleAddress return 300h for SGen Video.
;              Handle blank entries in SGBusIdTable.  No SGBus on NGens.
; 12/14/90 AT  GetModuleId doesn't return erc for empty XBus+ slots.
;              This lets clients know when to stop.
; 01/15/91 DR  GetModuleAddress for SGen - first 4 slots emulate NGen.
; 02/04/91 DR  Fix Beeper for 386i; adjust beeper length based on shCpuSpeed
; 11/07/91 JM  add WFetchTid
; 03/27/92 DR  SetModuleId
; 11/06/92 KK  Added EISA Support; GetEisaBusInfo, GetModuleID,
;              and GetModuleAddress
; 01/19/93 KK  In GetEisaBusInfo return sbType containing name of EISA CFG
;              file entered in config.sys.
; 03/30/93 JM  Add Dwell.
; 05/04/93 KK  Removed GetEisaBusInfo, it is now a request.
; 05/14/93 JA  Add ReturnOk6Args.
; 06/22/93 KK  Update GetModuleID to work with expanded EISA Config Table.
; 07/07/93 JA  Add ReturnOk10Args.
