;	PrinterInt_all.asm

%SET(FS,0)
$INCLUDE(:f1:ioaddr1.edf)
$INCLUDE(:f1:vfEqu.idf)

; ControlInterrupt values
bOpEnable 		EQU 0
bOpDisable 		EQU 1
tyLPT 			EQU 5
clearLptIntMF	EQU	190h		; printer int on GP

PUBLIC	LpInterrupt, pLpIsr, saDsLpIsr, lpUserNum
%if(%ctosp)then(
PUBLIC  ldtrLpUser
EXTRN   SetLdtrDs:far
)fi
EXTRN sc_FloppyInterruptSubr: FAR, ControlInterrupt: FAR

Data	Segment PUBLIC 'Data'
DGroup	GROUP	Data

EXTRN	vf: BYTE
EXTRN	LptIntClear: WORD

; Set up by request SetLpIsr
pLpIsr		DD	0
saDsLpIsr	DW	0
lpUserNum	DW	0FFFFh
%if(%ctosp)then(
ldtrLpUser  DW  0
)fi
EVEN

Data	ENDS

;********************************************
; Line Printer interrupt dispatch routine   *
;********************************************

LpCode	SEGMENT	PUBLIC	'Code'
ASSUME CS:LpCode, DS:DGroup

LpInterrupt	PROC	FAR
	test  vf_fNewgen, 1				; Newgen shares floppy and printer int
	jz    ChkLpIsr					; check floppy only if Newgen

; Read the newgen status port.  Check for printer interrupting.  If printer
; is interrupting then bypass the floppy altogether.  
	mov   dx, IntMonFlopPort  		;(This port NOT in NgenPortsStructure)
	in    al,dx                		;
	test  al,40h             		;is printer interrupting?
	jnz	  ChkLpIsr

; Since Printer is not interrupting, the interrupt must be for the floppy.
	Call  sc_FloppyInterruptSubr	;check floppies
	ret                     		;were outa here.

ChkLpIsr:
	cmp	  word ptr pLpIsr, 0		;Check if ISR committed yet
	jne	  LpDispatch				;jif not NIL
	cmp   word ptr pLpIsr+2, 0		;
	jne	  LpDispatch				;jif not NIL

; Bogus printer interrupt. Clear the lpt interrupt latch.
	mov   dx, LptIntClear	 		;Clear interrupt
	mov   al, 1						;
	out   dx,al						;
	ret        						;Return-- Interrupts NOT masked!

;MaskLPT:
;	push  tyLPT
;	push  bOpDisable
;	call  ControlInterrupt
;	ret


LpDispatch:
; We got a printer interrupt and pLpIsr is committed.  Dispatch.
%if(%ctosp)then(
	mov   ax, ldtrLpUser
	or    ax, ax
	je    LpDispatchGDT
; LDT case
	push  ax
	push  saDsLpIsr
	call  SetLdtrDs
	mov   ax, DGroup
	mov   es, ax
	lea   bx, pLpIsr
	call  dword ptr es:[bx]
	xor   ax, ax
	push  ax
	push  DGroup
	call  SetLdtrDs
	ret
)fi
LpDispatchGDT:
	lea	  BX, pLpIsr
	mov	  AX, DS
	mov	  ES, AX
	mov	  AX, saDsLpIsr
	mov	  DS, AX
	jmp	  DWORD PTR ES: [BX]
LpInterrupt	ENDP


LpCode	ENDS

END

; LOG
; 2/1/83 by MO created
; 1/11/84 by JA use lock on out to DMA0
; 1/29/84 MO
; add eoi code for t2 and 8086 NGens
; change hardwareType to processorType
; 8/10/86 by FW for NewGen.
; 11/3/86 by JA FloppyInterruptSubr.
; 11/18/86 by DR ctosp, rename modules
;	CTOS 2.3
; 2/15/88 by JA use sc_
; 9/1/88 by JA use ControlInterrupt
; 9/30/88 by JA add SetUpLpIsr (for Bull?)
; 10/5/88 by JA removed SetUpLpIsr to ParallelIO_all.plm.
; 05/10/89 by RLM port code for GP's.
; 04/15/91 by FW Leave interrupt unmasked on 286i/386i's.
; 04/17/91 by FW Use LptIntClear (from NgenPortsStructure) instead of
;                hard coded I/O addresses to clear the printer interrupt.
; 08/16/91 by AT Don't disable interrupt when spurious.  Never gets re-enabled
;                in ParallelIo_all.plm if already done SetLpIsr.
; 04/07/92 by GWH Fix concurrent floppy and lpt interrupt activity on the 
;    			  newgen
