$Mod286
;
; Cacher Utility code
;
public %'ListDelete, ListInsert,' CacheFind

CacherUtil segment public 'CODE'
assume cs: CacherUtil

%IF(0) THEN (%' Moved to CommonSubs_all.asm
;
; ListDelete: procedure (pEnt)
;
; Remove the entry from a doubly-linked list.  Pointers are sn:ra16.
; Selector$Of (pEnt.pNext) = 0, to mark as deleted (and trap double-delete).
;
; GP fault on bogus linkage.
; Mutual exclusion is caller's business.
; All registers hosed.
;
ListDelete proc far

pEnt        equ dword ptr [bp+6]
sArgs       equ 4

    push    BP
    mov     BP, SP
    push    DS

    lds     SI, pEnt                ;ds:si = pEnt
    les     DI, dword ptr DS:[SI]   ;es:di = pNext

    mov     BX, DS:[SI+4]           ;ax:bx = ent.pPrev
    mov     AX, DS:[SI+6]

    mov     word ptr DS:[SI+2], 0   ;selector$of(ent.pNext) = 0
    
    mov     ES:[DI+4], BX           ;next.pPrev = ent.pPrev
    mov     ES:[DI+6], AX
    
    mov     DS, AX                  ;ds:bx = pPrev
    
    mov     DS:[BX], DI             ;prev.pNext = ent.pNext
    mov     DS:[BX+2], ES

    pop     DS
    pop     BP
    ret     sArgs
ListDelete endp

;
; ListInsert: procedure (pPrev, pEnt)
;
; Append an entry onto a doubly-linked list.  Pointers are sn:ra16.
;
; GP fault on bogus linkage or if Selector$Of (pEnt.pNext) <> 0 (double-insert).
; Mutual exclusion is caller's business.
; All registers hosed.
;
ListInsert proc far

pPrev       equ dword ptr [bp+10]
pEnt        equ dword ptr [bp+6]
sArgs       equ 8

    push    BP
    mov     BP, SP
    push    DS

    lds     SI, pPrev               ;ds:si = pPrev
    les     DI, pEnt                ;es:di = pEnt
    mov     BX, DS:[SI]             ;ax:bx = prev.pNext
    mov     AX, DS:[SI+2]
    
    cmp     word ptr ES:[DI+2], 0   ;if selector$of(ent.pNext) <> 0
    jne     ListInsertBogus
    
    mov     ES:[DI], BX             ;ent.pNext = prev.pNext
    mov     ES:[DI+2], AX
    
    mov     DS:[SI], DI             ;prev.pNext = pEnt
    mov     DS:[SI+2], ES
    
    mov     ES:[DI+4], SI           ;ent.pPrev = pPrev
    mov     ES:[DI+6], DS
    
    mov     DS, AX                  ;ds:bx = pNext
    mov     DS:[BX+4], DI           ;next.pPrev = pEnt
    mov     DS:[BX+6], ES

ListInsertRet:
    pop     DS
    pop     BP
    ret     sArgs

public ListInsertBogus
ListInsertBogus:
    or      CX, 0FFFFh
    mov     ES, CX                  ;gp fault
    jmp     ListInsertRet
ListInsert endp
)FI

;
; CacheFind: procedure (pCid, pCpd, opCedRet, opChlRet) ErcType
;
; Given a cache id and cache pool descriptor, deposit the corresponding
; cache entry descriptor in pCedRet (hash the cid to the appropriate chl,
; and scan each ced on the chl for ced.cid = cid).
;
; If the appropriate ced can't be found, return ercNoSuchCacheEntry; else ercOk.
;
; A pointer to the hash list head appropriate for cid is deposited in ChlRet.
;
; Mutual exclusion is caller's business.
; All registers hosed.
;
CacheFind proc far

pCid                equ dword ptr [bp+14]
pCpd                equ dword ptr [bp+10]
opCedRet            equ  word ptr [bp+8]
opChlRet            equ  word ptr [bp+6]
sArgs               equ 12

; these must agree with 'CacherTypes.Edf'!
lcbCid              equ 8
lcwCid              equ 4
nChl                equ 131
loCpdRgChl          equ 28    ; offset to first chl in cpd
loCedHash           equ 12    ; offset to hash thread in ced
loHashRgCid         equ 8     ; offset to cid from hash thread
ercOk               equ 0
ercNoSuchCacheEntry equ 1411

    push    BP
    mov     BP, SP
    push    DS

    lds     SI, pCid               ;ds:si=pCid
    mov     BX, SI                 ;ds:bx=@rgbCid(i)

; sum the hash key
    mov     CX, lcbCid
    xor     AX, AX
cfHashIt:
    add     AL, byte ptr DS:[BX]
    inc     BX
    loop    cfHashIt

; hash the summed key to the appropriate Cache Hash List & set pChlRet
    mov     BL, nChl
    div     BL                     ;ax/bl -> al=q, ah=r
    shr     AX, 5
    and     AL, 0F8h               ;ax=oRgChl(hash(cid))-oRgChl(0)

    les     DI, pCpd               ;es:di=pCpd
    add     DI, loCpdRgChl         ;      pRgChl(0)
    add     DI, AX                 ;      pChl

    mov     BX, opChlRet           ;pChlRet=pChl
    mov     SS:[BX], DI
    mov     SS:[BX+2], ES

; scan the hash list (while pCed<>pChl) for matching cache id
; let ds:si=pCid, es:di=pCedPrev, dx:bx=pChl, ax=ercRet
    mov     DX, ES                 ;dx:bx=pChl
    mov     BX, DI
 
    mov     AX, ercNoSuchCacheEntry
    cld

cfNextHashEnt:
    cmp     BX, ES:[DI]
    jne     cfTestCid
    cmp     DX, ES:[DI+2]
    je      cfRet                  ;end of list: miss

cfTestCid:
    les     DI, dword ptr ES:[DI]  ;pCed = cedPrev.pHashNext
    push    DI                     ;pwCed.ra (cmpsw hoses)
    push    SI                     ;pwCid.ra (cmpsw hoses)
    add     DI, loHashRgCid        ;es:di=@ced.rgwCid
    mov     CX, lcwCid
    repe    cmpsw
    je      cfHit

    pop     SI
    pop     DI
    jmp     cfNextHashEnt

cfHit:
    pop     SI
    pop     DI
    mov     BX, opCedRet
    sub     DI, loCedHash
    mov     SS:[BX], DI
    mov     SS:[BX+2], ES
    mov     AX, ercOk
        
cfRet:
    pop     DS
    pop     BP
    ret     sArgs
CacheFind endp

CacherUtil ends

end
;
; log
;
; 03/02/89 MTR  Created
; 05/16/89 MTR  Cpd & Ced changes for cache chaining
; 10/01/92 JA   Cpd bigger (laundry).  ListDelete, ListInsert into CommonSubs
;
