/***
*utime.h - definitions/declarations for utime()
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structure used by the utime routine to set
*	new file access and modification times.  NOTE - MS-DOS
*	does not recognize access time, so this field will
*	always be ignored and the modification time field will be
*	used to set the new time.
*	[POSIX]
*
****/

#if !defined(_UTIME_DEFINED)

#define _UTIME_DEFINED

#include <time.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* define struct used by utime() function */

struct utimbuf {
	time_t actime;		/* access time */
	time_t modtime;		/* modification time */
#if defined(_POSIX_SOURCE)
	time_t exptime;		/* expiration time */
#endif
	};


/* function prototype */

extern signed int _FAR_ _cdecl utime(const char _FAR_ *,
	const struct utimbuf _FAR_ *);

#endif /* !_UTIME_DEFINED */
