/***
*stdlib.h - declarations/definitions for commonly used library functions
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This include file contains the function declarations for
*	commonly used library functions which either don't fit somewhere
*	else, or, like toupper/tolower, can't be declared in the normal
*	place for other reasons.
*	[POSIX/ANSI]
*
****/

#if !defined(_STDLIB_DEFINED)

#define _STDLIB_DEFINED

#include <stddef.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

#if defined(_DLL)
#define _LOADDS_ _loadds
#else
#define _LOADDS_
#endif

#define EXIT_SUCCESS	0
#define EXIT_FAILURE	1

#define MB_CUR_MAX	(sizeof(wchar_t))

/* definition of the return type for the onexit() function */

#if !defined(_POSIX_SOURCE)
typedef int (_FAR_ _cdecl _LOADDS_ * _cdecl onexit_t)();
#endif


/* data structure definitions for div and ldiv runtimes. */

typedef struct _div_t {
	signed int quot;
	signed int rem;
} div_t;

typedef struct _ldiv_t {
	signed long quot;
	signed long rem;
} ldiv_t;


/* maximum value that can be returned by the rand function. */

#define RAND_MAX 0x7FFF


/* min and max macros */

#if !defined(_POSIX_SOURCE)
#define max(a,b)	(((a) > (b)) ? (a) : (b))
#define min(a,b)	(((a) < (b)) ? (a) : (b))


/* sizes for buffers used by the _makepath() and _splitpath() functions.
 * note that the sizes include space for 0-terminator
 */

#define _MAX_PATH	260	/* max. length of full pathname */
#define _MAX_DRIVE	3	/* max. length of drive component */
#define _MAX_DIR	256	/* max. length of path component */
#define _MAX_FNAME	256	/* max. length of file name component */
#define _MAX_EXT	256	/* max. length of extension component */

/* external variable declarations */

#if defined(_MT)
extern int _far * _cdecl _far volatile _errno(void);
extern unsigned _far * _cdecl _far __doserrno(void);
#define errno	    (*_errno())
#define _doserrno   (*__doserrno())
#else
extern int _near _cdecl volatile errno; 	/* XENIX style error number */
extern int _near _cdecl _doserrno;		/* MS-DOS system error value */
#endif
extern char * _near _cdecl sys_errlist[];	/* perror error message table */
extern int _near _cdecl sys_nerr;		/* # of entries in sys_errlist table */

#if defined(_DLL)
extern char ** _FAR_ _cdecl environ;		/* pointer to environment table */
extern int _FAR_ _cdecl _fmode; 		/* default file translation mode */
extern int _FAR_ _cdecl _fileinfo;		/* open file info mode (for spawn) */
#else
extern char ** _near _cdecl environ;		/* pointer to environment table */
extern int _near _cdecl _fmode; 		/* default file translation mode */
extern int _near _cdecl _fileinfo;		/* open file info mode (for spawn) */
#endif

extern unsigned int _near _cdecl _psp;		/* Program Segment Prefix */

/* OS major/minor version numbers */

extern unsigned char _near _cdecl _osmajor;
extern unsigned char _near _cdecl _osminor;

#define DOS_MODE	0	/* Real Address Mode */
#define OS2_MODE	1	/* Protected Address Mode */

extern unsigned char _near _cdecl _osmode;
#endif /* !_POSIX_SOURCE */


/* function prototypes */

#if defined(_MT)
extern double _FAR_ _pascal atof(const char _FAR_ *);
extern double _FAR_ _pascal strtod(const char _FAR_ *, char _FAR_ * _FAR_ *);
extern ldiv_t _FAR_ _pascal ldiv(signed long, signed long);
#else	/* not _MT */
extern double _FAR_ _cdecl atof(const char _FAR_ *);
extern double _FAR_ _cdecl strtod(const char _FAR_ *, char _FAR_ * _FAR_ *);
extern ldiv_t _FAR_ _cdecl ldiv(signed long, signed long);
#endif

#if !defined(_POSIX_SOURCE)
extern long double   _FAR_ _cdecl _atold(const char _FAR_ *);
extern char _FAR_ *  _FAR_ _cdecl _fullpath(char _FAR_ *, const char _FAR_ *,
	size_t);
extern unsigned long _FAR_ _cdecl _lrotl(unsigned long, signed int);
extern unsigned long _FAR_ _cdecl _lrotr(unsigned long, signed int);
extern void          _FAR_ _cdecl _makepath(char _FAR_ *, const char _FAR_ *,
	const char _FAR_ *, const char _FAR_ *, const char _FAR_ *);
extern unsigned int  _FAR_ _cdecl _rotl(unsigned int, signed int);
extern unsigned int  _FAR_ _cdecl _rotr(unsigned int, signed int);
extern void          _FAR_ _cdecl _searchenv(const char _FAR_ *,
	const char _FAR_ *, char _FAR_ *);
extern void          _FAR_ _cdecl _splitpath(const char _FAR_ *, char _FAR_ *,
	char _FAR_ *, char _FAR_ *, char _FAR_ *);
extern long double   _FAR_ _cdecl _strtold(const char _FAR_ *,
	char _FAR_ * _FAR_ *);
extern char _FAR_ *  _FAR_ _cdecl itoa(signed int, char _FAR_ *, signed int);
extern char _FAR_ *  _FAR_ _cdecl ltoa(signed long, char _FAR_ *, signed int);
extern onexit_t      _FAR_ _cdecl onexit(onexit_t);
extern void          _FAR_ _cdecl swab(char _FAR_ *, char _FAR_ *,
	signed int);
extern char _FAR_ *  _FAR_ _cdecl ultoa(unsigned long, char _FAR_ *,
	signed int);
#endif /* !_POSIX_SOURCE */
extern void          _FAR_ _cdecl _exit(signed int);
extern void          _FAR_ _cdecl abort(void);
extern signed int    _FAR_ _cdecl abs(signed int);
extern signed int    _FAR_ _cdecl atexit(void (_cdecl _FAR_ _LOADDS_ *)
	(void));
extern signed int    _FAR_ _cdecl atoi(const char _FAR_ *);
extern signed long   _FAR_ _cdecl atol(const char _FAR_ *);
extern void _FAR_ *  _FAR_ _cdecl bsearch(const void _FAR_ *,
	const void _FAR_ *, size_t, size_t, signed int (_FAR_ _cdecl *)
	(const void _FAR_ *, const void _FAR_ *));
extern void _FAR_ *  _FAR_ _cdecl calloc(size_t, size_t);
extern div_t         _FAR_ _cdecl div(signed int, signed int);
extern char _FAR_ *  _FAR_ _cdecl ecvt(double, signed int, signed int _FAR_ *,
	signed int _FAR_ *);
extern void          _FAR_ _cdecl exit(signed int);
extern char _FAR_ *  _FAR_ _cdecl fcvt(double, signed int, signed int _FAR_ *,
	signed int _FAR_ *);
extern void          _FAR_ _cdecl free(void _FAR_ *);
extern char _FAR_ *  _FAR_ _cdecl gcvt(double, signed int, char _FAR_ *);
extern char _FAR_ *  _FAR_ _cdecl getenv(const char _FAR_ *);
extern signed long   _FAR_ _cdecl labs(signed long);
extern void _FAR_ *  _FAR_ _cdecl malloc(size_t);
extern void          _FAR_ _cdecl perror(const char _FAR_ *);
extern signed int    _FAR_ _cdecl putenv(const char _FAR_ *);
extern void          _FAR_ _cdecl qsort(void _FAR_ *, size_t, size_t,
	signed int (_FAR_ _cdecl *)(const void _FAR_ *, const void _FAR_ *));
extern signed int    _FAR_ _cdecl rand(void);
extern void _FAR_ *  _FAR_ _cdecl realloc(void _FAR_ *, size_t);
extern void          _FAR_ _cdecl srand(unsigned int);
extern signed long   _FAR_ _cdecl strtol(const char _FAR_ *,
	char _FAR_ * _FAR_ *, signed int);
extern unsigned long _FAR_ _cdecl strtoul(const char _FAR_ *,
	char _FAR_ * _FAR_ *, signed int);
extern signed int    _FAR_ _cdecl system(const char _FAR_ *);

#if !defined(_POSIX_SOURCE)
#if !defined(tolower)	/* tolower has been undefined - use function */
extern signed int    _FAR_ _cdecl tolower(signed int);
#endif	/* tolower */

#if !defined(toupper)	/* toupper has been undefined - use function */
extern signed int    _FAR_ _cdecl toupper(signed int);
#endif	/* toupper */
#endif

#endif /* !_STDLIB_DEFINED */
