/***
*grp.h - function declarations for group database handling
*
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file contains the function declarations for the library functions
*	related to group database handling.
*	[POSIX]
*
****/

#if !defined(_GRP_DEFINED) && defined(_POSIX_SOURCE)

#define _GRP_DEFINED

#include <sys/types.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

struct group {
	char *gr_name;
	gid_t gr_gid;
	char **gr_mem;
	};


/* function prototypes */

extern struct group _FAR_ * _FAR_ _cdecl getgrgid(gid_t);
extern struct group _FAR_ * _FAR_ _cdecl getgrnam(const char _FAR_ *);

#endif /* !_GRP_DEFINED && _POSIX_SOURCE */
