;	InitOsMain.asm
;
$Include(:f1:Ia186Equ.edf)

IOCR			EQU	56h
hdiskControlReg	EQU	7Ah
busTimeoutOn	EQU	400h
busTimeoutOff	EQU	0FBFFh

DGroup	Group	Data

Data	SEGMENT	PUBLIC	'Data'
EXTRN	beeperPortNGen: WORD
EXTRN	qUniqueRomId: DWORD
EXTRN	vfNmiOccurred: BYTE

public vbRomVer, vbCpuVer
vbRomVer db 0
vbCpuVer db 0

fCheckHDisk	DB	0
EVEN
Data	ENDS

Stack	SEGMENT Stack	'Stack'
InitSP	LABEL	WORD
	DW	0
Stack	ENDS

EXTRN	Kinit:FAR

PUBLIC	OsEntry, CheckDisks, InitSP, SwitchInitStacks

InitOsMain_Code	SEGMENT	PUBLIC	'COED'
ASSUME	CS: InitOsMain_Code, DS: DGroup


OsEntry	PROC	FAR
	cli
	mov  AX, DGroup
	mov  DS, AX
	pop  BX							; RealNub pushes ver,id and serialized id
	mov  qUniqueRomId, BX			; Retrieve them before switching stacks
	pop  BX
	mov  qUniqueRomId+2, BX
	pop  BX
	mov  vbRomVer, BL
	mov  vbCpuVer, BH
	mov  SS, AX
	mov  SP, OFFSET DGroup: InitSP
	call KInit						; never returns
OsEntry	ENDP

CheckDisks	PROC	FAR
	xor	AX, AX
	mov	ES, AX
	mov	BX, 8h
	mov	DI, WORD PTR ES: [BX]
	mov	SI, WORD PTR ES: [BX+2]
	mov	AX, OFFSET HDiskNotExist
	mov	WORD PTR ES: [BX], AX
	mov	AX, CS
	mov	WORD PTR ES: [BX+2], AX
	mov	fCheckHDisk, 0FFh
	in	AX, IOCR
	or	AX, busTimeoutOn
	out	IOCR, AX
	mov	AL, 80h
	out	hdiskControlReg, AL
	xchg	AX, AX
	in	AX, IOCR
	and	AX, busTimeoutOff
	out	IOCR, AX
	mov	WORD PTR ES: [BX], DI
	mov	WORD PTR ES: [BX+2], SI
	ret
CheckDisks	ENDP

HDiskNotExist	PROC	FAR
	push	AX
	mov	AX, DGroup
	mov	DS, AX
	cmp	fCheckHDisk, 0
	je	@1
	mov	fCheckHDisk, 0
@1:
	pop AX
	iret
HDiskNotExist	ENDP

; NmiNopEntry is used during initialization
public NmiNopEntry
NmiNopEntry proc far
	mov vfNmiOccurred, 0FFh
	iret
NmiNopEntry endp

; the following code is for debugging protected mode initialization
public SoundBeeper
SoundBeeper proc far
;beep the beeper - works for PCs only

mov dx, 61h
in al, dx
or al, 3
out dx, al

mov ax, 10h
call DoDelay

in al, dx
and ax,0FCh
out dx, al

mov ax, 20h
call DoDelay
ret

SoundBeeper endp

DoDelay proc near
	mov cx, 0ffffh
	loop $
	dec ax
	or  ax, ax
	jnz DoDelay
	ret
DoDelay endp

SwitchInitStacks proc far

; procedure(pStack, pExitProc)
	pop ax ; discard ret addr
	pop ax ; discard ret addr
	pop si ; pExitProc.ra
	pop di ; pExitProc.sa
	pop bx ; raStack
	pop ax ; saStack
	mov ss, ax
	mov sp, bx
	mov bp, bx
	push di ; exit cs
	push si ; exit ip
	ret	
SwitchInitStacks endp

InitOsMain_Code	ENDS

END OsEntry

; LOG
; 7/30/80 RH: created
; 1/7/83  MO  make module machine independent by combining OsMain.asm,
;             AwsOsm.asm and NGen code
; 04/17/86 DR protected mode
; 05/14/86 DR SwitchInitStacks
; 01/21/88 JM merge real mode SRP.
; 02/8/88  JA remove fHDiskIn.
; 04/26/89 AT NmiNopEntry set vfNmiOccurred.
; 09/05/90 SG Store cpuID and Rom version from realnub
; 12/14/90 AT RealNub passes ver,cpuId and serialized id on stack.
