$TITLE(23 MAY 85: Subroutines for General Synchronous Communications Support)
$PAGEWIDTH(132)
$PAGELENGTH(60)
$LIST

GenSync		SEGMENT	BYTE PUBLIC 'Code'
GenSync		ENDS
Data		SEGMENT	WORD PUBLIC 'Data'
Data		ENDS

DGroup		GROUP	Data

		ASSUME	CS:GenSync
		ASSUME	DS:DGroup

		EXTRN	Timeout:FAR,RequestHandler:FAR,ResponseHandler:FAR
		EXTRN	TxISR:FAR,ExtISR:FAR,RxISR:FAR,SpRxISR:FAR

Data		SEGMENT
		PUBLIC	pTimeout,pRequestHandler,pResponseHandler
		PUBLIC	pTxISR,pExtISR,pRxISR,pSpRxISR

pTimeout	DD	Timeout
pRequestHandler DD	RequestHandler
pResponseHandler DD	ResponseHandler
pTxISREntry	DD	TxISR
pExtISREntry	DD	ExtISR
pRxISREntry	DD	RxISR
pSpRxISREntry	DD	SpRxISR
pTxISR		DD	TxInt
pExtISR		DD	ExtInt
pRxISR		DD	RxInt
pSpRxISR	DD	SpRxInt
		DB	1024 DUP(?)
CommISRStack	EQU	THIS WORD

Data		ENDS
$EJECT

GenSync		SEGMENT
		PUBLIC	Disable,Enable
		PUBLIC	Input,Output,InWord,OutWord

CommInterrupt	PROC	FAR
TxInt:		MOV	BX,OFFSET DGroup:pTxISREntry
		JMP	SHORT CheckStack

ExtInt:		MOV	BX,OFFSET DGroup:pExtISREntry
		JMP	SHORT CheckStack

RxInt:		MOV	BX,OFFSET DGroup:pRxISREntry
		JMP	SHORT CheckStack

SpRxInt:	MOV	BX,OFFSET DGroup:pSpRxISREntry

CheckStack:	MOV	AX,SS		;First see which stack we're using
		CMP	AX,DGroup	;Our own?
		 JNE	SHORT SwitchStack	;No, go switch so that DS = SS
		JMP	DWORD PTR [BX]	;OK as is, proceed directly to routine

SwitchStack:	PUSH	BP
		MOV	BP,SP
		MOV	AX,[BP+6]	;AX = iLine parameter for ISR
		MOV	CX,SS		;Save current SS:SP...
		MOV	DX,SP
		MOV	SI,DGroup	;And establish our own with DS = SS
		MOV	SS,SI
		MOV	SP,OFFSET DGroup:CommISRStack
		PUSH	CX		;Now push old SS:SP onto our stack
		PUSH	DX
		PUSH	AX		;Lastly, set up iLine for called ISR
		CALL	DWORD PTR [BX]
		POP	DX
		POP	CX
		MOV	SS,CX		;Restore original interrupted stack
		MOV	SP,DX
		POP	BP
		RET	2		;Allowance for iLine on the stack
CommInterrupt	ENDP

Disable		PROC	FAR
		CLI		;Disable interrupts
		RET
Disable		ENDP

Enable		PROC	FAR
		STI		;Reenable interrupts
		RET
Enable		ENDP

Input		PROC	FAR
		PUSH	BP
		MOV	BP,SP
		MOV	DX,WORD PTR [BP+6]
		JMP	.+2
		IN	AL,DX
		POP	BP
		RET	2
Input		ENDP

Output		PROC	FAR
		PUSH	BP
		MOV	BP,SP
		MOV	AX,WORD PTR [BP+6]
		MOV	DX,WORD PTR [BP+8]
		JMP	.+2
		OUT	AL,DX
		POP	BP
		RET	4
Output		ENDP

InWord		PROC	FAR
		PUSH	BP
		MOV	BP,SP
		MOV	DX,WORD PTR [BP+6]
		JMP	.+2
		LOCK IN	AX,DX
		POP	BP
		RET	2
InWord		ENDP

OutWord		PROC	FAR
		PUSH	BP
		MOV	BP,SP
		MOV	AX,WORD PTR [BP+6]
		MOV	DX,WORD PTR [BP+8]
		JMP	.+2
		LOCK OUT AX,DX
		POP	BP
		RET	4
OutWord		ENDP

GenSync		ENDS

		END
