;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: Sysgen.asm                                                          *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: CTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* System generation variables.                                              *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;*                                                                           *;
;* TITLE:  CTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1990 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;


; The files "SysGen.Mdf" and "SysGen_Common.mdf" contain the definitions for 
; the macros which are used in this file, "SysGen.Asm". The intent is to make 
; changing the system build parameters as painless as possible, and so this 
; file has been created using macros which provide a high degree of 
; readability and allow the user to ignore the Assembly language constructs 
; which are actually generated. The prefix files and SysGen.Asm contain macros 
; which generate several types of data:
;
;     1. "Static" tables and variables which are allocated at link time.
;        These may be part of "DGroup", or they may be in other segments.
;     2. "Dynamic" tables and variables which are allocated at run time.
;        These also may be in "DGroup" or other segments.
;     3. "Initial" tables and variables which will be discarded after CTOS
;        initialization is completed.
;
; CONFIGURATION -- 
; This module uses several macro symbols to determine the configuration which
; is to be built.  The prefix files (e.g. pSrvrM.Asm, pClstr.Asm, FsM_N.asm)
; set these symbols, and then include the SysGen.Asm, SysGen.Mdf and 
; SysGen_Common.mdf modules.  When invoking the Assembler, list only the name 
; of the prefix file.
;
; DEBUGGER OPTIONS --       
; To simplify removal of the optional debugger, the flag fDebugger is used.
; This is set to TRUE (1) unless the prefix file sets it explicitly.  To
; remove the debugger, set the flag to FALSE (0) in the appropriate prefix
; file.  NOTE: You must also change the appropriate .fls file (e.g. 
; pSrvrM.fls) as described in the "Building a Customized CTOS" section of the 
; CTOS System Administration Guide or CTOS II 3.3 Software Release 
; Announcement (SRA).
;
; NOTES FOR CHANGING THIS FILE --
;
; Please be aware that in the Convergent Assembly language there are two types 
; of comments, normal comments, (any text on a line after a ";" character),  
; and a macro comment (%' text ').  It is not possible to "comment out" a 
; macro by inserting a ";" in front of it.  You may comment out a macro by 
; replacing the percent sign in the call with a ";" or by preceeding the call 
; with "%'".  This will cause the macro processor to ignore any text up to and 
; including the next "'" or RETURN (0Ah) character, whichever comes first. 
; Macro calls must not be mixed.  In general the invocation of a macro causes 
; an entry to be added to a table, and mixing macro calls would result in 
; scrambled tables.
;
; In most cases, you will not change this file at all, but rather will change 
; the SET macros contained in the prefix file (e.g. pSrvrL.Asm or FsL_N.Asm).
; The meaning and effect of these SET macros is explained below.
;
;
; SET AND CONFIGURATION MACROS USED IN THIS FILE --
;
; The following macros are used to control the conditional
; statements in this module:
;
;  WsType .............  7: NGEN Cluster
;                        8: NGEN
;                        9: NGEN Server (Master)
;                       10: FP
;                       11: TP
;                       12: CP
;                       13: SP
;                       14: DP
;                       19: BT
;                       20: GP
;                       21: GP+SI
;                       22: GP+CI
;
;  HardwareType .......  4: NGEN
;                       10: FP
;                       11: TP
;                       12: CP
;                       13: SP
;                       14: DP
;                       19: BT
;                       20: GP
;                       21: GP+SI
;                       22: GP+CI
;
;  ClusterConfig ...... 0: Standalone workstation
;                       1: Cluster workstation
;                       2: Cluster server (master)
;
;  fNoFileSystem ...... 0: Any workstation with a filesystem
;                       1: Cluster stations without filesystems
;
;  fDebugger .......... 0: Exclude debugger
;                       1: Include debugger
;
;  fHDisks ............ 0: No hard disks
;                       1: Include hard disks
;
;  CTOSP .............. 0: real mode Mp (CTOS Mp)
;                       1: protected Vp (CTOS VM)
;
;  fMulpar ............ 0: Single-partition OS. Obsolete.
;                       1: Multi-partition OS.  Always set true.
;
;  fVarpar ............ 0: Multi-partition OS.
;                       1: Variable-partition OS.  Always set same as CTOSP.
;
; COMPILATION FLAGS AND SYSTEM BUILD PARAMETERS.
;
; Many of these parameters control the allocation of structures when the OS is 
; initialized.  The memory for many of these structures is dynamically 
; allocated from a fixed size buffer in the data segment (DGroup).  The OS is 
; shipped with this buffer set to its maximum possible size.  If it were any 
; larger then the data segment would exceed 64K and the OS wouldn't link.  If 
; too many structures are allocated then the OS will crash with an ERC 101 at 
; boot.  The only recourse is to reduce the number of structures allocated.  
; This is done by reducing the counts in SET macros listed below.
;
; Many parameters may now be set in the configuration files, circumventing the 
; need to rebuild an Operating System.  The configuration files are 
; Config.sys, Ws>Config.sys and WsNNN>Config.sys.  Refer to the CTOS System 
; Administration Guide or CTOS II 3.3 SRA for more information.
;
; The "Set" macros placed in the "prefix" file are defined as follows:
;
; OS Build Parameters
;
;       sOsData ............ Reserves an empty buffer in the OS data segment 
;                            (DGroup) which is used for dynamic allocation.  
;                            The OS uses this space for data structures, such 
;                            as exchanges, which are allocated at run time 
;                            according to parameters set in the prefix file.  
;                            If configuration changes are made which increase 
;                            the static data size, sOsData may need to be 
;                            smaller.  If more dynamic memory is needed then 
;                            the static data size must be decreased and 
;                            sOsData increased.  NOTE:  The File System, 
;                            Cluster Agent and Operating System have separate 
;                            data segments, each of which must not exceed 64kb.
;
;       sContingencyLog .... Stray interrupt log (minimum value is 1 word)
;
;       sKbdBuffer ......... Keyboard type ahead buffer (must be a power of 2)
;
;       sOutBuffer ......... Size in bytes of the output character buffer.  
;                            This size must be a power of 2.  The output 
;                            buffer is used by SRPs in administrator mode.
;
;       nUsrExchange ....... User Exchanges (maximum 200).
;                            Each adds 10 bytes.
;
;       nPcb ............... Number of processes (CTOS and user combined).  
;                            The largest standard OS has 12, character mapped 
;                            video has 1, and the Executive has 2, making a 
;                            minimum of 15.  Each adds 40 bytes.
;
;       fTimeSlice ......... 0: disable run-queue rotation.
;                            1: enable run-queue rotation.
;                            When enabled, pcbs in a certain priority range on 
;                            the run queue are relinked behind other pcbs of 
;                            the same priority ten times per second.
;
;       lbTimeSlicePriority  when fTimeSlice is 1, sets low bound
;                            priority of pcbs to rotate.
;
;       hbTimeSlicePriority  when fTimeSlice is 1, sets high bound
;                            priority of pcbs to rotate.
;
;       nMsgWait ........... Total number of message link blocks.
;                            Each adds 6 bytes to CTOS.
;
;       nPTiming ........... Total number of simultaneous real time clock 
;                            service requests.  CTOS requires at least 16 to 
;                            run all Convergent programs.  Each adds 6 bytes.
;
;       nPartitions ........ Number of user numbers max.  Changing this number 
;                            causes some defaults to also be changed.  See the 
;                            prefix file.
;
;       nUcb ............... Number of user control blocks.  Each is 95 
;                            bytes.  Set to nPartitions always.
;
;       nFixup ............. Must be equal to the total number of outstanding
;                            route-by-file-handle requests to multi-instance
;                            servers.  Increase if error 156.
;
;       nDeviceHandle ...... The total number of simultaneous open multi-
;                            instance file handles.  Increase if error 157.
;
;       sParExitRunFile .... The minimum size in paragraphs (16 bytes)
;                            that the primary partition will shrink
;                            to due to CreatePartition and ConvertToSys
;                            requests.
;                            (May also be changed in configuration file)
;
;       cParScHeap ......... The size in paragraphs of the installable
;                            system common subroutine heap.  Each
;                            installed routine requires at least 8 bytes.
;                            (May also be changed in configuration file)
;
;       nGDTSlots .......... Number of slots in the Global Descriptor Table.
;                            Each slot takes 14 bytes.  This table is
;                            allocated out of high memory, not OS DGroup.
;
;       nSwapFabs .......... Number of Swap File Area Blocks needed for
;                            swap file management.  These are not the same
;                            blocks as set by nFab.  Each takes 6 bytes.
;
;       SwapFile ........... Name of the default preferred swap file.
;                            This is normally [Sys]<Sys>Crashdump.Sys.
;                            (May also be changed in configuration file)
;
;
;    Cluster Agent parameters are defined as follows:
;
;       nWsUserNum ......... Number of workstation user numbers.  There is a 
;                            user number required for each partition in each 
;                            cluster workstation.  SRP only.
;
;       nXBlk .............. Number of transmission blocks (XBlocks).
;                            Each requires sXBlk (see below) + 32 bytes.
;                            On a server this should be a function of the
;                            number of cluster workstations.
;                            (May also be changed in configuration file)
;
;       nSectorPerXBlock ... SRP: This is obsolete, see sXBlk below.
;                            For old workstations which still use this
;                            parameter, sXBlk on the SRP should be calculated
;                            as shown below.  Extra bytes will be wasted.
;
;       sXBlk .............. The maximum size (in bytes) of a request that 
;                            will fit in a XBlock.  This is the total size of
;                            the request block and all request and response
;                            data.  Prior to CTOS/SRP 3.0 this was set using
;                            nSectorPerXBlock.
;                            For conversion, sXBlk = (512*nSectorPerXBlock)+64.
;                            (May also be changed in configuration file)
;
;       nXBlkSmall ......... Number of small transmission blocks.
;                            Each requires sXBlkSmall (see below) + 32 bytes.
;                            Requests received from cluster workstations that
;                            fit in a small XBlock will not take up a large
;                            XBlock on the server.  This is useful for
;                            applications that have small requests that may be
;                            outstanding at the server for long periods of 
;                            time.
;                            (May also be changed in configuration file)
;
;       sXBlkSmall ......... The maximum size (in bytes) of a request that 
;                            will fit in a small XBlock.
;                            Prior to CTOS/SRP 3.0 this was sMaxSmallRq.
;                            (May also be changed in configuration file)
;
;       wsTotal ............ Total number of workstations that may be attached
;                            to the server.
;
;       nWsLine1 ........... Maximum number of cluster workstations which may
;                            be attached to channel 1 of the CP or GP, or to 
;                            the single cluster channel on a workstation.
;                            (May also be changed in configuration file)
;
;       nWsLine2 ........... Maximum number of cluster workstations which may
;                            be attached to channel 2 of the CP or GP.
;                            (May also be changed in configuration file)
;
;       nUserNum ........... The maximum number of users that can be 
;                            supported by this server.  Allocate one user
;                            number for each local user (nPartition) plus one
;                            for each possible cluster user.
;
;       nRcb ............... The number of Request Control Blocks.
;                            Workstations: Rcbs are used by cluster
;                            workstations to record the existence of
;                            outstanding requests to the server.
;                            Each Rcb requires 24 bytes.
;
;       nRepollActive....... Obsolete: The number of times to repoll cluster 
;                            workstations within a poll cycle.
;                            (May also be changed in configuration file)
;
;       nClusterTimeout .... The amount of time a workstation waits 
;                            before giving up on the master (erc 6).
;
;       nTryNewMaster ...... The number of times a workstation waits before 
;                            getting a new SNRM (new SNRMs, workstation IDs, 
;                            have numbers greater than 16). 
;
;
;
;    OS Build Parameters which only effect the SRP
;
;       c4kPagesMBusWindow . GP,SI,CI only.  The number of 4k pages
;                            to be used to map the megabus from a
;                            GP board.  1 page must be allocated for
;                            each 4MB of RAM on the largest other board
;                            on the bus.  For example, if another GP
;                            has 64MB then allocate 16 pages.  If all
;                            other boards are 186 boards then only 1 page
;                            is needed.
;
;       nRcb ............... The number of Request Control Blocks.
;                            SRP: Used for ICC, each rcb adds 18 bytes.
;
;       nWblk .............. Number of very large ICC request blocks.  Used to
;                            hold requests that don't fit in a YBlk.  Usually 
;                            0. Each requires sWBlk (see below) + 16 bytes.
;                            (May also be changed in configuration file)
;
;       sWblk .............. Size (in bytes) of a WBlk.
;                            (May also be changed in configuration file)
;
;       nYblk .............. Number of large ICC request blocks.
;                            Used to hold remote requests.
;                            Each requires sYBlk (see below) + 16 bytes.
;                            (May also be changed in configuration file)
;
;       sYBlk .............. Size (in bytes) of a Yblk.
;                            This must be at least as large as sXblk.
;                            (May also be changed in configuration file)
;
;       nZblk .............. Number of small ICC request blocks.
;                            Used to hold remote requests.
;                            Each requires sZBlk (see below) + 16 bytes.
;                            (May also be changed in configuration file)
;
;       sZblk .............. Size (in bytes) of a Zblk.
;                            (May also be changed in configuration file)
;
;       nMountedDisks....... Maximum number of disks which may be attached to
;                            the processor.  Fp/Dp/Gp+Si only.
;                            
;       nReqEnts ........... Size of the ICC input request circular buffer.  
;                            Each is five bytes.
;
;       nRespEnts .......... Size of the ICC input response circular buffer.  
;                            Each is 5 bytes.
;
;       sStatArea .......... Size of the ICC statistics ares. A
;                            minimum of 10 bytes is recommended
;
;       nLine .............. Number of configured RS-422 lines
;                            on a CP or GP.  Values of 1 or 2 are OK.
;
;       fSrpClock1 ......... Line speed of RS-422 line #1.  A
;                            value of 0FFh indicates the 1.8Mbs
;                            speed while 0 indicates 307kbs.
;                            (May also be changed in configuration file)
;
;       fSrpClock2 ......... As above, but for line #2.
;                            (May also be changed in configuration file)
;
;       nAdapters .......... Maximum number of multibus adapters in SRP 
;                            system.  If omitted, a default of 1 is assumed.
;
;       nNetUsers .......... The maximum number of CtNet users that can be 
;                            supported by this workstation.
;
;       fCheckECC .......... If set to FALSE, memory ECC (Error Correction)
;                            will not be tested during initialization.  It is
;                            recommended that this always be set TRUE.
;
;       fCheckMem .......... If set to FALSE, memory will not be tested during
;                            initialization.  It is recommended that this
;                            always be set TRUE. (SRP 186 processors only)
;
;       sTpInBuf,sTpOutBuf . Size of input and output buffers for the
;                            communication ports on the TP.
;
;
;
; File System Build Parameters. These only affect file system builds.
;
;       fVerifyFileStruct .. If this is non zero then CTOS will verify file 
;                            structures after writing to disk.  Adds 512 
;                            bytes.  Halves file system performance.
;                            (May also be changed in configuration file)
;
;       cDiskLogThreshold .. Indicates how many disk retry operations are to 
;                            be attempted before logging the disk error.  Only 
;                            applies to errors that are subject to retries.  
;                            This value can be greater than the total number 
;                            of retries done, thereby inhibiting log entries.
;                            (May also be changed in configuration file)
;
;       nIob ............... Total number of simultaneous disk I/O requests 
;                            allowed.  CTOS requires at least as many as disk 
;                            devices in the system to run all Convergent 
;                            programs.  Less than 5 IOBs per disk limits 
;                            performance.  Each IOB adds 128 dynamic bytes to 
;                            DGroup.
;
;       nFab ............... Total number of "runs" allowed for all open files 
;                            combined.  The appropriate number is highly 
;                            dependent on the frequency of file creation, 
;                            deletion, and expansion, and on the frequency 
;                            with which you reload your disk volumes. Each FAB 
;                            adds 10 dynamic bytes (In own segment if linked 
;                            with HfsUfb2, in DGroup otherwise).
;
;       nFcb ............... Total number of unique open files allowed in the
;                            system.  Each FCB adds 32 dynamic bytes (16 in 
;                            DGroup and 16 in another segment).
;
;       nFub ............... Number of file user blocks (one is required for 
;                            each outstanding file handle).  If linked with 
;                            HfsUfb2, FUBs are 15 bytes each and are 
;                            dynamically allocated in their own segment.  If 
;                            linked with HfsUfb, FUBs are 5 bytes and are 
;                            dynamically allocated in DGroup.
;
;       nScsiIob ........... Total number of simultaneous SCSI I/O requests 
;                            allowed.  CTOS requires at least as many as disk 
;                            devices in the system to run all Convergent 
;                            programs.  Each ScsiIob adds 66 dynamic bytes to 
;                            DGroup.
;
;       nUpb ............... Total number of open SCSI paths allowed in the 
;                            system.  Each adds 16 dynamic bytes to DGroup.
;
;       nLucb .............. Total number of active SCSI Logical Units allowed 
;                            in the system.  Each adds 74 bytes to DGroup.
;
;       nFloppy ............ Total number of floppy disks in the system.  Each 
;                            floppy present at boot time requires 98 bytes.
;
;       nDisk .............. Total number of rigid disks in the system.  Each 
;                            disk present at boot time requires 98 bytes.
;
;       nMemDisk ........... Total number of memory disks in the system.  Each 
;                            memory disk declared at system generation 
;                            requires 98 bytes.
;
;       nVhb ............... Total number of mountable mass storage
;                            devices (disks) in the system.  Each
;                            requires 256 bytes.
;
;       cbNameSpace ........ Size of the name heap used for caching file names 
;                            and passwords to increase performance.  Allocated 
;                            dynamically in own segment.
;                            NOTE: cbNameSpace MUST NOT EXCEED 65000.
;
;  The following parameters may be set in the prefix file or defined in this 
;  file, but Convergent recommends they NOT BE CHANGED.
;
;  WARNING:  Changing these parameters may cause unknown results.
;
;       TeleclusterTiming .. Timing parameter for SRP TeleCluster.  DO
;                            NOT CHANGE.
;
;       nFrames ............ Number of simultaneous video frames.
;
;       maxMedInterruptType  Maximum type number of all mediated interrupts.
;
;       XBlockHeaderSize.... Equals the maximum request block size.
;
;       fCommIOP ........... 0: Any workstation but Comm-IOP master
;                            1: CommIOP-cluster master.  IWS only.
;
;
;  The following parameters are included in this file, but THEY ARE OBSOLETE.  
;  They remain in this file because they are declared as publics.
;
;       lineHz ............. This is the AC line frequency, used by the real 
;                            time clock (50Hz or 60Hz).
;
;       nSysExchange ....... Exchanges reserved for CTOS.
;                            
;       nMsgWaitReserve .... Number of message link blocks
;                            reserved for CTOS "pSend" primative.
;
;       nSectorPerXBlkFst .. For an NGen master, if a high speed line is
;                            specified in Config.Sys (:ClusterLineSpeed: 
;                            1.8mbps), the number of sectors in each 
;                            transmission block will be taken from 
;                            nSectorPerXBlkFst instead of nSectorPerXBlk.
;
;       sioClock ........... Sio Clock divisor.  It is the
;                            divisor of 1,228,800 baud. (4 for
;                            307200 baud).  This is now a parameter in
;                            [Sys]<Sys>Config.Sys - for workstations.
;
;       fIopDump ........... Crashdump the IOP on load.  IWS only.
;
;       nIops .............. Number of IOP's.  IWS only.
;
;       nWsLine3 ........... Maximum number of workstations which may be 
;                            attached to channel 1 of IOP 2.  IWS only.
;
;       nWsLine4 ........... Maximum number of workstations which may be 
;                            attached to channel 2 of IOP 2.  IWS only.
;
;       FontRamBuf ......... 0FFh indicates that 8704 bytes buffer is reserved 
;                            at low memory for LoadFontRam operations.  IWS 
;                            only.
;
;

;###############################################################
; Encryption Key value
;  Used by the file system to encrypt all passwords on disk.
;  If changed, encryption-protected disks will be incompatible with
;  disks created by previous file systems.
;
;  The encryption process is loosely based on the RSA public-key method.
;  This number cannot be replaced by an arbitrary byte string.  
;  The key is part of a function that takes an un-encoded password
;  string as input and procuces an encrypted password as output.
;  User-generated keys should exceed 80 bytes (200 digits) and be, if not
;  prime, then have only a few factors.  The more factors, the more
;  plain text strings will encrypt into the same encoded string.
;
;  Password encryption is on a per-volume basis.  The user chooses the
;  option at ivolume time.  Care in remembering passwords must be exercised,
;  as it is impossible to determine the plain text string when only the
;  encrypted string and the key are known.

;################################################################

%DefineEncryptionKey(%( 7C8Dh, 1813h, 9F31h, 4BB9h,0E569h, 29F1h, 1B89h,0AD7Bh, 973Fh, 101Bh, 54FCh,0C922h, 5C63h, 9C97h, 840Ah, 06F0h, 612Dh,0DFCAh,0D3F7h, 335Bh,0D421h,0CD61h, 324Fh,0E40Eh, 0B0Bh, 6CE9h, 80D3h, 90BAh, 74A9h, 10E2h, 8C96h, 9CA6h,0C506h, 568Ah,0AD6Ah, 23BBh, 26A2h,0C0F9h,0A2CFh,0F383h, 0B05h, 1A7Eh,0C31Ah,0C9ACh, 8F67h, 4D69h, 083Dh, 44EEh ))

;###############################################################
;  Specify the name of a volume which is designated as the
; volume [Scr].  This is the volume where the spooler is
; going to create temporary files.
; (May also be changed in configuration file)
;################################################################

%IF(%*isdef(%ScratchVolume)) THEN (
    %ScratchVolumeSpec("%ScratchVolume")
    )
ELSE (
    %ScratchVolumeSpec("Sys")
    )FI
%IF(%fVarPar) THEN (
;###############################################################
;
; SwapFile(filename)
; SwapFilePswd(password)
; SwapFileTryEach(filename)
; SwapFileTryEachPswd(password)
; cKSwapFile(size)
;
;	These macros define the name of a file which CTOS uses
; when it becomes necessary to write a running program onto disk.
;
; The file mentioned in SwapFile is tried first. The file
; must be at least as large as the default create size (cKSwapFile).
; If it cannot be opened or is too small, then SwapFileTryEach is tried.
; Each time a decimal number is inserted into the name at the position
; where '00' occurs. If the file is in use, the next is tried.
; If the file couldn't be opened a Create is tried. If the create
; fails, the OS crashes with ercNoSwapFile.
;
; The file is created with size as specified by cKSwapFile.
; Size is measured in kilobytes(1024 byte blocks). A size of 512 would
; create a swap file of 1/2 megabyte.
; 
;################################################################

%IF(not (%*isdef(%SwapFile))) THEN (
	%define(SwapFile)([Sys]<Sys>CrashDump.Sys)
    )FI
%IF(not (%*isdef(%SwapFilePswd))) THEN (
	%define(SwapFilePswd)()
    )FI
%IF(not (%*isdef(%SwapFileTryEach))) THEN (
	%define(SwapFileTryEach)([Sys]<Sys>SwapArea00.Sys)
    )FI
%IF(not (%*isdef(%SwapFileTryEachPswd))) THEN (
	%define(SwapFileTryEachPswd)()
    )FI
%IF(not (%*isdef(%cKSwapFile))) THEN (
	%define(cKSwapFile)(1500)
    )FI
%SetSwapFileInfo

)FI

%IF (%ctosv) THEN (
;################################################################
; the DefineLibSearchPath macro defines a search path used when a library is 
; loaded. There may be multiple search paths, the order listed below is the
; order in which the search is performed. The password of the path may be 
; included in the spec. There must be at least one search path defined.
;################################################################
	%DefineLibSearchPath("[sys]<pmDll>")
	%EndLibSearchPath
	)FI


;###############################################################
;  SysGen Description of Interrupt handlers.

%IF (0) THEN (
;
; REAL MODE INTERRUPT DECLARATIONS
;
; NOTE: OS's built with this SysGen DO NOT support real mode processors.
;       The comments pertaining to interrupts on real mode processors
;       have been left in solely for clarity and reference.
;
; In real mode, SysGen defines interrupt handlers as either
; "raw" and "mediated".
;
;
; RAW INTERRUPTS --  A "raw" interrupt handler is a routine to
; which control is passed by the 80186 CPU when the interrupt
; occurs.  It is the responsibility of the handler to save the
; current register context, and to restore context before
; executing an interrupt return.  A raw interrupt may be
; generated by hardware (through the 8259A interrupt chip) or
; by software (with an "int" or an "int nn" instruction).
;
;
; RAW INTERRUPT DECLARATION -- To declare a raw interrupt
; handler use the macro "RawInterrupt" with two arguments, the
; 80186 interrupt type, and the name of the public procedure
; which will handle the interrupt.  Note that a raw interrupt
; handler must save the user context (registers), and should
; return with the "iret" Assembly Language instruction.  The
; effect of executing this macro is to have the CS:IP of the
; handler put into the pointer associated with the interrupt
; type:
;
;	RawInterrupt(type,pHandler)
;
;
; MEDIATED INTERRUPTS -- A "mediated" interrupt is one which
; CTOS "mediates" for the user, by saving the current register
; context, and then calling the interrupt handler as a
; subroutine.  This is especially useful because it allows
; FORTRAN and Pascal procedures to be written as interrupt
; handlers.  A "mediated" interrupt may be generated by
; hardware or software, just as with the "raw" interrupts.
;
;
; MEDIATED INTERUPT DECLARATION -- To declare a mediated
; interrupt handler, use the macro "MediatedInterrupt" with
; three arguments, the interrupt type, a flag (0 or 0FFh)
; saying whether or not the interrupts are generated by 
; hardware (whether to do EOI), and the name of the interrupt handler.
; CTOS will use the macro declarations to build a table which
; it will use to service interrupts:
;
;	MediatedInterrupt(type,fHardware,pHandler)
;
)FI
%IF (%CtosP) THEN (
;
; PROTECTED MODE INTERRUPT DECLARATIONS
;
; In protected mode, SysGen defines interrupt handlers as either
; "software" or "hardware".
;
;
; SOFTWARE INTERRUPTS -- A software interrupt occurs in response to
; a software generated event, such as an INT instruction or a
; program exeception, such as a general protection fault.  IDT entries
; for software interrupts contain task gates, hence, a software
; interrupt causes a task switch.  The interrupt handler need not save
; registers since a task switch occurred.  The interrupt handler may
; return to the interrupted task using IRET or may return to the
; kernel dispatcher using RET, behaving as a mediated interrupt.
;
;
; HARDWARE INTERRUPTS -- A hardware interrupt occurs in response to
; a external hardware interrupt.   IDT entries for hardware interrupts
; contain interrupt gates.  The CS:IP in the interrupt gate passes control
; to code that immediately calls an interrupt task, hence, a task switch
; occurs.  This two level vector is required to force the processor to
; unlock the memory bus during the time period beginning at the start of
; the interrupt acknowledge cycle and ending with the task switch.  Freeing
; the memory bus is necessary for high performance RS-422 cluster operation.
; The interrupt handler need not save registers since a task switch occurred.
; The interrupt handler may return to the interrupted task using IRET or may
; return to the kernel dispatcher using RET, behaving as a mediated interrupt.
; When using IRET, the interrupt handler must do EOI programming itself.  When
; RET is used the kernel handles EOI programming, and the interrupt handler
; must not do the EOI itself.
;
;
; INTERRUPT LEVEL -- The 80x86 interrupt level (type) is a code which the CPU 
; uses to distinguish different interrupts.  Interrupts may be generated in 
; one of four ways.  First, the CPU may generate the interrupt itself 
; (division error, overflow, after every instruction if TF is enabled, GP 
; fault, etc).  Second, a Non Maskable Interrupt (NMI) may occur, signaling 
; some catastrophic error such as power failure, bus timeout or parity error.  
; Third, a maskable hardware interrupt can be generated by the 8259A interrupt 
; controller chips.  Fourth, any level interrupt may be generated by software 
; using the INT instruction.  The level is used by the CPU to map the 
; interrupt to the IDT (interrupt descriptor table) which contains the "CS:IP" 
; of the appropriate interrupt handler.  On 80186 processors, the IDT is 
; located at physical address 0, and each entry is 4 bytes, starting with 
; level 0 at 0000:0000h, level 1 at 0000:0004h, etc.  On 80286 and later CPUs, 
; the IDT can be anywhere, and the entries are 8 bytes each.  Certain 
; interrupt levels are reserved by Intel, and may not be changed.
;
;
; SOFTWARE INTERRUPT DECLARATION -- To declare a software interrupt
; handler use the "SoftwareInterrupt" macro:
;
;	SoftwareInterrupt(iLevel,Handler,sStack,fEnable)
;
;		iLevel  - the interrupt level (see below)
;		Handler - name of public procedure which will handle the interrupt
;		sStack  - the count of bytes of the stack for the handler
;		fEnable - a flag indicating whether or not interrupts are to be
;		          enabled when the handler is invoked
;
;
; HARDWARE INTERUPT DECLARATION -- To declare a hardware interrupt handler,
; use the "HardwareInterrupt" macro as described below.
;
;
; ADDING HANDLERS -- In addition to adding the macro
; declaration of an interrupt handler, you must link CTOS with
; the object module containing the handler.  The handler should
; be written following the conventions outlined in the Assembly
; Language Manual (appendix) relating to register BP usage,
; segment names, etc.
;
;
; NON DECLARED INTERRUPTS -- Any interrupt which occurs of a
; type for which an interrupt handler is not supplied will
; cause CTOS to generate a "crash", which is described in the
; CTOS manual.
;
;
; REFERENCES -- Furthur information on interrupt handlers may
; be found in the following documents:
;
;	CTOS Operating System Concepts Manual
;	Assembly Language Manual, appendix on programming conventions
;	Specific hardware reference manuals (e.g. 386i Technical Reference Manual)
;	Specific Intel manuals (e.g. Intel 80386 Programmer's Reference Manual)
;
;
; Interrupt handlers:
;
; SKULL AND CROSSBONES
;
; EXTREME CAUTION IN CHANGING THE ORDER OF SOFTWARE INTERRUPTS
;
; All interrupt tasks that are entered with an error code must be
; defined BEFORE other interrupt tasks.  The last such task must be the
; GP fault handler.
;
; The kernel identifies interrupt tasks that are entered with an error
; code using the predicate sgTss <= sgTssGpFault.
; 
; ** NOTE **
; The parameter sStack (stack size in bytes) should be OR'd with 8000h to
; signal the operating system to place the stack for this interrupt 
; handler in low memory.  This is so real mode programs can use this interrupt
; level.

; Interrupt tasks entered WITH an error code.

%SoftwareInterrupt(8, DoubleTaskFault, 160, 0)
%SoftwareInterrupt(10, InvalidTssFault, 160, 0)
%SoftwareInterrupt(12, StackTaskFault, 160, 0)
%SoftwareInterrupt(14, PageTaskFault, 160, 0)

; GP fault handler must be last
%SoftwareInterrupt(13, GPTaskFault, 160, 0)

; Interrupt tasks entered WITHOUT an error code.

%SoftwareInterrupt(1, TraceRawInt, 128, 0)	; Convergent debugger
%SoftwareInterrupt(2, NmiTaskFault, 160, 0)	; Non-maskable interrupt(parity)
%SoftwareInterrupt(3, BreakRawInt, 128, 0)	; Convergent debugger

;
;	Describe the Hardware Interrupts topology for each
;	machine on which this OS will run.
;
;	Each topology begins with an entry for tyDevice=0 which must
;	describe the primary interrupt controller chip, bit mask
;	and memory word used to assert the initial mask.
;
;	The macro format is:
;
;	HardwareInterrupt(iLevel,tyDevice,lChip,bBit,wMem,Handler,sStack,fEnable)
;
;	iLevel   - the interrupt level
;	tyDevice - the device type, used in calls to ControlInterrupt.
;	           Literals are declared in SysGen_Common.mdf and CtosInternal.edf.
;		0	Interrupt controller
;		1	Cascaded controller
;		2	2nd cascaded controller or external controller
;		3	PIT (Programmable Interval Timer)
;		4	RTC (Real Time Clock)
;		5	LPT (Line Printer)
;		6	KBD (Keyboard)
;		7	RS422 line 1 (Cluster line 1)
;		8	RS422 line 2 (Cluster line 2)
;		9	Floppy1 (Internal/X-Bus shared, or Internal only)
;		10	WD-1010/2010 (Non-SCSI hard disk)
;		11	SCSI1 - SRP:Adapter 1,  WS:Internal/X-Bus shared, or Internal only
;		12	SCSI2 - SRP:Adapter 2,  WS:X-Bus when not shared
;		13	Dma TC (Terminal Count)
;		14	Doorbell
;		15	RS232 AB
;		16	RS232 CD
;		17	RS232 EF
;		18	RS232 GH
;		19	Math CoProcessor (PS2)
;		20	Redirected Cascade (PS2)
;		21	RS232 IJ
;		22	MegaBus DMA
;		23	Single Bit ECC error
;		24	X-Bus Interrupt 0
;		25	X-Bus Interrupt 1
;		26	Floppy2 (X-Bus when not shared)
;		27	X-Bus Interrupt 3
;		28	X-Bus Interrupt 4
;		29	HINTR87 (Reserved for OEM)
;		30  Keyboard Transmit
;		31  X-Bus Timeout (SuperGen only)
;	lChip    - string: 186, 8259, 8259Cascade, 8259Cascade2, DmaLPT or Ext8259
;	bBit     - binary bit mask for the interrupt
;	wMem     - optional word variable to echo mask value
;	Handler  - name of public procedure which will handle the interrupt
;	sStack  - the count of bytes of the stack for the handler
;	fEnable - a flag indicating whether or not interrupts are to be
;	          enabled when the handler is invoked.
;	          "CLI" (disabled) and "STI" (enabled) may also be used.
;
;	If Handler is "NIL", no IDT entry will be defined for the device.
;	This is used to define ControlInterrupt tables only.
;

%IF (NOT %fGp) THEN (

; T2/T3
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			80h,mask8259A,NIL,0,0)
%HardwareInterrupt( 64,tyXINTR0		,8259,			01h,mask8259A,%'
%'                     'DmyISR,8000h+200h,CLI)
%HardwareInterrupt( 65,tyRS232AB	,8259,			02h,mask8259A,%'
%'                     'RawCommNubAB,8000h+200h,CLI)
%HardwareInterrupt( 66,tyXINTR1		,8259,			04h,mask8259A,%'
%'                     'DmyISR,8000h+200h,CLI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 67,tyWD2010		,8259,			08h,mask8259A,%'
%'                     'DmyISR,512,STI)
%HardwareInterrupt( 67,tySCSI2		,8259,			08h,mask8259A,NIL,0,0)
)FI
%IF ((%wsType EQ ngen) OR
     (%wsType EQ ngenMaster) OR
     (%wsType EQ ngenCluster)) THEN (
%HardwareInterrupt( 68,tyRS4221		,8259,			10h,mask8259A,%'
%'                     'DmyISR,128,STI)
)FI
%HardwareInterrupt( 69,tyPIT		,8259,			20h,mask8259A,%'
%'                     'TimerInterrupt,8000h+200h,CLI)
%HardwareInterrupt( 70,tyKBD		,8259,			40h,mask8259A,%'
%'                     'IntHKbd,512,STI)
%HardwareInterrupt( 71,tyHINTR71	,8259,			80h,mask8259A,%'
%'                     'DmyISR,128,STI); Special OEM
%HardwareInterrupt( 80,tyRTC		,8259Cascade,	01h,cascade8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt( 81,tyXINTR3		,8259Cascade,	02h,cascade8259A,%'
%'                     'DmyISR,128,STI)
%HardwareInterrupt( 82,tyXINTR4		,8259Cascade,	04h,cascade8259A,%'
%'                     'DmyISR,200h,CLI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 83,tyFloppy1	,8259Cascade,	08h,cascade8259A,%'
%'                     'DmyISR,320,STI)
)FI
%HardwareInterrupt( 84,tyLPT		,8259Cascade,	10h,cascade8259A,%'
%'                     'LpInterrupt,200h,STI)
%HardwareInterrupt( 85,tyRS232CD	,8259Cascade,	20h,cascade8259A,%'
%'                     'RawCommNubCD,8000h+200h,CLI) ; FSA on B-28,B-38 EXP
%HardwareInterrupt( 87,tyHINTR87	,8259Cascade,	80h,cascade8259A,%'
%'                     'DmyISR,128,STI) ; Special OEM

; NewGen
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			80h,mask8259A,NIL,0,0)
%HardwareInterrupt( 64,tyXINTR0		,8259,			01h,mask8259A,%'
%'                     'DmyISR,8000h+200h,CLI)
%HardwareInterrupt( 65,tyRS232AB	,8259,			02h,mask8259A,%'
%'                     'RawCommNubAB,8000h+200h,CLI)
%HardwareInterrupt( 66,tyXINTR1		,8259,			04h,mask8259A,%'
%'                     'DmyISR,8000h+200h,CLI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 67,tyWD2010		,8259, 008h,mask8259A,%'
%'                     'DmyISR,512,03h)
%HardwareInterrupt( 67,tySCSI2		,8259,			08h,mask8259A,NIL,0,0)
)FI
%IF ((%wsType EQ ngen)  OR
     (%wsType EQ ngenMaster) OR
     (%wsType EQ ngenCluster)) THEN (
%HardwareInterrupt( 68,tyRS4221		,8259,			10h,mask8259A,%'
%'                     'DmyISR,128,STI)
)FI
%HardwareInterrupt( 69,tyPIT		,8259,			20h,mask8259A,%'
%'                     'TimerInterrupt,8000h+200h,CLI)
%HardwareInterrupt( 70,tyKBD		,8259,			40h,mask8259A,%'
%'                     'IntHKbd,512,STI)
%HardwareInterrupt( 71,tyHINTR71	,8259,			80h,mask8259A,%'
%'                     'DmyISR,128,STI); Special OEM
%HardwareInterrupt( 80,tyRTC		,8259Cascade,	01h,cascade8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt( 81,tyXINTR3		,8259Cascade,	02h,cascade8259A,%'
%'                     'DmyISR,128,STI)
%HardwareInterrupt( 82,tyXINTR4		,8259Cascade,	04h,cascade8259A,%'
%'                     'DmyISR,200h,CLI)
%HardwareInterrupt( 83,tyLPT		,8259Cascade,	08h,cascade8259A,%'
%'                     'LpInterrupt,200h,STI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 83,tyFloppy1	,8259Cascade,	08h,cascade8259A,NIL,0,0)
)FI
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 84,tySCSI1		,8259Cascade,	10h,cascade8259A,%'
%'                     'DmyISR,512,STI)
)FI
%HardwareInterrupt( 87,tyHINTR87	,8259Cascade,	80h,cascade8259A,%'
%'                     'DmyISR,128,STI) ; Special OEM

; SG-5000
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			04h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyExternal	,Ext8259,		00h,third8259A,NIL,0,0)
%HardwareInterrupt( 65,tyKBD		,8259,			02h,mask8259A,%'
%'                     'IntHKbd,512,STI)
%HardwareInterrupt( 68,tyRS232CD	,8259,			10h,mask8259A,%'
%'                     'RawCommNubCD,8000h+200h,CLI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 70,tyFloppy1	,8259,			40h,mask8259A,%'
%'                     'DmyISR,320,STI)
)FI
%HardwareInterrupt( 71,tyLPT		,8259,			80h,mask8259A,%'
%'                     'LpInterrupt,200h,STI)
%HardwareInterrupt( 81,tyRedirect	,8259Cascade,	02h,cascade8259A,NIL,0,0)
%HardwareInterrupt( 83,tyVoice		,8259Cascade,	08h,cascade8259A,%'
%'                     'DmyISR,128,STI)
%HardwareInterrupt( 84,tyKbdXmit	,8259Cascade,	10h,cascade8259A,%'
%'                     'IntHKbdXmit,512,STI)
%HardwareInterrupt( 85,tyCoprocessor,8259Cascade,	20h,cascade8259A,%'
%'                     'Coprocessor2Error,128,STI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 86,tyWD2010		,8259Cascade,	40h,cascade8259A,%'
%'                     'DmyISR,512,STI)
%HardwareInterrupt( 86,tySCSI1		,8259Cascade,	40h,cascade8259A,NIL,0,0)
%HardwareInterrupt( 86,tySCSI2		,8259Cascade,	40h,cascade8259A,NIL,0,0)
)FI
%HardwareInterrupt( 87,tyXBusTimeout,8259Cascade,	80h,cascade8259A,%'
%'                     'XBusTimeout,320,CLI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 87,tyFloppy2	,8259Cascade,	80h,cascade8259A,NIL,0,0)
)FI

%HardwareInterrupt( 96,tyRS232AB	,Ext8259,		01h,third8259A,%'
%'                     'RawCommNubAB,8000h+200h,CLI)
%IF ((%wsType EQ ngen)  OR
     (%wsType EQ ngenMaster) OR
     (%wsType EQ ngenCluster)) THEN (
%HardwareInterrupt( 97,tyRS4221		,Ext8259,		02h,third8259A,%'
%'                     'DmyISR,128,STI)
)FI
%HardwareInterrupt( 98,tyXINTR0		,Ext8259,		04h,third8259A,%'
%'                     'DmyISR,8000h+200h,CLI)
%HardwareInterrupt( 99,tyXINTR1		,Ext8259,		08h,third8259A,%'
%'                     'DmyISR,8000h+200h,CLI)
%HardwareInterrupt(100,tyXINTR4		,Ext8259,		10h,third8259A,%'
%'                     'DmyISR,200h,CLI)
%HardwareInterrupt(101,tyPIT		,Ext8259,		20h,third8259A,%'
%'                     'TimerInterrupt,8000h+200h,CLI)
%HardwareInterrupt(102,tyRTC		,Ext8259,		40h,Third8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt(103,tyXINTR3		,Ext8259,		80h,third8259A,%'
%'                     'DmyISR,128,STI)

; B-38 LCW
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			04h,mask8259A,NIL,0,0)
%HardwareInterrupt( 65,tyRS232AB	,8259,			02h,mask8259A,%'
%'                     'RawCommNubAB,8000h+200h,CLI)
%HardwareInterrupt( 80,tyRTC		,8259Cascade,	01h,cascade8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt( 81,tyRS232CD	,8259Cascade,	02h,cascade8259A,%'
%'                     'RawCommNubB,8000h+200h,CLI)
%HardwareInterrupt( 82,tyRS4221		,8259Cascade,	04h,cascade8259A,%'
%'                     'DmyISR,128,STI)
%HardwareInterrupt( 83,tyKBD		,8259Cascade,	08h,cascade8259A,%'
%'                     'IntHKbd,512,STI)
%HardwareInterrupt( 84,tyPIT		,8259Cascade,	10h,cascade8259A,%'
%'                     'TimerInterrupt,8000h+200h,CLI)
%HardwareInterrupt( 85,tyCoprocessor,8259Cascade,	20h,cascade8259A,%'
%'                     'RawCommNubCD,8000h+200h,CLI)
%HardwareInterrupt( 86,tyLPT		,8259Cascade,	40h,cascade8259A,%'
%'                     'LpInterrupt,200h,STI)
%HardwareInterrupt( 87,tyXINTR3		,8259Cascade,	80h,cascade8259A,%'
%'                     'DmyISR,128,STI)

; PC/AT
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			04h,mask8259A,NIL,0,0)
%HardwareInterrupt( 64,tyPIT		,8259,			01h,mask8259A,%'
%'                     'TimerInterrupt,8000h+200h,CLI)
%HardwareInterrupt( 65,tyKBD		,8259,			02h,mask8259A,%'
%'                     'IntHKbd,512,STI)
%HardwareInterrupt( 67,tyRS232CD	,8259,			08h,mask8259A,%'
%'                     'RawCommNubB,8000h+200h,CLI)
%HardwareInterrupt( 68,tyRS232AB	,8259,			10h,mask8259A,%'
%'                     'RawCommNubAB,8000h+200h,CLI)
%HardwareInterrupt( 69,tyIRQ5		,8259,			20h,mask8259A,%'
%'                     'DmyISR,512,CLI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 70,tyFloppy1	,8259,			40h,mask8259A,%'
%'                     'DmyISR,320,STI)
)FI
%HardwareInterrupt( 71,tyLPT		,8259,			80h,mask8259A,%'
%'                     'LpInterrupt,200h,STI)
%HardwareInterrupt( 80,tyRTC		,8259Cascade,	01h,cascade8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt( 81,tyRedirect	,8259Cascade,	02h,cascade8259A,NIL,0,0)
%HardwareInterrupt( 81,tyRS4221		,8259Cascade,	02h,cascade8259A,%'
%'                     'DmyISR,128,STI)
%HardwareInterrupt( 82,tyIRQ10		,8259Cascade,	04h,cascade8259A,%'
%'                     'DmyISR,512,CLI)
%HardwareInterrupt( 83,tyIRQ11		,8259Cascade,	08h,cascade8259A,%'
%'                     'DmyISR,512,CLI)
%HardwareInterrupt( 84,tyKbdXmit	,8259Cascade,	10h,cascade8259A,%'
%'                     'IntHKbd,512,STI)
%HardwareInterrupt( 85,tyCoprocessor,8259Cascade,	20h,cascade8259A,%'
%'                     'Coprocessor2Error,128,STI)
%IF ((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN (
%HardwareInterrupt( 86,tyWD2010		,8259Cascade,	40h,cascade8259A,%'
%'                     'DmyISR,512,03h)
%HardwareInterrupt( 86,tySCSI1		,8259Cascade,	40h,cascade8259A,NIL,0,0)
%HardwareInterrupt( 86,tySCSI2		,8259Cascade,	40h,cascade8259A,NIL,0,0)
)FI
;*AA*
%HardwareInterrupt( 86,tyRS232EF	,8259Cascade,	40h,cascade8259A,%'
%'                     'NIL,8000h+200h,CLI)
%HardwareInterrupt( 87,tyIRQ15		,8259Cascade,	80h,cascade8259A,%'
%'                     'DmyISR,512,CLI)

; Comarch
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			04h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade2	,8259Cascade,	04h,cascade8259A,NIL,0,0)
;*AA*
%HardwareInterrupt( 65,tyRS232AB	,8259Cascade,	08h,cascade8259A,%'
%'                     'RawCommNubAB,8000h+256,CLI)
%HardwareInterrupt( 67,tyRS4221		,8259Cascade,	08h,cascade8259A,%'
%'                     'DmyISR,256,CLI)
%HardwareInterrupt( 67,tyIRQ11		,8259Cascade,	08h,cascade8259A,%'
%'                     'NIL,0,0)
%HardwareInterrupt( 68,tyRS4222		,8259Cascade2,	80h,third8259A,%'
%'                     'DmyISR,128,CLI)
%HardwareInterrupt( 69,tyPIT		,8259,			08h,mask8259A,%'
%'                     'TimerInterrupt,8000h+256,CLI)
%HardwareInterrupt( 80,tyRTC		,8259Cascade,	01h,cascade8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt( 81,tyDoorbell	,8259Cascade2,	01h,third8259A,%'
%'                     'BmicInterrupt,256,STI)
;*AA*
%HardwareInterrupt( 84,tyRS232CD	,8259Cascade,	08h,cascade8259A,%'
%'                     'RawCommNubISDNAD,8000h+320,CLI)
%HardwareInterrupt( 85,tyRS232EF	,8259Cascade,	20h,cascade8259A,%'
%'                     'RawCommNubISDNB1,8000h+320,CLI)
%HardwareInterrupt( 86,tyRS232GH	,8259Cascade,	40h,cascade8259A,%'
%'                     'RawCommNubISDNB2,8000h+256,CLI)
%HardwareInterrupt( 87,tyDmaTC		,8259,			10h,mask8259A,%'
%'                     'SoftwareDmaInterrupt,256,STI)


)ELSE(
; GP
%HardwareInterrupt(  0,tyController	,8259,			00h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade	,8259,			04h,mask8259A,NIL,0,0)
%HardwareInterrupt(  0,tyCascade2	,8259Cascade,	04h,cascade8259A,NIL,0,0)
%HardwareInterrupt( 65,tyRS232AB	,8259Cascade2,	04h,third8259A,%'
%'                     'RawCommNubAB,8000h+256,CLI)
%HardwareInterrupt( 67,tyRS4221		,8259Cascade2,	40h,third8259A,%'
%'                     'DmyISR,128,CLI)
%HardwareInterrupt( 68,tyRS4222		,8259Cascade2,	80h,third8259A,%'
%'                     'DmyISR,128,CLI)
%HardwareInterrupt( 69,tyPIT		,8259,			08h,mask8259A,%'
%'                     'TimerInterrupt,8000h+256,CLI)
%HardwareInterrupt( 71,tyEccError	,8259Cascade2,	02h,third8259A,%'
%'                     'SingleBitErrorInterrupt,128,STI)
%HardwareInterrupt( 80,tyRTC		,8259Cascade,	01h,cascade8259A,%'
%'                     'RTCInterrupt,128,STI)
%HardwareInterrupt( 81,tyDoorbell	,8259Cascade,	08h,cascade8259A,%'
%'                     'Chime,256,STI)
%HardwareInterrupt( 82,tyMegabusDma	,8259Cascade,	40h,cascade8259A,%'
%'                     'MegaBusDmaInterrupt,256,STI)
%HardwareInterrupt( 83,tyLPT		,8259Cascade2,	01h,third8259A,%'
%'                     'LpInterrupt,128,STI)
%HardwareInterrupt( 84,tyRS232CD	,8259Cascade2,	10h,third8259A,%'
%'                     'RawCommNubCD,8000h+320,CLI)
%HardwareInterrupt( 84,tySCSI1		,8259Cascade2, 	10h,third8259A,NIL,0,0)
%HardwareInterrupt( 85,tyRS232EF	,8259Cascade2,	20h,third8259A,%'
%'                     'RawCommNubEF,8000h+320,CLI)
%HardwareInterrupt( 85,tySCSI2		,8259Cascade2,	20h,third8259A,NIL,0,0)
%HardwareInterrupt( 86,tyRS232GH	,8259Cascade2,	08h,third8259A,%'
%'                     'RawCommNubGH,8000h+256,CLI)
%HardwareInterrupt( 87,tyDmaTC		,8259,			10h,mask8259A,%'
%'                     'SoftwareDmaInterrupt,256,STI)
)FI%' GP
%EndHardwareInterruptTables
)FI%' CtosP

EVEN
;################################################################
; The following list of request codes are those requests for which the
; cluster agent will NOT mark the user as using resources on the master
; and therefore require no termination on the master. Clusters
; which issue to the master only the requests which are in this list will 
; not have termination requests sent to the master.
;
%RequestNoRemoteTermination(14)		;GetDateTime
%RequestNoRemoteTermination(235)	;CheckForMail
%RequestNoRemoteTermination(101Ah)	;RemoteTermination
%EndRemoteTermination
;################################################################

;################################################################
; Software Bus File Specs.
; The OS executes the files below at boot time in the order listed. 
; The macros to define the run files are:
;
;	InitRunFilePassword(Password)
; 	InitRunFile(RunFileSpec, attr)
;		where attr is:
;			Video	- run file configurable via :VdmFile: 
;			Rkvs	- run file configurable via :RkvsFile:
;			Dump	- run file exeuted for ext crashdumping
;			NoReset	- action finish disabled before this point
;			Cluster - srvr disabled before this point
;
; The first 3 run files must be Video, Rkvs, and ExtCrashDump.
;################################################################
%InitRunFilePassword("")

%IF (%ctosv) THEN (
%InitRunFile("[Sys]<Sys>PS_V.sys", "")
)FI
%InitRunFile("[Sys]<Sys>InstallVdm.Run", "Video")
%InitRunFile("", "NoReset") ; action-finish disabled until this point.
%InitRunFile("[Sys]<Sys>Rkvs.Run", "Rkvs")
%InitRunFile("[Sys]<Sys>ExtCrashDump.Run", "Dump") 
%InitRunFile("", "Cluster") ; Cluster disabled until this point in the sequence.
%InitRunFile("[Sys]<Sys>InstallKbd.Run", "")
%InitRunFile("[Sys]<Sys>Oem1.Run", "")
%InitRunFile("[Sys]<Sys>Oem2.Run", "")
%InitRunFile("[Sys]<Sys>Oem3.Run", "")
%InitRunFile("[Sys]<Sys>Oem4.Run", "")
%InitRunFile("[Sys]<Sys>DisplayConfig.Run", "")
%InitRunFile("[Sys]<Sys>SysInit.Run", "")
%InitRunFile("[Sys]<Sys>Signon.Run", "")
%InitRunFileEnd

%IF (%CtosP) THEN (
;################################################################
;	Native Langauge Support Keyboard Table(s) File
;	This macro defines the name of the file to be loaded at
;	initialization which contains keyboard emulation and encoding tables.
;   It will also be accessed at runtime if the keyboard id changes.
;################################################################

%IF(%*isdef(%NlsKbdFile)) THEN (
    %NlsKbdFileSpec("%NlsKbdFile","")
    )
ELSE (
    %NlsKbdFileSpec("[Sys]<Sys>NlsKbd.Sys","")
    )FI

%IF(%*isdef(%WsNlsKbdFile)) THEN (
    %WsNlsKbdFileSpec("%WsNlsKbdFile")
    )
ELSE (
    %WsNlsKbdFileSpec("[Sys]<Sys>Ws###>NlsKbd.Sys")
    )FI

)FI
EVEN
;###############################################################
;
;  Space occupied by the tables below this location will be
; reclaimed by the CTOS after its initialization
;
;  ANY RE-ORDERING OF THIS FILE MUST NOT CROSS THIS BOUNDRY !!!
;
; CTOS has been carefully constructed so that the various parts
; of CTOS reside either before this boundry (resident code and
; data) or after (initialization code and data).  There are
; five segments which are used in controlling this:
;
;	"code" ... anything in this segment will be resident
;	"const" .. anything in this segment will be resident
;	"data" ... anything in this segment will be resident if
;		   the module is linked before SysGen.Obj, or
;		   non resident if linked after
;	"stack" .. anything in this segment will be nonresident
;	"coed" ... anything in this segment will be non
;		   resident (ie discarded after intialization)
;
; The CTOS processes are allocated stacks out of memory
; reserved by the following macro call, and the stack segment
; is used only for a stack during CTOS initialization.
;
; The following macro is invoked with one argument, the number
; of bytes to be reserved for CTOS to use to build its
; structures, tables, and to allocate the stacks for the
; different processes (declared later in this file).  The macro
; variable sOsData may be defined in the prefix file if
; desired.  The OS will crash with as error 101 if this value
; is too small.
;################################################################

%IF (%*IsDef(%sOsData)) THEN (
%ResidentDataBoundry(%sOsData)
) ELSE (
%IF (%wsType EQ ngenCluster) THEN (%ResidentDataBoundry(15240))FI
%IF (%wsType EQ ngen) THEN (%ResidentDataBoundry(20480))FI
%IF (%wsType EQ NGenMaster) THEN (%ResidentDataBoundry(26600))FI
%IF (%fSrp) THEN (%ResidentDataBoundry(25600))FI
)FI
EVEN
;###############################################################
;
;   Table which describes reserved exchanges
; for CTOS resident processes. List each exchange only once.
;
;###############################################################
%AssignSysExch(1,Kbd)			;kbd
%AssignSysExch(3,SysIn)			;sysin or LogProc_Mf
%AssignSysExch(5,Termination)		;termination
%IF (%fVarPar) THEN (%'
%AssignSysExch(6,Sched)	; Variable Partition process
)FI
%AssignSysExch(10,LclFileSys)		;lclFileSys
%AssignSysExch(11,FileSys)		;CTOS "File system"
%AssignSysExch(12,Agent)		;agent
%AssignSysExch(15,Init)			;init process
%AssignSysExch(24,KbdInternal)		;kbd internal
%IF (%fNoFileSystem EQ 0) THEN (%'
%AssignSysExch(8,MassIo)		;massIo
%AssignSysExch(9,FsPocket)		;exchFsPocket
%AssignSysExch(14,ScsiManager)		;SCSI Manager (NGen and GP)
%AssignSysExch(16,FsPeriodic)
)FI
%IF (%fSrp) THEN (
%AssignSysExch(4,FilterPros)		;srp filter process
)FI
%'IF(%clusterConfig EQ 2)THEN(%'
%AssignSysExch(17,MstrAgentRcv)		;master agent receiver, also Mf
%AssignSysExch(13,MstrAgent)		;master agent
%')FI
%AssignSysExch(26,Swapper)		;swapper internal
%AssignSysExch(2,VideoSem)		;video semaphore internal and Kbd_Mf
%AssignSysExch(27,HwId)			;Hardware Id
;AssignSysExch(28,Nvram)		;Nvram Manager
%IF (%fCP OR %fTp) THEN (%'
%AssignSysExch(20,TpReq)		;ExchTpReq
%AssignSysExch(21,TpResp)		;ExchTpResp
)FI
%'	The following must be done last, so they choose an exch nobody else wants.
%IF (%fSrp) THEN (%'
%AllocSysExch(exchFilterPocket)		;File spec routing process pocket
)FI
%IF (%fVarPar) THEN (%'
%AllocSysExch(exchSchedPocket)	;any free exch
%AllocSysExch(exchQuiet)
)FI
%AllocSysExch(exchRqTracker)
%AllocSysExch(exchSpecHeap)
%AllocSysExch(ExchOSNamePlace)
%AllocSysExch(exchPit)
EVEN
;###############################################################
;
;   Table which describes the CTOS resident processes.  Each
; process is described by 5 attributes:     
;				
;      1. Process entry point                       
;      2. Size of its stack
;      3. priority (0 is highest, 254 lowest)
;      4. default exchange (0 if not required, <> 0 allocs next available)
;      5. optional "check proc" name; if supplied (non-0), proc is called
;         to decide if the process should be created
;
;   Stack size --
;	The stack size for a CTOS process must be large enough
; for the largest local variable and procedure call sequence,
; plus enough space for all possible interrupts that can occur.
; CTOS requires 64 bytes of user stack to save the context of a
; process when an interrupt occurs.
;                                                   
;   Priorities --                                   
;	In order for CTOS to function correctly, the following
; priority considerations must be obeyed:
;
;	MassIo ................ same as SCSI Manager
;	SCSI Manager .......... same as MassIo
;	Sched ................. higher than TerminationProcess
;	TerminationProcess .... lower than Sched
;
; All user (non CTOS) processes must be worse in priority than
; CTOS processes (The Convergent Executive starts all user
; programs with priority 128).
;
; process priorities:
;	0	Clock
;	1	Timer
;	2	Keyboard/Debugger
;	3	Master Agent Receiver/Cluster Agent
;	4 	MasterAgent
;	5	QuietProcess/TpProcess
;	6	RealFileSys/RKVS/Video
;	7	Sched/FilterPros
;	8	Termination
;	9	OvlyMgr(ResourceMgr)/ServiceHwIdRq
;	10	SysInPro
;	10	Massio
;	10  ScsiManager
;###############################################################
%IF(%CTOSV) THEN (%SET(sSchedStack,1024)) ELSE (%SET(sSchedStack,500))FI


%IF (%fSrp) THEN (			%' SRP
	%OsProcDesc(KbdProcess, 512, 2, %TRUE, 0)
	%IF (%ctosp) THEN (
		%OsProcDesc(ClockPro, 256, 0, %TRUE, 0)
	)FI
	%OsProcDesc(Timer, 256, 1, %FALSE, 0)
	%IF (%fCP OR %fGP) THEN (		%' Cluster Server
	    %'OsProcDesc(MstrAgentReceiver, 256, 3, %TRUE, 0)
	    %'OsProcDesc(MstrAgent, 256, 4, %TRUE, 0)
	) FI
	%IF (%fTP OR %fCP) THEN (		%' Comm Server
	    %OsProcDesc(TpProcess, 512, 5, %TRUE, 0)
	) FI
	%IF(%fVarPar) THEN (
		%OsProcDesc(QuietProcess, 512, 5, %TRUE, 0)
	    %OsProcDesc(Sched, %sSchedStack, 7, %TRUE, 0)
	) FI
	%OsProcDesc(TerminationProcess, 400, 8, %TRUE, 0)
    %OsProcDesc(LclFsFilterProcess, 170, 7, %TRUE, 0)
    %OsProcDesc(FileSystem/ResourceMgr, 600, 5, %TRUE, 0)
    %OsProcDesc(SysInPro, 256, 10, %TRUE, 0)
    %OsProcDesc(ServiceHwIdRq, 512, 9, 1, CheckHostCPU)
	%OsProcName(Null)
) ELSE (					%' Workstations
	%IF(%wsType EQ ngenCluster) THEN (	%' Clstr
	    %OsProcDesc(KbdProcess, 768, 2, %TRUE, 0)
		%OsProcDesc(Timer, 256, 1, %FALSE, 0)
	    %OsProcDesc(FileSystem/ResourceMgr, 600, 5, %TRUE, 0)
	    %OsProcDesc(SysInPro, 256, 10, %TRUE, 0)
	    %OsProcDesc(TerminationProcess, 400, 8, %TRUE, 0)
	    %OsProcDesc(ServiceHwIdRq, 512, 9, %TRUE, 0)
	    %IF(%fVarPar) THEN (
			%OsProcDesc(QuietProcess, 512, 5, %TRUE, 0)
			%OsProcDesc(Sched, %sSchedStack, 7, %TRUE, 0)
	    ) FI
	    %OsProcName(Null)
	) FI
	%IF(%wsType EQ ngen) THEN (
	    %IF(%localFS EQ 0) THEN (		%' Stnd
	    %OsProcDesc(KbdProcess, 768, 2, %TRUE, 0)
		%OsProcDesc(Timer, 256, 1, %FALSE, 0)
		%OsProcDesc(FileSystem/ResourceMgr, 600, 5, %TRUE, 0)
		%OsProcDesc(SysInPro, 256, 10, %TRUE, 0)
		%OsProcDesc(TerminationProcess, 400, 8, %TRUE, 0)
		%OsProcDesc(ServiceHwIdRq, 512, 9, 1, 0)
		%IF (%fVarPar) THEN (
			%OsProcDesc(QuietProcess, 512, 5, %TRUE, 0)
		    %OsProcDesc(Sched, %sSchedStack, 7, %TRUE, 0)
		) FI
		) ELSE (				%' ClstrLfs
		%OsProcDesc(KbdProcess, 768, 2, %TRUE, 0)
		%OsProcDesc(Timer, 256, 1, %FALSE, 0)
		%OsProcDesc(FileSystem/ResourceMgr, 600, 5, %TRUE, 0)
		%OsProcDesc(SysInPro, 256, 10, %TRUE, 0)
		%OsProcDesc(TerminationProcess, 400, 8, %TRUE, 0)
		%OsProcDesc(ServiceHwIdRq, 512, 9, 1, 0)
		%IF (%fVarPar) THEN (
			%OsProcDesc(QuietProcess, 512, 5, %TRUE, 0)
		    %OsProcDesc(Sched, %sSchedStack, 7, %TRUE, 0)
		) FI
	    )FI
	    %OsProcName(Null)
	)FI
	%IF(%wsType EQ NGenMaster) THEN (	%' Mstr
	    %OsProcDesc(KbdProcess, 768, 2, %TRUE, 0)
		%OsProcDesc(Timer, 256, 1, %FALSE, 0)
	    %OsProcDesc(FileSystem/ResourceMgr, 600, 5, %TRUE, 0)
	    %OsProcDesc(SysInPro, 256, 10, %TRUE, 0)
	    %OsProcDesc(TerminationProcess, 400, 8, %TRUE, 0)
	    %OsProcDesc(ServiceHwIdRq, 512, 9, 1, 0)
	    %IF (%fVarPar) THEN (
			%OsProcDesc(QuietProcess, 512, 5, %TRUE, 0)
			%OsProcDesc(Sched, %sSchedStack, 7, %TRUE, 0)
	    )FI
	    %OsProcName(Null)
	) FI
) FI					%' Workstation
EVEN

;###############################################################
; CTOS INITIALIZATION --
; The following macros generate three tables of pointers which
; are used by CTOS during its initialization phase. All of the
; routines pointed to in these tables reside in modules which
; are linked near the end of CTOS, and the code for these
; modules is discarded after initialization is complete. These
; routines should have their code segments named "coed", and
; should use "data" for the name of their data segments. This
; is to insure that the Linker will place the code and data at
; the end of the run file, after the "ResidentDataBoundry"
; mentioned earlier in this file. The routines should obey the
; Convergent programming conventions related to register usage
; (refer to The Assembly Language Manual). The routines are
; executed at one of three times during CTOS initialization:
;
;   InitProcHardware
;		After CTOS is booted, and after memory and bus timeout
;		tests are completed. This is the place to put hardware
;		test and verification routines.
;
;   InitProcIntDisable
;		After CTOS structures have been initialized but before
;		any processes have been started. This is the place to
;		put hardware intitialization routines.
;
;   InitProcIntEnable
;		After interrupts are enabled these routines are executed
;		as if they were a user program. (CTOS processes are running).
;		This is the place to put user process initialization routines.
;
; The routines are called in the order given, with no arguments, as
; subroutines using the Assembly Language indirect far call instruction.
;
; DESCRIPTION OF CONVERGENT INITIALIZATION ROUTINES --
;
; FileSystem:
;	InitFsDataStructures
;	InitFsHardware
;	InitFsMountDevices
;	InitFsSysDevNum
;	InitFsSystemTime
;
; SRP:
;	InitVideo .......... Video and screen initialization
;	ClockTest .......... (186 only)
;	IccInit ............ Determine bus configuration
;	RqExInit ...........
;	InitSysCom ......... System common area initialization
;	InitRtc ............ RTC initialization
;	InitPIT ............ PIT initialization
;	StartRTC ...........
;	AddressBootBlock ...
;	RestoreRTC .........
;	InitMapHardware .... Initialization for DMA mapping (386 only)
;	InitOSNamePlace .... proc/exchange name table
;	InitDebugNub ....... Debugger initialization routine
;	LoadFsMaster ....... Load filesystem if masterFp
;	LoadSrpConfig_Sys .. Setup configuration file for parsing
;	ParseIccData ....... Read ICC configuration
;	InitIccSegment ..... Initialize ICC structures
;	InitRouteTables .... Initialize routing tables
;	InitBroadcastHeap ..
;	LoadFsNotMaster .... Load filesystem if not masterFp
;	DoExtDump .......... Extended crash dumping
;	ParseSrpConfig_Sys . Read configuration information
;	LoadFileInit ....... Load request files
;	InitNLSTables ...... Initialize native language support
;	InitStatusLog ...... Log previous status and crash information
;	ParseBootList ...... Boot boards as per configuration file
;	InitSpecHeap ....... Initialize spec expansion heap
;	TpInit ............. Initialize terminal processor
;	CpInit ............. Initialize cluster processor
;	WaitForSrpCpuSync .. Synchronize boards on system bus
;	InitRouteTables .... Update routing tables from masterFp
;	SetDateTimeMaster .. Set system date and time
;	InitMstr ........... Initialize cluster
;	InitVpSwapFile .....
;	InitVpStructures ...
;	InitStatusVideo .... Display previous status and crash information
;	LoadTableOfContents  Load BootTape Table of Contents
;	CleanupTableOfContents Any necessary cleanup (i.e., memory, drivers)
;	LoadMemDiskImage ... Load MemDisk from BootTape
;
; Workstation:
;	SysGenInit .... Set variables according to rgSysGen structure
;	InitVideo ..... make sure video hardware works
;	KbdTest ....... see if kbd hardware works
;	RqExInit ...... Map virtual exchanges
;	FsIn1 ......... File system initialization
;	Init8255 ...... LED port
;	InitRtc ....... RTC initialization
;	InitSysCom .... System common area initialization
;	Init8237 ...... DMA Initialization
;	Init8251 ...... 8251A Initialization
;	KbdInit ....... Keyboard initialization
;	InitCounter ... 8253 counter 0 initialization
;	Init8259 ...... 8259A Initialization
;	CheckDisks .... Look for hard disk
;	FsIn2 ......... File system initialization routine
;	InitLoadFS .... Load file system and synchronize
;	DumpAndMTest .. Dump & memory test above 128K
;	InitOSNamePlace .... proc/exchange name table
;	InitDebugNub .. Debugger initialization routine
;   InitReadEisaCmos ... Reads resource information from EISA CMOS
;	LoadFileInit .. Loads boot-time configuration file(s)
;	WsInit ........ Cluster WS Agent Initialization
;	InitMstr ...... Master WS Cluster Initialization
;	IopInit ....... Master WS Cluster Initialization
;	IopStart ...... Master WS Cluster Initialization
;	SysDeviceInit . Initialize system devices
;   InitEisaConfig  .... Allocates PC resources
;
;################################################################

    %IF(%fSrp) THEN (				%' Pc + Comarch
	%' Everything including the kitchen sink!
	%InitProcHardware(InitResetBmic)
	%InitProcHardware(Init8259)
    %InitProcHardware(Init82380)
	%InitProcHardware(InitVideo)
	%InitProcHardWare(KbdTest)
	%InitProcHardWare(ClockTest)
	%InitProcHardware(Init8259)		%' Reinitialize after clock test
	%InitProcHardware(CheckForDAIModule)
	%InitProcHardware(Init8237)
	%InitProcHardware(Init8251)
	%InitProcHardware(InitComm2)
	%InitProcHardware(IccInit)

	%InitProcIntDisable(RqExInit)
	%InitProcIntDisable(KbdInit)
	%InitProcIntDisable(Init8259)
	%InitProcIntDisable(InitUcbs)
	%InitProcIntDisable(InitSysCom)
	%InitProcIntDisable(AllocMemForxLat)
	%InitProcIntDisable(InitMapHardware)
	%InitProcIntDisable(InitRtc)
	%InitProcIntDisable(InitPIT)
	%InitProcIntDisable(StartRTC)
	%InitProcIntDisable(AddressBootBlock)
	%InitProcIntDisable(RestoreRTC)%' Last IntDisable proc
	%IF(%fBT) THEN (
		%InitProcIntDisable(LoadTableOfContents)
		%InitProcIntDisable(InitLoadBootTapeOs)
	)FI
	%InitProcIntEnable(InitDwellCalibrate)
	%InitProcIntEnable(InitAllocUsers)
	%InitProcIntEnable(InitOSNamePlace)	%' OSName Place
	%IF(%fDebugger) THEN (
		%InitProcIntEnable(InitDbgOsIntf)	%' Helps debug init crash dumps
		%IF(%fWrappedDebugger) THEN (
			%InitProcIntEnable(InitVpStructures)
			%InitProcIntEnable(InitNlsTables)
			%InitProcIntEnable(InitDebugNub)
		)FI
	)FI
	%IF(NOT(%fNoFileSystem)) THEN (%'
		%' LoadFsMaster must be before LoadSrpConfig_Sys.
		%InitProcIntEnable(LoadFsMaster)
		%'InitProcIntEnable(LoadTableOfContents)
		%'InitProcIntEnable(LoadMemDiskImage)
	)FI
	%InitProcIntEnable(LoadConfig_Sys)
	%InitProcIntEnable(ParseIccData)
	%' InitIccSegment must be after ParseIccData.
	%InitProcIntEnable(InitIccSegment)
	%InitProcIntEnable(InitRcbSegment)
	%InitProcIntEnable(InitEnableBmic)
	%InitProcIntEnable(InitIccToMaster)
	%' Until InitRouteTables non-MasterFp only allowed to request to MasterFp,
	%' and MasterFp not allowed to issue any off-board requests.
	%IF(NOT(%fNoFileSystem)) THEN (%'
		%' LoadFsNotMaster must be after InitIccSegment.
		%InitProcIntEnable(LoadFsNotMaster)
	)FI
	%IF(%ctosv) THEN (
	    %InitProcIntEnable(InitReadEisaCmos)
	)FI
	%' InitConfig must be after InitIccSegment.
	%InitProcIntEnable(InitConfig)
	%InitProcIntEnable(InitBroadcastHeap)
	%' InitDebugNub must be after Initconfig.
	%IF (NOT %fWrappedDebugger) THEN (
		%InitProcIntEnable(InitNlsTables)
		%InitProcIntEnable(InitDebugNub)
	)FI
	%InitProcIntEnable(LoadFileInit)
	%' InitStatusLog must be before ParseBootList.
	%InitProcIntEnable(InitStatusLog)
	%InitProcIntEnable(ParseBootList)
	%' DoExtDump must be after ParseBootList.
	%InitProcIntEnable(DoExtDump)
	%InitProcIntEnable(InitSpecHeap)
	%IF(NOT(%fNoFileSystem)) THEN (%'
		%'InitProcIntEnable(CleanupTableOfContents)
	)FI
	%InitProcIntEnable(WaitForSrpCpuSync)
	%InitProcIntEnable(InitRouteTables)
	%InitProcIntEnable(SetDateTimeMaster)
	%InitProcIntEnable(SetScratchVolume)
    %InitProcIntEnable(LoadAgent)
	%InitProcIntEnable(StartRTC) %' In case crystal changed.
	%IF(%ctosv) THEN (
	    %InitProcIntEnable(InitEisaConfig)
	    %InitProcIntEnable(InitSem)
		%InitProcIntEnable(InitNameHeap)
		%InitProcIntEnable(InitDynLink)
		)FI
	%IF(%fVarPar) THEN (
		%InitProcIntEnable(InitVpSwapFile)
		%IF (NOT %fWrappedDebugger) THEN (
			%InitProcIntEnable(InitVpStructures)
		)FI
	)FI
	%IF(%ctosv) THEN (
	    %InitProcIntEnable(InitKernelStacks)
	)FI

    ) ELSE (					%' Workstation
	%InitProcHardware(Init8259)
	%InitProcHardWare(InitVideo)
	%InitProcHardWare(KbdTest)
	%InitProcHardWare(ClockTest)
	%InitProcHardware(Init8259)		%' Reinitialize after clock test

	%InitProcIntDisable(CheckForDAIModule)
	%InitProcIntDisable(StartRtc)
	%InitProcIntDisable(Init8237)
	%InitProcIntDisable(Init8251)
	%InitProcIntDisable(InitComm2)
	%InitProcIntDisable(RqExInit)
	%InitProcIntDisable(KbdInit)
	%InitProcIntDisable(Init8259)
	%'SuperGen Debug ... StartRtc after Init8259
	%InitProcIntDisable(StartRtc)
	%InitProcIntDisable(InitUcbs)
	%InitProcIntDisable(InitSysCom)
	%InitProcIntDisable(AllocMemForxLat)
	%InitProcIntDisable(InitRtc)
	
	%IF((%wsType EQ ngenCluster) OR (%wsType EQ ngen)  ) 
											THEN(%' Clstr, ClstrLfs
		%InitProcIntDisable(DAIFromHardware)
	)FI
	%InitProcIntDisable(RestoreRTC)%' Last IntDisable proc

	%InitProcIntEnable(InitDwellCalibrate)
	%InitProcIntEnable(InitAllocUsers)
	%InitProcIntEnable(InitOSNamePlace)	%' OSName Place
	%IF(%fDebugger) THEN (
		%InitProcIntEnable(InitDbgOsIntf)	%' Helps debug init crash dumps
	)FI

	%IF (%fWrappedDebugger) THEN (
		%InitProcIntEnable(InitVpStructures)
		%InitProcIntEnable(InitNlsTables)
		%InitProcIntEnable(InitDebugNub)
	)FI
	%IF(%ctosv) THEN (
	    %InitProcIntEnable(InitReadEisaCmos)
	)FI
	%InitProcIntEnable(AddressBootBlock)
	%IF((%wsType EQ ngen) AND (%localFS EQ 1) ) THEN (%' ClstrLfs
		%InitProcIntEnable(InitLoadClstrLfs)
		)
	ELSE (%' NOT ClstrLfs
		%IF((%wsType EQ ngen) OR (%wsType EQ ngenMaster)) THEN(%' Stnd, Master
			%InitProcIntEnable(InitLoadFS)
		)FI
		%IF(%wsType EQ ngenCluster)  THEN(%' Clstr
		    %InitProcIntEnable(LoadAgent)
		)FI
		%InitProcIntEnable(SysDeviceInit)
		%InitProcIntEnable(InitConfig)
	)FI
	%InitProcIntEnable(InitSpecHeap)
	%IF (NOT %fWrappedDebugger) THEN (
		%InitProcIntEnable(InitDebugNub)
	)FI
	%InitProcIntEnable(LoadFileInit)
	%IF (NOT %fWrappedDebugger) THEN (
		%InitProcIntEnable(InitNlsTables)
	)FI
	%IF(%ctosv) THEN (
	    %InitProcIntEnable(InitEisaConfig)
	    %InitProcIntEnable(InitSem)
		%InitProcIntEnable(InitNameHeap)
		%InitProcIntEnable(InitDynLink)
		)FI
	%' LoadAgent as late as possible to avoid mode-3 fence fragmentation.
	%IF (%wsType EQ NGenMaster) THEN (			%' Master
	    %InitProcIntEnable(LoadAgent)
	)FI
	%IF((%wsType EQ ngen) AND (%localFS EQ 0) ) THEN( %' Stnd
	    %InitProcIntEnable(LoadAgent)
	)FI
	%IF (%fVarPar) THEN (
		%InitProcIntEnable(InitVpSwapFile)
		%IF (NOT %fWrappedDebugger) THEN (
			%InitProcIntEnable(InitVpStructures)
		)FI
	)FI
	%IF(%ctosv) THEN (
	    %InitProcIntEnable(InitKernelStacks)
	)FI
	%InitProcIntEnable(InitStatusLog)
    )FI						%' Workstations
	%InitProcIntEnable(InitStatusVideo)		%' CTOS


;################################################################
;	Native Langauge Support Table File
;	This macro defines the name of the file to be loaded at
;	initialization which contains national tables and strings.
;################################################################

%IF(%*isdef(%NlsFile)) THEN (
    %NlsFileSpec("%NlsFile","")
    )
ELSE (
    %NlsFileSpec("[Sys]<Sys>Nls.Sys","")
    )FI
%IF(%*isdef(%WsNlsFile)) THEN (
    %WsNlsFileSpec("%WsNlsFile")
    )
ELSE (
    %WsNlsFileSpec("[Sys]<Sys>Ws###>Nls.Sys")
    )FI


%IF (%fSrp) THEN (
;################################################################
; Default Configuration File                                    #
;   This macro defines the default SrpConfig.sys file which is  #
;   used to bring the system up if there is no configuration    #
;   file in [sys]<sys> or it is unusable.                       #
;################################################################
                                                                 
%IF (%*IsDef(%DefaultConfigFile)) THEN (
    %DefaultCnfgFile("%DefaultConfigFile")
) ELSE (
    %DefaultCnfgFile("%'
%'       ':Boot:(Processor=CP00,OS=[sys]<sys>rSrpCp.run)
%'       ':Boot:(Processor=GP00,OS=[sys]<sys>pSrpGp.img)
")
)FI
)FI
;################################################################
; Default Debugger Ports                                        #
;   This macro defines the default Debugger port.  For          #
;   processors without ports, the CP terminal ports are used.   #
;                                                               #
;################################################################
%IF(%fGP) THEN (
%DefaultDebugPort(None,B)
)FI
%IF(%fFP) THEN (
%DefaultDebugPort(CP00,B)
)FI
%IF(%fDP OR %fSP) THEN (
%DefaultDebugPort(CP00,B)
)FI
%IF(%fCP) THEN (
%DefaultDebugPort(None,C)
)FI
%IF(%fTP) THEN (
%DefaultDebugPort(None,J)
)FI

;###############################################################
; Configuration File --
;	These macros define the search path for the configuration file.
;
;	The procedure for finding the config file is as follows:
;	
;	1. If the system has a CMOS or NVRAM Hardware ID use
;		'[sys]<sys>HWnnn>config.sys' if present. 
;	2. If the system was booted from the cluster use
;		'[sys]<sys>WSnnn>config.sys' if present.
;	3. If the system was booted from the cluster use
;		'[sys]<sys>WS>config.sys' if present.
;	4. Use '[sys]<sys>config.sys' if present.
;################################################################

%IF(%*isdef(%ConfigFile)) THEN (
; the second argument is the password to be used when opening all config files.
    %ConfigurationFile("%ConfigFile","")
    )
ELSE (
    %ConfigurationFile("[Sys]<Sys>Config.Sys","")
    )FI

%IF(%*isdef(%WsConfigFile)) THEN (
    %WsConfigurationFile("%WsConfigFile")
    )
ELSE (
    %WsConfigurationFile("[Sys]<Sys>Ws###>Config.Sys")
    )FI

%IF(%*isdef(%HwConfigFile)) THEN (
    %HwConfigurationFile("%HwConfigFile")
    )
ELSE (
    %HwConfigurationFile("[Sys]<Sys>HW###>Config.Sys")
    )FI



;###############################################################
; NGen Module Definition
; Format is  DefineXbusModule(id,size,fRMOS,fMode3Master) where size is in
; kilobytes.
; If a module has many ids then list each.
; Size can be 96, 224, 480 or 0(no window).
; Setting fRMOS to %TRUE makes the module addressable from real mode programs
;      running under a protected mode OS.
; Setting fMode3Master to %TRUE means that the module is a master for mode
; 3 dma. If a mode 3 master is present on the xbus, the loader will only
; load programs above 16 megabytes which have been linked 'HighMemProtected'
; or 'HighMemGdtProtected' (see '[Run file type]' parameter of link form).
;################################################################
%IF (%CtosP) THEN (
%DefineXbusModule(47,96,%FALSE,%FALSE)	%' /* PC001 */
%DefineXbusModule(49,0,%FALSE,%TRUE)	%' /* QIC tape */
%DefineXbusModule(50,0,%FALSE,%TRUE)	%' /* phone */
%DefineXbusModule(51,0,%FALSE,%TRUE)	%' /* phone */
%DefineXbusModule(52,0,%FALSE,%TRUE)	%' /* ethernet */
%DefineXbusModule(53,0,%FALSE,%TRUE)	%' /* ethernet */
%DefineXbusModule(56,96,%TRUE,%FALSE)	%' /* monochrome graphics */
%DefineXbusModule(57,96,%TRUE,%FALSE)	%' /* color graphics */
%DefineXbusModule(60,224,%FALSE,%FALSE)	%' /*GC003*/
%DefineXbusModule(61,224,%FALSE,%FALSE)	%' /*GC003*/
%DefineXbusModule(62,224,%FALSE,%FALSE)	%' /*GC003*/
%DefineXbusModule(63,224,%FALSE,%FALSE)	%' /*GC003*/
%DefineXbusModule(68,96,%TRUE,%FALSE)	%' /*GC102*/
%DefineXbusModule(80,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(81,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(82,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(83,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(84,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(85,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(86,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(87,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(88,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(89,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(90,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(91,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(92,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(93,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(94,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(95,96,%TRUE,%FALSE)	%' /*GCX04*/
%DefineXbusModule(132,0,%FALSE,%TRUE)	%' /* Unisys QIC */
%DefineXbusModule(195,0,%FALSE,%TRUE)	%' /* Unisys EN3 */
%DefineXbusModule(196,0,%FALSE,%TRUE)	%' /* Unisys TR2 */
%DefineXbusModule(197,0,%FALSE,%TRUE)	%' /* Unisys ID2 */
%DefineXbusModule(200,0,%FALSE,%TRUE)	%' /* ISDN */
%DefineXbusModule(201,0,%FALSE,%TRUE)	%' /* SuperGen Ethernet */
) FI

;###############################################################
; FINAL --
;    This macro does error checking, and fills in various
; counts in the tables generated by the above macros calls.
;
;################################################################
%Final
END
