;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: FsL_N.asm                                                           *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: CTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Parameters for a large-sized protected-mode file system.                  *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;*                                                                           *;
;* TITLE:  CTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1990 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;
;


$INCLUDE(Sysgen_Common.Mdf)
%Begin
EVEN
; MASS IO DEVICE CLASSES
;
; The SysGen must describe the initialization procedures to be used
; for different classes of hardware devices and interfaces.  At boot
; time, the hardware is examined and each time a mass storage device
; is encountered, the array 'rgMassIoInit' is used to vector an
; initialization request to the hardware-specific procedure for the
; device class.
;
; NOTE:		The MassIoInit macro MUST be invoked in ascending
;		device class order, with no gaps left in the
;		sequence.  If a particular hardware class cannot
;		be present on a system, the special entry name
;		"Dummy" MUST BE USED as a place holder to generate
;		the array correctly.

	%MassIoInit(InitWD2010)		;Device class 0: ST-506 disks
	%MassIoInit(InitWD2797)		;Device class 1: Floppy disks
	%MassIoInit(Dummy)
	%MassIoInit(Dummy)
	%MassIoInit(Dummy)
	%MassIoInit(InitNEC765C)	;Device class 5: Floppy disks
	%MassIoInit(InitISK)		;Device class 6: CT ISK Gate Array
	%MassIoInit(Dummy)
	%MassIoInit(Dummy)
	%MassIoInit(Dummy)
	%MassIoInit(InitCMD)		;Device class 10: Cache Memory Device
	%MassIoInit(Dummy)
	%MassIoInit(InitNCR53C94)	;Device class 12: SuperGen SCSI
	%MassIoInit(Dummy)
	%MassIoInit(InitAIC6260)	;Device class 14: PC/AT Adaptec 6260 SCSI
	%MassIoInit(Dummy)
	%MassIoInit(InitAIC7770)	;Device class 16: PC/AT Adaptec 7770 SCSI
	%MassIoInit(Dummy)
	%MassIoInit(Dummy)			;Device class 18: Nonexistent (config error)

	%MassIoDone

;###############################################################
;
;  Space occupied by the tables below this location will be
; recalimed by the OS after its initialization
;
;  ANY RE-ORDERING OF THIS FILE MUST NOT CROSS THIS BOUNDRY !!!
;
; CTOS has been carefully constructed so that the various parts
; of CTOS reside either before this boundry (resident code and
; data) or after (initialization code and data).  There are
; five segments which are used in controlling this:
;
;	"code" ... anything in this segment will be resident
;	"const" .. anything in this segment will be resident
;	"data" ... anything in this segment will be resident if
;		   the module is linked before SysGen.Obj, or
;		   non resident if linked after
;	"stack" .. anything in this segment will be nonresident
;	"coed" ... anything in this segment will be non
;		   resident (ie discarded after intialization)
;
; The CTOS processes are allocated stacks out of memory
; reserved by the following macro call, and the stack segment
; is used only for a stack during CTOS initialization.
;
; The following macro is invoked with one argument, the number
; of bytes to be reserved for CTOS to use to build its
; structures, tables, and to allocate the stacks for the
; different processes (declared later in this file).  The macro
; variable sOsData may be defined in the prefix file if
; desired.  The OS will crash with as error 101 if this value
; is too small.
;################################################################

%ResidentDataBoundry(50700)

EVEN
;###############################################################
;
;   Table which describes the CTOS resident processes.  Each
; process is described by 4 attributes:     
;				
;      1. Process entry point                       
;      2. Size of its stack
;      3. priority (0 is highest, 254 lowest)
;      4. default exchange (0 if not required, <> 0 allocs next available)
;      5. optional "check proc" name; if supplied (non-0), proc is called
;         to decide if the process should be created
;
;   Stack size --
;	The stack size for a CTOS process must be large enough
; for the largest local variable and procedure call sequence.
;                                                   
;###############################################################


%OsProcDesc(FileSystem, 656, 6, %TRUE, 0)
%OsProcDesc(MassIo, 1024, 10, %TRUE, 0)
%OsProcDesc(ScsiManager, 1280, 10, %FALSE, CheckForScsiHardware)

EVEN
;###############################################################
; CTOS INITIALIZATION --
; The following macros generate three tables of pointers which
; are used by FileSys during its initialization phase. All of the
; routines pointed to in these tables reside in modules which
; are linked near the start of the image, and the code for these
; modules is discarded after initialization is complete. These
; routines should have their code segments named "coed", and
; should use "data" for the name of their data segments. This
; is to insure that the Linker will place the code and data at
; the start of the run file, before the "ResidentDataBoundry"
; mentioned earlier in this file. The routines should obey the
; Convergent programming conventions related to register usage
; (refer to The Assembly Language Manual). The routines are
; executed at one of three times during initialization:
;
;   InitProcHardware
;		First after booted. This is the place to put hardware
;		test and verification routines.
;
;   InitProcIntDisable
;		After structures have been initialized but before
;		any processes have been started. This is the place to
;		put hardware inititialization routines.
;
;   InitProcIntEnable
;		After interrupts are enabled these routines are executed
;		as if they were a user program. (CTOS processes are running).
;		This is the place to put initialization routines.
;
; The routines are called in the order given, with no arguments, as
; subroutines using the Assembly Language indirect far call instruction.
;

	    %InitProcHardware(InitFsDataStructures)
	    %InitProcHardware(InitSysConfig)

	    %InitProcIntDisable(InitFsHardware)

	    %InitProcIntEnable(InitFsMountDevices)
	    %InitProcIntEnable(InitFsSysDevNum)
	    %InitProcIntEnable(InitFsSystemTime)

	    %InitProcIntEnable(InitFsFinish)


EVEN
;###############################################################
; System common subroutine definitions
;  The macro takes number, name and procedural interface for each routine
;  to be installed.
;
;################################################################
%SystemCommon(5, "StringsEqual",      "")
%SystemCommon(158, "UpdateFsDeviceName", "")

EVEN
;###############################################################
; Interrupt routine definitions
;  The macro takes device type, name, fDevice and fRaw for each routine
;  to be installed.
;
;################################################################
%'Interrupt(tyRS4221, "SigIsr", TRUE, TRUE)

EVEN
;###############################################################
; RTC initialization
;  Externally defined RTC blocks may be initialized at installation
;  using the RtcRq macro.
;  Arguments are
;      public name, timeInterval, resetValue, cEvents, exchange, rqCode.
;
;################################################################
%RtcRq(rqTimeAvr,10,10,2,0,0)%' for PC Auto-mount polling

EVEN
;################################################################
; File system miscellaneous data structures
; Change these setting as needed
;
%SET(nDisk, 16)
%SET(nFloppy, 4)
%SET(nMemDisk, 2)
%SET(nSCSI, 4)

%SET(fVerifyFileStruct, 0)
%SET(nFcb, 1200)
%SET(nFab, %nFcb*2)
%SET(nFub, %nFcb*2)
%SET(fFabUfbOwnSeg, %TRUE)
%SET(nIob, %nDisk*5+%nMemDisk*2)
%SET(nLucb, %nDisk+%nScsi)
%SET(nUpb, %nLucb*2)
%SET(nScsiIob, %nIob+2)

%SET(cbNameSpace,%nFcb*25)

%FileSystem(NGen)

EVEN
;###############################################################
; DEVICE DECLARATIONS
;
; The device declarations reserve Device Control Blocks (DCB's) for all
; mass storage (i.e. direct access) devices that are anticipated on a
; particular OS.  The only function of the DCB declared at system
; generation time is to associate a device name (e.g. F0, D0, D5 and so
; on) with the device.  The ACTUAL DCB's are dynamically allocated by
; initialization code; the device name, device password and retry limit
; are copied from the DCB declared below into the actual DCB.
;
; There are three families of devices recognized: floppy disks (either floppy
; or SCSI interfaces), rigid disks (either SMD, ST-506 or SCSI interfaces)
; and memory devices.  Conventional CTOS names within these families are
; Fn, Dn and Mn (where n is the device ordinal within its class), but these
; are configurable by the user.
;
; The DcbTemplate macro is used to declare the system generation DCB.
;
;	DcbTemplate(deviceFamily, "deviceName", "devicePassword", retryLimit)
;
; NOTES:	Device family must be 'floppyDisk', 'rigidDisk',
;		 'memDisk' or 'miscDevice'
;		Device name and password are limited to 12 characters

	%DcbTemplate(floppyDisk, "F0", "", 4)
	%DcbTemplate(floppyDisk, "F1", "", 4)
	%DcbTemplate(floppyDisk, "F2", "", 4)
	%DcbTemplate(floppyDisk, "F3", "", 4)
	%DcbTemplate(rigidDisk, "D0", "D0", 8)
	%DcbTemplate(rigidDisk, "D1", "D1", 8)
	%DcbTemplate(rigidDisk, "D2", "D2", 8)
	%DcbTemplate(rigidDisk, "D3", "D3", 8)
	%DcbTemplate(rigidDisk, "D4", "D4", 8)
	%DcbTemplate(rigidDisk, "D5", "D5", 8)
	%DcbTemplate(rigidDisk, "D6", "D6", 8)
	%DcbTemplate(rigidDisk, "D7", "D7", 8)
	%DcbTemplate(rigidDisk, "D8", "D8", 8)
	%DcbTemplate(rigidDisk, "D9", "D9", 8)
	%DcbTemplate(rigidDisk, "D10", "D10", 8)
	%DcbTemplate(rigidDisk, "D11", "D11", 8)
	%DcbTemplate(rigidDisk, "D12", "D12", 8)
	%DcbTemplate(rigidDisk, "D13", "D13", 8)
	%DcbTemplate(rigidDisk, "D14", "D14", 8)
	%DcbTemplate(rigidDisk, "D15", "D15", 8)
	%DcbTemplate(miscDevice, "Z0", "", 4)
	%DcbTemplate(miscDevice, "Z1", "", 4)
	%DcbTemplate(miscDevice, "Z2", "", 4)
	%DcbTemplate(miscDevice, "Z3", "", 4)
	%DcbTemplate(miscDevice, "Z4", "", 4)
	%DcbTemplate(miscDevice, "Z5", "", 4)
	%DcbTemplate(miscDevice, "Z6", "", 4)
	%DcbTemplate(miscDevice, "Z7", "", 4)

    %DcbTemplate(memDisk, "M0", "M0", 8)
    %DcbTemplate(memDisk, "M1", "M1", 8)

; SCSI Manager Declarations
;
; The following are the vendor ID and product ID for the GP/SI, which is a SCSI
; device. These values are copied to scsiMgrInquiryData by initialization code.
; See InitScsi_53C90.Plm and ScsiDriver_53C90.Plm for more information.
; Size of ScsiMgrVendorId must be 8. Size of ScsiMgrProductId must be 16.
; Size of ScsiMgrVersion must be 4.


%IF(%*isdef(ScsiMgrVendorId)) THEN (
    %SetScsiMgrVendorId("%ScsiMgrVendorId")
) ELSE (
    %SetScsiMgrVendorId("UNISYS  ")
)FI

%IF(%*isdef(ScsiMgrProductId)) THEN (
    %SetScsiMgrProductId("%ScsiMgrProductId")
) ELSE (
    %SetScsiMgrProductId("SCSI Manager    ")
)FI

%IF(%*isdef(ScsiMgrVersion)) THEN (
    %SetScsiMgrVersion("%ScsiMgrVersion")
) ELSE (
    %SetScsiMgrVersion("3.3 ")
)FI

; Summarize dcb structures in Gen.

%CreateGen

EVEN
;###############################################################
; FINAL --
;    This macro does error checking, and fills in various
; counts in the tables generated by the above macros calls.
;
;################################################################
%Final
END
