C  I/O ROUTINES (SPEAK, PSPEAK, RSPEAK, GETIN, YES, A5TOA1)


        SUBROUTINE SPEAK(N)

C  PRINT THE MESSAGE WHICH STARTS AT LINES(N).  PRECEDE IT WITH A BLANK LINE
C  UNLESS BLKLIN IS FALSE.

        IMPLICIT INTEGER(A-Z)
        LOGICAL BLKLIN
        COMMON /TXTCOM/ RTEXT,LINES
        COMMON /BLKCOM/ BLKBEG,BLKLIN,BLKEND
        DIMENSION RTEXT(205),LINES(9700),LINEST(15)

        IF(N.EQ.0)RETURN
        IF((LINES(N+1).XOR.'*^F?>').EQ.'>$<')RETURN
        IF(BLKLIN)TYPE 2
C  Reset BLKLIN (see comment in GETIN)
        BLKLIN=.TRUE.
        K=N
1       L=IABS(LINES(K))-1
        K=K+1
        II=0
        DO 444 I=K,L
        II=II+1
444     LINEST(II)=LINES(I).XOR.'*^F?>'
        TYPE 2,(LINEST(I),I=1,II)
2       FORMAT(' ',14A5)
        K=L+1
        IF(LINES(K).GE.0)GOTO 1
        RETURN
        END



        SUBROUTINE PSPEAK(MSG,SKIP)

C  FIND THE SKIP+1ST MESSAGE FROM MSG AND PRINT IT.  MSG SHOULD BE THE INDEX OF
C  THE INVENTORY MESSAGE FOR OBJECT.  (INVEN+N+1 MESSAGE IS PROP=N MESSAGE).

        IMPLICIT INTEGER(A-Z)
        COMMON /TXTCOM/ RTEXT,LINES
        COMMON /PTXCOM/ PTEXT
        DIMENSION RTEXT(205),LINES(9700),PTEXT(100)

        M=PTEXT(MSG)
        IF(SKIP.LT.0)GOTO 9
        DO 3 I=0,SKIP
1       M=IABS(LINES(M))
        IF(LINES(M).GE.0)GOTO 1
3       CONTINUE
9       CALL SPEAK(M)
        RETURN
        END



        SUBROUTINE RSPEAK(I)

C  PRINT THE I-TH "RANDOM" MESSAGE (SECTION 6 OF DATABASE).

        IMPLICIT INTEGER(A-Z)
        COMMON /TXTCOM/ RTEXT
        DIMENSION RTEXT(205)

        IF(I.NE.0)CALL SPEAK(RTEXT(I))
        RETURN
        END



        SUBROUTINE MSPEAK(I)

C  PRINT THE I-TH "MAGIC" MESSAGE (SECTION 12 OF DATABASE).

        IMPLICIT INTEGER(A-Z)
        COMMON /MTXCOM/ MTEXT
        DIMENSION MTEXT(35)

        IF(I.NE.0)CALL SPEAK(MTEXT(I))
        RETURN
        END



        SUBROUTINE GETIN(WORD1,WORD1X,WORD1Y,WORD2,WORD2X,WORD2Y)

C  GET A COMMAND FROM THE ADVENTURER.  SNARF OUT THE FIRST WORD, PAD IT WITH
C  BLANKS, AND RETURN IT IN WORD1.  WORD1X AND WORD1Y WILL GET UP TO 10 CHARS
C  IN LOWER CASE, FOR USE IN ERROR MESSAGES, ETC.
C  ANY NUMBER OF BLANKS MAY FOLLOW THE WORD.  IF A SECOND WORD APPEARS,
C  IT IS RETURNED IN WORD2 (LOWER CASE IN WORD2X, WORD2Y), ELSE WORD2 IS
C  SET TO ZERO.

        IMPLICIT INTEGER(A-Z)
        LOGICAL BLKLIN
        COMMON /BLKCOM/ BLKBEG,BLKLIN,BLKEND
        DIMENSION A(5),MASKS(6)
        DATA MASKS/"4000000000,"20000000,"100000,"400,"2,0/
        1      ,BLANKS/'     '/

        LC(X)=X.OR.(SHIFT((X.AND.'@@@@@'),-1))
        IF(BLKLIN)TYPE 1
1       FORMAT()
2       ACCEPT 3,(A(I),I=1,4)
3       FORMAT(4A5)
        J=0
        DO 9 I=1,4
        IF(A(I).NE.BLANKS)J=1
9       A(I)=A(I).AND.(SHIFT((A(I).AND.'@@@@@'),-1).XOR.-1)
        IF(BLKLIN.AND.J.EQ.0)GOTO 2

        SECOND=0
        WORD1X=A(1)
        WORD1Y=A(2)
        WORD2X=0
        WORD2Y=0

        DO 10 J=1,4
        DO 10 K=1,5
        MSK="774000000000
        IF(K.NE.1)MSK="177*MASKS(K)
        IF(((A(J).XOR.BLANKS).AND.MSK).EQ.0)GOTO 15
        IF(SECOND.EQ.0)GOTO 10
        MSK=-MASKS(6-K)
        WORD2X=(SHIFT(A(J),7*(K-1)).AND.MSK)
        1      +(SHIFT(A(J+1),7*(K-6)).AND.(-2-MSK))
        WORD2Y=(SHIFT(A(J+1),7*(K-1)).AND.MSK)
        1      +(SHIFT(A(J+2),7*(K-6)).AND.(-2-MSK))
        GO TO 20

15      IF(SECOND.EQ.1)GOTO 10
        SECOND=1
        IF(J.EQ.1)WORD1X=(WORD1X.AND.-MASKS(K))
        1      .OR.(BLANKS.AND.(-MASKS(K).XOR.-1))
10      CONTINUE

20      WORD1=WORD1X
        WORD2=WORD2X
        WORD1X=LC(WORD1X)
        WORD1Y=LC(WORD1Y)
        WORD2X=LC(WORD2X)
        WORD2Y=LC(WORD2Y)
C  Set BLKLIN to .FALSE. since new FOROTS will put out an extra line.
        BLKLIN=.FALSE.
        RETURN
        END



        LOGICAL FUNCTION YES(X,Y,Z)

C  CALL YESX (BELOW) WITH MESSAGES FROM SECTION 6.

        IMPLICIT INTEGER(A-Z)
        EXTERNAL RSPEAK
        LOGICAL YESX

        YES=YESX(X,Y,Z,RSPEAK)
        RETURN
        END



        LOGICAL FUNCTION YESM(X,Y,Z)

C  CALL YESX (BELOW) WITH MESSAGES FROM SECTION 12.

        IMPLICIT INTEGER(A-Z)
        EXTERNAL MSPEAK
        LOGICAL YESX

        YESM=YESX(X,Y,Z,MSPEAK)
        RETURN
        END



        LOGICAL FUNCTION YESX(X,Y,Z,SPK)

C  PRINT MESSAGE X, WAIT FOR YES/NO ANSWER.  IF YES, PRINT Y AND LEAVE YEA
C  TRUE; IF NO, PRINT Z AND LEAVE YEA FALSE.  SPK IS EITHER RSPEAK OR MSPEAK.

        IMPLICIT INTEGER(A-Z)

1       IF(X.NE.0)CALL SPK(X)
        CALL GETIN(REPLY,JUNK,JUNK,JUNK,JUNK,JUNK)
        IF(REPLY.EQ.'YES'.OR.REPLY.EQ.'Y')GOTO 10
        IF(REPLY.EQ.'NO'.OR.REPLY.EQ.'N')GOTO 20
        TYPE 9
9       FORMAT(/' Please answer the question.')
        GOTO 1
10      YESX=.TRUE.
        IF(Y.NE.0)CALL SPK(Y)
        RETURN
20      YESX=.FALSE.
        IF(Z.NE.0)CALL SPK(Z)
        RETURN
        END



        SUBROUTINE A5TOA1(A,B,C,CHARS,LENG)

C  A AND B CONTAIN A 1- TO 9-CHARACTER WORD IN A5 FORMAT, C CONTAINS ANOTHER
C  WORD AND/OR PUNCTUATION.  THEY ARE UNPACKED TO ONE CHARACTER PER WORD IN THE
C  ARRAY "CHARS", WITH EXACTLY ONE BLANK BETWEEN B AND C (OR NONE, IF C >= 0).
C  THE INDEX OF THE LAST NON-BLANK CHAR IN CHARS IS RETURNED IN LENG.

        IMPLICIT INTEGER(A-Z)
        DIMENSION CHARS(20),WORDS(3)
        DATA MASK,BLANK/"774000000000,' '/

        WORDS(1)=A
        WORDS(2)=B
        WORDS(3)=C
        POSN=1
        DO 1 WORD=1,3
        IF(WORD.EQ.2.AND.POSN.NE.6)GOTO 1
        IF(WORD.EQ.3.AND.C.LT.0)POSN=POSN+1
        DO 2 CH=1,5
        CHARS(POSN)=(WORDS(WORD).AND.MASK)+(BLANK-(BLANK.AND.MASK))
        IF(CHARS(POSN).EQ.BLANK)GOTO 1
        LENG=POSN
        WORDS(WORD)=SHIFT(WORDS(WORD),7)
2       POSN=POSN+1
1       CONTINUE
        RETURN
        END
C  <FORM FEED GOES HERE>
C  DATA STRUCTURE ROUTINES (VOCAB, DSTROY, JUGGLE, MOVE, PUT, CARRY, DROP)


        INTEGER FUNCTION VOCAB(ID,INIT)

C  LOOK UP ID IN THE VOCABULARY (ATAB) AND RETURN ITS "DEFINITION" (KTAB), OR
C  -1 IF NOT FOUND.  IF INIT IS POSITIVE, THIS IS AN INITIALISATION CALL SETTING
C  UP A KEYWORD VARIABLE, AND NOT FINDING IT CONSTITUTES A BUG.  IT ALSO MEANS
C  THAT ONLY KTAB VALUES WHICH TAKEN OVER 1000 EQUAL INIT MAY BE CONSIDERED.
C  (THUS "STEPS", WHICH IS A MOTION VERB AS WELL AS AN OBJECT, MAY BE LOCATED
C  AS AN OBJECT.)  AND IT ALSO MEANS THE KTAB VALUE IS TAKEN MOD 1000.

        IMPLICIT INTEGER(A-Z)
        COMMON /VOCCOM/ KTAB,ATAB,TABSIZ
        DIMENSION KTAB(300),ATAB(300)

        HASH=ID.XOR.'PHROG'
        DO 1 I=1,TABSIZ
        IF(KTAB(I).EQ.-1)GOTO 2
        IF(INIT.GE.0.AND.KTAB(I)/1000.NE.INIT)GOTO 1
        IF(ATAB(I).EQ.HASH)GOTO 3
1       CONTINUE
        CALL BUG(21)

2       VOCAB=-1
        IF(INIT.LT.0)RETURN
        CALL BUG(5)

3       VOCAB=KTAB(I)
        IF(INIT.GE.0)VOCAB=MOD(VOCAB,1000)
        RETURN
        END



        SUBROUTINE DSTROY(OBJ)

C  PERMANENTLY ELIMINATE "OBJECT" BY MOVING TO A NON-EXISTENT LOCATION.

        IMPLICIT INTEGER(A-Z)

        OBJECT=OBJ            !HACK TO KEEP HI-SEG FROM BEING WRITTEN
        CALL MOVE(OBJECT,0)
        RETURN
        END



        SUBROUTINE JUGGLE(OBJ)

C  JUGGLE AN OBJECT BY PICKING IT UP AND PUTTING IT DOWN AGAIN, THE PURPOSE
C  BEING TO GET THE OBJECT TO THE FRONT OF THE CHAIN OF THINGS AT ITS LOC.

        IMPLICIT INTEGER(A-Z)
        COMMON /PLACOM/ PLABEG,ATLOC,LINK,PLACE,FIXED,HOLDNG,PLAEND
        DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)

        OBJECT=OBJ            !HACK TO KEEP HI-SEG FROM BEING WRITTEN
        I=PLACE(OBJECT)
        J=FIXED(OBJECT)
        CALL MOVE(OBJECT,I)
        CALL MOVE(OBJECT+100,J)
        RETURN
        END



        SUBROUTINE MOVE(OBJ,WH)

C  PLACE ANY OBJECT ANYWHERE BY PICKING IT UP AND DROPPING IT.  MAY ALREADY BE
C  TOTING, IN WHICH CASE THE CARRY IS A NO-OP.  MUSTN'T PICK UP OBJECTS WHICH
C  ARE NOT AT ANY LOC, SINCE CARRY WANTS TO REMOVE OBJECTS FROM ATLOC CHAINS.

        IMPLICIT INTEGER(A-Z)
        COMMON /PLACOM/ PLABEG,ATLOC,LINK,PLACE,FIXED,HOLDNG,PLAEND
        DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)

        OBJECT=OBJ            !HACK TO KEEP HI-SEG FROM BEING WRITTEN
        WHERE=WH              !DITTO
        IF(OBJECT.GT.100)GOTO 1
        FROM=PLACE(OBJECT)
        GOTO 2
1       FROM=FIXED(OBJECT-100)
2       IF(FROM.GT.0.AND.FROM.LE.300)CALL CARRY(OBJECT,FROM)
        CALL DROP(OBJECT,WHERE)
        RETURN
        END



        INTEGER FUNCTION PUT(OBJ,WH,PVAL)

C  PUT IS THE SAME AS MOVE, EXCEPT IT RETURNS A VALUE USED TO SET UP THE
C  NEGATED PROP VALUES FOR THE REPOSITORY OBJECTS.

        IMPLICIT INTEGER(A-Z)

        OBJECT=OBJ            !HACK TO KEEP HI-SEG FROM BEING WRITTEN
        WHERE=WH              !DITTO
        CALL MOVE(OBJECT,WHERE)
        PUT=(-1)-PVAL
        RETURN
        END



        SUBROUTINE CARRY(OBJECT,WHERE)

C  START TOTING AN OBJECT, REMOVING IT FROM THE LIST OF THINGS AT ITS FORMER
C  LOCATION.  INCR HOLDNG UNLESS IT WAS ALREADY BEING TOTED.  IF OBJECT>100
C  (MOVING "FIXED" SECOND LOC), DON'T CHANGE PLACE OR HOLDNG.

        IMPLICIT INTEGER(A-Z)
        COMMON /PLACOM/ PLABEG,ATLOC,LINK,PLACE,FIXED,HOLDNG,PLAEND
        DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)

        IF(OBJECT.GT.100)GOTO 5
        IF(PLACE(OBJECT).EQ.-1)RETURN
        PLACE(OBJECT)=-1
        HOLDNG=HOLDNG+1
5       IF(ATLOC(WHERE).NE.OBJECT)GOTO 6
        ATLOC(WHERE)=LINK(OBJECT)
        RETURN
6       TEMP=ATLOC(WHERE)
7       IF(LINK(TEMP).EQ.OBJECT)GOTO 8
        TEMP=LINK(TEMP)
        GOTO 7
8       LINK(TEMP)=LINK(OBJECT)
        RETURN
        END



        SUBROUTINE DROP(OBJECT,WHERE)

C  PLACE AN OBJECT AT A GIVEN LOC, PREFIXING IT ONTO THE ATLOC LIST.  DECR
C  HOLDNG IF THE OBJECT WAS BEING TOTED.

        IMPLICIT INTEGER(A-Z)
        COMMON /PLACOM/ PLABEG,ATLOC,LINK,PLACE,FIXED,HOLDNG,PLAEND
        DIMENSION ATLOC(150),LINK(200),PLACE(100),FIXED(100)
        
        IF(OBJECT.GT.100)GOTO 1
        IF(PLACE(OBJECT).EQ.-1)HOLDNG=HOLDNG-1
        PLACE(OBJECT)=WHERE
        GOTO 2
1       FIXED(OBJECT-100)=WHERE
2       IF(WHERE.LE.0)RETURN
        LINK(OBJECT)=ATLOC(WHERE)
        ATLOC(WHERE)=OBJECT
        RETURN
        END
C  <FORM FEED GOES HERE>
C  WIZARDRY ROUTINES (START, MAINT, WIZARD, HOURS(X), NEWHRS(X), MOTD, POOF)


        LOGICAL FUNCTION START(DUMMY)

C  CHECK TO SEE IF THIS IS "PRIME TIME".  IF SO, ONLY WIZARDS MAY PLAY, THOUGH
C  OTHERS MAY BE ALLOWED A SHORT GAME FOR DEMONSTRATION PURPOSES.  IF SETUP<0,
C  WE'RE CONTINUING FROM A SAVED GAME, SO CHECK FOR SUITABLE LATENCY.  RETURN
C  TRUE IF THIS IS A DEMO GAME (VALUE IS IGNORED FOR RESTARTS).

        IMPLICIT INTEGER(A-Z)
        LOGICAL PTIME,SOON,YESM
        DIMENSION HNAME(6)
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
        1      SHORT,MAGIC,MAGNM,LATNCY,WIZBEG,SAVED,SAVET,SETUP,
        2      WIZEND

C  PREVENT NASTY OVERFLOW MESSAGES
        CALL ERRSET(0)

C  FIRST FIND OUT WHETHER IT IS PRIME TIME (SAVE IN PTIME) AND, IF RESTARTING,
C  WHETHER IT'S TOO SOON (SAVE IN SOON).  PRIME-TIME SPECS ARE IN WKDAY, WKEND,
C  AND HOLID; SEE MAINT ROUTINE FOR DETAILS.  LATNCY IS REQUIRED DELAY BEFORE
C  RESTARTING.  WIZARDS MAY CUT THIS TO A THIRD.

        CALL DATIME(D,T)
        PRIMTM=WKDAY
        IF(MOD(D,7).LE.1)PRIMTM=WKEND
        IF(D.GE.HBEGIN.AND.D.LE.HEND)PRIMTM=HOLID
        PTIME=(PRIMTM.AND.SHIFT(1,T/60)).NE.0
        SOON=.FALSE.
        IF(SETUP.GE.0)GOTO 20
        DELAY=(D-SAVED)*1440+(T-SAVET)
        IF(DELAY.GE.LATNCY)GOTO 20
        TYPE 10,DELAY
10      FORMAT(' This adventure was suspended a mere',I3,' minutes ago.')
        SOON=.TRUE.
        IF(DELAY.GE.LATNCY/3)GOTO 20
        CALL MSPEAK(2)
        CALL BYE

C  IF NEITHER TOO SOON NOR PRIME TIME, NO PROBLEM.  ELSE SPECIFY WHAT'S WRONG.

20      START=.FALSE.
        IF(SOON)GOTO 30
        IF(PTIME)GOTO 25
22      SAVED=-1
        RETURN

C  COME HERE IF NOT RESTARTING TOO SOON (MAYBE NOT RESTARTING AT ALL), BUT IT'S
C  PRIME TIME.  GIVE OUR HOURS AND SEE IF HE'S A WIZARD.  IF NOT, THEN CAN'T
C  RESTART, BUT IF JUST BEGINNING THEN WE CAN OFFER A SHORT GAME.

25      CALL MSPEAK(3)
        CALL HOURS
        CALL MSPEAK(4)
        IF(WIZARD(0))GOTO 22
        IF(SETUP.LT.0)GOTO 33
        START=YESM(5,7,7)
        IF(START)GOTO 22
        CALL BYE

C  COME HERE IF RESTARTING TOO SOON.  IF HE'S A WIZARD, LET HIM GO (AND NOTE
C  THAT IT THEN DOESN'T MATTER WHETHER IT'S PRIME TIME).  ELSE, TOUGH BEANS.

30      CALL MSPEAK(8)
        IF(WIZARD(0))GOTO 22
33      CALL MSPEAK(9)
        CALL BYE
        END



        SUBROUTINE MAINT

C  SOMEONE SAID THE MAGIC WORD TO INVOKE MAINTENANCE MODE.  MAKE SURE HE'S A
C  WIZARD.  IF SO, LET HIM TWEAK ALL SORTS OF RANDOM THINGS, THEN EXIT SO CAN
C  SAVE TWEAKED VERSION.  SINCE MAGIC WORD MUST BE FIRST COMMAND GIVEN, ONLY
C  THING WHICH NEEDS TO BE FIXED UP IS ABB(1).

        IMPLICIT INTEGER(A-Z)
        LOGICAL YESM,BLKLIN
        DIMENSION HNAME(6),ABB(150)
        COMMON /BLKCOM/ BLKBEG,BLKLIN,BLKEND
        COMMON /ABBCOM/ ABBBEG,ABB,ABBEND
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
        1      SHORT,MAGIC,MAGNM,LATNCY,WIZBEG,SAVED,SAVET,SETUP,
        2      WIZEND

        IF(.NOT.WIZARD(0))RETURN
        BLKLIN=.FALSE.
        IF(YESM(10,0,0))CALL HOURS
        IF(YESM(11,0,0))CALL NEWHRS
        IF(.NOT.YESM(26,0,0))GOTO 10
        CALL MSPEAK(27)
        ACCEPT 1,HBEGIN
1       FORMAT(G)
        CALL MSPEAK(28)
        ACCEPT 1,HEND
        CALL DATIME(D,T)
        HBEGIN=HBEGIN+D
        HEND=HBEGIN+HEND-1
        CALL MSPEAK(29)
        ACCEPT 2,HNAME
2       FORMAT(6A5)
10      TYPE 12,SHORT
12      FORMAT(' Length of short game (Null to leave at',I3,'):')
        ACCEPT 1,X
        IF(X.GT.0)SHORT=X
        CALL MSPEAK(12)
        BLKLIN=.FALSE.
        CALL GETIN(X,Y,Y,Y,Y,Y)
        IF(X.NE.' ')MAGIC=X
        CALL MSPEAK(13)
        ACCEPT 1,X
        IF(X.GT.0)MAGNM=X
        TYPE 16,LATNCY
16      FORMAT(' Latency for restart (Null to leave at',I3,'):')
        ACCEPT 1,X
        IF(X.GT.0.AND.X.LT.45)CALL MSPEAK(30)
        IF(X.GT.0)LATNCY=MAX0(45,X)
        IF(YESM(14,0,0))CALL MOTD(.TRUE.)
        SAVED=0
        SETUP=2
        ABB(1)=0
        CALL MSPEAK(15)
        BLKLIN=.TRUE.
        CALL CIAO
        END



        LOGICAL FUNCTION WIZARD(DUMMY)

C  ASK IF HE'S A WIZARD.  IF HE SAYS YES, MAKE HIM PROVE IT.  RETURN TRUE IF HE
C  REALLY IS A WIZARD.

        IMPLICIT INTEGER(A-Z)
        LOGICAL YESM
        DIMENSION HNAME(6),VAL(5)
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
        1      SHORT,MAGIC,MAGNM,LATNCY,WIZBEG,SAVED,SAVET,SETUP,
        2      WIZEND

        WIZARD=YESM(16,0,7)
        IF(.NOT.WIZARD)RETURN

C  HE SAYS HE IS.  FIRST STEP: DOES HE KNOW ANYTHING MAGICAL?

        CALL MSPEAK(17)
        CALL GETIN(WORD,X,X,X,X,X)
        IF(WORD.NE.MAGIC)GOTO 99

C  HE DOES.  GIVE HIM A RANDOM CHALLENGE AND CHECK HIS REPLY.

        CALL DATIME(D,T)
        T=T*2+1
        WORD='@@@@@'
        DO 15 Y=1,5
        X=79+MOD(D,5)
        D=D/5
        DO 12 Z=1,X
12      T=MOD(T*1027,1048576)
        VAL(Y)=(T*26)/1048576+1
15      WORD=WORD+SHIFT(VAL(Y),36-7*Y)
        IF(YESM(18,0,0))GOTO 99
        TYPE 18,WORD
18      FORMAT(/1X,A5)
        CALL GETIN(WORD,X,X,X,X,X)
        CALL DATIME(D,T)
        T=(T/60)*40+(T/10)*10
        D=MAGNM
        DO 19 Y=1,5
        Z=MOD(Y,5)+1
        X=MOD(IABS(VAL(Y)-VAL(Z))*MOD(D,10)+MOD(T,10),26)+1
        T=T/10
        D=D/10
19      WORD=WORD-SHIFT(X,36-7*Y)
        IF(WORD.NE.'@@@@@')GOTO 99

C  BY GEORGE, HE REALLY *IS* A WIZARD!

        CALL MSPEAK(19)
        RETURN

C  AHA!  AN IMPOSTOR!

99      CALL MSPEAK(20)
        WIZARD=.FALSE.
        RETURN
        END



        SUBROUTINE HOURS

C  ANNOUNCE THE CURRENT HOURS WHEN THE CAVE IS OPEN FOR ADVENTURING.  THIS INFO
C  IS STORED IN WKDAY, WKEND, AND HOLID, WHERE BIT SHIFT(1,N) IS ON IFF THE
C  HOUR FROM N:00 TO N:59 IS "PRIME TIME" (CAVE CLOSED).  WKDAY IS FOR
C  WEEKDAYS, WKEND FOR WEEKENDS, HOLID FOR HOLIDAYS.  NEXT HOLIDAY IS FROM
C  HBEGIN TO HEND.

        IMPLICIT INTEGER(A-Z)
        DIMENSION HNAME(6),VAL(5)
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME

        TYPE 1
1       FORMAT()
        CALL HOURSX(WKDAY,'Mon -',' Fri:')
        CALL HOURSX(WKEND,'Sat -',' Sun:')
        CALL HOURSX(HOLID,'Holid','ays: ')
        CALL DATIME(D,T)
        IF(HEND.LT.D.OR.HEND.LT.HBEGIN)RETURN
        IF(HBEGIN.GT.D)GOTO 10
        TYPE 5,HNAME
5       FORMAT(/' Today is a holiday, namely ',6A5)
        RETURN

10      D=HBEGIN-D
        T='days,'
        IF(D.EQ.1)T='day, '
        TYPE 15,D,T,HNAME
15      FORMAT(/' The next holiday will be in',I3,' ',A5,' namely ',6A5)
        RETURN
        END



        SUBROUTINE HOURSX(H,DAY1,DAY2)

C  USED BY HOURS (ABOVE) TO PRINT HOURS FOR EITHER WEEKDAYS OR WEEKENDS.

        IMPLICIT INTEGER(A-Z)
        LOGICAL FIRST

        FIRST=.TRUE.
        FROM=-1
        IF(H.NE.0)GOTO 10
        TYPE 2,DAY1,DAY2
2       FORMAT(10X,2A5,'   Open all day')
        RETURN

10      FROM=FROM+1
        IF((H.AND.SHIFT(1,FROM)).NE.0)GOTO 10
        IF(FROM.GE.24)GOTO 20
        TILL=FROM
14      TILL=TILL+1
        IF((H.AND.SHIFT(1,TILL)).EQ.0.AND.TILL.NE.24)GOTO 14
        IF(FIRST)TYPE 16,DAY1,DAY2,FROM,TILL
        IF(.NOT.FIRST)TYPE 18,FROM,TILL
16      FORMAT(10X,2A5,I4,':00 to',I3,':00')
18      FORMAT(20X,I4,':00 to',I3,':00')
        FIRST=.FALSE.
        FROM=TILL
        GOTO 10

20      IF(FIRST)TYPE 22,DAY1,DAY2
22      FORMAT(10X,2A5,'  Closed all day')
        RETURN
        END



        SUBROUTINE NEWHRS

C  SET UP NEW HOURS FOR THE CAVE.  SPECIFIED AS INVERSE--I.E., WHEN IS IT
C  CLOSED DUE TO PRIME TIME?  SEE HOURS (ABOVE) FOR DESC OF VARIABLES.

        IMPLICIT INTEGER(A-Z)
        DIMENSION HNAME(6)
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME

        CALL MSPEAK(21)
        WKDAY=NEWHRX('Weekd','ays:')
        WKEND=NEWHRX('Weeke','nds:')
        HOLID=NEWHRX('Holid','ays:')
        CALL MSPEAK(22)
        CALL HOURS
        RETURN
        END



        INTEGER FUNCTION NEWHRX(DAY1,DAY2)

C  INPUT PRIME TIME SPECS AND SET UP A WORD OF INTERNAL FORMAT.

        IMPLICIT INTEGER(A-Z)

        NEWHRX=0
        TYPE 1,DAY1,DAY2
1       FORMAT(' Prime time on ',2A5)
10      TYPE 2
2       FORMAT(' From:')
        ACCEPT 3,FROM
3       FORMAT(G)
        IF(FROM.LT.0.OR.FROM.GE.24)RETURN
        TYPE 4
4       FORMAT(' till:')
        ACCEPT 3,TILL
        TILL=TILL-1
        IF(TILL.LT.FROM.OR.TILL.GE.24)RETURN
        DO 5 I=FROM,TILL
5       NEWHRX=(NEWHRX.OR.SHIFT(1,I))
        GOTO 10
        END



        SUBROUTINE MOTD(ALTER)

C  HANDLES MESSAGE OF THE DAY.  IF ALTER IS TRUE, READ A NEW MESSAGE FROM THE
C  WIZARD.  ELSE PRINT THE CURRENT ONE.  MESSAGE IS INITIALLY NULL.

        IMPLICIT INTEGER(A-Z)
        LOGICAL ALTER
        DIMENSION MSG(100)
        DATA MSG/100*-1/

        IF(ALTER)GOTO 50

        K=1
10      IF(MSG(K).LT.0)RETURN
        TYPE 20,(MSG(I),I=K+1,MSG(K)-1)
20      FORMAT(' ',14A5)
        K=MSG(K)
        GOTO 10

50      M=1
        CALL MSPEAK(23)
55      ACCEPT 56,(MSG(I),I=M+1,M+14),K
56      FORMAT(15A5)
        IF(K.EQ.' ')GOTO 60
        CALL MSPEAK(24)
        GOTO 55
60      DO 62 I=1,14
        K=M+15-I
        IF(MSG(K).NE.' ')GOTO 65
62      CONTINUE
        GOTO 90
65      MSG(M)=K+1
        M=K+1
        IF(M+14.LT.100)GOTO 55
        CALL MSPEAK(25)
90      MSG(M)=-1
        RETURN
        END



        SUBROUTINE POOF

C  AS PART OF DATABASE INITIALISATION, WE CALL POOF TO SET UP SOME DUMMY
C  PRIME-TIME SPECS, MAGIC WORDS, ETC.

        IMPLICIT INTEGER(A-Z)
        DIMENSION HNAME(6)
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
        1      SHORT,MAGIC,MAGNM,LATNCY,WIZBEG,SAVED,SAVET,SETUP,
        2      WIZEND

        WKDAY="00777400
        WKEND=0
        HOLID=0
        HBEGIN=0
        HEND=-1
        SHORT=30
        MAGIC='DWARF'
        MAGNM=11111
        LATNCY=90
        RETURN
        END
C  <FORM FEED GOES HERE>
C  UTILITY ROUTINES (SHIFT, RAN, DATIME, CIAO, BYE, BUG)


        INTEGER FUNCTION SHIFT(VAL,DIST)
        IMPLICIT INTEGER(A-Z)

C  RETURN VAL LEFT-SHIFTED (LOGICALLY) DIST BITS (RIGHT-SHIFT IF DIST<0).

        SHIFT=VAL
        IF(DIST)10,20,30
10      IDIST=-DIST
        DO 11 I=1,IDIST
        J=0
        IF(SHIFT.LT.0)J="200000000000
11      SHIFT=((SHIFT.AND."377777777777)/2)+J
20      RETURN
30      DO 31 I=1,DIST
        J=0
        IF((SHIFT.AND."200000000000).NE.0)J="400000000000
31      SHIFT=(SHIFT.AND."177777777777)*2+J
        RETURN
        END



        INTEGER FUNCTION RAN(RANGE)

C  SINCE THE RAN FUNCTION IN LIB40 SEEMS TO BE A REAL LOSE, WE'LL USE ONE OF
C  OUR OWN.  IT'S BEEN RUN THROUGH MANY OF THE TESTS IN KNUTH VOL. 2 AND
C  SEEMS TO BE QUITE RELIABLE.  RAN RETURNS A VALUE UNIFORMLY SELECTED
C  BETWEEN 0 AND RANGE-1.  NOTE RESEMBLANCE TO ALG USED IN WIZARD.

        IMPLICIT INTEGER(A-Z)
        DATA R/0/

        D=1
        IF(R.NE.0)GOTO 1
        CALL DATIME(D,T)
        R=18*T+5
        D=1000+MOD(D,1000)
1       DO 2 T=1,D
2       R=MOD(R*1021,1048576)
        RAN=(RANGE*R)/1048576
        RETURN
        END



        SUBROUTINE DATIME(D,T)

C  RETURN THE DATE AND TIME IN D AND T.  D IS NUMBER OF DAYS SINCE 01-JAN-77,
C  T IS MINUTES PAST MIDNIGHT.  THIS IS HARDER THAN IT SOUNDS, BECAUSE THE
C  FINAGLED DEC FUNCTIONS RETURN THE VALUES ONLY AS ASCII STRINGS!

        IMPLICIT INTEGER(A-Z)
        DIMENSION DAT(2),MONTHS(12),HATH(12)
        DATA MONTHS/'-JAN-','-FEB-','-MAR-','-APR-','-MAY-','-JUN-',
        1      '-JUL-','-AUG-','-SEP-','-OCT-','-NOV-','-DEC-'/
        DATA HATH/31,28,31,30,31,30,31,31,30,31,30,31/

C  FUNCTION I2 TAKES 2-DIGIT ASCII AND YIELDS DECIMAL VALUE.

        I2(X)=(SHIFT(X,-29).AND.15)*10+(SHIFT(X,-22).AND.15)

        CALL DATE(DAT)
        CALL TIME(TIM)

        YEAR=I2(SHIFT(DAT(2),14))-77
        D=I2(DAT(1))-1
        X=((SHIFT(DAT(1),14).OR.SHIFT(DAT(2),-21)).AND..NOT."1004020001)
        1      .OR.'-@@@-'
C  ABOVE FUNNY EXPRESSION GUARANTEES (A) UPPER-CASE, AND (B) BOTTOM BIT OKAY.
        DO 1 MON=1,12
        IF(X.EQ.MONTHS(MON))GOTO 2
1       D=D+HATH(MON)
        CALL BUG(28)

2       D=D+YEAR*365+YEAR/4
        IF(MOD(YEAR,4).EQ.3.AND.MON.GT.2)D=D+1
        T=I2(TIM)*60+I2(SHIFT(TIM,21))
        RETURN
        END



        SUBROUTINE CIAO

C  EXITS, AFTER ISSUING REMINDER TO SAVE NEW CORE IMAGE.  USED WHEN
C  WHEN CREATING NEW VERSION VIA MAGIC MODE.  ON SOME SYSTEMS, THE CORE
C  IMAGE IS LOST ONCE THE PROGRAM EXITS.  IF SO, SET K=31 INSTEAD OF 32.

        IMPLICIT INTEGER(A-Z)
        DATA K/32/

        CALL MSPEAK(K)
        IF(K.EQ.31)CALL GETIN(A,A,A,A,A,A)
        CALL BYE
        END

        SUBROUTINE BYE
C
C  LEAVE WITHOUT ANY FUSS
C
        TYPE 1
1       FORMAT(' ')
        CALL ICALLI(0,"12)
        STOP
        END

        SUBROUTINE BUG(NUM)
        IMPLICIT INTEGER(A-Z)

C  THE FOLLOWING CONDITIONS ARE CURRENTLY CONSIDERED FATAL BUGS.  NUMBERS < 20
C  ARE DETECTED WHILE READING THE DATABASE; THE OTHERS OCCUR AT "RUN TIME".
C       0      MESSAGE LINE > 70 CHARACTERS
C       1      NULL LINE IN MESSAGE
C       2      TOO MANY WORDS OF MESSAGES
C       3      TOO MANY TRAVEL OPTIONS
C       4      TOO MANY VOCABULARY WORDS
C       5      REQUIRED VOCABULARY WORD NOT FOUND
C       6      TOO MANY RTEXT OR MTEXT MESSAGES
C       7      TOO MANY HINTS
C       8      LOCATION HAS COND BIT BEING SET TWICE
C       9      INVALID SECTION NUMBER IN DATABASE
C       20     SPECIAL TRAVEL (500>L>300) EXCEEDS GOTO LIST
C       21     RAN OFF END OF VOCABULARY TABLE
C       22     VOCABULARY TYPE (N/1000) NOT BETWEEN 0 AND 3
C       23     INTRANSITIVE ACTION VERB EXCEEDS GOTO LIST
C       24     TRANSITIVE ACTION VERB EXCEEDS GOTO LIST
C       25     CONDITIONAL TRAVEL ENTRY WITH NO ALTERNATIVE
C       26     LOCATION HAS NO TRAVEL ENTRIES
C       27     HINT NUMBER EXCEEDS GOTO LIST
C       28     INVALID MONTH RETURNED BY DATE FUNCTION

        TYPE 1, NUM
1       FORMAT (' FATAL ERROR, SEE SOURCE CODE FOR INTERPRETATION.'/
        1      ' PROBABLY CAUSE: ERRONEOUS INFO IN DATABASE.'/
        2      ' ERROR CODE =',I2/)
        STOP
        END

C  STATE SAVING/RESTORING ROUTINES (SVCOMN,PUTWD,PUTSIX,LDCOMN,GETWD,
C                                  GETSIX,MAKFIL)

        SUBROUTINE SVCOMN(WD2X,WD2Y,N,CMADRS,CMSZES,VRSION)
C
C  This subroutine will create a file with the necessary information
C  to restart a suspended game.  It makes use of the CMADRS and CMSZES
C  arrays set up in the main program to tell it what needs to be saved.
C  Blocks of storage beginning at CMADRS(i) and of length CMSZES(i)
C  will be saved.  Currently there are N such blocks.
C
        IMPLICIT INTEGER(A-Z)
        COMMON /PUTCOM/ ZERONE,COUNT,BCOUNT,WORD,ERR
        DIMENSION SAVNAM(2),DUMMY(1),CMADRS(N),CMSZES(N)

        CALL MAKFIL(WD2X,WD2Y,SAVNAM)

10      OPEN(UNIT=1,DIALOG=SAVNAM,MODE='IMAGE',ACCESS='SEQOUT',
        1PROTECTION="077,ERR=100)

        ZERONE=-1
        COUNT=0
        BCOUNT=0
        WORD=0
        ERR=0
        CHECK=0

        K=VRSION
        CALL PUTWD(K)
        DO 35 I=1,N
        K=CMSZES(I)
35      CALL PUTWD(K)
        DO 50 I = 1,N
        J = CMADRS(I)-LOCF(DUMMY(1))+1
        DO 40 K=J,J+CMSZES(I)
        CHECK=CHECK+(DUMMY(K).AND."007777775563)
        CALL PUTWD(DUMMY(K))
        IF(ERR.EQ.-1) GO TO 100
40      CONTINUE
50      CONTINUE
        CALL PUTWD(CHECK)
        IF(BCOUNT.NE.0) WRITE (1,ERR=100) WORD

        TYPE 60,SAVNAM
60      FORMAT(/' Your adventure has been saved in file ',2A5)
        RETURN
100     TYPE 101
101     FORMAT(/' I''m sorry, but I don''t seem to able to write',
        1   ' the file.')
        RETURN
        END

        SUBROUTINE PUTWD(W)
        IMPLICIT INTEGER (A-Z)
        COMMON /PUTCOM/ ZERONE,COUNT,BCOUNT,WORD,ERR
C
C  THIS ROUTINE CREATES A PACKED DATA FILE.  DATA IS WRITTEN IN 6-BIT
C  BYTES.  A BLOCK OF BYTES CAN HAVE 1 OF 3 FORMS:
C
C       00 NN         --  MEANS NN WORDS OF 0'S
C       07 NN         --  MEANS NN WORDS OF -1'S
C       NN AA BB...FF   --  WHERE NN IS 01 THRU 06 MEANS THAT
C                         THE NEXT NN BYTES FORM THE LOW-ORDER
C                         PORTION OF A WORD.
C         E.G. 0705031345610003  WOULD EXPAND TO:
C               -1, -1, -1, -1, -1, "134561, 0, 0, 0
C
C----------------------------------------------------------------------
C
C  FIRST, SEE IF WE HAVE A 0 OR -1 TO WRITE
C
        IF (W.NE.0.AND.W.NE.-1) GO TO 200

        IF (-7*W.EQ.ZERONE.OR.COUNT.EQ.0) GO TO 100

C  HERE IF WE HAVE FINISHED A RUN OF 0'S OR -1'S

50      CALL PUTSIX(ZERONE)
        CALL PUTSIX(COUNT)
        COUNT=0
        IF(W.NE.0.AND.W.NE.-1) GO TO 250

C  HERE TO START OR CONTINUE A NEW RUN OF 0'S OR -1'S

100     ZERONE=-7*W
        COUNT=COUNT+1
        IF(COUNT.LT.63) RETURN
        CALL PUTSIX(ZERONE)
        CALL PUTSIX(COUNT)
        COUNT=0
        RETURN

C  HERE WITH SOMETHING OTHER THAN 0, -1.  FIRST SEE IF WE MUST OUTPUT
C  A RUN.

200     IF(COUNT.EQ.0) GO TO 250
        GO TO 50

C  COUNT NUMBER OF SIGNIFICANT BYTES

250     K=6
        MASK="770000000000
260     IF((W.AND.MASK).NE.0) GO TO 300
        MASK=SHIFT(MASK,-6)
        K=K-1
        GO TO 260
300     CALL PUTSIX(K)
310     CALL PUTSIX(SHIFT((W.AND.MASK),(1-K)*6))
        MASK=SHIFT(MASK,-6)
        K=K-1
        IF(K.GT.0) GO TO 310
        RETURN
        END

        SUBROUTINE PUTSIX(S)
        IMPLICIT INTEGER(A-Z)
        COMMON /PUTCOM/ ZERONE,COUNT,BCOUNT,WORD,ERR

        BCOUNT=BCOUNT+1
        WORD=WORD.OR.SHIFT((S.AND."77),6*(6-BCOUNT))
        IF(BCOUNT.LT.6) RETURN
        WRITE(1,ERR=100) WORD
        BCOUNT=0
        WORD=0
        RETURN
100     ERR=-1
        RETURN
        END

        SUBROUTINE LDCOMN(WD2X,WD2Y,N,CMADRS,CMSZES,VRSION)
        IMPLICIT INTEGER(A-Z)
        COMMON /PUTCOM/ ZERONE,COUNT,BCOUNT,WORD,ERR
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME(6),
        1      SHORT,MAGIC,MAGNM,LATNCY,WIZBEG,SAVED,SAVET,SETUP,
        2      WIZEND
        DIMENSION SAVNAM(2),DUMMY(1),CMADRS(N),CMSZES(N)

        CALL MAKFIL(WD2X,WD2Y,SAVNAM)
10      OPEN(UNIT=1,DIALOG=SAVNAM,MODE='IMAGE',ACCESS='SEQIN',ERR=100)

        ZERONE=1
        COUNT=0
        BCOUNT=0
        WORD=0
        ERR=0
        CHECK=0

        IF(GETWD(0).NE.VRSION) GO TO 100
        DO 30 I = 1,N
        IF(GETWD(0).NE.CMSZES(I)) GO TO 100
30      CONTINUE
        DO 50 I = 1,N
        J = CMADRS(I)-LOCF(DUMMY(1))+1
        DO 40 K=J,J+CMSZES(I)
        DUMMY(K)=GETWD(0)
        CHECK=CHECK+(DUMMY(K).AND."007777775563)
        IF(ERR.EQ.-1) GO TO 100
40      CONTINUE
50      CONTINUE

        I=GETWD(0)
        IF(CHECK.NE.I) GO TO 100
        RETURN

100     TYPE 101,SAVNAM
101     FORMAT(/' I''m sorry, but I don''t seem to be able to read',
        1   ' file ',2A5)
C
C  MAKE SURE THAT A RESTART WILL DO THE RIGHT THING
C
        SETUP=3
        CALL BYE
        STOP
        END

        INTEGER FUNCTION GETWD(DUM)
        IMPLICIT INTEGER(A-Z)
        COMMON /PUTCOM/ ZERONE,COUNT,BCOUNT,WORD,ERR

        IF (COUNT.NE.0) GO TO 50
C
C  HERE WHEN WE DON'T HAVE ANY PARTIAL SEQUENCES TO RETURN
C
        W = GETSIX(0)
        IF (W.GE.1.AND.W.LE.6) GO TO 30
C
C  HERE WHEN WE DETECT A SEQUENCE OF 0'S OR -1'S
C
        IF(W.GT.7) GO TO 100
        ZERONE = -W/7
        COUNT= GETSIX(0)
        GO TO 50
C
C  HERE WHEN WE HAVE A WORD OTHER THAN 0, -1
C
30      GETWD=0
        DO 35 I=1,W
        K=GETSIX(0)
35      GETWD = SHIFT(GETWD,6).OR.K
        RETURN
C
C  HERE WHEN WE ARE IN THE MIDDLE OF RETURNING A SEQUENCE
C
50      COUNT = COUNT-1
        GETWD=ZERONE
        RETURN

100     ERR=-1
        RETURN
        END

        INTEGER FUNCTION GETSIX(DUM)
        IMPLICIT INTEGER (A-Z)
        COMMON /PUTCOM/ ZERONE,COUNT,BCOUNT,WORD,ERR

        IF(BCOUNT.NE.0) GO TO 20

        READ (1,ERR=100,END=100) WORD
        BCOUNT=6

20      GETSIX = SHIFT(WORD,-(BCOUNT-1)*6).AND."77
        BCOUNT=BCOUNT-1
        RETURN

100     ERR=-1
        RETURN
        END

        SUBROUTINE MAKFIL(A,B,SAVNAM)
        IMPLICIT INTEGER(A-Z)
        LOGICAL LETNUM
        DIMENSION SAVNAM(2),M(6)
        DATA LCA/"141/,LCZ/"172/,CH0/"60/,CH9/"71/,MASK/"774000000000/
        DATA M/"774000000000,"777760000000,"777777700000,"777777777400,
        1      "777777777776,"777777777776/
        GETCHR(X,Y)=SHIFT(X,-(5-Y)*7-1).AND."177
        LETNUM(I)=(I.GE.CH0.AND.I.LE.CH9).OR.(I.GE.LCA.AND.I.LE.LCZ)

        IF(A.NE.0) GO TO 5

C  SET THE DEFAULT NAME

        SAVNAM(1)='SAVE.'
        SAVNAM(2)='ADV'
        RETURN

C  FIND FIRST NON-ALPHAMERIC  (REMEMBER A AND B ARE IN LOWER CASE)

5       DO 10 I=1,5
        J=GETCHR(A,I)
        IF(.NOT.LETNUM(J)) GO TO 20
10      CONTINUE
        I=6
        J=GETCHR(B,1)
        IF(LETNUM(J)) I=7

C  I NOW HAS POSITION OF FIRST NON-ALPHA...

20      S1=-(I-2)*7
        S2=S1+35
        SAVNAM(1)=(A.AND.M(I-1)).OR.SHIFT(' .adv',S1)
        J=0
        IF(I.EQ.7) J=B.AND.MASK
        SAVNAM(2)=J.OR.SHIFT(' .adv',S2)
C
C  CHANGE TO UPPER CASE SO IT TYPES OUT NICELY.  SIGH.
        DO 30 I=1,2
30      SAVNAM(I)=SAVNAM(I).AND.(SHIFT((SAVNAM(I).AND.'@@@@@'),-1).XOR.-1)
        RETURN
        END

