;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: TapeStrings.asm                                                     *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/25/90 120G/04 Arif Obaid   / Add 34880 (RecSizeTooSmall) & 34881.      *;
;* 12/28/89 120F/03 Arif Obaid   / Display improvements (aesthetics).        *;
;* 11/02/89 120D/02 Arif Obaid   / Utility merge, added 34856-59 & 78        *;
;* 11/02/89 120D/01 Sury         / Utility merge, added 34860-63             *;
;* 08/28/89 120C/00 P. Campbell  / Master -> Server, Server -> Service       *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

$INCLUDE(:f0:String.Mdf)
$INCLUDE(:f0:msgNls.mdf)

%InitStrings

%msgNlsSb (34811) (rgMissingTapeHeaders) ('Missing tape headers starting at file ')
%msgNlsSb (34812) (rgRemountTape) ('Please correct the problem. Do you wish to continue?')
%msgNlsSb (34813) (rgEarlyEot) ('End of tape record processed after file number ')
%msgNlsSb (34814) (sbBadTapePrompt) ('Tape is not a valid backup tape or has been corrupted.', 0Ah, ; 
& 'Do you wish to attempt to recover the data from the tape?')
%msgNlsSb (34815) (rgNoTapePlusForRead) ('The name [tape]+ is meaningless when reading.
')
%msgNlsSb (34816) (rgRestoringFromBackup) ('Restoring from backup taken on ')
%msgNlsSb (34817) (sbNoHeaderAvailable) ('Restoring from tape with a corrupt header.', 0Ah, ; 
& 'No information about its origin is available.')
%msgNlsSb (34818) (rgHardTapeErrors) ('
Number of hard tape errors :')
%msgNlsSb (34819) (rgSoftTapeErrors) ('
Number of soft tape errors :')
%msgNlsSb (34820) (rgCorruptSeparators) ('
Tape file separators are corrupt.  No data recoverable after this point.')
%msgNlsSb (34821) (rgExistingFile) ('Tape already contains a backup performed on ')
%msgNlsSb (34822) (rgOverwriteOk) ('
Do you wish to overwrite it?')
%msgNlsSb (34823) (rgMountPrompt) ('
Please mount tape number ')
%msgNlsSb (34824) (rgErrorWritingHeader) ('Tape error while writing header: ')
%msgNlsSb (34825) (rgRewindingMsg) ('
Rewinding and unloading reel ')
%msgNlsSb (34825) (rgDotDotMsg) (' ... ')
%msgNlsSb (34826) (rgRewindDoneMsg) (' done.')
%msgNlsSb (34827) (rgContinuingMsg) ('Continuing on reel ')
%msgNlsSb (34700) (rgRestoringMsg) ('
Restoring')
%msgNlsZb (34828) (msgBlankTape) ('Tape is blank .... it contains no data')
%msgNlsZb (34829) (msgHdwrError) ('Tape controller failed micro diagnostic.')
%msgNlsZb (34830) (msgEarlyEot) ('An unexpected tape mark was found.')
%msgNlsZb (34831) (msgTapeParity) ('Tape contained unrecoverable data error.')
%msgNlsZb (34832) (msgInterfaceParity) ('A parity error occurred on the controller to drive interface.')
%msgNlsZb (34833) (msgPROMCheckSum) ('Tape controller failed PROM checksum test.')
%msgNlsZb (34834) (msgTapeNotReady) ('Tape drive is off line or not ready.')
%msgNlsZb (34835) (msgNoTapeHardware) ('Tape controller is missing or improperly configured.')
%msgNlsZb (34836) (msgBadTapeSpec) ('Invalid tape name. Use [QIC], [QIC]n, [QIC]+, [QICm], [QICm]n, [QICm]+,
[TAPExy], [TAPE]n or [TAPE]+')  ;M03;
%msgNlsZb (34837) (msgTapeInUse) ('Tape is currently in use.')
%msgNlsZb (34838) (msgTapeReadOnly) ('Tape is write-protected.')
%msgNlsZb (34839) (msgBadTapeAddress) ('Tape buffers must be located in lower 512K.')
%msgNlsZb (34840) (msgTapeRecordTruncated) ('Tape buffer is not large enough to accommodate tape record.')
%msgNlsZb (34841) (msgCorruptTape) ('An attempt has been made to access a file on the tape which 
does not exist or the tape is corrupt.') ;M03;
%msgNlsZb (34842) (msgInvalidTapePosition) ('Tape is not positioned at a file mark.')
%msgNlsZb (34843) (msgInvalidTapeReel) ('Continuation tape is not from the same backup set.')
%msgNlsZb (34844) (msgInvalidTapeSequence) ('Tape reel is mounted out of sequence.')
%msgNlsZb (34845) (msgMissingTapeConfigFile) ('Tape configuration file is missing or inacessible.')
%msgNlsZb (34846) (msgBadTapeConfigFile) ('Tape configuration file is invalid.')
%msgNlsZb (34847) (msgBadTapeRecordSize) ('Tape record size for backup must be between 1K and 16K bytes.')
%msgNlsZb (34848) (msgTapeBufferTooSmall) ('Tape buffer is too small (must be at least 3 times record size, for Half Inch).')
%msgNlsZb (34849) (msgAlreadyInstalled) ('Tape service is already installed.')
%msgNlsZb (34850) (msgCPCFailure) ('Tape controller initialization failure.')
%msgNlsZb (34851) (msgTapeTimeOut) ('Tape controller timed out.')
%msgNlsZb (34852) (msgNoFreeTapeCBs) ('Tape service ran out of device control blocks.')
%msgNlsZb (34853) (msgBadAlignment) ('Tape buffer must be aligned on even byte boundary - check source code.')
%msgNlsZb (34854) (msgBufferTooBig) ('Tape buffer is larger than can be handled by tape service - check configuration file.')
%msgNlsSb (34855) (rgNoqicPlusForRead) ('The name [QIC]+ is meaningless when reading.
')
;---- Begin M02 ------;
%msgNlsZb (34856) (rgEraseOK) ('Do you wish to erase it?')
%msgNlsZb (34857) (rgbNoConfigFileMsg1) ('Configuration file can not be found; therefore default values are assumed:')
%msgNlsZb (34858) (rgbNoConfigFileMsg2) ('Record Size (64512 / 63K) if backing up; Rewind upon completion.')
%msgNlsZb (34859) (rgRetensionOnly) (' will only be retensioned.')
;---- End   M02 -----;
;---- Begin M01 -----;
%msgNlsSb (34860) (rgNoTapeNForWrite) ('[QICm]n, where n > 0, is invalid for backup.') ;M03;
%msgNlsSb (34861) (rgTapeNotAtEndofData) ('Current tape position is not logical end of data.')
%msgNlsSb (34862) (rgInvalidMultiple) ('[QICm]n, where n<>0 is only valid for the first drive in the list.')
%msgNlsSb (34863) (rgNoMultipleDrives) ('Multiple drives not allowed for read.')
%msgNlsSb (34864) (rgTapeWearingOut1) ('WARNING - More than 8 retries; Cartridge is wearing out.')
%msgNlsSb (34876) (rgTapeWearingOut2) ('          Data was accepted and is still valid.')
%msgNlsSb (34877) (rgMountIn) (' in ')
%msgNlsSb (34878) (rgTooManySources) ('Too many sourc devices specified.')
;---- End   M01 -----;

;M04 Begin;
%msgNlsSb (34880) (rgRecSizeTooSmall) ('Record size exceeds XBlk limits, cannot run from cluster - check configuration file.')
%msgNlsSb (34881) (rgTapeContinueMsg) ('Continuing on tape ')
;M04 End;
;
;*************************************************************************
;
; STRONGEST WARNING
;
; DO NOT modify the following three strings (even for nationalization)
; These strings are already embedded in backup tapes.  If you were to
; change these strings, old backup tapes would not be recognized! - IK
;
%rgString rgEor	('/// END OF REEL - nnn/nnn/nnnn')
%rgString rgEot	('*** END OF TAPE - nnn/nnn/nnnn')
%rgString rgHeader ('<<< BACKUP TAPE - nnn/nnn/nnnn')
;
;************************************************************************
;
%FinishStrings
END
