	TITLE 'COLEX SASI 5-1/4" Winchester handler'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
;Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*		Disk I/O module for CP/M 3.0			*
;*	Uses the Colex SASI card, Xebec SASI interface and	*
;*	Teac SD-412 (or Seagate ST-412) Winchester.		*
;*								*
;****************************************************************
;  Date		  Author		Modification
;15-May-83	K.J. Brand	Version 1.0
;23-Nov-83	R.J. Wellsted	Version 2.0, 17 sectors/track ignore
;					soft errors.
;06-Dec-83	R.J. Wellsted	Version 2.1, wait for req on each byte xfered.
;23-Feb-84	R.J. Wellsted	Version 2.2, Add retries.
	PAGE
	DSEG

	PUBLIC	HDXD0,HDXD1	;xdph addresses
	EXTRN	@ADRV,@RDRV,@DBNK ;bios parameters for disk i/o
	EXTRN	@DMA,@TRK,@SECT
	EXTRN	?WBOOT		;warm boot vector
	EXTRN	?PMSG		;print message @<HL> up to 00
	EXTRN	?PDEC		;print 16 bit binary number in <HL>
	EXTRN	?PDERR		;print BIOS disk error header
	EXTRN	?CONIN,?CONO	;con in and out
	EXTRN	?CONST		;get console status
	EXTRN	?BNKSL		;bank select routine

	MACLIB	PORTS		;port address equates
	MACLIB	CPM3		;cp/m 3.0 disk definition macros
	MACLIB	Z80		;z80 opcodes
	MACLIB	EQUATES		;system equates
	PAGE
;****************************************************************
;*								*
;*		SASI / Winchester equates			*
;*								*
;****************************************************************
NMBTRY	EQU	4		;the number of retries allowed
WINSIZ	EQU	2		;the number of 256 byte units per sector

I$O	EQU	00000001B	;bit 0 is I/O
REQ	EQU	00000010B	;bit 1 is request
C$D	EQU	00000100B	;bit 2 is C/D
MSG	EQU	00001000B	;bit 3 is message
BSY	EQU	00010000B	;bit 4 is busy
ACK	EQU	00100000B	;bit 5 is acknowledge
SEL	EQU	01000000B	;bit 6 is select
RESET	EQU	10000000B	;bit 7 is reset

REQ$SENSE EQU	3		;getting bad news from xebec
XBCID	EQU	0CH		;xebec init command
HDRD	EQU	8		;sasi read command
HDWRT	EQU	0AH		;sasi write command

MAXCYL	EQU	306		;no. of cylinders on SD-412
MAXHDS	EQU	4		;no. of heads
WRTCYL	EQU	128		;cylinder to reduce write current
WRTPRC	EQU	64		;cylindm to start write precomp.
ECCDTA	EQU	11		;max burst error length (bits)
	PAGE
;****************************************************************
;*								*
;*		XDPHs for the disks				*
;*								*
;****************************************************************
	DW	HD$WRITE	;write entry point
	DW	HD$READ		;read entry point
	DW	HD$LOGIN	;login entry point
	DW	HD$INIT0	;init entry point
	DB	0,0		;relative drive,media flag
HDXD0:	DPH     0,DPBHD0,0	;no skew, no check vector
				;gencpm makes allocation vector

	DW	HD$WRITE	;write entry point
	DW	HD$READ		;read entry point
	DW	HD$LOGIN	;login entry point
	DW	HD$INIT0	;init entry point
	DB	1,0		;relative drive,media flag
HDXD1:	DPH	0,DPBHD1,0	;no skew, no check vector
				;gencpm makes allocation vector

	CSEG
DPBHD0:	DPB	512,17,613,4096,1024,1,8000H
DPBHD1:	DPB	512,17,1224,4096,1024,614,8000H

	DSEG
	PAGE
;****************************************************************
;*								*
;*		 Initialization entry point.			*
;*	called for first time initialization. all init done	*
;*	with drive 0 call.					*
;*								*
;****************************************************************
HD$INIT0:			;set up sasi adapter PIO
	MVI	A,8FH		;port A bi-directional
	OUT	P$HOST+2	;send to control port A
	MVI	A,0CFH		;port B bit i/o
	OUT	P$HOST+3	;send to control port B
	MVI	A,00111111B	;make bits 7,6 output..5-0 input
	OUT	P$HOST+3	;send to control port B
	XRA	A		;form a 0
	OUT	P$HDCOM		;clear control bits
	IN	P$HDDATA	;and set up data port as input for now
	MVI	A,RESET		;load a xebec reset command
	OUT	P$HDCOM		;send to control port
	PUSHIX			;90 t state delay for controller
	PUSHIX			;electronics
	PUSHIX			; allows the reset to do its stuff
	POPIX
	POPIX
	POPIX
	XRA	A		;form a zero
	OUT	P$HDCOM		;turn off the reset
	MVI	A,6		;load step rate
	STA	CNTRL		;save it away for future use
	LXI	H,0		;clear addresses
	SHLD	ADDR2
	SHLD	ADDR0		;24 bits
	MVI	A,1		;default to 1 block
	STA	BLOCKS		;save in command block
	MVI	A,XBCID		;configuration command
	STA	COMND		;save command
	CALL	SELSEND		;send to controller
	LXI	H,IDBYTES	;place where config data is set up
	LXI	D,MAXCYL	;load no. of cylinders
	MOV	M,D		;save high byte first
	INX	H		;adjust pointer
	MOV	M,E		;save low byte
	INX	H		;adjust pointer
	MVI	M,MAXHDS	;save the no. of heads
	INX	H		;adjust pointer
	LXI	D,WRTCYL	;load reduced write current start cylinder
	MOV	M,D		;save high byte
	INX	H		;adjust pointer
	MOV	M,E		;save low byte
	INX	H		;adjust pointer
	LXI	D,WRTPRC	;load write precomp start cylinder
	MOV	M,D		;save high byte
	INX	H		;adjust ponter
	MOV	M,E		;save low byte
	INX	H		;adjust pointer
	MVI	M,ECCDTA	;save burst error length
	MVI	B,8		;the no. of bytes to send
	MVI	C,P$HDDATA	;point to hard disk data port
	LXI	H,IDBYTES	;point to bytes to send
LOOP1:	IN	P$HDSTAT	;get hdisk status
	ANI	C$D		;control or data?
	JRNZ	LOOP1		;loop if not data
LOOP2:	IN	P$HDSTAT	;get status again
	ANI	REQ		;ready for data?
	JRZ	LOOP2		;loop if not
	OUTI			;send parameter to xebec
	JRNZ	LOOP2		;back for rest?
	JMP	STATUS		;return from status call

HD$INIT1:			;all initialization done by drive 0
	RET

HD$LOGIN:			;not required because media doesn't change
	RET
	PAGE
;****************************************************************
;*								*
;*		Hard disk Read/Write entry points		*
;*	these entries are called with the following arguments:	*
;*		relative drive number	in @rdrv (8 bits)	*
;*		absolute drive number	in @adrv (8 bits)	*
;*		disk transfer address	in @dma (16 bits)	*
;*		disk transfer bank	in @dbnk (8 bits)	*
;*		disk track address	in @trk (16 bits)	*
;*		disk sector address	in @sect (16 bits)	*
;*		pointer to XDPH in <DE>				*
;*	they transfer the appropriate data, check for error,	*
;*	and if not a soft error, return a status code in <A>	*
;*								*
;****************************************************************
HD$READ:
	LXI	H,READ$MSG	;point to read text
	MVI 	A,HDRD		;load read command
	JR 	RW$COMMON	;rest in common routine

HD$WRITE:
	LXI	H,WRITE$MSG	;point to write text
	MVI 	A,HDWRT		;load write command

RW$COMMON:			;common read/write code
	SHLD	OPERATION$NAME	;save text pointer
	STA 	COMND		;save command
	LHLD	@TRK		;get track no.
	XRA	A		;0 msb
	MVI	B,4		;count to mult by 16
LOOP3:	DAD	H		;hl=hl*2
	ACI	0		;take care of carry
	DJNZ	LOOP3		;continue until hl=hl*16
	LDED	@TRK		;get track no. again
	DAD	D		;add in track no.
	ACI	0		;*17
	LDED	@SECT		;get sector no.
	DAD	D		;add in sector no
	ACI	0		;from 24 bit result
	XCHG			;result in ade
	LXI	H,ADDR2		;point to where address goes
	MOV	M,A		;save high byte
	INX	H		;adjust pointer
	MOV	M,D		;save middle byte
	INX	H		;adjust pointer
	MOV	M,E		;save low byte
	MVI	A,NMBTRY	;get number of retries
	STA	RTRYNO		;save it
RETRY:	CALL	SELSEND		;send command

	IF BANKED
	JMP	XFERDAT		;jump to common if banked, else drop in

	CSEG			;code that moves data must be resident
XFERDAT:
	SSPD	SAVE$STACK	;out with the old...
	LXI	SP,NEW$STACK	; ...in with the new
	LDA	@DBNK		;get transfer bank no.
	CALL	?BNKSL		;select bank for xfer of data
	ENDIF
	LHLD	@DMA		;load xfer address
	MVI	B,0		;set up for 256 byte xfer
	MVI	C,P$HDDATA	;to/from data port
	LDA	COMND		;get command sent
	CPI	HDRD		;check direction
	JRZ	READ		;skip if read
WRITE:	IN	P$HDSTAT	;get xebec status
	ANI	C$D		;control or data?
	JRNZ	WRITE		;loop if not data
	MVI	D,WINSIZ	;no. of 256 byte blocks to xfer
LOOP5:	IN	P$HDSTAT	;get status again
	ANI	REQ		;ready for xfer?
	JRZ	LOOP5		;loop if not
	OUTI			;send byte
	JRNZ	LOOP5		;done 256 bytes?
	DCR	D		;adjust counter
	JRNZ	LOOP5		;loop if not done
	JR	PRE$STATUS	;finish up with status

READ:	IN	P$HDSTAT	;get xebec status
	ANI	C$D		;control or data?
	JRNZ	READ		;loop if not data
	MVI	D,WINSIZ	;no. of 256 byte blocks to xfer
LOOP7:	IN	P$HDSTAT	;get status again
	ANI	REQ		;ready for xfer?
	JRZ	LOOP7		;loop if not
	INI			;get byte
	JRNZ	LOOP7		;done 256 bytes?
	DCR	D		;adjust counter
	JRNZ	LOOP7		;loop if not done
PRE$STATUS:
	IF BANKED
	XRA	A		;make a 0
	CALL	?BNKSL		;reselect bank 0
	LSPD	SAVE$STACK	;replace old stack
	JMP	STATUS		;jump if banked, else fall in
	ENDIF

	DSEG
STATUS:	LXI	H,STAT$BYTES	;point to buffer
	MVI	B,2		;get 2 bytes at first
LOOP8:	IN	P$HDSTAT	;get xebec status
	BIT	4,A		;test busy bit
	JRZ	ERROR		;if not busy must be error
	ANI	C$D		;control or data?
	JRZ	LOOP8		;loop if not control
LOOP9:	IN	P$HDSTAT	;get status again
	BIT	4,A		;test busy bit
	JRZ	ERROR		;if not busy must be error
	ANI	REQ		;ready to xfer?
	JRZ	LOOP9		;loop if not ready
	IN	P$HDDATA	;get first result byte
	MOV	M,A		;save it in buffer
	INX	H		;adjust pointer
	DCR	B		;adjust counter
	JRNZ	LOOP9		;loop if not done
	LDA	STAT$BYTES	;get 1st byte
	ANI	00000010B	;look at the status byte
	RZ			;all's well if zero

ERROR:	LXI	H,RTRYNO	;point to retry counter
	DCR	M		;adjust it
	JNZ	RETRY		;retry if not done
	MVI	A,REQ$SENSE	;get error bytes from controller
	STA	COMND		;save the command
	CALL	SELSEND		;send to xebec
	MVI	B,4		;get four bytes
	MVI	C,P$HDDATA	;xebec data port
	LXI	H,ERR$BYTES	;error code buffer
LOOPA:	IN	P$HDSTAT	;get xebec status
	ANI	C$D		;control or data?
	JRNZ	LOOPA		;loop if not data
LOOPB:	IN	P$HDSTAT	;get status agian
	ANI	REQ		;ready to xfer?
	JRZ	LOOPB		;loop if not
	INIR			;get the bytes
	CALL	STATUS		;finish up by calling status routine
				;what's returned are error codes
				;***WARNING*** RECURSIVE CALL
	LDA	ERR$BYTES	;get error code byte
	ANI	3FH		;mask off unwanted bits
	RZ			;null error
	SUI	18H		;test for corrected soft error
	RZ			;done if so
	CALL	?PDERR		;prints message about where error occurred
	LHLD	OPERATION$NAME	;tell user what it was doing
	CALL	?PMSG		;print message
	LDA	ERR$BYTES	;get error code
	MOV	L,A		;copy to hl
	MVI	H,0		;make it 16 bits
	CALL	?PDEC		;print the error no.
	MVI	A,1		;return hard error to cpm
	RET
	PAGE
;****************************************************************
;*								*
;*	The routine to select the Xebec and send the command	*
;*								*
;****************************************************************
SELSEND:
	IN	P$HDSTAT	;get xebec status
	ANI	BSY		;is it busy?
	JRNZ	SELSEND		;loop if so
	MVI	A,1		;pattern to select controller
	OUT	P$HDDATA	;send it
	MVI	A,SEL		;load select command
	OUT	P$HDCOM		;select the controller
LOOPD:	IN	P$HDSTAT	;get controller status
	ANI	BSY		;has it responded yet?
	JRZ	LOOPD		;loop until it does
	XRA	A		;load a zero
	OUT	P$HDCOM		;clear the select command
SENDCMD:
	LXI	H,COMND		;point to command block
LOOPE:	IN	P$HDSTAT	;get xebec status
	ANI	REQ		;ready for xfer?
	JRZ	LOOPE		;loop until it is
	IN	P$HDSTAT	;get status
	ANI	C$D OR I$O	;mask for control output
	CPI	C$D		;test for data
	RNZ			;done if so
	MOV	A,M		;get command byte
	OUT	P$HDDATA	;send to xebec
	INX	H		;adjust pointer
	JR	LOOPE		;loop back for the rest
	PAGE
;****************************************************************
;*								*
;*		Data areas for Hard disk routines.		*
;*								*
;****************************************************************
	CSEG
COMND:	DS 	1		;command byte
ADDR2:	DS	1		;high address
ADDR1:	DS	1		;middle address
ADDR0:	DS	1		;low address
BLOCKS:	DS	1		;block count
CNTRL:	DS	1		;step rate control

RTRYNO:	DS	1		;retry counter
OPERATION$NAME:
	DS	2		;pointer to text message
READ$MSG:			;text for read error
	DB	', Read, Code = ',0
WRITE$MSG:			;text for write error
	DB	', Write, Code = ',0
STAT$BYTES:
	DS	2		;buffer to hold result code
ERR$BYTES:
	DS	4		;buffer for error code
IDBYTES:
	DS	10		;buffer for drive params
SAVE$STACK:
	DS	2		;saved sp during xfers
	DS	32		;stack space
NEW$STACK EQU	$

	END
