	TITLE	'COLEX SC-820 Floppy Bootstrap for CP/M 3.0'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
;Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*		Colex SC-820 Floppy boot program.		*
;*								*
;*		This program resides on sector 1 of track 0.	*
;*	The bootstrap PROM loads this sector into location	*
;*	0100H and then transfers control to this program.	*
;*	This program then reads in the rest of tracks 0 and 1	*
;*	into location 0400H upwards. Control is then passed to	*
;*	the CP/M 3.0 loader at 0400H.				*
;*								*
;****************************************************************
;  Date		  Author		Modification
;19-Sep-83	K.J. Brand	only works for 5 1/4"
;				cp/m 2.2 format system tracks
	PAGE
	MACLIB	Z80

CPMLDR	EQU	400H		;where cpmldr is loaded and executed from
SEX	EQU	19		;number of sectors this loader will get
			
FLPPORT	EQU	0E4H		;base of floppy card
COM1797	EQU	FLPPORT+0
TRK1797	EQU	FLPPORT+1
SEC1797	EQU	FLPPORT+2
DAT1797	EQU	FLPPORT+3	;data port
DMA1797	EQU	0E0H
DRV1797	EQU	0E3H

RD	EQU	10001000B	;sector read for 1797
STEPIN	EQU	01011001B	;step in track for 1797
RESTORE	EQU	00001001B	;restore

START:	MVI	A,RESTORE	;load the restore command
	OUT	COM1797		;send command to wd1797
	CALL	BUSY		;wait for it to finish
	LXI	B,2		;b = track number, c = sect number
	LXI	D,SEX*256	;d = number of sectors to read
	LXI	H,CPMLDR	;cpmldr address
LSECT:	MOV	A,C		;get sector no.
	OUT	SEC1797		;send to 1797
	SHLD	DMADDR		;save sector dma address
	EXX			;save regs
	CALL	READ		;read the sector
	EXX			;restore regs
	ANI	10011100B	;check for rnf, crc, data lost
	JRNZ	START		;try again if error
	DCR	D		;decrement # of sectors
	JZ	CPMLDR		;and start cp/m if finished
	INR	H		;incrementing address by full 512
	INR	H
	INR	C		;increment sector no.
	MOV	A,C		;get sector no. for test
	CPI	11		;beyond end of track?
	JRC	LSECT		;no, read next sector from this track
	INR	B		;otherwise increment track number
	MVI	A,STEPIN	;load wd1797 command for stepin
	OUT	COM1797		;send to wd1797
	CALL	BUSY		;wait for it to finish
	MOV	C,B		;reset sector number with cheap 1
	JR	LSECT		;loop back for more

READ:  	LXI	B,12*256+DMA1797 ;point to dma & load no. of bytes to send
	LXI	H,XFER		;point to data to send to dma
	OUTIR			;set up the dma
	MVI	A,RD		;load the read command
	OUT	COM1797		;send to wd1797
	MVI	A,87H		;load dma enable command
	OUT	DMA1797		;enavle the dma
				;fall through to busy and then return
BUSY:	MVI	A,0FH		;load delay count
LP:	DCR	A		;give wd1797 chance to sort itself out
	JRNZ	LP		;loop back if not done yet
LP1:	IN	COM1797		;get wd1797 status
	BIT	0,A		;test if still busy
	JRNZ	LP1		;loop back if so
	RET			;done if not

XFER:	DB	0C3H		;dma command block
	DB	79H
DMADDR:	DW	0		;address pointer
LENGTH:	DW	512-1		;no. of bytes
	DB	14H
	DB	28H
	DB	0C5H
	DB	DAT1797
	DB	9AH
	DB	0CFH

	END
