#ifndef SYS_MLS_H
#define SYS_MLS_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mls.h: version 24.1 created on 10/28/91 at 18:35:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mls.h	24.1	10/28/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 *	mls.h     Mandatory access header file 
 *	(C)Copyright 1989 by ARIX Corp.
 *
 */

/* Define the arguments to the mls system call 
 */
#define GETMAC		0
#define SETMAC		1
#define GETFMAC		2
#define SETFMAC		3


/* secure inodes are 128 bytes long - previous released inode are 64 
 * The kernel label routines must know what size the inode is to make
 * proper decisions on what happens (yes, as rediculous as it sound, we
 * do support old 64 byte inode systems
 */
#define SECURE_INODE	128

/* This defines the maximum number of categories * 8 that a single label
 * may contain
 */
#define MAXCATLST	16


/* define the default locations of the label definition files */
#define	LABELFILE	"/etc/security/mls/labels"
#define LEVELS		"/etc/security/mls/levels"
#define CATFILE		"/etc/security/mls/categories" 	

typedef struct slabel {
	ushort	level;
	char	catlst[MAXCATLST];	/* 128 categories in list */
	} slabel_t;

typedef struct {
	char	name[10];
	slabel_t label;
	} mac_sym_t;

/*
 * exec_labels are a configurable set of labels that must be present 
 * on an executable file if it is to be exec'd by a process using
 * P_EXECR
 */

typedef struct slabelmap {
	char		name[20];	/* symbolic name of the slabel */
	slabel_t	label;		/* actual labels */
	} slabelmap_t;


#ifdef MLS_SYMS
slabelmap_t slabel_map[] = {
	"SYS_SEC",		
	14,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"SECURED",
	12,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"SYS_ADM",		
	10,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"SYS_DEV",
	7,	
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"SYS_USER",
	6,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"TRUSTED",
	4,	
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"PROTECTED",
	2,	
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"UNSECURE",			
	0,	
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,

	"",
	0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0
	};

#endif
#endif	/* SYS_MLS_H */
