/* @(#)user.h	6.1 */
#ifndef DIR_H
#include "sys/dir.h"
#endif DIR_H
#ifndef PARAM_H
#include "sys/param.h"
#endif PARAM_H
#ifndef SIGNAL_H
#include "sys/signal.h"
#endif SIGNAL_H

/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE*click bytes long;
 * contains the system stack per user; is cross referenced
 * with the proc structure for the same process.
 */

/* size of mmuslots */
#define NUMMUSLOTS 1024

/* template for mmu_grp */
struct tmmu_grp  {
	int	*start;
	int	*top_slot;
	int	*bottom_slot;
	unsigned int counter;
	short	procid;
	short	size;
	char	avail;
	char	userid;
	struct mmureg	*shmstart;
	struct mmureg	*shmtop;
};
struct tmmu_div  {
	char    num_entries;
	short	size;
	struct  tmmu_grp   *ptr;
};

/* number of entries in mmu_grp structure.
   max size of mmu_grp is the number of available userids which is
   0x7f minus kernel id minus the process id for mmu_invalid
*/
#define SIZEMMUGRP	80
#define SIZEMMUGRP25	126
#define SIZEDIVISIONS    5

/* mmu_grp itself */
extern struct tmmu_grp own_mmu_grp[SIZEMMUGRP25];
extern struct tmmu_div sl_mmu_divisions[SIZEDIVISIONS];

/* ptr to current mmu_grp */
extern struct tmmu_grp *own_curmmu_grp;

/* ptr and sizes for mmu_grp */
extern int num32, num64, num128, num256, num1024;
extern struct tmmu_grp *ptr32, *ptr64, *ptr128, *ptr256, *ptr1024;

/* index into u page data structures specific to the processor */
#define MASTER_CPU 0
 
struct	user
{
	char	u_slreturn;		/* set if returning from slave */
	char	enblreg;		/* contents of map control register */
	char	u_acflag;
	char	u_fpp_saved;		/* fpp regs saved */
	int	u_error;		/* return error code */
	caddr_t	u_base;			/* base address for IO */
	unsigned u_count;		/* bytes remaining for IO */
	off_t	u_offset;		/* offset in file for IO */
	int	*u_ap;			/* pointer to arglist */
	char	u_comm[DIRSIZ];
	char	u_segflg;		/* IO flag: 0:user D; 1:system */
	char	u_intflg;		/* catch intr from sys */
	struct proc *u_procp;		/* pointer to proc structure */
	label_t	u_rsav;			/* save info when exchanging stacks */
	label_t	u_qsav;			/* for quits and interrupts */
	label_t	u_ssav;			/* label variable for swapping */
	ushort	u_uid;			/* effective user id */
	ushort	u_gid;			/* effective group id */
	ushort	u_ruid;			/* real user id */
	ushort	u_rgid;			/* real group id */
	union {				/* syscall return values */
		struct	{
			int	r_val1;
			int	r_val2;
		}r_reg;
		off_t	r_off;
		time_t	r_time;
	} u_r;
	short   mmu1index;		/* this set of variables is used to */
	short   offset1;		/* point into the mmuslots array to */
	int     length1;		/* inform the device driver which  */
	short   mmu2index;		/* memory is to be read/written to */
	short   offset2;		/* used when doing swap/phys i/o */
	int     length2;
	short   mmuslots[NUMMUSLOTS];	/* image of mmu registers */
	short   datastartslot;		/* index into mmuslots of data seg */
	short   datatopslot;		/* index of last data seg slot */
	short   texttopslot;		/* index of last text seg slot */
	short	stktopslot;		/* index of top of stack slot */
	char	u_slots_chg[4];		/* memory map changed ? */
#ifdef notdef
	char	u_mmu_offset[4];	/* contents of mmu offset register */
#else
	char	u_mmu_pad[4];		/* pad to preserve offsets */
#endif
	struct  tmmu_grp *u_mmu_grp_ptr[4]; /* ptr to data struct for map set */
	short	u_fmode;		/* file mode for IO */
	ushort	u_pbsize;		/* bytes in block for IO */
	ushort	u_pboff;		/* offset in block for IO */
	short	u_errcnt;		/* syscall error count */
	dev_t	u_pbdev;		/* real device for IO */
	daddr_t	u_rablock;		/* read ahead block addr */
	struct inode *u_cdir;		/* current directory of process */
	struct inode *u_rdir;		/* root directory of process */
	caddr_t	u_dirp;			/* pathname pointer */
	struct direct u_dent;		/* current directory entry */
	struct inode *u_pdir;		/* inode of parent directory of dirp */
	struct file *u_ofile[NOFILE];	/* pointers to file structures of open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	int	u_arg[10];		/* arguments to current system call */
	unsigned u_tsize;		/* text size (clicks) */
	unsigned u_dsize;		/* data size (clicks) */
	unsigned u_ssize;		/* stack size (clicks) */
	int	u_signal[NSIG];		/* disposition of signals */
	time_t	u_utime;		/* this process user time */
	time_t	u_stime;		/* this process system time */
	time_t	u_cutime;		/* sum of childs' utimes */
	time_t	u_cstime;		/* sum of childs' stimes */
	int	*u_ar0;			/* address of users saved R0 */
	struct {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;
	short	*u_ttyp;		/* pointer to pgrp in "tty" struct */
	dev_t	u_ttyd;			/* controlling tty dev */
	struct {			/* header of executable file */
		unsigned ux_mag;	/* magic number */
		unsigned ux_tsize;	/* text size */
		unsigned ux_dsize;	/* data size */
		unsigned ux_bsize;	/* bss size */
		unsigned ux_ssize;	/* symbol table size */
		unsigned ux_tstart;
		unsigned ux_unused;
		unsigned ux_entloc;	/* entry location */
	} u_exdata;
	time_t	u_start;
	time_t	u_ticks;
	long	u_mem;
	long	u_ior;
	long	u_iow;
	long	u_iosw;
	long	u_ioch;
	daddr_t	u_limit;		/* maximum write address */
	short	u_cmask;		/* mask for file creation */
	short	u_lock;			/* process/text locking flags */
	union {				/* contents of mmu offset register */
		char 	offreg12M[4];
		short	offreg25M[4];
	} u_offreg;
	int	*u_regs_ptr;		/* ptr to allow slave to orient itself
					   on the stack */
	int	u_stack[1];
					/* kernel stack per user
					 * extends from u + USIZE*64
					 * backward not to reach here
					 */
};
extern struct user u;

#define	u_rval1	u_r.r_reg.r_val1
#define	u_rval2	u_r.r_reg.r_val2
#define	u_roff	u_r.r_off
#define	u_rtime	u_r.r_time

#define u_mmu_offset25	u_offreg.offreg25M
#define u_mmu_offset	u_offreg.offreg12M

/* ioflag values: Read/Write, User/Kernel, Ins/Data 
#define	U_WUD	0
#define	U_RUD	1
#define	U_WKD	2
#define	U_RKD	3
#define	U_WUI	4
#define	U_RUI	5
*/

#define	EXCLOSE	01

/* size of user process stack segment in pages */
#define STACKKLUDGE  16

/* magic numbers for u.u_exdata.ux_mag */
#define NORMALMAGIC  0407
#define PUREMAGIC    0410
#define NORMALMAGIC20 0607
#define PUREMAGIC20  0610

/* declarations of variables below exist in machdep.c */
extern char *useroffsetreg;	/* address of user offset mmu register */
extern short *useroffsetreg25;	/* address of user offset mmu register */
extern char *useridreg;		/* address of userid mmu register */
extern char *enblregmmu;	/* address of fault enable mmu register */
extern char enblstatemmu;	/* current contents of fault enable mmu reg */
extern char *own_peek1base, *own_peek2base, *own_peek3base, *own_peek4base, 
	    *own_swap1base, *own_swap2base, *own_bootbaseaddr;
extern short *own_p1slotadr;
extern short *own_p2slotadr, *own_p3slotadr, *own_p4slotadr, *own_swap1slot,
	     *own_swap2slot, *own_bootslotaddr, *own_uslotadr;

/* slot number of the first free slot */
extern short mmufreslot;
extern short sl_mmufreslot;

/* constant offset used to translate kernel virtual addresses to physical */
extern int kerneloffset;

/* 
   bus_error is a flag used by fuword, suword, etc to tell whether user access
   was successful
*/
extern	int	own_bus_error;

/* bit positions of the data access and code access mmu fault enables */
#define DATAACCESSFLTENB  0x20
#define CODEACCESSFLTENB  0x10
#define MAPENABLE	  0x03		/* enable stats also */
#define IDFLTENB	  0x04
#define WRTPROTFLTENB	  0x08
#define STATSENABLE	  0x02

/* number of mmu registers */
#define NUMMMUREGS 4096

/* format of mmu regs */
struct mmureg25  {
	unsigned   unused25     : 2;
	unsigned   pagenum25    : 14;
	unsigned   unused1     : 4;
	unsigned   attributes1  : 5;
	unsigned   userid      : 7;
};
struct mmureg12  {
	unsigned   unused2    : 4;
	unsigned   pagenum12   : 12;
	unsigned   unused1     : 4;
	unsigned   attributes1  : 5;
	unsigned   userid      : 7;
};

struct mmureg {
	union {
		struct mmureg25 mmu25;
		struct mmureg12 mmu12;
	} mmu_u;
};

#define pagenum	mmu_u.mmu12.pagenum12
#define attributes mmu_u.mmu12.attributes1
#define pagenum25m mmu_u.mmu25.pagenum25

#ifdef notdef
struct mmureg  {
	unsigned   unused2     : 2;
	unsigned   pagenum     : 14;
	unsigned   unused1     : 4;
	unsigned   attributes  : 5;
	unsigned   userid      : 7;
};
#define	pagenum25m pagenum
#endif

/* bit positions of mmu attributes */
#define MMUWRITEPROT 1
#define MMUACCESSED  2
#define MMUCACHEABLE 8
#define MMUCODEPAGE  16

/* flag values for virtphys indicating whether the address is a 
   kernel address of user address
*/
#define KERNEL  0
#define USER    1

/* kernel id for mmu registers */
#define KERNELID 0

/* invalid indication for user id */
#define MMUINVALID 0x7f

/* ptr to beginning of mmu regs used for user processes. dec in machdep.c */
extern struct mmureg *mmufreaddr;
extern struct mmureg *sl_mmufreaddr;

