/* @(#)systm.h	6.1 */
/*
 * Random set of variables used by more than one routine.
 */
extern struct inode *rootdir;	/* pointer to inode of root directory */
extern short cputype;		/* type of cpu = 40, 45, 70, 750, 780 */
extern time_t lbolt;		/* time in HZ since last boot */
extern time_t time;		/* time in sec from 1970 */

extern char runin;		/* scheduling flag */
extern char runout;		/* scheduling flag */
extern char own_runrun;		/* scheduling flag */
extern char own_curpri;		/* current priority */
extern struct proc *own_curproc;/* current proc */
extern struct proc *runq;	/* head of linked list of running processes */

extern short maxmem;		/* max available memory */
extern short physmem;		/* physical memory on this CPU */
extern daddr_t swplo;		/* block number of swap space */
extern	nswap;			/* size of swap space */
extern dev_t rootdev;		/* device of the root */
extern dev_t swapdev;		/* swapping device */
extern dev_t pipedev;		/* pipe device */
extern char *panicstr;		/* panic string pointer */
extern	blkacty;		/* active block devices */
extern	pwr_cnt, pwr_act;
extern int (*pwr_clr[])();

dev_t getmdev();
daddr_t	bmap();
struct inode *ialloc();
struct inode *iget();
struct inode *owner();
struct inode *maknode();
struct inode *namei();
struct buf *alloc();
struct buf *getblk();
struct buf *geteblk();
struct buf *bread();
struct buf *breada();
struct filsys *getfs();
struct file *getf();
struct file *falloc();
int	uchar();

#ifndef DEBUG_H			/* include debug.h in not already included */
#include <sys/debug.h>
#endif

#ifdef DEBUG_SYSTEM_CALLS
#define NSYSENT	68
#else
#define NSYSENT	65
#endif DEBUG_SYSTEM_CALLS

/*
 * Structure of the system-entry table
 */
extern struct sysentarg {
	int	sy_narg;		/* total number of arguments */
} sysentarg[NSYSENT];
extern struct sysentcall {
	int	(*sy_call)();		/* handler */
} sysentcall[NSYSENT];
