
/*
 *	@(#)space.h	2.1
 */
#include	"sys/acct.h"
#include	"sys/tty.h"
#include	"sys/termio.h"
#include	"sys/buf.h"
#include	"sys/file.h"
#include	"sys/inode.h"
#include	"sys/proc.h"
#include	"sys/text.h"
#include	"sys/map.h"
#include	"sys/callo.h"
#include	"sys/mount.h"
#include	"sys/elog.h"
#include	"sys/err.h"
#include	"sys/iobuf.h"
#include	"sys/opt.h"
#include	"sys/var.h"
#include	"sys/init.h"
#include	"sys/flock.h"


struct	buf	bfreelist;		/* head of the free list of buffers */
struct	pfree	pfreelist;		/* Head of physio header pool */
struct	buf	pbuf[NPBUF];		/* Physical io header pool */
struct  buf 	bufhdrs[NBUF];		/* buffer headers */

struct	hbuf	hbuf[NHBUF];		/* buffer hash table */

struct	file	file[NFILE];		/* file table */

struct	inode	inode[NINODE];		/* inode table */
struct	locklist locklist[NFLOCKS];	/* lock table */
struct flckinfo	flckinfo = {		/* lockf accounting */
	NFLOCKS, 0, 0, 0 
};
struct filock	flox[NFLOCKS];		/* lockf table */

struct	proc	proc[NPROC];		/* process table */
struct	fpp_proc	proc_fpp[NPROC];		/* process table */

struct	text	text[NTEXT];		/* text table */

struct	map	swapmap[SMAPSIZ] = {
	mapdata(SMAPSIZ)
};

struct	callo	callout[NCALL];

struct	mount	mount[NMOUNT];

struct	err	err = {
	NESLOT,
};

cpuint() { panic("cpuint"); }
dmcint() { panic("dmcint"); }

struct	acct	acctbuf;
struct	inode	*acctp;

unsigned short	conmax = 1;		/* conmax = CON_0_DEV; */
char		conline = L_CON;
char		sxtline = L_SXT;
char		gctty_line = L_GCTTY;
struct	cblock	cfree[NCLIST];

unsigned short	condev = C_CON;
unsigned short	gctty_dev = C_GCTTY;

#ifdef	GCTTY_0
#	include	"sys/gc.h"
#else
#	ifdef	GCLP_0
#		include	"sys/gc.h"
#	else
#		ifdef	GCBSC_0
#			include	"sys/gc.h"
#		else
#			ifdef	GCSNA_0
#				include	"sys/gc.h"
#			else
				gc_init(){return(0);}
#			endif
#		endif
#	endif
#endif

#ifdef	GCTTY_0
#	include	"gcp/sema.h"
#	include	"gcp/pto.h"
#	include	"sys/gctio.h"
#	include	"sys/gctty.h"
	unsigned short	gctty_max = GCTTY_0_DEV;
	struct	gctty	*gctty_tty[GCTTY_0_DEV];
	short	gctty_pgrp[GCTTY_0_DEV];
#else
	int	*	gctty_tty = (int *)NULL;
	int		gctty_pgrp = (int *)NULL;
	gctty_initialize(){}
	gctty_interrupt(){}
	gctty_reset(){}
#endif

#ifdef	GCLP_0
#	include	"sys/lprio.h"
#	include	"sys/gclp.h"
	unsigned short	gclp_max = GCLP_0_DEV;
	struct	gclp	*gclp_lp[GCLP_0_DEV];
#else
	gclp_initialize(){}
	gclp_interrupt(){}
	gclp_reset(){}
#endif

#ifdef	GCBSC_0
#	include	"sys/gcbsc.h"
	unsigned short	gcbsc_max = GCBSC_0_DEV;

#	ifdef	GCBSCT_0
		unsigned short	gcbsct_max = GCBSCT_0_DEV;
#	endif

#	ifdef	GCBSCM_0
		unsigned short	gcbscm_max = GCBSCM_0_DEV;
#	endif

#else
	gcbsc_initialize(){}
	gcbsc_interrupt(){}
	gcbsc_reset(){}
#endif

#ifdef	GCSNA_0
#	include	"sys/gcsna.h"
	unsigned short	gcsna_max = GCSNA_0_DEV;

#	ifdef	GCSNAT_0
		unsigned short	gcsnat_max = GCSNAT_0_DEV;
#	endif


#else
	gcsna_initialize(){}
	gcsna_interrupt(){}
	gcsna_reset(){}
#endif

#ifdef	GCSDLC_0
		unsigned short	gcsdlc_max = GCSDLC_0_DEV;

#	ifdef	GCSDLCT_0
		unsigned short	gcsdlct_max = GCSDLCT_0_DEV;
#	endif
#else
	gcsdlc_interrupt(){}
	gcsdlc_initialize(){}
	gcsdlc_reset(){}
#endif


#ifdef	GCTTM_0
	unsigned short	gcttm_dev = C_GCTTM;
	unsigned short	gcttm_max = GCTTM_0_DEV;
	struct	gctty	*gcttm_ttm[GCTTM_0_DEV];
	struct	cir_buf	*gcmuxt_muxt[GCMUXT_0_DEV];
	short	gcttm_pgrp[GCTTM_0_DEV];
#else
	int	*	gcttm_ttm = (int *)NULL;
	gcttm_initialize(){}
	gcttm_interrupt(){}
	gcttm_reset(){}
#endif





#ifdef SXT_0
#	include	"sys/sxt.h"
	unsigned short	sxtmax = SXT_0 * SXT_0_PHYS;
	struct Link	sxtlink[SXT_0 * SXT_0_PHYS] = {0};
#endif

#ifdef DISK_0
#	ifdef	RDSK_0
	unsigned short	rdkmax = RDSK_0_DEV;
	struct	iobuf	rdktab[DISK_0 * DISK_0_PHYS];
#	endif
	unsigned short	dkmax = DISK_0_DEV;
	struct	iobuf	dktab[DISK_0 * DISK_0_PHYS];
	struct	dkinf	phydr[DISK_0 * DISK_0_PHYS];
	int		dk_cnt = DISK_0 * DISK_0_PHYS;
	struct	iotime	dkstat[DISK_0 * DISK_0_PHYS];

#	ifdef TAPE_0
		unsigned short	mtmax = TAPE_0_DEV;
		struct	iobuf	mttab[TAPE_0 * TAPE_0_PHYS];
		int		mt_cnt = TAPE_0 * TAPE_0_PHYS;
		struct	iotime	mtstat[TAPE_0 * TAPE_0_PHYS];
#	endif

#	ifdef NINETRK_0
		unsigned short	ntmax = NINETRK_0_DEV;
		struct	iobuf	nttab[NINETRK_0 * NINETRK_0_PHYS];
		int		nt_cnt = NINETRK_0 * NINETRK_0_PHYS;
		struct	iotime	ntstat[NINETRK_0 * NINETRK_0_PHYS];
#	endif
#endif

/* for tape i/o with user buffer non-long-word aligned */
char 	non_aligned_buf[NON_ALIGNED_SIZE];
int	non_aligned_size = NON_ALIGNED_SIZE;
short	non_aligned_kern_map[(NON_ALIGNED_SIZE/4096)+2];
short	non_aligned_user_map[(NON_ALIGNED_SIZE/4096)+2];

#ifdef TRACE_0
#	include	"sys/trace.h"
	struct	trace	trace[TRACE_0 * TRACE_0_PHYS];
#endif

#ifdef MESG
#	include	"sys/ipc.h"
#	include	"sys/msg.h"
	struct	map	msgmap[MSGMAP];
	struct	msqid_ds msgque[MSGMNI];
	struct	msg	msgh[MSGTQL];
	struct	msginfo	msginfo = {
		MSGMAP, MSGMAX, MSGMNB, MSGMNI, MSGSSZ, MSGTQL, MSGSEG
	};
	char		msgbuf[MSGSEG * MSGSSZ]; 	/* kernel message buffers */
	char	*	msg;
#endif

#ifdef SEMA
#	ifndef IPC_ALLOC
#		include	"sys/ipc.h"
#	endif
#	include	"sys/sem.h"
	struct	semid_ds sema[SEMMNI];
	struct	sem	sem[SEMMNS];
	struct	map	semmap[SEMMAP];
	struct	sem_undo *sem_undo[NPROC];
#	define	SEMUSZ	(sizeof(struct sem_undo)+sizeof(struct undo)*SEMUME)
	int		semu[ ( ( SEMUSZ * SEMMNU ) + NBPW - 1 ) / NBPW ];
	union {
		short		semvals[SEMMSL];
		struct	semid_ds ds;
		struct	sembuf	semops[SEMOPM];
	} semtmp;

	struct	seminfo	seminfo = {
		SEMMAP, SEMMNI, SEMMNS, SEMMNU, SEMMSL,
		SEMOPM, SEMUME, SEMUSZ, SEMVMX, SEMAEM
	};
#endif

#ifdef SHMEM
#	ifndef	IPC_ALLOC
#		include	"sys/ipc.h"
#	endif
#	include	"sys/shm.h"
	struct	shmid_ds *shm_shmem[NPROC*SHMSEG];
	struct	shmid_ds shmem[SHMMNI];	
	struct	shmpt_ds shm_ppindex[NPROC*SHMSEG];
	struct	map 	shm_map[SHMMNI*2] = {mapdata(SHMMNI*2)}; /* *2 is in shm also */
	short		 shm_mmu[SHMALL*2];/* make it bigger to account for fragmentation */
	struct	shminfo	shminfo = {
		SHMMAX, SHMMIN, SHMMNI, SHMSEG, SHMBRK, SHMALL
	};
#endif

#ifndef	MAC_0
#define MAC_0_DEV	0
	unsigned int	macmax = 0;
	int	*	mac_slot = (int *)NULL;
	int	*	mac_ptr = (int *)NULL;
	int mac_busy;
struct mac_slt {			/* Device to MAC array */
	int enth;			/* Which instance of a MAC */
	int intrpt;			/* Interrupt flag */
	struct icb *icb;			/* Icb ptr to a MAC */
	struct mac *mac;			/* Mac ptr to a MAC */
} mac_slt[1];

	macint(){return(0);}
	macinit(){return(0);}
#else
#	include	"sys/mac.h"
	unsigned int	macmax = MAC_0_DEV;
	struct	icb	*mac_slot[MAC_0_DEV]=0;
	struct	mac	*mac_ptr[MAC_0_DEV]=0;
	int mac_busy[MAC_0_DEV];		/* Local device busy array */

struct mac_slt {			/* Device to MAC array */
	int enth;			/* Which instance of a MAC */
	int intrpt;			/* Interrupt flag */
	struct icb *icb;			/* Icb ptr to a MAC */
	struct mac *mac;			/* Mac ptr to a MAC */
} mac_slt[MAC_0_DEV];

#endif

#ifdef PRF_0
#	include	"sys/profiler.h"
	unsigned short	prfmax = PRF_0_DEV;
	struct	prfargs	prf_ptr[PRF_0_DEV];
#else
	prfintr(){}
#endif


struct	var	v = {
	NBUF, NCALL, NINODE, (char *)(&inode[NINODE]), NFILE,
	(char *)(&file[NFILE]), NMOUNT, (char *)(&mount[NMOUNT]),
	NPROC, (char *)(&proc[1]), NTEXT, (char *)(&text[NTEXT]),
	NCLIST, NSABUF, MAXUP, SMAPSIZ, NHBUF, NHBUF-1, NPBUF,
	NFLOCKS, MAC_0_DEV
};

int	turn_off_exec_attr = EXEC_FROM_DATA_SPACE;
