/*	@(#)profiler.h	2.1	*/
/*
 * prof.h	-		system profiler header file
 *				extended for icb profiling
 */

#define PRFMAX 1024		/* maximum number of text addresses */
#define PRF_ON    1		/* profiler collecting samples */
#define PRF_VAL   2		/* profiler contains valid text symbols */

#define PRF_SET   0		/* set prfstat */
#define PRF_CLR   1		/* clr prfstat */
#define PRF_GET	  2		/* get prfid */


/*
 * structure defining addresses and counters for
 * each board to be profiled
 */
struct prfid {
	char name[80];	/* name of a.out file running */
	unsigned stat;	/* state of profiler */
	unsigned max;	/* highest text address */
};
struct prfargs {
	struct prfid p;
	unsigned p_sym[PRFMAX];	/* list of text addresses */
	unsigned p_sys[PRFMAX+1]; /* counters for sys mode  */
};
