/* @(#)proc.h	6.1 */

#define PROC_H
#ifndef TYPES_H
#include "sys/types.h"
#endif
/*
 * One structure allocated per active process. It contains all data needed
 * about the process while the process may be swapped out.
 * Other per process data (user.h) is swapped with the process.
 */

/*	Temporary kludge for file/record locking until
**	distributed unix changes go in.
*/

#define	p_epid	p_pid
#define	p_sysid	p_pid

struct fpp_proc {
	short	state[92];
	int	control[3];
	int	data[24];
};

struct	proc {
	char	p_stat;
	char	p_flag;
	short  	p_addr;		/* page no of phys adddress of u area in ram */

	char	p_pri;		/* priority, negative is high */
	char	pad3[3];

	char	p_time;		/* resident time for scheduling */
	char	pad4[3];

	char	p_cpu;		/* cpu usage for scheduling */
	char	pad5[3];

	char	p_nice;		/* nice for cpu usage */
	char	pad6[3];

	ushort	p_uid;		/* real user id */
	ushort	p_suid;		/* set (effective) user id */

	short	p_pgrp;		/* name of process group leader */
	short	p_pid;		/* unique process id */

	int	p_ppid;		/* process id of parent */
	int	p_size;		/* size of swappable image (clicks) */

	short	p_swaddr;	/* disk address when swapped */
	short	p_swsize;	/* number of clicks already swapped */

	short	p_tsize;	/* size of text (used by exec/swapin) */
	short	p_ssize;	/* size of stack (used by exec/swapin) */

	int	p_sig;		/* signals pending to this process */
	union {
		caddr_t	p_cad;
		int	p_int;
	} p_unw;
#define	p_wchan	p_unw.p_cad
#define	p_arg	p_unw.p_int
	struct text *p_textp;	/* pointer to text structure */
	struct proc *p_link;	/* linked list of running processes */
	int	p_clktim;	/* time to alarm clock signal */

	short	p_smbeg;	/* first mmuindex for shared mem */
	short	p_smend;	/* last mmuindex for shared mem */

	char	p_sys;		/* bit 0 == 0 if sys, otherwise user mode */
				/* upper 3 bits reserved for cpuslotnum */
				/* of processor executing this process */
	char	p_sl_resumable;	/* bit 0 == 1 then process can be resumed to
				   slave from sleep/wakeup
				*/
	char	p_fpp_type;	/* if set then it contains the version number
				   of the fpp we must restore to
				*/
	char	pad1;      

	char	p_mfs_sleep;	/* set when proc waiting to enter long cr */
	char	pad2[3];	/*put following elements on long word boundary*/

	/* used for synchronizing psignal(), issig() */
	unsigned int	p_signal_sem;

	/*
	 * when this process began waiting for a long c.r., used
	 * for timeouts
	 */
	unsigned int	p_start_time;

	/*
	 * backwards pointer for doubly linked list manipulations
	 * in mfs_sleep/wakeup routines
	 */
	struct proc	*p_back;
	struct fpp_proc	*p_fpp_ptr;
};
/* sys codes */
#define SLUSER	0x1		/* can be taken by slave processor */
#define RUNNING 0x2		/* running on slave, do not swap */
#define SLSYS 	0x10		/* can be taken by slave processor */
				/* resume to system mode */

/* p_sys modes masks */
#define SYS_MODE_MASK 0x1	/* bit 0 == 0 if process is in system mode */
#define RUNNING_MASK  0x2	/* bit 1 == 1 if process is on slave */
#ifndef M68020_MASK
#define M68020_MASK   0x4	/* bit 2 == 1 if process requires 68020 cpu */
#endif M68020_MASK
#define FPP_MASK      0x8	/* bit 3 == 1 if process requires FPP */
#define SLOTNUM_MASK  0xe0	/* bits 5 - 7 contain slotnum of processor 
				   executing this process */

extern struct proc proc[];	/* the proc table itself */
extern struct fpp_proc proc_fpp[];	/* the fpp proc table */

/* stat codes */
#define	SSLEEP	1		/* awaiting an event */
#define	SWAIT	2		/* (abandoned state) */
#define	SRUN	3		/* running */
#define	SIDL	4		/* intermediate state in process creation */
#define	SZOMB	5		/* intermediate state in process termination */
#define	SSTOP	6		/* process being traced */
#define	SXBRK	7		/* process being xswapped */
#define	SXSTK	8		/* process being xswapped */
#define	SXTXT	9		/* process being xswapped */

/* flag codes */
#define	SLOAD	01		/* in core */
#define	SSYS	02		/* scheduling process */
#define	SLOCK	04		/* process cannot be swapped */
#define	SSWAP	0x08		/* process is being swapped out */
#define	STRC	0x10		/* process is being traced */
#define	SWTED	0x20		/* another tracing flag */
#define	STEXT	0x40		/* text pointer valid */
#define	SSPART	0x80		/* process is partially swapped out */

/*
 * parallel proc structure
 * to replace part with times
 * to be passed to parent process
 * in ZOMBIE state.
 */
#ifndef NPROC
struct	xproc {
	char	xp_stat;
	char	xp_flag;
	short	xp_paddr;
	char	xp_pri;		/* priority, negative is high */
	char	pad3[3];
	char	xp_time;	/* resident time for scheduling */
	char	pad4[3];
	char	xp_cpu;		/* cpu usage for scheduling */
	char	pad5[3];
	char	xp_nice;	/* nice for cpu usage */
	char	pad6[3];
	ushort	xp_uid;		/* real user id */
	ushort	xp_suid;	/* set (effective) user id */
	short	xp_pgrp;	/* name of process group leader */
	short	xp_pid;		/* unique process id */
	int	xp_ppid;	/* process id of parent */
	short	xp_xstat;	/* Exit status for wait */
	time_t	xp_utime;	/* user time, this proc */
	time_t	xp_stime;	/* system time, this proc */
};
#endif
