/* @(#)param.h	6.1 */
#define PARAM_H
/*
 * fundamental variables
 * don't change too often
 */

#define	NOFILE	64		/* max open files per process */
#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000		/* max links */

#define	MAXMEM	0x400		/* max core in clicks */
/*  MAXBLK should always be evenly divisible by 4 */
#define	MAXBLK	120		/* max blocks possible for phys IO */
#define MAXTBLK	130		/* max blks for tape phys io */
#define MAXDBLK	240		/* max blks for disk phys io */
#define	SWAPSIZE 8		/* granularity of partial swaps (in clicks) */
#define	SSIZE	1		/* initial stack size clicks */
#define	SINCR	1		/* increment of stack clicks */
#define	USIZE	1		/* size of user block clicks */
/* USRSTACK is referenced in machdep.c from within asm. so change it there */
#define	USRSTACK (0x1000000-ctob(USIZE))	/* Start of user stack */

#define	CANBSIZ	256		/* max size of typewriter line	*/
#define	HZ	50		/* Ticks/second of the clock */
#define	NCARGS	5120		/* # characters in exec arglist */

/*
 * priorities
 * should not be altered too much
 */

#define	PMASK	0177
#define	PCATCH	0400
#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	39
#define	PUSER	60
#define	PIDLE	127

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */

#define FsTYPE	2


#if FsTYPE==2
	/* New 1024 byte file system */
#define	BSIZE	1024		/* size of file system block (bytes) */
#define	SBUFSIZE	BSIZE	/* system buffer size */
#define	BSHIFT	10		/* LOG2(BSIZE) */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	01777		/* BSIZE-1 */
#define	INOPB	16		/* inodes per block */
#define	INOSHIFT	4	/* LOG2(INOPB) if exact */
#define	NMASK	0377		/* NINDIR-1 */
#define	NSHIFT	8		/* LOG2(NINDIR) */
#define	FsBSIZE(dev)	BSIZE
#define	FsBSHIFT(dev)	BSHIFT
#define	FsNINDIR(dev)	NINDIR
#define	FsBMASK(dev)	BMASK
#define	FsINOPB(dev)	INOPB
#define	FsLTOP(dev, b)	(b)	/* used to be (b<<1) */
#define	FsPTOL(dev, b)	(b)	/* used to be (b>>1) */
#define	FsNMASK(dev)	NMASK
#define	FsNSHIFT(dev)	NSHIFT
#define	FsITOD(dev, x)	itod(x)
#define	FsITOO(dev, x)	itoo(x)
#define FsBOFF(dev,x)	(x&01777)	/* offset into 1K block */
#define FsBNO(dev,x)	(x>>10)		/* block number */
#define FsINOS(dev,x)	((x&~017)+1)
#endif

/*****************************************************************************

KERNEL WON'T COMPILE WITHOUT Fs2BLK BEING DEFINED
strangely enough it seems that WE never compiled the kernel except in 
dual (i.e. both 512/1024 byte sectors) mode
*****************************************************************************/
#define Fs2BLK  0x2000

#define	NICFREE	50		/* number of superblock free blocks */
#define	NCPS	1		/* Number of clicks per segment */
#define	NBPC	4096		/* Number of bytes per click */
#define PAGESIZE 4096
#define	BPCSHIFT	12	/* LOG2(NBPC) if exact */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	CDLIMIT	(1L<<11)	/* default max write address */
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	SUPERBOFF	512	/* byte offset of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define	NICINOD	100		/* number of superblock inodes */
#define	CLKTICK	20000		/* microseconds in a clock tick */

#define	UMODE	PS_S		/* usermode bits */
#define	USERMODE(ps)	((ps & UMODE) != UMODE)
#define SYSMODE(ps)	(ps & UMODE)
#define	BASEPRI(ps)	((ps & PS_IPL) != 0)

#define	lobyte(X)	(((unsigned char *)&X)[1])
#define	hibyte(X)	(((unsigned char *)&X)[0])
#define	loword(X)	(((ushort *)&X)[1])
#define	hiword(X)	(((ushort *)&X)[0])
