#define MAXSLOTS 19
#define MAXIOPS 12
#define MAXASPS 12
#define MAXDTCS 12

/*
 *	board types
 */

#define CPU 0
#define MASTERCPU 0
#define SLAVECPU  1
#define DMC 2
#define DTC 3
#define ASP 4
#define DTC68K 5
#define MEMBOARD 6

/*
 *	board vectors
 */

#define VECDTC 0
#define VECASP 1
#define VECDMC 2
#define VECCPU 3

struct iop {
	struct iop *nextiop;
	struct iop *nextvec;
	int (* service)();		/* interrupt service routine */
	int (* proc)();
	union rtb *rtb;
	unsigned short offset;
	char slot;
	char type;
	char board;
};

#define IOPC	('I'<<8)
#define IOPGET	(IOPC|1)
#define IOPSET	(IOPC|2)
#define IOPPROC	(IOPC|3)

#define IOP_BASE(n) (0x600000 + (n << 16))
