/*	%W%	*/
/*   @(#)Arete/5.0   6/30/84   /usr/src/head/sys/ioctl.h   */



/* Special Peripheral Device ioctl */

#define PERIOC  ('P'<<8)
#define PERGET  (PERIOC|0)
#define PERSET  (PERIOC|1)

/* the following two ioctl command macros are for used
 * by sadc (called by sar) to get system activity info
 * from the iop's
 */

#define GC_GETSAR	0		/* get sar info from gc's */
#define DK_GETSAR	1		/* get sar info from hsdt's */


/* the following three ioctl command macros are for used
 * by sadc (called by sar) to get system activity info
 * from the cpu's
 */
#define GET_SYSINFO	2
#define GET_SYSERR	4

/*
 * this is the data structure used for an ioctl on /dev/sar
 * with any of the previous three commands
 */

struct sario {
	int	cpu;		/* cpu id, 0 - 3 */
	char	*addr;		/* pointer to data area to fill */
};


/*
 * The following ioctl commands are for use with archive and
 * nine track devices.  They are all used as a value pointed
 * to in arg, with a PERSET command.
 *
 * ioctl(fd, PERSET, arg)
 * int fd, cmd, *arg;
 */

#define REWIND 	    3			/* rewind the tape */
#define WEOF 	    4			/* write end of file (9 track) */
#define REOF 	    5			/* read end of file (9 track) */
#define TAPESTAT    6			/* get tape status */
#define TENSION     7			/* archive only */
#define ERASE       8			/* erase tape from current location*/ 
#define RECBACK     0xb			/* back one record (9track)*/
#define QIC11       0xd			/* change to QIC11 format (archive)*/
#define QIC24       0xe			/* change to QIC24 format (archive)*/
#define REVSFM      0x12		/* return tape status from last tape
#define LASTSTAT    0x14		/* return tape status from last tape
					   operation */
#define DRIVETYPE   0x15		/* return drive type TRACK9/ARCHIVE */

