/*	@(#)inode.h	3.13	*/
/*   @(#)Arete/5.0   6/30/84   /usr/src/head/sys/inode.h   */

/*
 * The I node is the focus of all
 * file activity in unix. There is a unique
 * inode allocated for each active file,
 * each current directory, each mounted-on
 * file, text file, and the root. An inode is 'named'
 * by its dev/inumber pair. (iget/iget.c)
 * Data, from mode on, is read in
 * from permanent inode on volume.
 */

#define	NADDR	13
#define	NSADDR	(NADDR*sizeof(daddr_t)/sizeof(short))

/* file locking hooks */
struct locklist {
	/* Note link must be first in struct */
	struct	locklist  *ll_link;	/* link to next lock region */
	int		  ll_flags;	/* misc flags ** sleeping */
	struct	proc      *ll_proc;	/* process which owns region */
	off_t		  ll_start;	/* starting offset */
	off_t		  ll_end;	/* ending offset, zero is eof */
};

struct	inode
{
	struct inode *i_forw;	/* hash chain forw */
	struct inode *i_back;	/* hash chain back */
	char	i_flag;
	char	pad[3];
	cnt_t	i_count;	/* reference count */
	char	pad1[2];
	dev_t	i_dev;		/* device where inode resides */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
	ushort	i_mode;
	char	pad2[2];
	short	i_nlink;	/* directory entries */
	char	pad3[2];
	ushort	i_uid;		/* owner */
	char	pad4[2];
	ushort	i_gid;		/* group of owner */
	char	pad5[2];
	off_t	i_size;		/* size of file */
	struct {
		union {
			daddr_t i_a[NADDR];	/* if normal file/directory */
			short	i_f[NSADDR];	/* if fifo's */
		} i_p;
		daddr_t	i_l;		/* last logical block read */
	} i_blks;
	struct locklist *i_locklist;	/* locked region list locking	      */
	long 	*i_filocks;		/* pointer to filock (structure) list */
	int	i_inode_lock;
	int	reader_count;

};


extern struct locklist locklist[];	/* The lock table itself */

extern struct inode inode[];	/* The inode table itself */


/* flags */
#define	ILOCK	01		/* inode is locked */
#define	IUPD	02		/* file has been modified */
#define	IACC	04		/* inode access time to be updated */
#define	IMOUNT	010		/* inode is mounted on */
#define	IWANT	020		/* some process waiting on lock */
#define	ITEXT	040		/* inode is pure text prototype */
#define	ICHG	0100		/* inode has been changed */
#define	ISYN	0200		/* do synchronous write for iupdate */

/* modes */
#define		IFMT	0170000	/* type of file */
#define		IFDIR	0040000	/* directory */
#define		IFCHR	0020000	/* character special */
#define		IFBLK	0060000	/* block special */
#define		IFREG	0100000	/* regular */
#define		IFMPC	0030000	/* multiplexed char special */
#define		IFMPB	0070000	/* multiplexed block special */
#define		IFIFO	0010000	/* fifo special */
#define		ISUID	0004000	/* set user id on execution */
#define		ISGID	0002000	/* set group id on execution */
#define 	ISVTX	0001000	/* save swapped text even after use */
#define		IREAD	0000400	/* read, write, execute permissions */
#define		IWRITE	0000200
#define		IEXEC	0000100

/* lock flags */
#define INODE_WANTED	00001
#define INODE_LOCKED	00002
#define READER_LOCKED	00004


#define	i_addr	i_blks.i_p.i_a
#define	i_lastr	i_blks.i_l
#define	i_rdev	i_blks.i_p.i_a[0]

#define	i_faddr	i_blks.i_p.i_a
#define	NFADDR	10
#define	PIPSIZ	NFADDR*BSIZE
#define	i_frptr	i_blks.i_p.i_f[NSADDR-5]
#define	i_fwptr	i_blks.i_p.i_f[NSADDR-4]
#define	i_frcnt	i_blks.i_p.i_f[NSADDR-3]
#define	i_fwcnt	i_blks.i_p.i_f[NSADDR-2]
#define	i_fflag	i_blks.i_p.i_f[NSADDR-1]
#define	IFIR	01
#define	IFIW	02
