/*
 * A tty structure is needed for each UNIX character device that
 * is used for terminal IO.
 */

struct gctty {
	unsigned char t_eye_catcher[4];	/* eye catcher */
	struct	cirbuf t_rawq;		/* raw input queue */
	struct	cirbuf t_canq;		/* canonical queue */
	struct	cir_buf t_outq;		/* output queue */
	struct	cirbuf t_tbuf;		/* tx control block */
	struct	cirbuf t_rbuf;		/* rx control block */
	struct	cirbuf t_icmd;		/* icb input command queue	*/
	struct tcb	*t_input_tcb;	/* input tcb			*/
	struct tcb	*t_output_tcb;	/* output tcb			*/
	struct tcb	*t_control_tcb;	/* control tcb			*/
	unsigned char	*t_canwb;	/* iop's canon work buffer	*/
	struct scc *t_scc;		/* scc base address */
	unsigned short t_iflag;		/* input modes */
	unsigned short t_oflag;		/* output modes */
	unsigned short t_cflag;		/* control modes */
	unsigned short t_lflag;		/* line discipline modes */
	short	t_state;		/* internal state */
	short	t_pgrp;			/* process group name */
	unsigned short	t_gcp_state;	/* gcp state			*/
	unsigned short	t_lock_state;	/* locked state variables	*/
	struct sema	t_lock;		/* lock semaphore		*/
	unsigned char t_cc[NCC]; 	/* settable control chars */
	struct termio	t_ioctl_set;	/* ioctl set			*/
	unsigned char	t_ioctl_cmd;	/* ioctl command		*/
	unsigned char	t_ioctl_arg;	/* ioctl argument		*/
	unsigned char t_exst;		/* software copy external status */
	unsigned char t_number;		/* channel number */
	char	t_line;			/* line discipline */
	char	t_delct;		/* delimiter count */
	char	t_term;			/* terminal type */	
	char	t_tmflag;		/* terminal flags */
	char	t_col;			/* current column */
	char	t_row;			/* current row */
	char	t_vrow;			/* variable row */
	char	t_lrow;			/* last physical row */
	char	t_hqcnt;		/* no. high queue packets on t_outq */	
	char	t_dstat;		/* used by terminal handlers
						and line disciplines */
	unsigned char t_wr5;
	unsigned char t_openf;		/* open flags */
	unsigned short t_dlycnt;	/* number of delays pending */
	unsigned char t_closing;	/* wait for close */
	unsigned char t_code;		/* gcp code running */
	unsigned char t_gcline;		/* gcp line discipline */
	unsigned char	t_board;	/* board number			*/
	unsigned char	t_device;	/* device number		*/
	struct gctio	t_gctio;	/* extened gcp tty ioctl	*/
	struct pto	t_pto_dcd;	/* dsr to dcd delay		*/
	struct pto	t_pto_active;	/* inactive delay		*/
};

#define GCTTY_CFLAG_MASK (CBAUD|CSIZE|CSTOPB|PARENB|PARODD)

/*
 *	locked state variables
 */

#define GCTTY_LS_IRDY	0x0001		/* input ready			*/
#define GCTTY_LS_ORDY	0x0002		/* output ready			*/
#define GCTTY_LS_CRDY	0x0004		/* control ready		*/

#define GCTTY_LS_SISLP	0x0010		/* slave input sleeping		*/
#define GCTTY_LS_SOSLP	0x0020		/* slave output sleeping	*/

#define GCTTY_LS_MISLP	0x0100		/* master input sleeping	*/
#define GCTTY_LS_MOSLP	0x0200		/* master output sleeping	*/
#define GCTTY_LS_MCSLP	0x0400		/* master control sleeping	*/

/*
 *	gcp state variables
 */

#define GCTTY_STATE_RTO 	0x0001	/* raw io time out		*/
#define GCTTY_STATE_DSR 	0x0002	/* waiting for dsr to drop	*/
#define GCTTY_STATE_BREAK 	0x0004	/* received break		*/

/*
 *	slave to master commands
 */

#define GCTTY_STOM_STATE	(0x0100|GC_TTY_COMMANDS)
#define GCTTY_STOM_READ		(0x0200|GC_TTY_COMMANDS)
#define GCTTY_STOM_INTR		(0x0300|GC_TTY_COMMANDS)
#define GCTTY_STOM_QUIT		(0x0400|GC_TTY_COMMANDS)
#define GCTTY_STOM_SWITCH	(0x0500|GC_TTY_COMMANDS)
#define GCTTY_STOM_FLUSH	(0x0600|GC_TTY_COMMANDS)
#define GCTTY_STOM_IOCTL	(0x0700|GC_TTY_COMMANDS)
#define GCTTY_STOM_TXLOW	(0x0800|GC_TTY_COMMANDS)
#define GCTTY_STOM_HUP		(0x0900|GC_TTY_COMMANDS)
#define GCTTY_STOM_SWTCH	(0x0a00|GC_TTY_COMMANDS)
#define GCTTY_STOM_TACT		(0x0b00|GC_TTY_COMMANDS)

/*
 *	master to slave commands
 */

#define GCTTY_MTOS_OPEN		(0x0100|GC_TTY_COMMANDS)
#define GCTTY_MTOS_CLOSE	(0x0200|GC_TTY_COMMANDS)
#define GCTTY_MTOS_TIMEO	(0x0300|GC_TTY_COMMANDS)
#define GCTTY_MTOS_READ		(0x0400|GC_TTY_COMMANDS)
#define GCTTY_MTOS_UNBLOCK	(0x0500|GC_TTY_COMMANDS)
#define GCTTY_MTOS_IOCTL	(0x0600|GC_TTY_COMMANDS)
#define GCTTY_MTOS_WRITE	(0x0700|GC_TTY_COMMANDS)
#define GCTTY_STOS_TIMEO	(0x0a00|GC_TTY_COMMANDS)

/*
 *	virtual registers
 */

#define GCTTY_VR_LP		0
#define GCTTY_VR_TTY_BASE	1

#define GCTTY_VR_TTY00		GCTTY_VR_TTY_BASE + 00
#define GCTTY_VR_TTY01		GCTTY_VR_TTY_BASE + 01
#define GCTTY_VR_TTY02		GCTTY_VR_TTY_BASE + 02
#define GCTTY_VR_TTY03		GCTTY_VR_TTY_BASE + 03
#define GCTTY_VR_TTY04		GCTTY_VR_TTY_BASE + 04
#define GCTTY_VR_TTY05		GCTTY_VR_TTY_BASE + 05
#define GCTTY_VR_TTY06		GCTTY_VR_TTY_BASE + 06
#define GCTTY_VR_TTY07		GCTTY_VR_TTY_BASE + 07
#define GCTTY_VR_TTY08		GCTTY_VR_TTY_BASE + 08
#define GCTTY_VR_TTY09		GCTTY_VR_TTY_BASE + 09
#define GCTTY_VR_TTY10		GCTTY_VR_TTY_BASE + 10
#define GCTTY_VR_TTY11		GCTTY_VR_TTY_BASE + 11
#define GCTTY_VR_TTY12		GCTTY_VR_TTY_BASE + 12
#define GCTTY_VR_TTY13		GCTTY_VR_TTY_BASE + 13
#define GCTTY_VR_TTY14		GCTTY_VR_TTY_BASE + 14
#define GCTTY_VR_TTY15		GCTTY_VR_TTY_BASE + 15

#define GCTTY_VR_END		GCTTY_VR_TTY15 + 1
